/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core.prices;

import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.prices.BSPriceTypeExp;
import org.black_ixx.bossshop.core.prices.BSPriceTypeItem;
import org.black_ixx.bossshop.core.prices.BSPriceTypeItemAll;
import org.black_ixx.bossshop.core.prices.BSPriceTypeMoney;
import org.black_ixx.bossshop.core.prices.BSPriceTypeNothing;
import org.black_ixx.bossshop.core.prices.BSPriceTypePoints;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public abstract class BSPriceType {
    public static BSPriceType Item;
    public static BSPriceType ItemAll;
    public static BSPriceType Money;
    public static BSPriceType Nothing;
    public static BSPriceType Points;
    public static BSPriceType Exp;
    public static BSPriceType ThirdCurrencyVariable;
    private static List<BSPriceType> types;
    private String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<BSPriceType>();
        Item = BSPriceType.registerType(new BSPriceTypeItem());
        ItemAll = BSPriceType.registerType(new BSPriceTypeItemAll());
        Money = BSPriceType.registerType(new BSPriceTypeMoney());
        Nothing = BSPriceType.registerType(new BSPriceTypeNothing());
        Points = BSPriceType.registerType(new BSPriceTypePoints());
        Exp = BSPriceType.registerType(new BSPriceTypeExp());
    }

    public static BSPriceType registerType(BSPriceType type) {
        types.add(type);
        return type;
    }

    public static BSPriceType detectType(String s) {
        for (BSPriceType type : types) {
            if (!type.isType(s)) continue;
            return type;
        }
        return Nothing;
    }

    public static List<BSPriceType> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        BSPriceType.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public void updateNames() {
        this.names = this.createNames();
    }

    public abstract Object createObject(Object var1, boolean var2);

    public abstract boolean validityCheck(String var1, Object var2);

    public abstract void enableType();

    public abstract boolean hasPrice(Player var1, BSBuy var2, Object var3, ClickType var4, boolean var5);

    public abstract String takePrice(Player var1, BSBuy var2, Object var3, ClickType var4);

    public abstract String getDisplayPrice(Player var1, BSBuy var2, Object var3, ClickType var4);

    public abstract String[] createNames();

    public abstract boolean mightNeedShopUpdate();

    public boolean isPlayerDependend(BSBuy buy, ClickType clicktype) {
        return this.supportsMultipliers() && ClassManager.manager.getMultiplierHandler().hasMultipliers();
    }

    public boolean overridesReward() {
        return false;
    }

    public boolean supportsMultipliers() {
        return false;
    }
}

