/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.listeners;

import java.util.HashMap;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSShop;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SignListener
implements Listener {
    private boolean s;
    private BossShop plugin;

    public SignListener(boolean s, BossShop plugin) {
        this.s = s;
        this.plugin = plugin;
    }

    private BSShop getBossShopSign(String line) {
        if (line == null || line == "") {
            return null;
        }
        line = line.toLowerCase();
        HashMap<Integer, BSShop> set = this.plugin.getClassManager().getShops().getShops();
        for (Integer s : set.keySet()) {
            BSShop shop = set.get(s);
            String signtext = shop.getSignText();
            if (signtext == null || !line.endsWith(signtext.toLowerCase())) continue;
            return shop;
        }
        return null;
    }

    @EventHandler
    public void createSign(SignChangeEvent e) {
        if (!this.s) {
            return;
        }
        BSShop shop = this.getBossShopSign(e.getLine(0));
        if (shop != null) {
            if (shop.needPermToCreateSign() && !e.getPlayer().hasPermission("BossShop.createSign")) {
                this.plugin.getClassManager().getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)e.getPlayer());
                e.setCancelled(true);
                return;
            }
            if (e.getLine(0) != "") {
                e.setLine(0, this.plugin.getClassManager().getStringManager().transform(e.getLine(0)));
            }
            if (e.getLine(1) != "") {
                e.setLine(1, this.plugin.getClassManager().getStringManager().transform(e.getLine(1)));
            }
            if (e.getLine(2) != "") {
                e.setLine(2, this.plugin.getClassManager().getStringManager().transform(e.getLine(2)));
            }
            if (e.getLine(3) != "") {
                e.setLine(3, this.plugin.getClassManager().getStringManager().transform(e.getLine(3)));
            }
        }
    }

    @EventHandler
    public void interactSign(PlayerInteractEvent e) {
        Sign s;
        BSShop shop;
        Block b;
        if (!this.s) {
            return;
        }
        if (e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && (b = e.getClickedBlock()).getType().name().contains("SIGN") && b.getState() instanceof Sign && (shop = this.getBossShopSign((s = (Sign)b.getState()).getLine(0))) != null) {
            if (e.getPlayer().hasPermission("BossShop.open") || e.getPlayer().hasPermission("BossShop.open.sign") || e.getPlayer().hasPermission("BossShop.open.sign." + shop.getShopName())) {
                this.plugin.getClassManager().getShops().openShop(e.getPlayer(), shop);
                return;
            }
            this.plugin.getClassManager().getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)e.getPlayer());
            return;
        }
    }

    public void setSignsEnabled(boolean b) {
        this.s = b;
    }
}

