/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.black_ixx.bossshop.core.BSBuy;
import org.black_ixx.bossshop.core.BSShop;
import org.black_ixx.bossshop.core.BSShops;
import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.core.rewards.BSRewardType;
import org.black_ixx.bossshop.events.BSLoadShopItemsEvent;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.config.ConfigLoader;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BSConfigShop
extends BSShop {
    private String ymlName;
    private File f;
    private FileConfiguration config;
    private ConfigurationSection section;

    public BSConfigShop(int shop_id, String ymlName, BSShops shophandler) {
        this(shop_id, new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/shops/" + ymlName), shophandler);
    }

    public BSConfigShop(int shop_id, File f, BSShops shophandler) {
        this(shop_id, f, shophandler, null);
    }

    public BSConfigShop(int shop_id, File f, BSShops shophandler, ConfigurationSection sectionOptional) {
        super(shop_id);
        this.f = f;
        try {
            this.config = ConfigLoader.loadConfiguration(f, true);
        }
        catch (InvalidConfigurationException e) {
            ClassManager.manager.getBugFinder().severe("Invalid Configuration! File: /shops/" + this.ymlName + " Cause: " + e.getMessage());
            String name = this.ymlName.replace(".yml", "");
            this.setSignText("[" + name + "]");
            this.setNeedPermToCreateSign(true);
            this.setShopName(name);
            ItemStack i = new ItemStack(Material.WHITE_WOOL, 1);
            ItemMeta m = i.getItemMeta();
            m.setDisplayName(ChatColor.RED + "Your Config File contains mistakes! (" + this.ymlName + ")");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.YELLOW + "For more information check /plugins/" + "BossShopPro" + "/BugFinder.yml out!");
            m.setLore(lore);
            i.setItemMeta(m);
            this.addShopItem(new BSBuy(BSRewardType.Command, BSPriceType.Nothing, "tell %player% the config file (" + this.ymlName + ") contains mistakes...", null, "", 0, "", name), i, ClassManager.manager);
            this.finishedAddingItems();
            return;
        }
        this.setup(shophandler, (ConfigurationSection)(sectionOptional == null ? this.config : sectionOptional));
    }

    public void setup(BSShops shophandler, ConfigurationSection section) {
        this.section = section;
        this.addDefaults();
        this.setShopName(section.getString("ShopName"));
        this.setDisplayName(section.getString("DisplayName"));
        this.setSignText(section.getString("signs.text"));
        this.setNeedPermToCreateSign(section.getBoolean("signs.NeedPermissionToCreateSign"));
        this.setManualInventoryRows(section.getInt("InventoryRows", -1));
        String commands = section.getString("Command");
        if (commands != null) {
            this.setCommands(commands.split(":"));
        }
        ClassManager.manager.getSettings().update(this);
        this.loadItems();
        BSLoadShopItemsEvent event = new BSLoadShopItemsEvent(shophandler, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.finishedAddingItems();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public ConfigurationSection getConfigurationSection() {
        return this.section;
    }

    public void saveConfig() {
        try {
            this.config.save(this.f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        this.f = new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/shops/" + this.ymlName);
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
        InputStream defConfigStream = ClassManager.manager.getPlugin().getResource(this.f.getName());
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void addDefault(String name, String rewardType, String priceType, Object reward, Object price, List<String> menuitem, String message, int loc, String permission) {
        ConfigurationSection c = this.section.getConfigurationSection("shop").createSection(name);
        c.set("RewardType", (Object)rewardType);
        c.set("PriceType", (Object)priceType);
        c.set("Price", price);
        c.set("Reward", reward);
        c.set("MenuItem", menuitem);
        c.set("Message", (Object)message);
        c.set("InventoryLocation", (Object)loc);
        c.set("ExtraPermission", (Object)permission);
    }

    public void addDefaults() {
        this.section.addDefault("ShopName", (Object)"ExtraShop");
        this.section.addDefault("signs.text", (Object)"[ExtraShop]");
        this.section.addDefault("signs.NeedPermissionToCreateSign", (Object)false);
        if (this.section.getConfigurationSection("shop") == null && this.section.getConfigurationSection("itemshop") == null) {
            this.section.createSection("shop");
            ArrayList<String> menuItem = new ArrayList<String>();
            menuItem.add("type:STONE");
            menuItem.add("amount:1");
            menuItem.add("name:&8Example");
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("tell %name% Example");
            this.addDefault("Example", "command", "money", cmd, 5000, menuItem, "", 1, "");
            this.config.options().copyDefaults(true);
            this.saveConfig();
        }
    }

    @Override
    public int getInventorySize() {
        if (this.section.getInt("InventorySize") != 0) {
            return this.section.getInt("InventorySize");
        }
        return super.getInventorySize();
    }

    public void loadItems() {
        ConfigurationSection c = this.section.getConfigurationSection("shop");
        if (c != null) {
            for (String key : c.getKeys(false)) {
                ClassManager.manager.getBuyItemHandler().loadItem(c, this, key);
            }
        }
    }

    @Override
    public void reloadShop() {
        this.reloadConfig();
    }
}

