/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline.steps;

import com.google.common.collect.Sets;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.api.events.user.UserQuestProgressionEvent;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.enums.Category;
import io.github.battlepass.logger.DebugLogger;
import io.github.battlepass.logger.containers.LogContainer;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.pipeline.processors.AntiAbuseProcessor;
import io.github.battlepass.quests.workers.pipeline.steps.QuestCompletionStep;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.service.Locks;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.actions.objects.variable.ExecutableActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class QuestValidationStep {
    private final AntiAbuseProcessor i;
    private final QuestCompletionStep e;
    private final BattlePlugin c;
    private final BattlePassApi l;
    private final DebugLogger k;
    private final QuestController n;
    private final Set<String> m;
    private final Set<String> j;
    private final boolean a;
    private final boolean b;
    private final boolean d;
    private final boolean g;
    private final ReentrantLock h;
    private static boolean f;
    private static final String[] o;

    public QuestValidationStep(BattlePlugin battlePlugin) {
        boolean bl = QuestValidationStep.b();
        boolean bl2 = bl;
        this.h = Locks.newReentrantLock();
        String[] stringArray = o;
        Config config = battlePlugin.getConfig(stringArray[4]);
        this.i = new AntiAbuseProcessor(battlePlugin);
        this.e = new QuestCompletionStep(battlePlugin);
        this.c = battlePlugin;
        this.l = battlePlugin.getLocalApi();
        this.n = battlePlugin.getQuestController();
        this.m = Sets.newHashSet(config.stringList(stringArray[3]));
        this.j = Sets.newHashSet(config.stringList(stringArray[7]));
        this.a = config.bool(stringArray[9]);
        this.b = config.bool(stringArray[8]);
        this.d = config.bool(stringArray[6]);
        this.g = config.bool(stringArray[10]);
        this.k = battlePlugin.getDebugLogger();
        if (ActionContainer.b() != null) {
            QuestValidationStep.b(!bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompletion(ActionExecution actionExecution, Collection<Quest> collection) {
        Player player = actionExecution.getPlayer();
        boolean bl = QuestValidationStep.c();
        String string = player.getWorld().getName();
        if (this.areServerQuestsBlocked()) {
            String[] stringArray = o;
            this.k.log(LogContainer.of(stringArray[11]));
            return;
        }
        if (this.isWorldServerBlocked(string)) {
            return;
        }
        this.i.applyMeasures(actionExecution, collection);
        for (Quest quest : collection) {
            if (!actionExecution.getQuestType().equalsIgnoreCase(quest.getType()) && bl) continue;
            if (this.isQuestSeasonEndBlocked(quest)) {
                this.k.log(LogContainer.of(o[1]));
                if (bl) continue;
            }
            this.h.lock();
            try {
                this.proceed(actionExecution, quest);
            }
            finally {
                this.h.unlock();
            }
            if (bl) continue;
        }
    }

    public boolean proceed(ActionExecution actionExecution, Quest quest) {
        BigInteger bigInteger = this.n.getQuestProgress((User)actionExecution.getUser(), quest);
        if (!this.isQuestValid(actionExecution, quest)) {
            return false;
        }
        if (this.isRegionQuestBlocked(actionExecution, quest)) {
            return false;
        }
        Variable variable = quest.getVariable();
        ExecutableActionResult executableActionResult = actionExecution.getQuestResult();
        if (executableActionResult == null || executableActionResult.isEligible(actionExecution.getPlayer(), variable)) {
            UserQuestProgressionEvent userQuestProgressionEvent = new UserQuestProgressionEvent(actionExecution, quest);
            Bukkit.getPluginManager().callEvent((Event)userQuestProgressionEvent);
            if (!userQuestProgressionEvent.isCancelled()) {
                this.e.process(actionExecution, quest, bigInteger, actionExecution.getProgress());
            }
            return true;
        }
        return false;
    }

    public boolean isQuestPrimarilyValid(User user, Quest quest, BigInteger bigInteger, boolean bl) {
        boolean bl2;
        if (this.areServerQuestsBlocked() || this.isQuestSeasonEndBlocked(quest) || this.n.isQuestDone(user, quest) || bl && this.isProgressIdentical(quest, user, bigInteger) || this.isPassTypeQuestBlocked(quest, user)) {
            return false;
        }
        int n = Category.stripWeek(quest.getCategoryId());
        boolean bl3 = bl2 = n == 0;
        if (!bl2 && !user.bypassesLockedWeeks() && ((long)n > this.l.getCurrentWeek() || this.a && (long)n < this.l.getCurrentWeek())) {
            return false;
        }
        return !this.b || bl2 || user.bypassesLockedWeeks() || !this.isPreviousWeekBlocked(user, n);
    }

    public boolean isQuestValid(ActionExecution actionExecution, Quest quest) {
        if (!this.isQuestPrimarilyValid((User)actionExecution.getUser(), quest, actionExecution.getProgress(), actionExecution.shouldOverrideUpdate())) {
            return false;
        }
        Player player = actionExecution.getPlayer();
        String string = player.getWorld().getName();
        return !this.isWorldQuestBlocked(quest, string);
    }

    private boolean areServerQuestsBlocked() {
        return this.l.hasSeasonEnded() && this.d && this.g;
    }

    private boolean isWorldServerBlocked(String string) {
        return !this.m.isEmpty() && !this.m.contains(string) || this.j.contains(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isQuestSeasonEndBlocked(Quest quest) {
        if (!this.l.hasSeasonEnded()) return false;
        String[] stringArray = o;
        if (quest.getCategoryId().contains(stringArray[5])) {
            if (this.d) return true;
        }
        if (!quest.getCategoryId().contains(o[2])) return false;
        if (!this.g) return false;
        return true;
    }

    private boolean isWorldQuestBlocked(Quest quest, String string) {
        return quest.getBlacklistedWorlds().contains(string) || !quest.getWhitelistedWorlds().isEmpty() && !quest.getWhitelistedWorlds().contains(string);
    }

    private boolean isPassTypeQuestBlocked(Quest quest, User user) {
        return quest.getExclusiveTo() != null && !quest.getExclusiveTo().equalsIgnoreCase(user.getPassId());
    }

    private boolean isProgressIdentical(Quest quest, User user, BigInteger bigInteger) {
        return this.n.getQuestProgress(user, quest).compareTo(bigInteger) == 0;
    }

    private boolean isPreviousWeekBlocked(User user, int n) {
        boolean bl;
        block2: {
            boolean bl2 = QuestValidationStep.c();
            for (int i = n - 1; i > 0; --i) {
                bl = this.n.isWeekDone(user, i);
                if (bl2) {
                    if (bl) continue;
                    return true;
                }
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isRegionQuestBlocked(ActionExecution var1_1, Quest var2_2) {
        block13: {
            block12: {
                var4_3 = (User)var1_1.getUser();
                var3_4 = QuestValidationStep.b();
                if (!this.c.getServer().getPluginManager().isPluginEnabled(QuestValidationStep.o[0])) {
                    return false;
                }
                if (var2_2.getWhitelistedRegions().isEmpty() && var2_2.getBlacklistedRegions().isEmpty()) {
                    return false;
                }
                var5_5 = WorldGuard.getInstance().getPlatform().getRegionContainer();
                var6_6 = var5_5.get(BukkitAdapter.adapt((World)var4_3.getPlayer().getWorld()));
                var7_7 = var5_5.createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)var4_3.getPlayer().getLocation()));
                if (var6_6 == null) {
                    return false;
                }
                if (var2_2.getWhitelistedRegions().isEmpty()) break block12;
                var8_8 = var2_2.getWhitelistedRegions().iterator();
                while (var8_8.hasNext()) {
                    var9_9 = var8_8.next();
                    v0 = var10_10 = var6_6.getRegion(var9_9);
                    if (!var3_4) {
                        if (v0 != null && var7_7.getRegions().contains(var10_10)) {
                            return false;
                        }
                        if (!var3_4) continue;
                    }
                    ** GOTO lbl26
                }
            }
            if (var2_2.getBlacklistedRegions().isEmpty()) break block13;
            for (String var9_9 : var2_2.getBlacklistedRegions()) {
                v0 = var10_10 = var6_6.getRegion(var9_9);
lbl26:
                // 2 sources

                if (v0 != null && var7_7.getRegions().contains(var10_10)) {
                    return true;
                }
                if (!var3_4) continue;
            }
        }
        return false;
    }

    public static void b(boolean bl) {
        f = bl;
    }

    public static boolean b() {
        return f;
    }

    public static boolean c() {
        boolean bl = QuestValidationStep.b();
        return !bl;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[12];
                var3_1 = 0;
                var2_2 = "MG/,_)G{Z9f2x\u0014\u0010~\"{Tmt`\u007f\u0007Vt\u000f)`K\u001c]}Z83HNTuZ}eY\u000fFnD80Z\u001dA7X1!B\u000b@?\b<._NCoM.4HN]|\b)(R\u001d\u0012nQ-%\u001b\u000f@\u007f\b9)H\u000fPvM9`T\u0000\u0012iM<3T\u0000\u0012\u007fF9n\u0004mM8+\u0012m@44^\u0002[i\\8$\u0016\u0019]hD93\biM)4R\u0000Ui\u0005~I4,B!iM<3T\u0000\u001f|A3)H\u0006W~\u0006.4T\u001e\u001f~I4,BCCoM.4H\u0012xD<#P\u0002[i\\8$\u0016\u0019]hD932y]/2^\u0000F7[8!H\u0001\\4]3,T\rYi\u0006/%J\u001b[hMp0I\u000bDsG(3\u0016\r]wX1%O\u0007]t*y]/2^\u0000F7[8!H\u0001\\4]3,T\rYi\u00061/X\u0005\u001fjZ86R\u0001Gi\u0005*%^\u0005A";
                var4_3 = "MG/,_)G{Z9f2x\u0014\u0010~\"{Tmt`\u007f\u0007Vt\u000f)`K\u001c]}Z83HNTuZ}eY\u000fFnD80Z\u001dA7X1!B\u000b@?\b<._NCoM.4HN]|\b)(R\u001d\u0012nQ-%\u001b\u000f@\u007f\b9)H\u000fPvM9`T\u0000\u0012iM<3T\u0000\u0012\u007fF9n\u0004mM8+\u0012m@44^\u0002[i\\8$\u0016\u0019]hD93\biM)4R\u0000Ui\u0005~I4,B!iM<3T\u0000\u001f|A3)H\u0006W~\u0006.4T\u001e\u001f~I4,BCCoM.4H\u0012xD<#P\u0002[i\\8$\u0016\u0019]hD932y]/2^\u0000F7[8!H\u0001\\4]3,T\rYi\u0006/%J\u001b[hMp0I\u000bDsG(3\u0016\r]wX1%O\u0007]t*y]/2^\u0000F7[8!H\u0001\\4]3,T\rYi\u00061/X\u0005\u001fjZ86R\u0001Gi\u0005*%^\u0005A".length();
                var1_4 = 10;
                var0_5 = -1;
                QuestValidationStep.b(false);
lbl8:
                // 2 sources

                while (true) {
                    v0 = 80;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0003'VY>ju\u0016+YC\"l=\u0014lD^>tu\u001f6_O#))\u0005'D^\"jX\u0012~z\u0014H\u0011>\u0007\u001e\n\u0015m<\u001eeC\n!v7\u00170RY\"$>\u001f0\u0017\u000f3e,\u0004.RZ0w+]2[K(a*UbVYqw=\u00111XDql9\u0003bRD5a<P#YNq`9\u0019.^O\"$~P,XX<e4\u0003bVX4$<\u00191VH=a<^";
                    var4_3 = "\u0003'VY>ju\u0016+YC\"l=\u0014lD^>tu\u001f6_O#))\u0005'D^\"jX\u0012~z\u0014H\u0011>\u0007\u001e\n\u0015m<\u001eeC\n!v7\u00170RY\"$>\u001f0\u0017\u000f3e,\u0004.RZ0w+]2[K(a*UbVYqw=\u00111XDql9\u0003bRD5a<P#YNq`9\u0019.^O\"$~P,XX<e4\u0003bVX4$<\u00191VH=a<^".length();
                    var1_4 = 33;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 58;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 74;
                            break;
                        }
                        case 1: {
                            v15 = 120;
                            break;
                        }
                        case 2: {
                            v15 = 13;
                            break;
                        }
                        case 3: {
                            v15 = 16;
                            break;
                        }
                        case 4: {
                            v15 = 107;
                            break;
                        }
                        case 5: {
                            v15 = 62;
                            break;
                        }
                        default: {
                            v15 = 98;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        QuestValidationStep.o = var5;
    }
}

