/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import me.angeschossen.betterfarming.hikari.HikariConfig;
import me.angeschossen.betterfarming.hikari.HikariConfigMXBean;
import me.angeschossen.betterfarming.hikari.HikariPoolMXBean;
import me.angeschossen.betterfarming.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.betterfarming.hikari.pool.HikariPool;
import me.angeschossen.betterfarming.slf4j.Logger;
import me.angeschossen.betterfarming.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements Closeable,
DataSource {
    private static final Logger RLHXh = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean HXvGq = new AtomicBoolean();
    private final HikariPool pdjAO;
    private volatile HikariPool UhzX;

    public HikariDataSource() {
        this.pdjAO = null;
    }

    public HikariDataSource(HikariConfig hikariConfig) {
        hikariConfig.validate();
        hikariConfig.copyStateTo(this);
        RLHXh.info("{} - Starting...", (Object)hikariConfig.getPoolName());
        this.UhzX = this.pdjAO = new HikariPool(this);
        RLHXh.info("{} - Start completed.", (Object)hikariConfig.getPoolName());
        this.RLHXh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.pdjAO != null) {
            return this.pdjAO.getConnection();
        }
        HikariPool hikariPool = this.UhzX;
        if (hikariPool == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                hikariPool = this.UhzX;
                if (hikariPool == null) {
                    this.validate();
                    RLHXh.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        this.UhzX = hikariPool = new HikariPool(this);
                        this.RLHXh();
                    }
                    catch (HikariPool.PoolInitializationException poolInitializationException) {
                        if (poolInitializationException.getCause() instanceof SQLException) {
                            throw (SQLException)poolInitializationException.getCause();
                        }
                        throw poolInitializationException;
                    }
                    RLHXh.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return hikariPool.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        HikariPool hikariPool = this.UhzX;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n) {
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLoginTimeout(n);
        }
    }

    @Override
    public int getLoginTimeout() {
        HikariPool hikariPool = this.UhzX;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return (T)dataSource;
            }
            if (dataSource != null) {
                return dataSource.unwrap(clazz);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return true;
        }
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return true;
            }
            if (dataSource != null) {
                return dataSource.isWrapperFor(clazz);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object object) {
        boolean bl = this.getMetricRegistry() != null;
        super.setMetricRegistry(object);
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            hikariPool.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean bl = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            hikariPool.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object object) {
        boolean bl = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(object);
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            hikariPool.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.UhzX != null && this.UhzX.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.UhzX;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool hikariPool;
        if (!this.isClosed() && (hikariPool = this.UhzX) != null && connection.getClass().getName().startsWith("me.angeschossen.betterfarming.hikari")) {
            hikariPool.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.HXvGq.getAndSet(true)) {
            return;
        }
        HikariPool hikariPool = this.UhzX;
        if (hikariPool != null) {
            try {
                RLHXh.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                hikariPool.shutdown();
                RLHXh.info("{} - Shutdown completed.", (Object)this.getPoolName());
            }
            catch (InterruptedException interruptedException) {
                RLHXh.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.HXvGq.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.UhzX + ")";
    }
}

