/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.hibernate;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import me.angeschossen.betterfarming.hikari.HikariConfig;
import me.angeschossen.betterfarming.hikari.HikariDataSource;
import me.angeschossen.betterfarming.hikari.hibernate.HikariConfigurationUtil;
import me.angeschossen.betterfarming.slf4j.Logger;
import me.angeschossen.betterfarming.slf4j.LoggerFactory;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long RLHXh = -9131625057941275711L;
    private static final Logger HXvGq = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig pdjAO = null;
    private HikariDataSource UhzX = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            HXvGq.warn("me.angeschossen.betterfarming.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map map) {
        try {
            HXvGq.debug("Configuring HikariCP");
            this.pdjAO = HikariConfigurationUtil.loadConfiguration(map);
            this.UhzX = new HikariDataSource(this.pdjAO);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
        HXvGq.debug("HikariCP Configured");
    }

    public Connection getConnection() {
        Connection connection = null;
        if (this.UhzX != null) {
            connection = this.UhzX.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ConnectionProvider.class.equals(clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(clazz)) {
            return (T)this.UhzX;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    public void stop() {
        this.UhzX.close();
    }
}

