/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.slf4j;

import java.io.Closeable;
import java.util.Map;
import me.angeschossen.betterfarming.slf4j.helpers.NOPMDCAdapter;
import me.angeschossen.betterfarming.slf4j.helpers.Util;
import me.angeschossen.betterfarming.slf4j.impl.StaticMDCBinder;
import me.angeschossen.betterfarming.slf4j.spi.MDCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDC {
    static final String RLHXh = "http://www.slf4j.org/codes.html#null_MDCA";
    static final String HXvGq = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
    static MDCAdapter pdjAO;

    private MDC() {
    }

    private static MDCAdapter RLHXh() {
        try {
            return StaticMDCBinder.getSingleton().getMDCA();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return StaticMDCBinder.SINGLETON.getMDCA();
        }
    }

    public static void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        pdjAO.put(string, string2);
    }

    public static MDCCloseable putCloseable(String string, String string2) {
        MDC.put(string, string2);
        return new MDCCloseable(string);
    }

    public static String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return pdjAO.get(string);
    }

    public static void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        pdjAO.remove(string);
    }

    public static void clear() {
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        pdjAO.clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return pdjAO.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> map) {
        if (pdjAO == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        pdjAO.setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        return pdjAO;
    }

    static {
        try {
            pdjAO = MDC.RLHXh();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            pdjAO = new NOPMDCAdapter();
            String string = noClassDefFoundError.getMessage();
            if (string != null && string.contains("StaticMDCBinder")) {
                Util.report("Failed to load class \"org.slf4j.impl.StaticMDCBinder\".");
                Util.report("Defaulting to no-operation MDCAdapter implementation.");
                Util.report("See http://www.slf4j.org/codes.html#no_static_mdc_binder for further details.");
            }
            throw noClassDefFoundError;
        }
        catch (Exception exception) {
            Util.report("MDC binding unsuccessful.", exception);
        }
    }

    public static class MDCCloseable
    implements Closeable {
        private final String RLHXh;

        private MDCCloseable(String string) {
            this.RLHXh = string;
        }

        public void close() {
            MDC.remove(this.RLHXh);
        }
    }
}

