/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.rtpmenu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.SuperRonanCraft.BetterRTP.player.commands.RTPCommand;
import me.SuperRonanCraft.BetterRTP.player.commands.types.CmdTeleport;
import me.SuperRonanCraft.BetterRTP.references.customEvents.RTP_CommandEvent;
import me.SuperRonanCraft.BetterRTPAddons.Addon;
import me.SuperRonanCraft.BetterRTPAddons.Main;
import me.SuperRonanCraft.BetterRTPAddons.addons.rtpmenu.MenuData;
import me.SuperRonanCraft.BetterRTPAddons.addons.rtpmenu.RTPMenuWorldInfo;
import me.SuperRonanCraft.BetterRTPAddons.addons.rtpmenu.RTPMenu_Refresh;
import me.SuperRonanCraft.BetterRTPAddons.addons.rtpmenu.RTPMenu_Settings;
import me.SuperRonanCraft.BetterRTPAddons.util.Files;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;

public class AddonRTPMenu
implements Addon,
Listener {
    public static String name = "RTPMenu";
    private final RTPMenu_Settings settings = new RTPMenu_Settings();
    private final HashMap<Player, MenuData> playerData = new HashMap();
    private HashMap<String, RTPMenuWorldInfo> worlds = new HashMap();

    public MenuData getData(Player player) {
        if (!this.playerData.containsKey(player)) {
            this.playerData.put(player, new MenuData());
        }
        return this.playerData.getOrDefault(player, null);
    }

    @Override
    public boolean isEnabled() {
        return this.getFile(Files.FILETYPE.CONFIG).getBoolean(name + ".Enabled");
    }

    @Override
    public void load() {
        for (Player object2 : this.playerData.keySet()) {
            object2.closeInventory();
        }
        this.playerData.clear();
        this.settings.load(name);
        ConfigurationSection configurationSection = this.getFile(Files.FILETYPE.CONFIG).getConfigurationSection("RTPMenu");
        List list = configurationSection.getMapList("WorldList");
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String string = entry.getKey().toString();
                Map map2 = (Map)map.get(string);
                if (map2 == null) continue;
                String string2 = "MAP";
                String string3 = string;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (map2.get("Item") != null && map2.get("Item").getClass() == String.class) {
                    string2 = String.valueOf(map2.get("Item").toString());
                }
                if (map2.get("Name") != null && map2.get("Name").getClass() == String.class) {
                    string3 = String.valueOf(map2.get("Name").toString());
                }
                if (map2.get("Lore") != null && map2.get("Lore").getClass() == ArrayList.class) {
                    arrayList = new ArrayList((ArrayList)map2.get("Lore"));
                }
                int n = 0;
                if (map2.get("Slot") != null && map2.get("Slot").getClass() == Integer.class) {
                    n = (Integer)map2.get("Slot");
                }
                try {
                    this.worlds.put(string, new RTPMenuWorldInfo(string3, Material.valueOf((String)string2.toUpperCase()), arrayList, n));
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    Main.getInstance().getLogger().warning("The item " + string2 + " is an unknown item id! Set to a map!");
                }
            }
        }
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
    }

    @Override
    public void unload() {
        HandlerList.unregisterAll((Listener)this);
        for (Player player : this.playerData.keySet()) {
            player.closeInventory();
        }
    }

    @Override
    public RTPCommand getCmd() {
        return null;
    }

    @EventHandler
    private void onClick(InventoryClickEvent inventoryClickEvent) {
        if (this.validClick(inventoryClickEvent)) {
            inventoryClickEvent.setCancelled(true);
            MenuData menuData = this.getData((Player)inventoryClickEvent.getWhoClicked());
            CmdTeleport.teleport((CommandSender)inventoryClickEvent.getWhoClicked(), (String)"rtp", (World)menuData.getWorldSlots().get(inventoryClickEvent.getSlot()), null);
            inventoryClickEvent.getWhoClicked().closeInventory();
        }
    }

    @EventHandler
    private void onTeleport(RTP_CommandEvent rTP_CommandEvent) {
        if (rTP_CommandEvent.getCmd() instanceof CmdTeleport && rTP_CommandEvent.getSendi() instanceof Player) {
            rTP_CommandEvent.setCancelled(true);
            Player player = (Player)rTP_CommandEvent.getSendi();
            new RTPMenu_Refresh(this, player, this.settings.getRefresh());
        }
    }

    private boolean validClick(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player) || inventoryClickEvent.isCancelled()) {
            return false;
        }
        if (inventoryClickEvent.getCurrentItem() == null || inventoryClickEvent.getCurrentItem().getType().equals((Object)Material.AIR)) {
            return false;
        }
        if (inventoryClickEvent.getWhoClicked() instanceof Player) {
            MenuData menuData = this.playerData.getOrDefault((Player)inventoryClickEvent.getWhoClicked(), null);
            if (menuData != null) {
                if (!inventoryClickEvent.getInventory().equals(menuData.getMenuInv())) {
                    return false;
                }
                if (!Objects.equals(inventoryClickEvent.getClickedInventory(), menuData.getMenuInv())) {
                    inventoryClickEvent.setCancelled(true);
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public RTPMenu_Settings getSettings() {
        return this.settings;
    }

    public HashMap<String, RTPMenuWorldInfo> getWorlds() {
        return this.worlds;
    }
}

