/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import java.util.List;
import java.util.Locale;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.thread.CacheHandler;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFertilizeEvent;

public final class BlockFertilizeListener
extends Queue
implements Listener {
    @EventHandler
    protected void onBlockFertilize(BlockFertilizeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (!Config.getConfig((World)block.getWorld()).BLOCK_PLACE) {
            return;
        }
        Location location = block.getLocation();
        List blocks = event.getBlocks();
        if (Tag.SAPLINGS.isTagged((Keyed)block.getType()) && (!Config.getConfig((World)location.getWorld()).TREE_GROWTH || blocks.size() == 1 && ((BlockState)blocks.get(0)).getLocation().equals((Object)location))) {
            return;
        }
        if (block.getType().name().toLowerCase(Locale.ROOT).contains("mushroom") && (!Config.getConfig((World)location.getWorld()).MUSHROOM_GROWTH || blocks.size() == 1 && ((BlockState)blocks.get(0)).getLocation().equals((Object)location))) {
            return;
        }
        String user = "#bonemeal";
        Player player = event.getPlayer();
        if (player != null) {
            user = player.getName();
        } else {
            Object[] data = CacheHandler.redstoneCache.get(location);
            if (data != null) {
                long oldTime;
                long newTime = System.currentTimeMillis();
                if (newTime - (oldTime = ((Long)data[0]).longValue()) < 50L) {
                    user = (String)data[1];
                }
                CacheHandler.redstoneCache.remove(location);
            }
        }
        for (BlockState newBlock : blocks) {
            Queue.queueBlockPlace(user, newBlock, newBlock.getType(), newBlock.getBlock().getState(), newBlock.getType(), -1, 0, newBlock.getBlockData().getAsString());
        }
    }
}

