/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.player;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.lookup.BlockLookup;
import net.coreprotect.database.lookup.ChestTransactionLookup;
import net.coreprotect.database.lookup.InteractionLookup;
import net.coreprotect.database.lookup.SignMessageLookup;
import net.coreprotect.language.Phrase;
import net.coreprotect.listener.player.PlayerInteractEntityListener;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Cake;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class PlayerInteractListener
extends Queue
implements Listener {
    public static ConcurrentHashMap<String, Object[]> lastInspectorEvent = new ConcurrentHashMap();

    @EventHandler(priority=EventPriority.LOWEST)
    protected void onPlayerInspect(PlayerInteractEvent event) {
        Block block;
        final Player player = event.getPlayer();
        World world = player.getWorld();
        if (!Boolean.TRUE.equals(ConfigHandler.inspecting.get(player.getName()))) {
            return;
        }
        if (!player.hasPermission("coreprotect.inspect")) {
            Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
            ConfigHandler.inspecting.put(player.getName(), false);
            return;
        }
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            Bed bed;
            BlockState checkBlock = event.getClickedBlock().getState();
            int x = checkBlock.getX();
            int y = checkBlock.getY();
            int z = checkBlock.getZ();
            BlockData checkBlockData = checkBlock.getBlockData();
            if (checkBlockData instanceof Bisected && !(checkBlockData instanceof Waterlogged) && ((Bisected)checkBlockData).getHalf().equals((Object)Bisected.Half.TOP) && y > BukkitAdapter.ADAPTER.getMinHeight(world)) {
                checkBlock = world.getBlockAt(checkBlock.getX(), checkBlock.getY() - 1, checkBlock.getZ()).getState();
            }
            if (checkBlockData instanceof Bed && (bed = (Bed)checkBlockData).getPart().equals((Object)Bed.Part.HEAD)) {
                checkBlock = event.getClickedBlock().getRelative(bed.getFacing().getOppositeFace()).getState();
            }
            final BlockState blockFinal = checkBlock;
            class BasicThread
            implements Runnable {
                BasicThread() {
                }

                @Override
                public void run() {
                    Object[] lookupThrottle;
                    if (ConfigHandler.converterRunning) {
                        player.sendMessage(Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                        return;
                    }
                    if (ConfigHandler.purgeRunning) {
                        player.sendMessage(Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                        return;
                    }
                    if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                        player.sendMessage(Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                        return;
                    }
                    try (Connection connection = Database.getConnection(true);){
                        if (connection != null) {
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                            Statement statement = connection.createStatement();
                            String resultData = BlockLookup.performLookup(null, statement, blockFinal, (CommandSender)player, 0, 1, 7);
                            if (resultData.contains("\n")) {
                                for (String b : resultData.split("\n")) {
                                    Chat.sendComponent((CommandSender)player, b);
                                }
                            } else if (resultData.length() > 0) {
                                Chat.sendComponent((CommandSender)player, resultData);
                            }
                            statement.close();
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{false, System.currentTimeMillis()});
                            if (blockFinal instanceof Sign && player.getGameMode() != GameMode.CREATIVE) {
                                Thread.sleep(1500L);
                                Sign sign = (Sign)blockFinal;
                                player.sendSignChange(sign.getLocation(), sign.getLines(), sign.getColor());
                            }
                        } else {
                            player.sendMessage(Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BasicThread runnable = new BasicThread();
            Thread thread = new Thread(runnable);
            thread.start();
            if (checkBlockData instanceof Bisected) {
                int worldMinHeight;
                int worldMaxHeight = world.getMaxHeight();
                if (y < worldMaxHeight - 1) {
                    Block y1 = world.getBlockAt(x, y + 1, z);
                    player.sendBlockChange(y1.getLocation(), y1.getBlockData());
                }
                if (y > (worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(world))) {
                    Block y2 = world.getBlockAt(x, y - 1, z);
                    player.sendBlockChange(y2.getLocation(), y2.getBlockData());
                }
            }
            Block x1 = world.getBlockAt(x + 1, y, z);
            Block x2 = world.getBlockAt(x - 1, y, z);
            Block z1 = world.getBlockAt(x, y, z + 1);
            Block z2 = world.getBlockAt(x, y, z - 1);
            player.sendBlockChange(x1.getLocation(), x1.getBlockData());
            player.sendBlockChange(x2.getLocation(), x2.getBlockData());
            player.sendBlockChange(z1.getLocation(), z1.getBlockData());
            player.sendBlockChange(z2.getLocation(), z2.getBlockData());
            event.setCancelled(true);
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (block = event.getClickedBlock()) != null) {
            Material type = block.getType();
            boolean isInteractBlock = BlockGroup.INTERACT_BLOCKS.contains(type);
            boolean isContainerBlock = BlockGroup.CONTAINERS.contains(type);
            boolean isSignBlock = Tag.SIGNS.isTagged((Keyed)type);
            if (isInteractBlock || isContainerBlock || isSignBlock) {
                Block clickedBlock = event.getClickedBlock();
                if (isSignBlock) {
                    final Location location = clickedBlock.getLocation();
                    class BasicThread
                    implements Runnable {
                        BasicThread() {
                        }

                        @Override
                        public void run() {
                            Object[] lookupThrottle;
                            if (ConfigHandler.converterRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.purgeRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                return;
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                            try (Connection connection = Database.getConnection(true);){
                                if (connection != null) {
                                    Statement statement = connection.createStatement();
                                    List<String> signData = SignMessageLookup.performLookup(null, statement, location, (CommandSender)player, 1, 7);
                                    for (String signMessage : signData) {
                                        String bypass = null;
                                        if (signMessage.contains("\n")) {
                                            String[] split = signMessage.split("\n");
                                            signMessage = split[0];
                                            bypass = split[1];
                                        }
                                        if (signMessage.length() <= 0) continue;
                                        Chat.sendComponent((CommandSender)player, signMessage, bypass);
                                    }
                                    statement.close();
                                } else {
                                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{false, System.currentTimeMillis()});
                        }
                    }
                    BasicThread runnable = new BasicThread();
                    Thread thread = new Thread(runnable);
                    thread.start();
                    event.setCancelled(true);
                } else if (isContainerBlock && Config.getConfig((World)world).ITEM_TRANSACTIONS) {
                    Location location = null;
                    if (type.equals((Object)Material.CHEST) || type.equals((Object)Material.TRAPPED_CHEST)) {
                        Chest chest = (Chest)clickedBlock.getState();
                        InventoryHolder inventoryHolder = chest.getInventory().getHolder();
                        if (inventoryHolder instanceof DoubleChest) {
                            DoubleChest doubleChest = (DoubleChest)inventoryHolder;
                            location = doubleChest.getLocation();
                        } else {
                            location = chest.getLocation();
                        }
                    }
                    if (location == null) {
                        location = clickedBlock.getLocation();
                    }
                    final Location finalLocation = location;
                    class BasicThread
                    implements Runnable {
                        BasicThread() {
                        }

                        @Override
                        public void run() {
                            Object[] lookupThrottle;
                            if (ConfigHandler.converterRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.purgeRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                return;
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                            try (Connection connection = Database.getConnection(true);){
                                if (connection != null) {
                                    Statement statement = connection.createStatement();
                                    List<String> blockData = ChestTransactionLookup.performLookup(null, statement, finalLocation, (CommandSender)player, 1, 7, false);
                                    for (String data : blockData) {
                                        Chat.sendComponent((CommandSender)player, data);
                                    }
                                    statement.close();
                                } else {
                                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{false, System.currentTimeMillis()});
                        }
                    }
                    BasicThread runnable = new BasicThread();
                    Thread thread = new Thread(runnable);
                    thread.start();
                    event.setCancelled(true);
                } else if (isInteractBlock) {
                    Block interactBlock = clickedBlock;
                    if (BlockGroup.DOORS.contains(type)) {
                        int y = interactBlock.getY() - 1;
                        Block blockUnder = interactBlock.getWorld().getBlockAt(interactBlock.getX(), y, interactBlock.getZ());
                        if (blockUnder.getType().equals((Object)type)) {
                            interactBlock = blockUnder;
                        }
                    }
                    final Block finalInteractBlock = interactBlock;
                    class BasicThread
                    implements Runnable {
                        BasicThread() {
                        }

                        @Override
                        public void run() {
                            Object[] lookupThrottle;
                            if (ConfigHandler.converterRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.purgeRunning) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.lookupThrottle.get(player.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(player.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                                Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                return;
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{true, System.currentTimeMillis()});
                            try (Connection connection = Database.getConnection(true);){
                                if (connection != null) {
                                    Statement statement = connection.createStatement();
                                    String blockData = InteractionLookup.performLookup(null, statement, finalInteractBlock, (CommandSender)player, 0, 1, 7);
                                    if (blockData.contains("\n")) {
                                        for (String splitData : blockData.split("\n")) {
                                            Chat.sendComponent((CommandSender)player, splitData);
                                        }
                                    } else {
                                        Chat.sendComponent((CommandSender)player, blockData);
                                    }
                                    statement.close();
                                } else {
                                    Chat.sendMessage((CommandSender)player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ConfigHandler.lookupThrottle.put(player.getName(), new Object[]{false, System.currentTimeMillis()});
                        }
                    }
                    BasicThread runnable = new BasicThread();
                    Thread thread = new Thread(runnable);
                    thread.start();
                    if (!BlockGroup.SAFE_INTERACT_BLOCKS.contains(type) || player.isSneaking()) {
                        event.setCancelled(true);
                    }
                }
            } else {
                boolean performLookup = true;
                EquipmentSlot eventHand = event.getHand();
                String uuid = event.getPlayer().getUniqueId().toString();
                long systemTime = System.currentTimeMillis();
                if (lastInspectorEvent.get(uuid) != null) {
                    Object[] lastEvent = lastInspectorEvent.get(uuid);
                    long lastTime = (Long)lastEvent[0];
                    EquipmentSlot lastHand = (EquipmentSlot)lastEvent[1];
                    long timeSince = systemTime - lastTime;
                    if (timeSince < 50L && !eventHand.equals((Object)lastHand)) {
                        performLookup = false;
                    }
                }
                if (performLookup) {
                    Material eventItem;
                    final Player finalPlayer = player;
                    final BlockState finalBlock = event.getClickedBlock().getRelative(event.getBlockFace()).getState();
                    class BasicThread
                    implements Runnable {
                        BasicThread() {
                        }

                        @Override
                        public void run() {
                            Object[] lookupThrottle;
                            if (ConfigHandler.converterRunning) {
                                Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.purgeRunning) {
                                Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
                                return;
                            }
                            if (ConfigHandler.lookupThrottle.get(finalPlayer.getName()) != null && (((Boolean)(lookupThrottle = ConfigHandler.lookupThrottle.get(finalPlayer.getName()))[0]).booleanValue() || System.currentTimeMillis() - (Long)lookupThrottle[1] < 100L)) {
                                Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                return;
                            }
                            ConfigHandler.lookupThrottle.put(finalPlayer.getName(), new Object[]{true, System.currentTimeMillis()});
                            try (Connection connection = Database.getConnection(true);){
                                if (connection != null) {
                                    Statement statement = connection.createStatement();
                                    if (finalBlock.getType().equals((Object)Material.AIR) || finalBlock.getType().equals((Object)Material.CAVE_AIR)) {
                                        String blockData = BlockLookup.performLookup(null, statement, finalBlock, (CommandSender)finalPlayer, 0, 1, 7);
                                        if (blockData.contains("\n")) {
                                            for (String b : blockData.split("\n")) {
                                                Chat.sendComponent((CommandSender)finalPlayer, b);
                                            }
                                        } else if (blockData.length() > 0) {
                                            Chat.sendComponent((CommandSender)finalPlayer, blockData);
                                        }
                                    } else {
                                        String blockData = BlockLookup.performLookup(null, statement, finalBlock, (CommandSender)finalPlayer, 0, 1, 7);
                                        if (blockData.contains("\n")) {
                                            for (String splitData : blockData.split("\n")) {
                                                Chat.sendComponent((CommandSender)finalPlayer, splitData);
                                            }
                                        } else if (blockData.length() > 0) {
                                            Chat.sendComponent((CommandSender)finalPlayer, blockData);
                                        }
                                    }
                                    statement.close();
                                } else {
                                    Chat.sendMessage((CommandSender)finalPlayer, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ConfigHandler.lookupThrottle.put(finalPlayer.getName(), new Object[]{false, System.currentTimeMillis()});
                        }
                    }
                    BasicThread runnable = new BasicThread();
                    Thread thread = new Thread(runnable);
                    thread.start();
                    Util.updateInventory(event.getPlayer());
                    lastInspectorEvent.put(uuid, new Object[]{systemTime, eventHand});
                    if (event.hasItem() && (eventItem = event.getItem().getType()).isBlock() && eventItem.createBlockData() instanceof Bisected) {
                        int worldMinHeight;
                        int x = finalBlock.getX();
                        int y = finalBlock.getY();
                        int z = finalBlock.getZ();
                        int worldMaxHeight = world.getMaxHeight();
                        if (y < worldMaxHeight - 1) {
                            Block blockBisected = world.getBlockAt(x, y + 1, z);
                            player.sendBlockChange(blockBisected.getLocation(), blockBisected.getBlockData());
                        }
                        if (y > (worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(world))) {
                            Block blockBisected = world.getBlockAt(x, y - 1, z);
                            player.sendBlockChange(blockBisected.getLocation(), blockBisected.getBlockData());
                        }
                    }
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            World world = event.getClickedBlock().getWorld();
            if (event.useInteractedBlock() != Event.Result.DENY) {
                Block relativeBlock;
                Block block = event.getClickedBlock();
                if (block.getType() == Material.DRAGON_EGG) {
                    this.clickedDragonEgg(event.getPlayer(), block);
                }
                if (Config.getConfig((World)world).BLOCK_BREAK && BlockGroup.FIRE.contains((relativeBlock = event.getClickedBlock().getRelative(event.getBlockFace())).getType())) {
                    Player player = event.getPlayer();
                    Material type = relativeBlock.getType();
                    Queue.queueBlockBreak(player.getName(), relativeBlock.getState(), type, relativeBlock.getBlockData().getAsString(), 0);
                }
            }
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            World world = player.getWorld();
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && block != null) {
                Material type = block.getType();
                if (event.useInteractedBlock() != Event.Result.DENY) {
                    BlockState blockState;
                    ItemStack mainHand;
                    boolean isCake = false;
                    if (Tag.SIGNS.isTagged((Keyed)type)) {
                        EnumSet<Material[]> dyeSet = EnumSet.of(Material.BLACK_DYE, new Material[]{Material.BLUE_DYE, Material.BROWN_DYE, Material.CYAN_DYE, Material.GRAY_DYE, Material.GREEN_DYE, Material.LIGHT_BLUE_DYE, Material.LIGHT_GRAY_DYE, Material.LIME_DYE, Material.MAGENTA_DYE, Material.ORANGE_DYE, Material.PINK_DYE, Material.PURPLE_DYE, Material.RED_DYE, Material.WHITE_DYE, Material.YELLOW_DYE});
                        Material handType = null;
                        mainHand = player.getInventory().getItemInMainHand();
                        if (event.getHand().equals((Object)EquipmentSlot.HAND) && mainHand != null) {
                            handType = mainHand.getType();
                        }
                        if (handType != null && (dyeSet.contains(handType) || handType.name().endsWith("INK_SAC")) && Config.getConfig((World)block.getWorld()).SIGN_TEXT) {
                            boolean oldGlowing;
                            int oldColor;
                            blockState = block.getState();
                            Sign sign = (Sign)blockState;
                            String line1 = sign.getLine(0);
                            String line2 = sign.getLine(1);
                            String line3 = sign.getLine(2);
                            String line4 = sign.getLine(3);
                            int newColor = oldColor = sign.getColor().getColor().asRGB();
                            boolean newGlowing = oldGlowing = BukkitAdapter.ADAPTER.isGlowing(sign);
                            if (dyeSet.contains(handType)) {
                                newColor = DyeColor.valueOf((String)handType.name().replaceFirst("_DYE", "")).getColor().asRGB();
                            } else {
                                boolean bl = newGlowing = handType != Material.INK_SAC;
                            }
                            if (oldGlowing != newGlowing || oldColor != newColor) {
                                Location location = blockState.getLocation();
                                Queue.queueSignText(player.getName(), location, 0, oldColor, oldGlowing, line1, line2, line3, line4, 1);
                                Queue.queueBlockPlace(player.getName(), block.getState(), block.getType(), blockState, block.getType(), -1, 0, blockState.getBlockData().getAsString());
                                Queue.queueSignText(player.getName(), location, 2, newColor, newGlowing, line1, line2, line3, line4, 0);
                            }
                        }
                    } else if (BlockGroup.INTERACT_BLOCKS.contains(type)) {
                        if (event.getHand().equals((Object)EquipmentSlot.HAND) && Config.getConfig((World)world).PLAYER_INTERACTIONS) {
                            Block interactBlock = event.getClickedBlock();
                            if (BlockGroup.DOORS.contains(type)) {
                                int y = interactBlock.getY() - 1;
                                Block blockUnder = interactBlock.getWorld().getBlockAt(interactBlock.getX(), y, interactBlock.getZ());
                                if (blockUnder.getType().equals((Object)type)) {
                                    interactBlock = blockUnder;
                                }
                            }
                            Queue.queuePlayerInteraction(player.getName(), interactBlock.getState(), type);
                        }
                    } else if (BlockGroup.LIGHTABLES.contains(type)) {
                        BlockData blockData = block.getBlockData();
                        if (blockData instanceof Lightable && ((Lightable)blockData).isLit() && (BlockGroup.CANDLES.contains(type) && event.getMaterial() == Material.AIR || !BlockGroup.CANDLES.contains(type) && event.getMaterial().name().endsWith("_SHOVEL"))) {
                            ((Lightable)blockData).setLit(false);
                            Queue.queueBlockPlace(player.getName(), block.getState(), type, block.getState(), type, -1, 0, blockData.getAsString());
                        }
                        isCake = type.name().endsWith(Material.CAKE.name());
                    } else if (type == Material.JUKEBOX) {
                        BlockState blockState2 = block.getState();
                        if (blockState2 instanceof Jukebox) {
                            Jukebox jukebox = (Jukebox)blockState2;
                            ItemStack jukeboxRecord = jukebox.isPlaying() ? jukebox.getRecord() : new ItemStack(Material.AIR);
                            ItemStack oldItemState = jukeboxRecord.clone();
                            ItemStack newItemState = new ItemStack(Material.AIR);
                            if (jukeboxRecord.getType() == Material.AIR) {
                                ItemStack handItem = null;
                                ItemStack mainHand2 = player.getInventory().getItemInMainHand();
                                ItemStack offHand = player.getInventory().getItemInOffHand();
                                if (event.getHand().equals((Object)EquipmentSlot.HAND) && mainHand2 != null && Tag.ITEMS_MUSIC_DISCS.isTagged((Keyed)mainHand2.getType())) {
                                    handItem = mainHand2;
                                } else if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND) && offHand != null && Tag.ITEMS_MUSIC_DISCS.isTagged((Keyed)offHand.getType())) {
                                    handItem = offHand;
                                } else {
                                    return;
                                }
                                oldItemState = new ItemStack(Material.AIR);
                                newItemState = handItem.clone();
                            }
                            if (!oldItemState.equals((Object)newItemState)) {
                                if (Config.getConfig((World)player.getWorld()).PLAYER_INTERACTIONS) {
                                    Queue.queuePlayerInteraction(player.getName(), blockState2, type);
                                }
                                if (Config.getConfig((World)block.getWorld()).ITEM_TRANSACTIONS) {
                                    boolean logDrops = player.getGameMode() != GameMode.CREATIVE;
                                    ItemStack[] oldState = new ItemStack[]{oldItemState};
                                    ItemStack[] newState = new ItemStack[]{newItemState};
                                    PlayerInteractEntityListener.queueContainerSpecifiedItems(player.getName(), Material.JUKEBOX, new Object[]{oldState, newState}, jukebox.getLocation(), logDrops);
                                }
                            }
                        }
                    } else if (type == Material.DRAGON_EGG) {
                        this.clickedDragonEgg(player, block);
                    }
                    if (isCake || type == Material.CAKE) {
                        boolean placeCandle = false;
                        if (type == Material.CAKE) {
                            Material handType = null;
                            mainHand = player.getInventory().getItemInMainHand();
                            if (event.getHand().equals((Object)EquipmentSlot.HAND) && mainHand != null) {
                                handType = mainHand.getType();
                            }
                            if (handType != null && BlockGroup.CANDLES.contains(handType) && Config.getConfig((World)block.getWorld()).BLOCK_PLACE) {
                                blockState = block.getState();
                                Entity[] blockData = blockState.getBlockData();
                                Material newMaterial = Material.getMaterial((String)(handType.name() + "_" + Material.CAKE.name()));
                                if (newMaterial != null && ((Cake)blockData).getBites() == 0) {
                                    Queue.queueBlockPlace(player.getName(), block.getState(), block.getType(), blockState, newMaterial, -1, 0, blockData.getAsString());
                                    placeCandle = true;
                                }
                            }
                        }
                        if (!placeCandle) {
                            String userUUID = player.getUniqueId().toString();
                            Location location = player.getLocation();
                            long time = System.currentTimeMillis();
                            int wid = Util.getWorldId(location.getWorld().getName());
                            int x = location.getBlockX();
                            int y = location.getBlockY();
                            int z = location.getBlockZ();
                            String coordinates = x + "." + y + "." + z + "." + wid + "." + userUUID;
                            CacheHandler.interactCache.put(coordinates, new Object[]{time, Material.CAKE, block.getState()});
                        }
                    }
                }
            }
            if (event.useItemInHand() != Event.Result.DENY) {
                List<Material> entityBlockTypes = Arrays.asList(Material.ARMOR_STAND, Material.END_CRYSTAL, Material.BOW, Material.CROSSBOW, Material.TRIDENT, Material.EXPERIENCE_BOTTLE, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.ENDER_PEARL, Material.FIREWORK_ROCKET, Material.EGG, Material.SNOWBALL);
                ItemStack handItem = null;
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offHand = player.getInventory().getItemInOffHand();
                if (event.getHand().equals((Object)EquipmentSlot.HAND) && mainHand != null && entityBlockTypes.contains(mainHand.getType())) {
                    handItem = mainHand;
                } else if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND) && offHand != null && entityBlockTypes.contains(offHand.getType())) {
                    handItem = offHand;
                } else {
                    return;
                }
                if (handItem.getType().equals((Object)Material.END_CRYSTAL)) {
                    if (block != null && Config.getConfig((World)world).BLOCK_PLACE && (block.getType().equals((Object)Material.OBSIDIAN) || block.getType().equals((Object)Material.BEDROCK))) {
                        Location crystalLocation = block.getLocation().clone();
                        crystalLocation.setY(crystalLocation.getY() + 1.0);
                        boolean exists = false;
                        for (Entity entity : crystalLocation.getChunk().getEntities()) {
                            if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != crystalLocation.getBlockX() || entity.getLocation().getBlockY() != crystalLocation.getBlockY() || entity.getLocation().getBlockZ() != crystalLocation.getBlockZ()) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            Player playerFinal = player;
                            Location locationFinal = crystalLocation;
                            Scheduler.runTask(CoreProtect.getInstance(), () -> {
                                try {
                                    boolean blockExists = false;
                                    int showingBottom = 0;
                                    for (Entity entity : locationFinal.getChunk().getEntities()) {
                                        if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != locationFinal.getBlockX() || entity.getLocation().getBlockY() != locationFinal.getBlockY() || entity.getLocation().getBlockZ() != locationFinal.getBlockZ()) continue;
                                        EnderCrystal enderCrystal = (EnderCrystal)entity;
                                        showingBottom = enderCrystal.isShowingBottom() ? 1 : 0;
                                        blockExists = true;
                                        break;
                                    }
                                    if (blockExists) {
                                        Queue.queueBlockPlace(playerFinal.getName(), locationFinal.getBlock().getState(), locationFinal.getBlock().getType(), locationFinal.getBlock().getState(), Material.END_CRYSTAL, showingBottom, 1, null);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }, locationFinal);
                        }
                    }
                } else {
                    Location relativeBlockLocation = player.getLocation().clone();
                    relativeBlockLocation.setY(relativeBlockLocation.getY() + 1.0);
                    Location blockLocation = relativeBlockLocation.clone();
                    blockLocation.setY(blockLocation.getY() + 1.0);
                    if (handItem.getType() == Material.ARMOR_STAND || handItem.getType() == Material.FIREWORK_ROCKET) {
                        if (block == null) {
                            return;
                        }
                        Block relativeBlock = block.getRelative(event.getBlockFace());
                        relativeBlockLocation = relativeBlock.getLocation();
                        blockLocation = block.getLocation();
                    }
                    String relativeBlockKey = world.getName() + "-" + relativeBlockLocation.getBlockX() + "-" + relativeBlockLocation.getBlockY() + "-" + relativeBlockLocation.getBlockZ();
                    String blockKey = world.getName() + "-" + blockLocation.getBlockX() + "-" + blockLocation.getBlockY() + "-" + blockLocation.getBlockZ();
                    Object[] keys = new Object[]{relativeBlockKey, blockKey, handItem};
                    ConfigHandler.entityBlockMapper.put(player.getName(), keys);
                }
            }
        } else if (event.getAction().equals((Object)Action.PHYSICAL)) {
            Block block = event.getClickedBlock();
            if (block == null || !block.getType().equals((Object)Material.FARMLAND) && !block.getType().equals((Object)Material.TURTLE_EGG)) {
                return;
            }
            World world = block.getWorld();
            if (event.useInteractedBlock() != Event.Result.DENY && Config.getConfig((World)world).BLOCK_BREAK) {
                Block blockAbove;
                Material type;
                Player player = event.getPlayer();
                if (block.getType().equals((Object)Material.FARMLAND) && !(type = (blockAbove = world.getBlockAt(block.getX(), block.getY() + 1, block.getZ())).getType()).equals((Object)Material.AIR) && !type.equals((Object)Material.CAVE_AIR)) {
                    Queue.queueBlockBreak(player.getName(), blockAbove.getState(), type, blockAbove.getBlockData().getAsString(), 0);
                }
                Queue.queueBlockBreak(player.getName(), block.getState(), block.getType(), block.getBlockData().getAsString(), 0);
                Queue.queueBlockPlaceDelayed(player.getName(), block.getLocation(), block.getType(), null, null, 0);
            }
        }
    }

    private void clickedDragonEgg(Player player, Block block) {
        Location location = block.getLocation();
        long time = System.currentTimeMillis();
        int wid = Util.getWorldId(location.getWorld().getName());
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        String coordinates = x + "." + y + "." + z + "." + wid + "." + Material.DRAGON_EGG.name();
        CacheHandler.interactCache.put(coordinates, new Object[]{time, Material.DRAGON_EGG, player.getName()});
    }
}

