/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.FindBiome;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.FindBiome.FindBiomeInfo;
import com.Zrips.CMI.Modules.Region.CMIRegion;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import com.Zrips.CMI.Modules.tp.Teleportations;
import com.Zrips.CMI.commands.list.findbiome;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FindBiomeManager {
    public ConcurrentHashMap<UUID, FindBiomeInfo> FindBiomeInfo = new ConcurrentHashMap();
    private CMI plugin;

    public FindBiomeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public boolean stop(Player player) {
        if (this.FindBiomeInfo.containsKey(player.getUniqueId())) {
            FindBiomeInfo findBiomeInfo = this.FindBiomeInfo.get(player.getUniqueId());
            findBiomeInfo.setRunning(false);
            Bukkit.getServer().getScheduler().cancelTask(findBiomeInfo.getScheduleId());
            return true;
        }
        return false;
    }

    public void start(FindBiomeInfo findBiomeInfo) {
        if (this.FindBiomeInfo.containsKey(findBiomeInfo.getPlayer().getUniqueId())) {
            FindBiomeInfo findBiomeInfo2 = this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
            findBiomeInfo2.setRunning(false);
            Bukkit.getServer().getScheduler().cancelTask(findBiomeInfo2.getScheduleId());
        }
        this.FindBiomeInfo.put(findBiomeInfo.getPlayer().getUniqueId(), findBiomeInfo);
        if (findBiomeInfo.getStartTime() == 0L) {
            findBiomeInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(findBiomeInfo);
    }

    private void loadChunk(final FindBiomeInfo findBiomeInfo) {
        Bukkit.getServer().getScheduler().cancelTask(findBiomeInfo.getScheduleId());
        findBiomeInfo.setscheduleId(Bukkit.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)FindBiomeManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).FindBiomeManager.this.FindBiomeInfo.containsKey(findBiomeInfo.getPlayer().getUniqueId())) {
                            return;
                        }
                        if (!findBiomeInfo.isRunning()) {
                            return;
                        }
                        Location location = findBiomeInfo.getRI().getWorld().getWorldBorder().getCenter();
                        double d = findBiomeInfo.getRI().getWorld().getWorldBorder().getSize() / 2.0;
                        double d2 = location.getX() - d;
                        double d3 = location.getX() + d;
                        double d4 = location.getZ() - d;
                        double d5 = location.getZ() + d;
                        int n = 0;
                        while (n < findBiomeInfo.getSpeed()) {
                            WorldInfo worldInfo = findBiomeInfo.getRI();
                            CMIRegion cMIRegion = worldInfo.getNextChunkLoc(true);
                            worldInfo.addLastChecked();
                            if (worldInfo.allChecked()) {
                                findBiomeInfo.setRunning(false);
                                Bukkit.getServer().getScheduler().cancelTask(findBiomeInfo.getScheduleId());
                                (this).FindBiomeManager.this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
                                if (findBiomeInfo.getPlayer().isOnline()) {
                                    findBiomeInfo.getPlayer().sendMessage(FindBiomeManager.this.plugin.getLM().getMessage("command.findbiome.info.cantFindBiome", "[amount]", findBiomeInfo.getRI().getTotalChunks()));
                                }
                                return;
                            }
                            if (!(cMIRegion == null || (double)(cMIRegion.getX() * 16) < d2 || (double)(cMIRegion.getX() * 16) > d3 || (double)(cMIRegion.getZ() * 16) < d4 || (double)(cMIRegion.getZ() * 16) > d5)) {
                                Location location2;
                                final Biome biome = findBiomeInfo.getRI().getWorld().getBiome(cMIRegion.getX() * 16, cMIRegion.getZ() * 16);
                                if (findBiomeInfo.isMessages() && findBiomeInfo.getShowInfo() + 2000L < System.currentTimeMillis()) {
                                    findBiomeInfo.setShowRegionInfo(false);
                                    long l = worldInfo.getLastChecked();
                                    l = l < 1L ? 1L : l;
                                    Long l2 = worldInfo.getLeftToScan();
                                    long l3 = System.currentTimeMillis() - findBiomeInfo.getStartTime();
                                    double d6 = l3 / l;
                                    double d7 = (double)l2.longValue() * d6;
                                    CMIActionBar.send((Player)findBiomeInfo.getPlayer(), (String)FindBiomeManager.this.plugin.getLM().getMessage("command.findbiome.info.infoShow", "[tps]", String.format("%.2f", FindBiomeManager.this.plugin.getLagMeter().getTPS()), "[left]", l2, "[time]", CMITimeManager.to24hourShort((Long)((long)d7)), "[speed]", findBiomeInfo.getSpeed()));
                                    if (FindBiomeManager.this.plugin.getLagMeter().getTPS() > ((FindBiomeManager)(this).FindBiomeManager.this).plugin.getConfigManager().scanSoftCap) {
                                        findBiomeInfo.setSpeed(findBiomeInfo.getSpeed() + 100);
                                    } else if (findBiomeInfo.getSpeed() - 500 >= 0) {
                                        findBiomeInfo.setSpeed(findBiomeInfo.getSpeed() - 500);
                                    } else {
                                        findBiomeInfo.setSpeed(1);
                                    }
                                    findBiomeInfo.setShowInfo(System.currentTimeMillis());
                                }
                                if (biome.equals((Object)findBiomeInfo.getBiome()) && findBiomeInfo.getPlayer().isOnline() && (!(location2 = new Location(findBiomeInfo.getRI().getWorld(), (double)(cMIRegion.getX() * 16 + 8), 64.0, (double)(cMIRegion.getZ() * 16 + 8))).getWorld().equals(findBiomeInfo.getPlayer().getWorld()) || !(location2.distance(findBiomeInfo.getPlayer().getLocation()) < (double)(FindBiomeManager.this.plugin.getViewRange(null) * 16 / 2)))) {
                                    findBiomeInfo.setRunning(false);
                                    Bukkit.getServer().getScheduler().cancelTask(findBiomeInfo.getScheduleId());
                                    (this).FindBiomeManager.this.FindBiomeInfo.remove(findBiomeInfo.getPlayer().getUniqueId());
                                    Bukkit.getScheduler().runTask((Plugin)FindBiomeManager.this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            if (findBiomeInfo.getPlayer().isOnline()) {
                                                if (location2.getWorld().getEnvironment() == World.Environment.NETHER) {
                                                    location2.setY(64.0);
                                                    FindBiomeManager.this.plugin.getTeleportations().teleport(findBiomeInfo.getPlayer(), location2, false, Teleportations.TeleportType.Biome);
                                                } else {
                                                    FindBiomeManager.this.plugin.getTeleportations().teleport(findBiomeInfo.getPlayer(), location2.getWorld().getHighestBlockAt(location2).getLocation(), false, Teleportations.TeleportType.Biome);
                                                }
                                                CMILC.info(findbiome.class, (CommandSender)findBiomeInfo.getPlayer(), "teleportedTo", "[biome]", biome.name().toLowerCase());
                                            }
                                        }
                                    });
                                    return;
                                }
                            }
                            ++n;
                        }
                        FindBiomeManager.this.loadChunk(findBiomeInfo);
                    }
                });
            }
        }, 1L));
    }
}

