/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Ranks;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import com.Zrips.CMI.Modules.Ranks.CMIRankPlaceholder;
import com.Zrips.CMI.Modules.Ranks.RankManager;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import org.bukkit.entity.Player;

public class CMIRank {
    private String name;
    private String displayName;
    private boolean enabled;
    private boolean defaultRank;
    private boolean AutoRankup;
    private boolean rankUpConfirmation;
    private List<CMIRank> nextRanks;
    private List<String> nextRanksT;
    private List<String> Commands;
    private List<String> CommandsOnRankDown;
    private LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> statRequirements;
    private LinkedHashMap<String, String> permRequirements;
    private LinkedHashMap<String, CMIRankPlaceholder> placeholderRequirements;
    private LinkedHashMap<String, Integer> mcmmoRequirements;
    private LinkedHashMap<String, Integer> aureliumRequirements;
    private LinkedHashMap<String, Integer> JobsRequirements;
    private LinkedHashMap<CMIItemStack, Integer> ItemRequirements;
    private double moneyCost;
    private double expCost;
    private int votes;
    private int weight = 0;

    public void reset() {
        this.enabled = false;
        this.defaultRank = false;
        this.AutoRankup = false;
        this.rankUpConfirmation = false;
        this.nextRanks = new ArrayList<CMIRank>();
        this.nextRanksT = new ArrayList<String>();
        this.Commands = new ArrayList<String>();
        this.CommandsOnRankDown = new ArrayList<String>();
        this.statRequirements = new LinkedHashMap();
        this.permRequirements = new LinkedHashMap();
        this.placeholderRequirements = new LinkedHashMap();
        this.mcmmoRequirements = new LinkedHashMap();
        this.aureliumRequirements = new LinkedHashMap();
        this.JobsRequirements = new LinkedHashMap();
        this.ItemRequirements = new LinkedHashMap();
        this.moneyCost = 0.0;
        this.expCost = 0.0;
        this.votes = 0;
    }

    public CMIRank(String string) {
        this.name = string;
        this.reset();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isDefaultRank() {
        return this.defaultRank;
    }

    public void setDefaultRank(boolean bl) {
        this.defaultRank = bl;
    }

    public boolean isRankUpConfirmation() {
        return this.rankUpConfirmation;
    }

    public void setRankUpConfirmation(boolean bl) {
        this.rankUpConfirmation = bl;
    }

    public List<CMIRank> getNextRanks() {
        return this.nextRanks;
    }

    public List<CMIRank> getNextValidRankUps(CMIUser cMIUser) {
        ArrayList<CMIRank> arrayList = new ArrayList<CMIRank>();
        for (CMIRank cMIRank : this.getNextRanks()) {
            if (cMIRank.canRankup(cMIUser) != RankManager.rankupFailType.None) continue;
            arrayList.add(cMIRank);
        }
        return arrayList;
    }

    public boolean isOnSamePathWith(CMIRank cMIRank) {
        if (this.checkPrevious(this, cMIRank)) {
            return true;
        }
        return this.checkNext(this, cMIRank);
    }

    private boolean checkPrevious(CMIRank cMIRank, CMIRank cMIRank2) {
        List<CMIRank> list2 = cMIRank.getPreviousRanks();
        if (list2.contains(cMIRank2)) {
            return true;
        }
        for (CMIRank cMIRank3 : list2) {
            if (cMIRank3 == cMIRank || !this.checkPrevious(cMIRank3, cMIRank2)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNext(CMIRank cMIRank, CMIRank cMIRank2) {
        List<CMIRank> list2 = cMIRank.getNextRanks();
        if (list2.contains(cMIRank2)) {
            return true;
        }
        for (CMIRank cMIRank3 : list2) {
            if (cMIRank3 == cMIRank || !this.checkNext(cMIRank3, cMIRank2)) continue;
            return true;
        }
        return false;
    }

    public List<CMIRank> getPreviousRanks() {
        ArrayList<CMIRank> arrayList = new ArrayList<CMIRank>();
        for (Map.Entry<String, CMIRank> entry : CMI.getInstance().getRankManager().getRanks().entrySet()) {
            for (CMIRank cMIRank : entry.getValue().getNextRanks()) {
                if (!cMIRank.getName().equals(this.getName())) continue;
                arrayList.add(entry.getValue());
            }
        }
        return arrayList;
    }

    public List<CMIRank> getValidPreviousRanks(CMIUser cMIUser) {
        CMIRank cMIRank = cMIUser.getRank();
        ArrayList<CMIRank> arrayList = new ArrayList<CMIRank>();
        for (Map.Entry<String, CMIRank> entry : CMI.getInstance().getRankManager().getRanks().entrySet()) {
            for (CMIRank cMIRank2 : entry.getValue().getNextRanks()) {
                if (!cMIRank2.getName().equals(cMIRank.getName())) continue;
                arrayList.add(entry.getValue());
            }
        }
        return arrayList;
    }

    public String getValidPreviousRanksAsString() {
        String string = "";
        for (Map.Entry<String, CMIRank> entry : CMI.getInstance().getRankManager().getRanks().entrySet()) {
            for (CMIRank cMIRank : entry.getValue().getNextRanks()) {
                if (!cMIRank.getName().equals(this.getName())) continue;
                if (!string.isEmpty()) {
                    string = String.valueOf(string) + LC.info_ListSpliter.getLocale(new Object[0]);
                }
                string = String.valueOf(string) + entry.getValue().getDisplayName();
            }
        }
        return string;
    }

    public RankManager.rankupFailType canRankup(CMIUser cMIUser) {
        if (cMIUser.getRank() == this) {
            return RankManager.rankupFailType.SameRank;
        }
        return CMI.getInstance().getRankManager().canRankUp(cMIUser, this);
    }

    public double getMoneyCost() {
        return this.moneyCost;
    }

    public void setMoneyCost(double d) {
        this.moneyCost = d;
    }

    public double getExpCost() {
        return this.expCost;
    }

    public void setExpCost(double d) {
        this.expCost = d;
    }

    public List<String> getCommands() {
        return this.Commands;
    }

    public void setCommands(List<String> list2) {
        this.Commands = list2;
    }

    public LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> getStatRequirements() {
        return this.statRequirements;
    }

    public LinkedHashMap<Object, Long> getStatRequirement(StatsManager.CMIStatistic cMIStatistic) {
        return this.statRequirements.get((Object)cMIStatistic);
    }

    public CMIRank addStatRequirement(StatsManager.CMIStatistic cMIStatistic, String string, Long l) {
        CMIEntityType cMIEntityType;
        LinkedHashMap<Object, Long> linkedHashMap = this.getStatRequirement(cMIStatistic);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
        }
        if (string.equalsIgnoreCase("none")) {
            linkedHashMap.put(string, l);
            this.statRequirements.put(cMIStatistic, linkedHashMap);
        } else if (cMIStatistic.getSubType() == StatsManager.CMIType.Block || cMIStatistic.getSubType() == StatsManager.CMIType.Material) {
            CMIMaterial cMIMaterial = CMIMaterial.get((String)string);
            if (cMIMaterial != null && cMIMaterial != CMIMaterial.NONE) {
                linkedHashMap.put(cMIMaterial, l);
                this.statRequirements.put(cMIStatistic, linkedHashMap);
            }
        } else if (cMIStatistic.getSubType() == StatsManager.CMIType.Entity && (cMIEntityType = CMIEntityType.getByName((String)string)) != null) {
            linkedHashMap.put(cMIEntityType, l);
            this.statRequirements.put(cMIStatistic, linkedHashMap);
        }
        return this;
    }

    public void setStatRequirements(LinkedHashMap<StatsManager.CMIStatistic, LinkedHashMap<Object, Long>> linkedHashMap) {
        this.statRequirements = linkedHashMap;
    }

    public boolean isAutoRankup() {
        return this.AutoRankup;
    }

    public void setAutoRankup(boolean bl) {
        this.AutoRankup = bl;
    }

    public void setNextRanksT(List<String> list2) {
        this.nextRanksT = list2;
    }

    public void calculateNextRanks() {
        this.nextRanks.clear();
        for (String string : this.nextRanksT) {
            CMIRank cMIRank = CMI.getInstance().getRankManager().getRank(string);
            if (cMIRank == null) continue;
            this.nextRanks.add(cMIRank);
        }
    }

    public void finalizeRankup(CMIUser cMIUser) {
        this.finalizeRankup(cMIUser, true, true);
    }

    public void finalizeRankup(CMIUser cMIUser, Boolean bl, Boolean bl2) {
        ParticleManager.CMIPresetAnimations cMIPresetAnimations;
        if (bl.booleanValue()) {
            this.performCommands(cMIUser);
        }
        if (bl2.booleanValue()) {
            this.takeMoney(cMIUser);
            this.takeExp(cMIUser);
            CMI.getInstance().getRankManager().removeContents(cMIUser.getPlayer(), this.getItemRequirements());
        }
        CMI.getInstance().getRankManager().removeFromCheck(cMIUser.getUniqueId());
        cMIUser.addForDelayedSave();
        if (cMIUser.isOnline() && (cMIPresetAnimations = CMI.getInstance().getRankManager().getRankEffect()) != null && cMIPresetAnimations.isEnabled()) {
            cMIPresetAnimations.show(cMIUser.getPlayer(false));
        }
    }

    @Deprecated
    public void takeExp(CMIUser cMIUser) {
        if (this.getExpCost() <= 0.0) {
            return;
        }
        Player player = cMIUser.getPlayer();
        int n = (int)((double)cMIUser.getExp() - this.getExpCost());
        if (n < 0) {
            return;
        }
        player.setLevel(0);
        player.setExp(0.0f);
        player.setTotalExperience(0);
        player.giveExp(n);
    }

    @Deprecated
    public void takeMoney(CMIUser cMIUser) {
        if (this.getMoneyCost() <= 0.0) {
            return;
        }
        cMIUser.withdraw(this.getMoneyCost());
    }

    public void takeItems(CMIUser cMIUser) {
        CMI.getInstance().getRankManager().removeContents(cMIUser.getPlayer(), this.getItemRequirements());
    }

    public void performCommands(CMIUser cMIUser) {
        Snd snd = new Snd().setSender(cMIUser).setTarget(cMIUser);
        List<String> list2 = new ArrayList<String>(this.Commands);
        list2 = CMI.getInstance().getLM().updateSnd(snd, list2);
        CMI.getInstance().getSpecializedCommandManager().processCmds(list2, cMIUser.isOnline() ? cMIUser.getPlayer() : null);
    }

    public void performCommandsOnRankDown(CMIUser cMIUser) {
        Snd snd = new Snd().setSender(cMIUser).setTarget(cMIUser);
        List<String> list2 = new ArrayList<String>(this.CommandsOnRankDown);
        list2 = CMI.getInstance().getLM().updateSnd(snd, list2);
        CMI.getInstance().getSpecializedCommandManager().processCmds(list2, cMIUser.isOnline() ? cMIUser.getPlayer() : null);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.getName();
        }
        return CMIChatColor.translate((String)this.displayName);
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public LinkedHashMap<String, String> getPermRequirements() {
        return this.permRequirements;
    }

    public void setPermRequirements(LinkedHashMap<String, String> linkedHashMap) {
        this.permRequirements = linkedHashMap;
    }

    public LinkedHashMap<String, Integer> getMcmmoRequirements() {
        return this.mcmmoRequirements;
    }

    public void setMcmmoRequirements(LinkedHashMap<String, Integer> linkedHashMap) {
        this.mcmmoRequirements = linkedHashMap;
    }

    public LinkedHashMap<String, Integer> getJobsRequirements() {
        return this.JobsRequirements;
    }

    public void setJobsRequirements(LinkedHashMap<String, Integer> linkedHashMap) {
        this.JobsRequirements = linkedHashMap;
    }

    public LinkedHashMap<CMIItemStack, Integer> getItemRequirements() {
        return this.ItemRequirements;
    }

    public void setItemRequirements(LinkedHashMap<CMIItemStack, Integer> linkedHashMap) {
        this.ItemRequirements = linkedHashMap;
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int n) {
        this.votes = n;
    }

    public List<String> getCommandsOnRankDown() {
        return this.CommandsOnRankDown;
    }

    public void setCommandsOnRankDown(List<String> list2) {
        this.CommandsOnRankDown = list2;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public LinkedHashMap<String, Integer> getAureliumRequirements() {
        return this.aureliumRequirements;
    }

    public void setAureliumRequirements(LinkedHashMap<String, Integer> linkedHashMap) {
        this.aureliumRequirements = linkedHashMap;
    }

    public LinkedHashMap<String, CMIRankPlaceholder> getPlaceholderRequirements() {
        return this.placeholderRequirements;
    }

    public void setPlaceholderRequirements(LinkedHashMap<String, CMIRankPlaceholder> linkedHashMap) {
        this.placeholderRequirements = linkedHashMap;
    }
}

