/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SpawnerCharge;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.SpawnerCharge.PlayerCharge;
import com.Zrips.CMI.Modules.SpawnerCharge.SCharges;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpawnerChargeManager {
    private LinkedHashMap<String, SCharges> map = new LinkedHashMap();
    private Integer total = 0;
    private HashMap<UUID, PlayerCharge> spawnerCharges = new HashMap();
    private boolean SpawnersSupportDisabled = false;
    private int SpawnersBreakBaseDropChance = 100;
    private boolean SpawnersXpDrop = true;
    private boolean SpawnersBreakEnabled = false;
    private boolean SpawnersPlaceEnabled = false;
    private boolean SpawnersPlaceRequiresPermission = false;
    private boolean SpawnersBreakRequiresExactPermission = false;
    private boolean SpawnersPlaceRequiresExactPermission = false;
    private boolean SpawnersEggInteractRequiresPermission = false;
    private int SpawnersBreakSilkTouchLevel = 1;
    private boolean SpawnerDropFromTnt = false;
    private int SpawnerDropChanceTnt = 30;
    private boolean SpawnerDropFromCreeper = false;
    private int SpawnerDropChanceCreeper = 30;
    private boolean ChargesUse = false;
    private boolean ChargesBreakWithoutCharge = false;
    private boolean SpawnersProximityUse = false;
    private int SpawnersProximityRange = 0;

    public void loadConfig() {
        ConfigReader configReader = CMI.getInstance().getConfigManager().getConfig();
        configReader.addComment("Spawners.FullDisable", new String[]{"If you experiencing issues with spawner handling, set this to true to avoid any spawner manipulations from CMI side", "This will disable features like, spawner placement, spawner drops, spawner charges and so on"});
        this.SpawnersSupportDisabled = configReader.get("Spawners.FullDisable", Boolean.valueOf(false));
        configReader.addComment("Spawners.Break.Enabled", new String[]{"ATTENTION! cmi.dropspawner will be required to get spawner dropping for the player", "Enable or disable spawner handler for spawner break", "If enabled player will get spawner if using silktouch pickaxe and have cmi.dropspawner permission node", "If player has cmi.dropspawner.nosilk permission node, player is not required to use silk touch pickaxe to get droped spawner"});
        this.SpawnersBreakEnabled = configReader.get("Spawners.Break.Enabled", Boolean.valueOf(false));
        configReader.addComment("Spawners.Break.RequiresExactPermission", new String[]{"If set to true, player will need to have particular permission node to break and get particular spawner.", "In example: player should have cmi.dropspawner.pig to break pig spawner and get it dropped, or cmi.dropspawner.zombie to get zombie spawner"});
        this.SpawnersBreakRequiresExactPermission = configReader.get("Spawners.Break.RequiresExactPermission", Boolean.valueOf(false));
        configReader.addComment("Spawners.Break.DropExp", new String[]{"When set to false, exp will not be dropped from broken spawner independent if spawner it self is being dropped", "When set to true exp will be dropped only if spawner is not"});
        this.SpawnersXpDrop = configReader.get("Spawners.Break.DropExp", Boolean.valueOf(false));
        configReader.addComment("Spawners.Break.SilkTouchLevel", new String[]{"Minimal silktouch level required to get spawner back"});
        this.SpawnersBreakSilkTouchLevel = configReader.get("Spawners.Break.SilkTouchLevel", 1);
        configReader.addComment("Spawners.Break.BaseDropChance", new String[]{"Number in percentage from 0 up to 100 for a spawner to be dropped when you break one"});
        this.SpawnersBreakBaseDropChance = configReader.get("Spawners.Break.BaseDropChance", 100);
        this.SpawnersBreakBaseDropChance = this.SpawnersBreakBaseDropChance > 100 ? 100 : (this.SpawnersBreakBaseDropChance < 0 ? 0 : this.SpawnersBreakBaseDropChance);
        configReader.addComment("Spawners.Place.Enabled", new String[]{"Enable or disable spawner handler for spawner place", "If enabled player will place spawner depending from what it is by its type", "If disabled then spawner will be placed in normal way and it will allow other plugins to handle its placement"});
        this.SpawnersPlaceEnabled = configReader.get("Spawners.Place.Enabled", Boolean.valueOf(true));
        configReader.addComment("Spawners.Place.RequiresPermission", new String[]{"If set to true, player will need to have appropriate permission node to place spawner by its type"});
        this.SpawnersPlaceRequiresPermission = configReader.get("Spawners.Place.RequiresPermission", Boolean.valueOf(false));
        configReader.addComment("Spawners.Place.RequiresExactPermission", new String[]{"RequiresPermission should be set to true for this to work. If set to true, player will need to have particular permission node to place particular spawner.", "In example: player should have cmi.placespawner.pig to place pig spawner, or cmi.placespawner.zombie to place zombie spawner", "If set to false, then player will need to have basic cmi.placespawner permission to place any type of spawner"});
        this.SpawnersPlaceRequiresExactPermission = configReader.get("Spawners.Place.RequiresExactPermission", Boolean.valueOf(false));
        configReader.addComment("Spawners.Interact.EggRequiresPermission", new String[]{"When set to true, players trying to change spawner with monster egg will require appropriate permission node", "In example: player should have cmi.egginteract.pig to change spawner into pig, or cmi.egginteract.zombie to change into zombie spawner"});
        this.SpawnersEggInteractRequiresPermission = configReader.get("Spawners.Interact.EggRequiresPermission", Boolean.valueOf(false));
        configReader.addComment("Spawners.TnTExplosionDrop", new String[]{"If set to true, spawners will have chance to be dropped when destroying with tnt"});
        this.SpawnerDropFromTnt = configReader.get("Spawners.TnTExplosionDrop.use", Boolean.valueOf(false));
        configReader.addComment("Spawners.TnTExplosionDrop.Chance", new String[]{"Chance in percentage for spawner to drop"});
        this.SpawnerDropChanceTnt = configReader.get("Spawners.TnTExplosionDrop.Chance", 30);
        configReader.addComment("Spawners.CreeperExplosionDrop", new String[]{"If set to true, spawners will have chance to be dropped when destroyed by creeper"});
        this.SpawnerDropFromCreeper = configReader.get("Spawners.CreeperExplosionDrop.use", Boolean.valueOf(false));
        this.SpawnerDropChanceCreeper = configReader.get("Spawners.CreeperExplosionDrop.Chance", 30);
        configReader.addComment("Spawners.Charges.Use", new String[]{"When enabled players will be assigned to particular spawner charges group who have cmi.spawners.charge.[groupName] permission node", "Players will be limited to how many spawners they can mine", "StartingCharge will determine how many charges they will have on first time joining group", "MaxCharge will limit to how many charges you can have at one time", "Cooldown determines how often new charge will be given", "Bonus is optional and it will determine by how many seconds to lower cooldown for next charge when placing spawner", "Option to bypass limitations with cmi.spawners.charge.bypass"});
        this.ChargesUse = configReader.get("Spawners.Charges.Use", Boolean.valueOf(false));
        configReader.addComment("Spawners.Charges.BreakWithoutCharge", new String[]{"If set to true when player runs out of spawner charges spawner will be destroyed without droping it"});
        this.ChargesBreakWithoutCharge = configReader.get("Spawners.Charges.BreakWithoutCharge", Boolean.valueOf(false));
        if (!configReader.getC().isConfigurationSection("Spawners.Charges.List") || configReader.getC().getConfigurationSection("Spawners.Charges").getKeys(false).size() < 2) {
            configReader.get("Spawners.Charges.List.Noob.Use", Boolean.valueOf(false));
            configReader.get("Spawners.Charges.List.Noob.StartingCharge", 2);
            configReader.get("Spawners.Charges.List.Noob.MaxCharge", 5);
            configReader.get("Spawners.Charges.List.Noob.Cooldown", 3600);
            configReader.get("Spawners.Charges.List.Noob.Bonus", 10);
            configReader.get("Spawners.Charges.List.Advanced.Use", Boolean.valueOf(false));
            configReader.get("Spawners.Charges.List.Advanced.StartingCharge", 3);
            configReader.get("Spawners.Charges.List.Advanced.MaxCharge", 6);
            configReader.get("Spawners.Charges.List.Advanced.Cooldown", 3000);
            configReader.get("Spawners.Charges.List.Advanced.Bonus", 10);
        }
        if (configReader.getC().isConfigurationSection("Spawners.Charges.List")) {
            Set set = configReader.getC().getConfigurationSection("Spawners.Charges.List").getKeys(false);
            for (String string : set) {
                if (!configReader.getC().isBoolean("Spawners.Charges.List." + string + ".Use") || !configReader.getC().isInt("Spawners.Charges.List." + string + ".StartingCharge") || !configReader.getC().isInt("Spawners.Charges.List." + string + ".MaxCharge") || !configReader.getC().isInt("Spawners.Charges.List." + string + ".Cooldown")) continue;
                boolean bl = configReader.get("Spawners.Charges.List." + string + ".Use", Boolean.valueOf(configReader.getC().getBoolean("Spawners.Charges.List." + string + ".Use")));
                int n = configReader.get("Spawners.Charges.List." + string + ".StartingCharge", configReader.getC().getInt("Spawners.Charges.List." + string + ".StartingCharge"));
                int n2 = configReader.get("Spawners.Charges.List." + string + ".MaxCharge", configReader.getC().getInt("Spawners.Charges.List." + string + ".MaxCharge"));
                int n3 = configReader.get("Spawners.Charges.List." + string + ".Cooldown", configReader.getC().getInt("Spawners.Charges.List." + string + ".Cooldown"));
                int n4 = 0;
                if (configReader.getC().isInt("Spawners.Charges.List." + string + ".Bonus")) {
                    n4 = configReader.get("Spawners.Charges.List." + string + ".Bonus", configReader.getC().getInt("Spawners.Charges.List." + string + ".Bonus"));
                }
                if (!bl) continue;
                SCharges sCharges = new SCharges(string, n, n2, n3);
                sCharges.setBonus(n4);
                if (!this.ChargesUse) continue;
                CMI.getInstance().getSpawnerChargesManager().addCharge(sCharges);
            }
        }
        configReader.addComment("Spawners.Proximity.Use", new String[]{"Allows to limit how tight spawners can be placed from each other"});
        this.SpawnersProximityUse = configReader.get("Spawners.Proximity.Use", Boolean.valueOf(false));
        configReader.addComment("Spawners.Proximity.Range", new String[]{"Radius in blocks from placed block. Max range is 16", "Can be bypassed with cmi.spawners.proximity.bypass"});
        this.SpawnersProximityRange = CMINumber.clamp((int)configReader.get("Spawners.Proximity.Range", 3), (int)0, (int)16);
        if (this.SpawnersProximityRange == 0) {
            this.SpawnersProximityUse = false;
        }
    }

    public PlayerCharge getPCharge(CMIUser cMIUser, boolean bl) {
        return this.spawnerCharges.computeIfAbsent(cMIUser.getUniqueId(), uUID -> new PlayerCharge(cMIUser, bl));
    }

    private void recalculateTotalSpawnerEntities() {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIEntityType cMIEntityType;
            EntityType entityType = entityTypeArray[n2];
            if (entityType.name() != null && entityType.isSpawnable() && entityType.isAlive() && (cMIEntityType = CMIEntityType.getByType((EntityType)entityType)) != null && !cMIEntityType.equals((Object)CMIEntityType.SHULKER) && !cMIEntityType.equals((Object)CMIEntityType.ARMOR_STAND) && cMIEntityType.getType() != null) {
                this.total = this.total + 1;
            }
            ++n2;
        }
    }

    public void addCharge(SCharges sCharges) {
        this.map.put(sCharges.getName().toLowerCase(), sCharges);
    }

    public SCharges getCharge(String string) {
        return this.map.get(string.toLowerCase());
    }

    public SCharges getCharge(Player player) {
        SCharges sCharges = null;
        if (player == null) {
            return sCharges;
        }
        for (Map.Entry<String, SCharges> entry : this.map.entrySet()) {
            if (!PermissionsManager.CMIPerm.spawners_charge_$1.hasPermission((CommandSender)player, entry.getKey())) continue;
            sCharges = entry.getValue();
        }
        return sCharges;
    }

    public boolean changeSpawnerType(Block block, EntityType entityType) {
        BlockState blockState = block.getState();
        CreatureSpawner creatureSpawner = (CreatureSpawner)blockState;
        try {
            creatureSpawner.setSpawnedType(entityType);
        }
        catch (Exception exception) {
            return false;
        }
        creatureSpawner.update();
        return true;
    }

    @Deprecated
    public void openSpawnerPickerUI(Player player) {
        this.openSpawnerPickerUI(player, 1);
    }

    public void openSpawnerPickerUI(final Player player, int n) {
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                SpawnerChargeManager.this.openSpawnerPickerUI(player, n);
            }
        };
        cMIGui.addLock(GUIManager.InvType.Gui);
        cMIGui.setTitle(CMILC.getIM("spawner", "pickOne", new Object[0]));
        if (this.total == 0) {
            this.recalculateTotalSpawnerEntities();
        }
        PageInfo pageInfo = new PageInfo(45, this.total.intValue(), n);
        int n2 = -1;
        Stream<String> stream = Arrays.stream(EntityType.values()).map(Enum::name).sorted();
        Object[] objectArray = stream.toArray();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CMIEntityType cMIEntityType;
            Object object = objectArray[n4];
            EntityType entityType = EntityType.valueOf((String)((String)object));
            if (entityType.name() != null && entityType.isSpawnable() && entityType.isAlive() && (cMIEntityType = CMIEntityType.getByType((EntityType)entityType)) != null && !cMIEntityType.equals((Object)CMIEntityType.SHULKER) && !cMIEntityType.equals((Object)CMIEntityType.ARMOR_STAND) && cMIEntityType.getType() != null && pageInfo.isEntryOk()) {
                if (pageInfo.isBreak()) break;
                boolean bl = false;
                if (PermissionsManager.CMIPerm.command_spawner_$1.hasPermission((CommandSender)player, false, entityType.name().toLowerCase())) {
                    bl = true;
                }
                ++n2;
                CMIMaterial cMIMaterial = cMIEntityType.getSpawnEggMaterial();
                if (cMIMaterial == null) {
                    cMIMaterial = CMIMaterial.PIG_SPAWN_EGG;
                }
                Material material = cMIMaterial.getMaterial();
                CMIItemStack cMIItemStack = new CMIItemStack(bl ? material : Material.STONE_BUTTON);
                if (cMIItemStack.getCMIType().isSpawnEgg()) {
                    cMIItemStack.setEntityType(cMIEntityType);
                }
                cMIItemStack.setDisplayName("&r&f" + cMIEntityType.getTranslatedName());
                CMIGuiButton cMIGuiButton = new CMIGuiButton(Integer.valueOf(n2), cMIItemStack.getItemStack());
                cMIGuiButton.addCommand("cmi spawner " + entityType.name());
                cMIGuiButton.addPermission("cmi.command.spawner." + entityType.name().toLowerCase());
                cMIGui.addButton(cMIGuiButton);
            }
            ++n4;
        }
        cMIGui.addPagination(pageInfo);
        cMIGui.autoResize();
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public int getSpawnerDropChance(Player player, Block block) {
        CMINBT cMINBT;
        String string;
        if (!PermissionsManager.CMIPerm.dropspawner.hasPermission((CommandSender)player, 5L, new String[0])) {
            return 0;
        }
        ItemStack itemStack = CMI.getInstance().getPlayerManager().getUser(player).getItemInHand();
        int n = this.SpawnersBreakBaseDropChance;
        PermissionInfo permissionInfo = CMI.getInstance().getPermissionsManager().getPermissionInfo(player, PermissionsManager.CMIPerm.dropspawner_basedropchance_$1);
        if (permissionInfo != null) {
            n = permissionInfo.getMaxValue(n);
        }
        if (itemStack != null && (string = (cMINBT = new CMINBT(itemStack)).getString("PublicBukkitValues.slimefun:slimefun_item")) != null && string.equals("PICKAXE_OF_CONTAINMENT")) {
            return -1;
        }
        try {
            if (block != null && this.SpawnersBreakRequiresExactPermission && !PermissionsManager.CMIPerm.dropspawner_$1.hasPermission((CommandSender)player, ((CreatureSpawner)block.getState()).getSpawnedType().name().toLowerCase())) {
                n = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!CMI.getInstance().getUtilManager().hasSilkTouch(itemStack, this.SpawnersBreakSilkTouchLevel) && !PermissionsManager.CMIPerm.dropspawner_nosilk.hasPermission((CommandSender)player)) {
            n = 0;
        }
        return n;
    }

    public boolean isSpawnersSupportDisabled() {
        return this.SpawnersSupportDisabled;
    }

    public boolean isSpawnersXpDrop() {
        return this.SpawnersXpDrop;
    }

    public boolean isSpawnersEggInteractRequiresPermission() {
        return this.SpawnersEggInteractRequiresPermission;
    }

    public boolean isSpawnersPlaceRequiresExactPermission() {
        return this.SpawnersPlaceRequiresExactPermission;
    }

    public boolean isSpawnersPlaceRequiresPermission() {
        return this.SpawnersPlaceRequiresPermission;
    }

    public boolean isSpawnersPlaceEnabled() {
        return this.SpawnersPlaceEnabled;
    }

    public boolean isSpawnerDropFromCreeper() {
        return this.SpawnerDropFromCreeper;
    }

    public int getSpawnerDropChanceCreeper() {
        return this.SpawnerDropChanceCreeper;
    }

    public boolean isSpawnersBreakEnabled() {
        return this.SpawnersBreakEnabled;
    }

    public int getSpawnerDropChanceTnt() {
        return this.SpawnerDropChanceTnt;
    }

    public boolean isSpawnerDropFromTnt() {
        return this.SpawnerDropFromTnt;
    }

    public boolean isChargesUse() {
        return this.ChargesUse;
    }

    public boolean isChargesBreakWithoutCharge() {
        return this.ChargesBreakWithoutCharge;
    }

    public boolean isSpawnersProximityUse() {
        return this.SpawnersProximityUse;
    }

    public int getSpawnersProximityRange() {
        return this.SpawnersProximityRange;
    }
}

