/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Worlds;

import com.Zrips.CMI.Modules.Worlds.CMIChunk;
import java.util.TreeMap;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class CMIRegion {
    private int z = 0;
    private int x = 0;
    private World world;
    private TreeMap<Integer, CMIChunk> chunks = new TreeMap();

    public CMIRegion(Location location) {
        this(location.getWorld(), location.getChunk().getX() >> 5, location.getChunk().getZ() >> 5);
    }

    public CMIRegion(Chunk chunk) {
        this(chunk.getWorld(), chunk.getX() >> 5, chunk.getZ() >> 5);
    }

    public CMIRegion(World world2, int n, int n2) {
        this.x = n;
        this.z = n2;
        this.world = world2;
    }

    public int getX() {
        return this.x;
    }

    public CMIRegion setX(int n) {
        this.x = n;
        return this;
    }

    public int getZ() {
        return this.z;
    }

    public CMIRegion setZ(int n) {
        this.z = n;
        return this;
    }

    public CMIChunk getChunk(Chunk chunk) {
        return this.getChunk(chunk.getX(), chunk.getZ()).setGenerated(true).recheckBiomes();
    }

    public Integer getPlace() {
        return this.x + this.z * 1024;
    }

    public CMIChunk getRelativeChunk(int n, int n2) {
        return this.getChunk(this.x * 32 + n, this.z * 32 + n2);
    }

    private int getChunkRelativePlace(int n, int n2) {
        return (n -= this.x * 32) + (n2 -= this.z * 32) * 32;
    }

    public boolean exists(int n) {
        CMIChunk cMIChunk = this.chunks.get(n);
        return cMIChunk != null;
    }

    public boolean exists(int n, int n2) {
        CMIChunk cMIChunk = this.chunks.get(this.getChunkRelativePlace(n, n2));
        return cMIChunk != null;
    }

    public CMIChunk getChunk(int n, int n2) {
        CMIChunk cMIChunk = this.chunks.get(this.getChunkRelativePlace(n, n2));
        return cMIChunk;
    }

    public TreeMap<Integer, CMIChunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(TreeMap<Integer, CMIChunk> treeMap) {
        this.chunks = treeMap;
    }

    public CMIChunk addChunk(World world2, int n, int n2) {
        CMIChunk cMIChunk = new CMIChunk(world2, n, n2);
        this.chunks.put(cMIChunk.getPlace(), cMIChunk);
        return cMIChunk;
    }

    public CMIChunk addChunk(Chunk chunk) {
        CMIChunk cMIChunk = new CMIChunk(chunk);
        this.chunks.put(cMIChunk.getPlace(), cMIChunk);
        return cMIChunk;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world2) {
        this.world = world2;
    }
}

