/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;

public class NameChangeListener
implements Listener {
    private CMI plugin;
    ConcurrentHashMap<UUID, String> temp = new ConcurrentHashMap();

    public NameChangeListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onJoinLowest(PlayerLoginEvent playerLoginEvent) {
        if (!playerLoginEvent.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            return;
        }
        if (!this.plugin.getConfigManager().isPerformCommandsOnNewName()) {
            return;
        }
        Player player = playerLoginEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player.getUniqueId());
        if (cMIUser == null) {
            return;
        }
        this.temp.put(player.getUniqueId(), cMIUser.getName(false));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (!this.plugin.getConfigManager().isPerformCommandsOnNewName()) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player.getUniqueId());
        if (cMIUser == null) {
            return;
        }
        String string = this.temp.remove(player.getUniqueId());
        this.plugin.getPlayerManager().updateUserName(cMIUser, player.getName());
        if (string == null || string.equals(player.getName())) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.plugin.getConfigManager().getOptimizationsNameChangeCommands());
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.set(n, arrayList.get(n).replace("[oldname]", string).replace("[newname]", player.getName()));
            ++n;
        }
        CMIScheduler.runTaskLater(() -> {
            if (!player.isOnline()) {
                return;
            }
            Snd snd = new Snd();
            snd.setSender(cMIUser).setTarget(cMIUser);
            this.plugin.getLM().updateSnd(snd, arrayList);
            this.plugin.getSpecializedCommandManager().processCmds((List<String>)arrayList, player);
        }, (long)10L);
    }
}

