/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.Modules.tp.Teleportations;
import com.Zrips.CMI.commands.list.alert;
import com.Zrips.CMI.commands.list.lastonline;
import com.Zrips.CMI.commands.list.lockip;
import com.Zrips.CMI.commands.list.mail;
import com.Zrips.CMI.commands.list.patrol;
import com.Zrips.CMI.events.CMIUserBalanceChangeEvent;
import com.Zrips.CMI.utils.SpawnUtil;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.Team;

public class UserEvents
implements Listener {
    private CMI plugin;
    private HashMap<UUID, Long> weMap = new HashMap();
    HashMap<UUID, Long> roofTeleporterDelay = new HashMap();
    HashMap<UUID, Long> informer = new HashMap();

    public UserEvents(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCMIUserBalanceChangeEvent(CMIUserBalanceChangeEvent cMIUserBalanceChangeEvent) {
        if (CMI.getInstance().isFullyLoaded()) {
            this.plugin.getEconomyManager().updateBalTop(cMIUserBalanceChangeEvent.getUser());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLoginNameCheck(PlayerLoginEvent playerLoginEvent) {
        if (!this.plugin.getConfigManager().PreventDifferentCapitalizationNames) {
            return;
        }
        Player player = playerLoginEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (Bukkit.getServer().getOnlineMode()) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player.getName(), false);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getUniqueId().equals(player.getUniqueId())) {
            return;
        }
        if (cMIUser.getName(false) == null || cMIUser.getName(false).equals(player.getName())) {
            return;
        }
        playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_OTHER, CMILC.info_cantLoginWithDifCap.getLocale("[oldName]", cMIUser.getName(false), "[currentName]", player.getName()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (cMIUser.getLockedIps().isEmpty()) {
            return;
        }
        InetAddress inetAddress = playerLoginEvent.getAddress();
        if (inetAddress == null) {
            return;
        }
        String string = inetAddress.getHostAddress();
        if (string == null) {
            return;
        }
        if (cMIUser.getLockedIps().contains(string)) {
            return;
        }
        playerLoginEvent.disallow(PlayerLoginEvent.Result.KICK_OTHER, CMILC.getIM(lockip.class, "CantLogin", new Object[0]));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLoginIpRecord(final PlayerLoginEvent playerLoginEvent) {
        final Player player = playerLoginEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (!Config.IPRecord) {
            return;
        }
        if (Bukkit.getOnlineMode()) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)UserEvents.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            UserEvents.this.record(player, playerLoginEvent.getAddress());
                        }
                    });
                }
            }, 20L);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)UserEvents.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            UserEvents.this.record(player, playerLoginEvent.getAddress());
                        }
                    });
                }
            }, (long)this.plugin.getConfigManager().IPdelay * 20L);
        }
    }

    private void record(Player player, InetAddress inetAddress) {
        if (!player.isOnline()) {
            return;
        }
        String string = inetAddress.getHostAddress();
        if (string == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser != null) {
            cMIUser.addIps(string);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (player.hasMetadata("NPC")) {
            return;
        }
        final CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        cMIUser.setDeathLoc(new CMILocation(player.getLocation()));
        if (PermissionsManager.CMIPerm.command_back_ondeath.hasPermission((CommandSender)player)) {
            cMIUser.setLastTeleportLocation(player.getLocation(), false);
            cMIUser.setBungeeBackLocation(null);
        }
        cMIUser.addForDelayedSave();
        if (Version.isCurrentEqualOrLower((Version)Version.v1_15_R1)) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    cMIUser.respawn();
                }
            }, 5L);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    cMIUser.respawn();
                }
            }, 40L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void teleportBack(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld()) && playerTeleportEvent.getFrom().distance(playerTeleportEvent.getTo()) < 2.0) {
            return;
        }
        Location location = playerTeleportEvent.getFrom().clone();
        if (cMIUser.isSitting()) {
            location = location.add(0.0, 0.7, 0.0);
        }
        if (!(playerTeleportEvent.getCause().name().equalsIgnoreCase("CHORUS_FRUIT") || playerTeleportEvent.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.ENDER_PEARL) || playerTeleportEvent.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.UNKNOWN) || playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld()) && !(playerTeleportEvent.getFrom().distance(playerTeleportEvent.getTo()) > (double)this.plugin.getTpManager().getBackMinDistance()))) {
            Long l = this.weMap.get(player.getUniqueId());
            if (l != null && l + 100L > System.currentTimeMillis()) {
                return;
            }
            if (!this.plugin.getTpManager().getBackBlackList().contains(location.getWorld().getName().toLowerCase())) {
                cMIUser.setLastTeleportLocation(location, false);
                cMIUser.setBungeeBackLocation(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void teleportBackWECompasss(PlayerInteractEvent playerInteractEvent) {
        if (this.plugin.getTpManager().isBackWithWE()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (CMIItemStack.getItemInMainHand((Player)player) == null || !CMIItemStack.getItemInMainHand((Player)player).getType().equals((Object)Material.COMPASS)) {
            return;
        }
        if ((playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) && !player.hasPermission("worldedit.navigation.thru.command") || (playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_AIR) || playerInteractEvent.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) && !player.hasPermission("worldedit.navigation.jumpto.command")) {
            return;
        }
        this.weMap.put(player.getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerMoveEvent playerMoveEvent) {
        if (!this.plugin.getConfigManager().isPreventPlayersOnNetherRoof()) {
            return;
        }
        if (!playerMoveEvent.getTo().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlockX() == playerMoveEvent.getTo().getBlockX() && playerMoveEvent.getFrom().getBlockY() == playerMoveEvent.getTo().getBlockY() && playerMoveEvent.getFrom().getBlockZ() == playerMoveEvent.getTo().getBlockZ()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        Long l = this.roofTeleporterDelay.get(player.getUniqueId());
        if (l != null && l + 1000L > System.currentTimeMillis()) {
            return;
        }
        Integer n = this.plugin.getConfigManager().getNetherRoofHeight() == 0 ? CMIWorld.getMaxHeight((World)playerMoveEvent.getTo().getWorld()) : this.plugin.getConfigManager().getNetherRoofHeight();
        if (playerMoveEvent.getTo().getBlockY() < n) {
            return;
        }
        this.roofTeleporterDelay.put(player.getUniqueId(), System.currentTimeMillis());
        boolean bl = this.plugin.getTeleportations().teleport(player, player.getLocation().clone().add(0.0, -5.0, 0.0), false, false, Teleportations.TeleportType.NetherRoof);
        if (!bl) {
            CMILocation cMILocation = SpawnUtil.getSpawnPoint(player);
            if (cMILocation == null) {
                return;
            }
            this.plugin.getTeleportations().teleport((CommandSender)player, player, (Location)cMILocation, true, Teleportations.TeleportType.NetherRoof);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveBelow(PlayerMoveEvent playerMoveEvent) {
        if (!this.plugin.getConfigManager().isPreventPlayersBelowBedrock()) {
            return;
        }
        if (!playerMoveEvent.getTo().getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && !playerMoveEvent.getTo().getWorld().getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlockX() == playerMoveEvent.getTo().getBlockX() && playerMoveEvent.getFrom().getBlockY() == playerMoveEvent.getTo().getBlockY() && playerMoveEvent.getFrom().getBlockZ() == playerMoveEvent.getTo().getBlockZ()) {
            return;
        }
        if (playerMoveEvent.getTo().getBlockY() > CMIWorld.getMinHeight((World)playerMoveEvent.getTo().getWorld())) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        boolean bl = false;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            try {
                bl = player.isGliding();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (!player.isFlying() && !bl) {
            return;
        }
        Long l = this.roofTeleporterDelay.get(player.getUniqueId());
        if (l != null && l + 1000L > System.currentTimeMillis()) {
            return;
        }
        this.roofTeleporterDelay.put(player.getUniqueId(), System.currentTimeMillis());
        Location location = player.getLocation().clone();
        location.setY(64.0);
        boolean bl2 = this.plugin.getTeleportations().teleport(player, location, false, false, Teleportations.TeleportType.BelowBedrock);
        if (!bl2) {
            location = SpawnUtil.getSpawnPoint(player);
            if (location == null) {
                return;
            }
            this.plugin.getTeleportations().teleport((CommandSender)player, player, location, true, Teleportations.TeleportType.BelowBedrock);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerFlyToHigh(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        if (this.plugin.getConfigManager().isFlyAboveRoof()) {
            return;
        }
        if (playerMoveEvent.getTo().getBlockY() <= this.plugin.getUtilManager().getMaxWorldHeight(playerMoveEvent.getTo().getWorld()) - 1) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlockX() == playerMoveEvent.getTo().getBlockX() && playerMoveEvent.getFrom().getBlockY() == playerMoveEvent.getTo().getBlockY() && playerMoveEvent.getFrom().getBlockZ() == playerMoveEvent.getTo().getBlockZ()) {
            return;
        }
        if (playerMoveEvent.getFrom().getBlockY() > playerMoveEvent.getTo().getBlockY()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        boolean bl = false;
        if (player.isFlying()) {
            bl = true;
        }
        if (!bl && Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            try {
                if (player.isGliding()) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bl) {
            if (PermissionsManager.CMIPerm.worldlimit_fly_aboveroof.hasPermission((CommandSender)player, false, 10000L)) {
                return;
            }
            if (this.informer.get(player.getUniqueId()) == null || this.informer.get(player.getUniqueId()) < System.currentTimeMillis()) {
                CMILC.info_flyingToHigh.sendMessage(player, "[max]", this.plugin.getUtilManager().getMaxWorldHeight(playerMoveEvent.getTo().getWorld()));
                this.informer.put(player.getUniqueId(), System.currentTimeMillis() + 5000L);
            }
            playerMoveEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        final CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        this.weMap.remove(player.getUniqueId());
        this.roofTeleporterDelay.remove(player.getUniqueId());
        this.informer.remove(player.getUniqueId());
        this.plugin.getPlayerManager().removeCommandSpy(cMIUser.getUniqueId());
        this.plugin.getPlayerManager().removeSignSpy(cMIUser.getUniqueId());
        this.plugin.getPlayerManager().removeCommandSpyDelayed(cMIUser.getUniqueId());
        this.plugin.getPlayerManager().removeSocialSpy(cMIUser.getUniqueId());
        this.plugin.getPlayerManager().removeSocialSpyDelayed(cMIUser.getUniqueId());
        cMIUser.setLogOutLocation(player.getLocation());
        cMIUser.setLastLogoff(System.currentTimeMillis());
        lastonline.addLogOff(cMIUser);
        cMIUser.getTotalPlayTime();
        cMIUser.addForDelayedSave();
        Team team = this.plugin.getSB().getTeam("CMINP" + cMIUser.getId());
        if (team != null) {
            try {
                team.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!cMIUser.isOnline()) {
                    cMIUser.setPlayer(null);
                }
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void removeFromRankCheck(PlayerQuitEvent playerQuitEvent) {
        this.plugin.getRankManager().removeFromCheck(playerQuitEvent.getPlayer().getUniqueId());
        this.plugin.getPlayerManager().removeSocialSpy(playerQuitEvent.getPlayer().getUniqueId());
        if (this.plugin.getDbManager().isForceSaveOnLogOut()) {
            try {
                CMIUser.getUser(playerQuitEvent.getPlayer()).addForDelayedSave();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.plugin.getDbManager().saveBatchAsync(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerJoinEvent playerJoinEvent) {
        final Player player = playerJoinEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        final CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (this.plugin.getDbManager().isForceLoadOnLogIn()) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    UserEvents.this.plugin.getDbManager().getDB().loadUser(player.getUniqueId());
                    UserEvents.this.processPlayerLogin(cMIUser);
                }
            }, 20L);
        } else {
            this.processPlayerLogin(cMIUser);
        }
    }

    private void processPlayerLogin(final CMIUser cMIUser) {
        cMIUser.setLastLogin(System.currentTimeMillis());
        lastonline.addLogOff(cMIUser);
        if (cMIUser.getPlayerTime() > 0L && cMIUser.isOnline()) {
            cMIUser.getPlayer().setPlayerTime(cMIUser.getPlayerTime(), false);
        }
        cMIUser.recalculateRank();
        if (Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            cMIUser.reaplyNamePlate();
        }
        if (cMIUser.getOptionState(PlayerOption.chatSpy).booleanValue()) {
            this.plugin.getPlayerManager().addSocialSpyDelayed(cMIUser.getUniqueId());
        }
        if (cMIUser.getOptionState(PlayerOption.cmdSpy).booleanValue()) {
            this.plugin.getPlayerManager().addCommandSpyDelayed(cMIUser.getUniqueId());
        }
        if (cMIUser.getOptionState(PlayerOption.signSpy).booleanValue()) {
            this.plugin.getPlayerManager().addSignSpyDelayed(cMIUser.getUniqueId());
        }
        cMIUser.updateDisplayName();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!cMIUser.getMails().isEmpty() && cMIUser.isOnline()) {
                    RawMessage rawMessage = new RawMessage();
                    rawMessage.addText(CMILC.getIM(mail.class, "waitingMail", "[amount]", cMIUser.getMails().size())).addHover(LC.info_Click.getLocale(new Object[0])).addCommand("cmi mail");
                    rawMessage.show(cMIUser.getPlayer(false));
                }
            }
        }, 40L);
        if (cMIUser.isOnline()) {
            if (cMIUser.getAlertUntil() > 0L) {
                List<String> list2 = CMILC.getIML(alert.class, "inform", new Object[0]);
                String string = null;
                Snd snd = new Snd();
                snd.setTarget(cMIUser);
                list2 = this.plugin.getLM().updateSnd(snd, list2);
                list2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), list2);
                if (cMIUser.getAlertReason() != null) {
                    string = CMILC.getIM(alert.class, "reason", "[reason]", CMIChatColor.translate((String)cMIUser.getAlertReason()), "[reasson]", CMIChatColor.translate((String)cMIUser.getAlertReason()));
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String string22;
                    if (!PermissionsManager.CMIPerm.command_alert_inform.hasPermission((CommandSender)player)) continue;
                    for (String string22 : list2) {
                        player.sendMessage(string22.replace("[name]", cMIUser.getName()));
                    }
                    if (string != null) {
                        player.sendMessage(string);
                    }
                    if (!this.plugin.getConfigManager().isNotesShowOnAlertEvent() || cMIUser.getNotes().isEmpty()) continue;
                    snd = new Snd().setSender(player).setTarget(cMIUser);
                    string22 = new RawMessage();
                    string22.addText(CMILC.getIM(patrol.class, "notes", snd, "[amount]", cMIUser.getNotes().size())).addHover(LC.info_Click.getLocale(new Object[0])).addCommand("cmi note " + cMIUser.getName() + " list");
                    string22.show(player);
                }
                if (System.currentTimeMillis() > cMIUser.getAlertUntil()) {
                    cMIUser.setAlertUntil(0L);
                }
            }
            if (this.plugin.getConfigManager().getMotd() != null) {
                this.plugin.getCTextManager().showCText((CommandSender)cMIUser.getPlayer(false), this.plugin.getConfigManager().getMotd(), 1);
            }
            try {
                if (this.plugin.getConfigManager().isPotionEffectsDeductWhileOffline() && cMIUser.getLastLogoff() > 0L) {
                    long l = System.currentTimeMillis() - cMIUser.getLastLogoff();
                    l /= 50L;
                    for (Snd snd : cMIUser.getPlayer().getActivePotionEffects()) {
                        cMIUser.getPlayer().removePotionEffect(snd.getType());
                        if ((long)snd.getDuration() <= l) continue;
                        PotionEffect potionEffect = new PotionEffect(snd.getType(), (int)((long)snd.getDuration() - l), snd.getAmplifier(), snd.isAmbient(), snd.hasParticles());
                        cMIUser.getPlayer().addPotionEffect(potionEffect);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

