/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Chat.CMIPlayerMessageColor;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Placeholders.Placeholder;
import com.Zrips.CMI.commands.list.colorlimits;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

public class ChatManager {
    private CMI plugin;
    private boolean ModifyChatFormat = false;
    private boolean ChatClickHoverMessages = false;
    private boolean ChatDiscordSRV = false;
    private String ChatDiscordSRVGlobalChannel = "global";
    private String DiscordSRVLabel = "";
    private String DiscordSRVUnlinkedLabel = "";
    private boolean DiscordSRVRanged = true;
    private boolean ChatDynMapChat = false;
    private boolean ChatReplyToLastMessenger = false;
    private int LastMessengerTimeOut = 120;
    private boolean PrivateMessagesGroups = false;
    private boolean ColorsPublicMessages = false;
    private boolean ColorsPrivateMessage = false;
    private boolean ChatIgnorePublicMessage = false;
    private boolean ColorsMe = false;
    private boolean ColorsNickName;
    private List<String> cleanUpWhiteList;
    private Set<CMIPlayerMessageColor> chatColors = new LinkedHashSet<CMIPlayerMessageColor>();
    private Map<UUID, CMIPlayerMessageColor> messageColorCache = Collections.synchronizedMap(new HashMap());
    public static String fileName = "Chat.yml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(UUID uUID, CMIPlayerMessageColor cMIPlayerMessageColor) {
        Map<UUID, CMIPlayerMessageColor> map = this.messageColorCache;
        synchronized (map) {
            this.messageColorCache.put(uUID, cMIPlayerMessageColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(UUID uUID) {
        Map<UUID, CMIPlayerMessageColor> map = this.messageColorCache;
        synchronized (map) {
            this.messageColorCache.remove(uUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMIPlayerMessageColor getColorFromCache(UUID uUID) {
        Map<UUID, CMIPlayerMessageColor> map = this.messageColorCache;
        synchronized (map) {
            return this.messageColorCache.get(uUID);
        }
    }

    public ChatManager(CMI cMI) {
        this.plugin = cMI;
    }

    public boolean loadConfig(boolean bl) {
        Object object;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            if (bl) {
                this.plugin.consoleMessage("&cSEVERE CONFIG FILE READ ERROR. Check your spelling! Changes will not be applied until you fix it or perform server restart which can result in config file reset");
                return false;
            }
            exception.printStackTrace();
        }
        if (configReader == null) {
            return false;
        }
        configReader.addComment("Chat.ModifyChatFormat", new String[]{"Will try to modify chat to display it in defined format"});
        this.ModifyChatFormat = configReader.get("Chat.ModifyChatFormat", Boolean.valueOf(false));
        configReader.addComment("Chat.ClickHoverMessages", new String[]{"When set to true, regular and private messages (excludes clean messages) will have additional information when hovering over it (PlaceHolderAPI supported) and can be clicked for quick reply option", "To change default hover over messages seen on sent message, go to your locale file to Chat section"});
        this.ChatClickHoverMessages = configReader.get("Chat.ClickHoverMessages", Boolean.valueOf(true));
        configReader.addComment("Chat.DiscordSRV.Enabled", new String[]{"Enables support for DiscordSRV plugin"});
        this.ChatDiscordSRV = configReader.get("Chat.DiscordSRV.Enabled", Boolean.valueOf(configReader.getC().getBoolean("Chat.DiscordSRVPublicChat", true)));
        configReader.addComment("Chat.DiscordSRV.GlobalChannel", new String[]{"Defines name of global chat channel in discordsrv"});
        this.ChatDiscordSRVGlobalChannel = configReader.get("Chat.DiscordSRV.GlobalChannel", "global");
        configReader.addComment("Chat.DiscordSRV.Label", new String[]{"Indicator which can be used as {discord} in chat format to indicate that message came from discord and not ingame"});
        this.DiscordSRVLabel = configReader.get("Chat.DiscordSRV.Label", configReader.getC().getString("Chat.DiscordSRVLabel", "&2[&7D&2]"));
        configReader.addComment("Chat.DiscordSRV.LabelUnlinked", new String[]{"Indicator which can be used as {discord} in chat format to indicate that message came from unlinked discord account"});
        this.DiscordSRVUnlinkedLabel = configReader.get("Chat.DiscordSRV.UnlinkedLabel", "&4[&cD&4]");
        configReader.addComment("Chat.DiscordSRV.RangedMessages", new String[]{"When enabled and you have ranged messages enabled, we will send all of them to DiscordSRV", "When disabled, only shouts and messages sent by players with " + PermissionsManager.CMIPerm.chat_rangebypass.getPermission() + " permission node will be visible in discord"});
        this.DiscordSRVRanged = configReader.get("Chat.DiscordSRV.RangedMessages", Boolean.valueOf(true));
        configReader.addComment("Chat.DynMapChat", new String[]{"Enables support for DynMap web chat"});
        this.ChatDynMapChat = configReader.get("Chat.DynMapChat", Boolean.valueOf(true));
        configReader.addComment("Chat.ReplyToLastMessenger", new String[]{"When set to false, each time you will use /r you will reply to person you previously sent message directly or to person who sent you message if there is none you have conversion before", "When this set to true, players with /r will reply to person who last sent private message. This can result in confusion when using /r while getting private messages from multiple players"});
        this.ChatReplyToLastMessenger = configReader.get("Chat.ReplyToLastMessenger", Boolean.valueOf(false));
        configReader.addComment("Chat.LastMessengerTimeOut", new String[]{"If ReplyToLastMessenger is set to false, then timeOut will be taken into consideration to who you should reply", "If you had conversation in last 120 seconds (default) then even receiving message from 3rd person, you will still reply to original player", "If you had conversation in longer then 120 seconds period, then you will reply to latest person who send you a message"});
        this.LastMessengerTimeOut = configReader.get("Chat.LastMessengerTimeOut", 120);
        configReader.addComment("Chat.PrivateMessagesGroups", new String[]{"When set to true players will need to have " + PermissionsManager.CMIPerm.command_msg_$1_send.getPermission("[groupName]") + " where [groupName] is receivers main permission group"});
        this.PrivateMessagesGroups = configReader.get("Chat.PrivateMessagesGroups", Boolean.valueOf(false));
        this.plugin.getChatFormatManager().loadConfig(configReader);
        String string = "";
        Object object2 = ChatColor.values();
        int n = ((ChatColor[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + object.name().toLowerCase().replace("_", "") + "(&" + object.getChar() + ")";
            ++n2;
        }
        configReader.addComment("Chat.Colors.PublicMessage", new String[]{"If set to true then all public messages will be filtered from color codes and will allow to colorize them with appropriate permission node", "cmi.colors.publicmessage.[colorName]", "Colors: " + string});
        this.ColorsPublicMessages = configReader.get("Chat.Colors.PublicMessage", Boolean.valueOf(true));
        configReader.addComment("Chat.Colors.PrivataMessage", new String[]{"If set to true then private messages will be filtered from color codes and will allow to colorize them with appropriate permission node", "cmi.colors.privatemessage.[colorName]"});
        this.ColorsPrivateMessage = configReader.get("Chat.Colors.PrivateMessage", Boolean.valueOf(configReader.getC().getBoolean("Chat.Colors.PrivataMessage", true)));
        configReader.addComment("Chat.Colors.me", new String[]{"If set to true then /me messages will be filtered from color codes and will allow to colorize them with appropriate permission node", "cmi.colors.me.[colorName]"});
        this.ColorsMe = configReader.get("Chat.Colors.me", Boolean.valueOf(configReader.getC().getBoolean("Chat.Colors.me", true)));
        configReader.addComment("Chat.Colors.CleanUp", new String[]{"If set to true, then color codes will get removed from text instead of leaving them if player dont have appropriate permission node for that color"});
        object2 = colorlimits.CMIColorTypes.values();
        n = ((colorlimits.CMIColorTypes[])object2).length;
        n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            if (!((Enum)object).equals((Object)colorlimits.CMIColorTypes.nickname)) {
                ((colorlimits.CMIColorTypes)((Object)object)).setClean(configReader.get("Chat.Colors.CleanUp." + ((Enum)object).name(), Boolean.valueOf(((colorlimits.CMIColorTypes)((Object)object)).isClean())));
            }
            ++n2;
        }
        configReader.addComment("Chat.Colors.CleanUp.WhiteList", new String[]{"List of strings to ignore when checking chat for color codes player cant use.", "This will bypass players colorcode restrictions and will allow usage of particular chat formats", "Applies only for public and private messages"});
        this.cleanUpWhiteList = configReader.get("Chat.Colors.CleanUp.WhiteList", Arrays.asList("&c\u2764&7"));
        configReader.addComment("Chat.IgnorePublicMessage", new String[]{"If set to true, players public message who is in your ignore list will not be shown"});
        this.ChatIgnorePublicMessage = configReader.get("Chat.IgnorePublicMessage", Boolean.valueOf(true));
        configReader.addComment("Chat.Colors.NickName", new String[]{"If set to true then nickName will be filtered from color codes when player changes it", "cmi.colors.nickname.[colorName]"});
        this.ColorsNickName = configReader.get("Chat.Colors.NickName", Boolean.valueOf(true));
        configReader.addComment("Chat.Colors.Picker", new String[]{"Determines /cmi chatcolor command contents. What player can pick will be determined by cmi.colors.publicmessage.[colorCode] and will be used in " + Placeholder.CMIPlaceHolders.cmi_user_chatcolor.getFull() + " placeholder"});
        object = configReader.get("Chat.Colors.Picker", Arrays.asList("&f", "&2", "&3", "&7", "&8", "&a", "&b", "&c", "&e", "&6", "{#00e625}", "{#brown}"));
        this.chatColors.clear();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            object2 = CMIChatColor.getFormats((String)string2);
            CMIChatColor cMIChatColor = CMIChatColor.getColor((String)(string2 = string2.replace(CMIChatColor.deColorize((String)new CMIPlayerMessageColor(null, (Set<CMIChatColor>)object2).formatsToString()), "")));
            if (cMIChatColor == null) {
                CMIMessages.consoleMessage((String)("&5Failed to recognize chat color code (" + string2 + ")"));
                continue;
            }
            this.chatColors.add(new CMIPlayerMessageColor(cMIChatColor, (Set<CMIChatColor>)object2));
        }
        this.plugin.getTagManager().load(configReader);
        this.plugin.getChatBubbleManager().loadConfig(configReader);
        configReader.save();
        return true;
    }

    public boolean isModifyChatFormat() {
        return this.ModifyChatFormat;
    }

    public boolean isChatClickHoverMessages() {
        return this.ChatClickHoverMessages;
    }

    public boolean isColorsPublicMessages() {
        return this.ColorsPublicMessages;
    }

    public boolean isColorsPrivateMessage() {
        return this.ColorsPrivateMessage;
    }

    public boolean isChatIgnorePublicMessage() {
        return this.ChatIgnorePublicMessage;
    }

    public List<String> getCleanUpWhiteList() {
        return this.cleanUpWhiteList;
    }

    public boolean isChatReplyToLastMessenger() {
        return this.ChatReplyToLastMessenger;
    }

    public int getLastMessengerTimeOut() {
        return this.LastMessengerTimeOut;
    }

    public boolean isColorsMe() {
        return this.ColorsMe;
    }

    public boolean isChatDynMapChat() {
        return this.ChatDynMapChat;
    }

    public boolean isPrivateMessagesGroups() {
        return this.PrivateMessagesGroups;
    }

    public boolean isChatDiscordSRV() {
        return this.ChatDiscordSRV;
    }

    public String getChatDiscordSRVGlobalChannel() {
        return this.ChatDiscordSRVGlobalChannel;
    }

    public String getDiscordSRVLabel() {
        return this.DiscordSRVLabel;
    }

    public String getDiscordSRVUnlinkedLabel() {
        return this.DiscordSRVUnlinkedLabel;
    }

    public boolean isDiscordSRVRanged() {
        return this.DiscordSRVRanged;
    }

    public boolean isColorsNickName() {
        return this.ColorsNickName;
    }

    public Set<CMIPlayerMessageColor> getChatColors() {
        return this.chatColors;
    }
}

