/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChunkPreview;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.ChunkPreviewInfo;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChunkPreview {
    public ConcurrentHashMap<UUID, ChunkPreviewInfo> Info = new ConcurrentHashMap();
    private CMI plugin;

    public ChunkPreview(CMI cMI) {
        this.plugin = cMI;
    }

    public void clearCache(UUID uUID) {
        this.Info.remove(uUID);
    }

    public void loadRegionFile(ChunkPreviewInfo chunkPreviewInfo) {
        if (chunkPreviewInfo.getStartTime() == 0L) {
            chunkPreviewInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(chunkPreviewInfo);
    }

    private void loadChunk(final ChunkPreviewInfo chunkPreviewInfo) {
        Bukkit.getServer().getScheduler().cancelTask(chunkPreviewInfo.getScheduleId());
        chunkPreviewInfo.setscheduleId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!ChunkPreview.this.Info.containsKey(chunkPreviewInfo.getPlayer().getUniqueId())) {
                    return;
                }
                if (!chunkPreviewInfo.isRunning()) {
                    return;
                }
                int n = 0;
                while (n < chunkPreviewInfo.getSpeed()) {
                    int n2;
                    Chunk chunk = null;
                    int n3 = 0;
                    int n4 = 0;
                    n3 = chunkPreviewInfo.getChunkChecked();
                    n4 = chunkPreviewInfo.getChunks().size();
                    if (chunkPreviewInfo.getChunks().size() == chunkPreviewInfo.getChunkChecked()) {
                        chunkPreviewInfo.setRunning(false);
                        Bukkit.getServer().getScheduler().cancelTask(chunkPreviewInfo.getScheduleId());
                        if (chunkPreviewInfo.getPlayer().isOnline()) {
                            chunkPreviewInfo.getPlayer().sendMessage(ChunkPreview.this.plugin.getLM().getMessage("command.preview.info.Finished", new Object[0]));
                        }
                        return;
                    }
                    int n5 = chunkPreviewInfo.getChunks().get(chunkPreviewInfo.getChunkChecked()).getX();
                    int n6 = chunkPreviewInfo.getChunks().get(chunkPreviewInfo.getChunkChecked()).getZ();
                    chunk = chunkPreviewInfo.getWorld().getChunkAt(n5, n6);
                    chunkPreviewInfo.addChunkCkecked();
                    if (chunkPreviewInfo.isMessages() && chunkPreviewInfo.getShowInfo() + 2000L < System.currentTimeMillis() && n3 > 0) {
                        chunkPreviewInfo.setShowRegionInfo(false);
                        n2 = n4 - n3;
                        long l = System.currentTimeMillis() - chunkPreviewInfo.getStartTime();
                        long l2 = l / (long)n3;
                        int n7 = (int)((long)n2 * l2 / 1000L);
                        int n8 = n7 / 60;
                        chunkPreviewInfo.setChunksCkeckedLast(n3);
                        CMIActionBar.send((Player)chunkPreviewInfo.getPlayer(), (String)ChunkPreview.this.plugin.getLM().getMessage("command.preview.info.InfoShow", "[tps]", String.format("%.2f", ChunkPreview.this.plugin.getLagMeter().getTPS()), "[left]", n2, "[min]", n8, "[sec]", n7 -= n8 * 60, "[speed]", chunkPreviewInfo.getSpeed()));
                        if (chunkPreviewInfo.isAutoSpeed()) {
                            if (ChunkPreview.this.plugin.getLagMeter().getTPS() > ((ChunkPreview)ChunkPreview.this).plugin.getConfigManager().lfixSoftCap) {
                                chunkPreviewInfo.setSpeed(chunkPreviewInfo.getSpeed() + 1);
                            } else {
                                chunkPreviewInfo.setSpeed(chunkPreviewInfo.getSpeed() - 2);
                            }
                        }
                        chunkPreviewInfo.setShowInfo(System.currentTimeMillis());
                    }
                    if (chunk != null) {
                        int n9 = Bukkit.getServer().getViewDistance();
                        n2 = chunkPreviewInfo.getPlayer().getLocation().getChunk().getX() - chunk.getX();
                        int n10 = chunkPreviewInfo.getPlayer().getLocation().getChunk().getZ() - chunk.getZ();
                        n2 = n2 < 0 ? n2 * -1 : n2;
                        int n11 = n10 = n10 < 0 ? n10 * -1 : n10;
                        if ((n2 >= n9 || n10 >= n9) && chunkPreviewInfo.getPlayer().isOnline() && chunkPreviewInfo.getPlayer().getWorld().getName().equals(chunkPreviewInfo.getWorld().getName())) {
                            ChunkPreview.this.plugin.getNMS().resendChunk(chunk, chunkPreviewInfo.getPlayer());
                        }
                        chunk.getWorld().unloadChunkRequest(chunk.getX(), chunk.getZ());
                    }
                    ++n;
                }
                ChunkPreview.this.loadChunk(chunkPreviewInfo);
            }
        }, 20L));
    }
}

