/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Ranks;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Ranks.rankPlaceholderAction;
import com.Zrips.CMI.Modules.Ranks.rankPlaceholderType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public class CMIRankPlaceholder {
    private static final String regex = "^(.*?)(>=|<=|==)(.*?)(;)(.+)";
    private static final Pattern pattern = Pattern.compile("^(.*?)(>=|<=|==)(.*?)(;)(.+)", 8);
    private String placeholder = "";
    private Object value = "";
    private rankPlaceholderType type = rankPlaceholderType.invalid;
    private rankPlaceholderAction action = rankPlaceholderAction.equal;
    private String message = "";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMIRankPlaceholder(String string) {
        Matcher matcher = pattern.matcher(string);
        try {
            while (true) {
                if (!matcher.find()) {
                    return;
                }
                this.placeholder = matcher.group(1);
                this.value = matcher.group(3);
                this.message = matcher.group(5);
                String string2 = matcher.group(2);
                this.action = string2.equalsIgnoreCase(">=") ? rankPlaceholderAction.more : (string2.equalsIgnoreCase("<=") ? rankPlaceholderAction.less : rankPlaceholderAction.equal);
                try {
                    this.value = Double.parseDouble((String)this.value);
                    this.type = rankPlaceholderType.number;
                }
                catch (Throwable throwable) {
                    this.type = rankPlaceholderType.string;
                }
            }
        }
        catch (Throwable throwable) {
            this.type = rankPlaceholderType.invalid;
        }
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public rankPlaceholderType getType() {
        return this.type;
    }

    public void setType(rankPlaceholderType rankPlaceholderType2) {
        this.type = rankPlaceholderType2;
    }

    public rankPlaceholderAction getAction() {
        return this.action;
    }

    public void setAction(rankPlaceholderAction rankPlaceholderAction2) {
        this.action = rankPlaceholderAction2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public double percent(Player player) {
        if (player == null) {
            return 0.0;
        }
        String string = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, this.getPlaceholder());
        switch (this.type) {
            case invalid: {
                return 0.0;
            }
            case number: {
                switch (this.action) {
                    case equal: {
                        return string.equalsIgnoreCase((String)this.getValue()) ? 100.0 : 0.0;
                    }
                    case less: {
                        try {
                            double d = Double.parseDouble(string);
                            return d <= (Double)this.getValue() ? 100.0 : 0.0;
                        }
                        catch (Throwable throwable) {
                            return 0.0;
                        }
                    }
                    case more: {
                        try {
                            double d = Double.parseDouble(string);
                            return d >= (Double)this.getValue() ? 100.0 : d / (Double)this.getValue() * 100.0;
                        }
                        catch (Throwable throwable) {
                            return 0.0;
                        }
                    }
                }
                break;
            }
            case string: {
                return string.equalsIgnoreCase((String)this.getValue()) ? 100.0 : 0.0;
            }
        }
        return 0.0;
    }
}

