/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Totems;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.CMIVisualEffect;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.Modules.Totems.TotemBossBar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class TotemManager {
    private HashMap<UUID, TotemBossBar> totem = new HashMap();
    CMI plugin;
    private boolean TotemRemoveFromInventory = false;
    private boolean TotemCooldownUse = false;
    private boolean TotemWarmupUse = false;
    private boolean TotemProtectFromVoid = false;
    private int TotemCooldownTime = -1;
    private int TotemWarmupTime = -1;
    private int TotemEffectRegeneration = -1;
    private int TotemEffectFireResistance = -1;
    private int TotemEffectAbsorbtion = -1;

    public TotemManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Totem.RemoveFromInventory", new String[]{"When this set to true, on players death totem will be used even if he is not holding it in hand"});
        this.TotemRemoveFromInventory = configReader.get("Totem.RemoveFromInventory", Boolean.valueOf(false));
        configReader.addComment("Totem.Cooldown.Use", new String[]{"When this set to true player can use totem only every X second's"});
        this.TotemCooldownUse = configReader.get("Totem.Cooldown.Use", Boolean.valueOf(false));
        this.TotemCooldownTime = configReader.get("Totem.Cooldown.Time", 600);
        configReader.addComment("Totem.Warmup.Use", new String[]{"When this set to true player can use totem to have X amount of second's, during which he can die and be resurected", "Totem will be consumed durring activation and wont be returned even if resurection is not used during warmup time"});
        this.TotemWarmupUse = configReader.get("Totem.Warmup.Use", Boolean.valueOf(false));
        this.TotemWarmupTime = configReader.get("Totem.Warmup.Time", 10);
        configReader.addComment("Totem.ProtectFromVoid", new String[]{"If player falls into void while having totem, he will be teleported to respawn location and totem gets consumed"});
        this.TotemProtectFromVoid = configReader.get("Totem.ProtectFromVoid", Boolean.valueOf(true));
        configReader.addComment("Totem.Effects.Regeneration", new String[]{"Time in seconds effect needs to be applied to the player. Set it to 0 if you want to disable it"});
        this.TotemEffectRegeneration = configReader.get("Totem.Effects.Regeneration", 45);
        this.TotemEffectFireResistance = configReader.get("Totem.Effects.FireResistance", 40);
        this.TotemEffectAbsorbtion = configReader.get("Totem.Effects.Absorbtion", 5);
    }

    public boolean isTotemRemoveFromInventory() {
        return this.TotemRemoveFromInventory;
    }

    public boolean isTotemCooldownUse() {
        return this.TotemCooldownUse;
    }

    public boolean isTotemWarmupUse() {
        return this.TotemWarmupUse;
    }

    public int getTotemCooldownTime() {
        return this.TotemCooldownTime;
    }

    public int getTotemWarmupTime() {
        return this.TotemWarmupTime;
    }

    public boolean isTotemProtectFromVoid() {
        return this.TotemProtectFromVoid;
    }

    public void hideAllBars() {
        for (Map.Entry<UUID, TotemBossBar> entry : this.totem.entrySet()) {
            Player player = CMIUser.getOnlinePlayer(entry.getKey());
            TotemBossBar totemBossBar = this.getBossBar(player);
            if (totemBossBar == null) {
                return;
            }
            totemBossBar.getBar().setVisible(false);
        }
    }

    public boolean isOnCd(Player player) {
        TotemBossBar totemBossBar = this.totem.get(player.getUniqueId());
        if (totemBossBar == null) {
            return false;
        }
        return totemBossBar.getType() == BossBarType.Cooldown;
    }

    public boolean isOnWarmup(Player player) {
        TotemBossBar totemBossBar = this.totem.get(player.getUniqueId());
        if (totemBossBar == null) {
            return false;
        }
        return totemBossBar.getType() == BossBarType.Warmup;
    }

    public TotemBossBar getBossBar(Player player) {
        TotemBossBar totemBossBar = this.totem.get(player.getUniqueId());
        if (totemBossBar != null) {
            return totemBossBar;
        }
        return null;
    }

    @Deprecated
    public TotemBossBar getBossBar(Player player, BossBarType bossBarType) {
        return this.getBossBar(player.getUniqueId(), bossBarType);
    }

    public TotemBossBar getBossBar(UUID uUID, BossBarType bossBarType) {
        TotemBossBar totemBossBar = this.totem.get(uUID);
        if (totemBossBar != null && totemBossBar.getType() == bossBarType) {
            return totemBossBar;
        }
        return null;
    }

    public void addCooldownPlayer(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        cMIUser.setTotemCooldown(System.currentTimeMillis());
        if (this.isOnWarmup(player)) {
            this.removePlayer(player, BossBarType.Warmup);
        }
        BossBar bossBar = null;
        if (cMIUser.getOptionState(PlayerOption.totemBossBar).booleanValue()) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
            bossBar.setTitle(CMILC.info_totem_cooldown.getLocale("[time]", CMITimeManager.to24hourShort((Long)this.getLeftCd(System.currentTimeMillis(), this.getTotemCooldownTime()))));
            bossBar.setVisible(true);
            bossBar.addPlayer(player);
            bossBar.setProgress(1.0);
        }
        this.totem.put(player.getUniqueId(), new TotemBossBar(bossBar, BossBarType.Cooldown));
        this.ShowTotemCooldown(cMIUser);
    }

    public void addWarmupPlayer(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        cMIUser.setTotemWarmup(System.currentTimeMillis());
        BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
        bossBar.setTitle(CMILC.info_totem_warmup.getLocale("[time]", CMITimeManager.to24hourShort((Long)this.getLeftCd(System.currentTimeMillis(), this.getTotemWarmupTime()))));
        bossBar.setVisible(true);
        bossBar.addPlayer(player);
        bossBar.setProgress(1.0);
        if (this.isOnCd(player)) {
            this.removePlayer(player, BossBarType.Cooldown);
        }
        TotemBossBar totemBossBar = new TotemBossBar(bossBar, BossBarType.Warmup);
        this.totem.put(player.getUniqueId(), totemBossBar);
        this.ShowTotemWarmup(player);
        this.showWarmupEffect(player);
    }

    public void showWarmupEffect(Player player) {
        CMIPEAnimationInterface cMIPEAnimationInterface;
        TotemBossBar totemBossBar = this.totem.get(player.getUniqueId());
        if (totemBossBar == null) {
            cMIPEAnimationInterface = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
            totemBossBar = new TotemBossBar((BossBar)cMIPEAnimationInterface, BossBarType.Warmup);
            this.totem.put(player.getUniqueId(), totemBossBar);
        }
        if ((cMIPEAnimationInterface = CMI.getInstance().getParticleManager().getParticleAnimation(ParticleManager.CMIPresetAnimations.TotemHalo.getAnimString())) != null) {
            CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(player, cMIPEAnimationInterface);
            cMIVisualEffect.setTargetPlayer(player);
            cMIVisualEffect.setUntil(System.currentTimeMillis() + (long)(this.getTotemWarmupTime() * 1000) - 500L);
            cMIVisualEffect.show();
            totemBossBar.setEffect(cMIVisualEffect);
        }
    }

    public void stopWarmupEffect(Player player) {
        TotemBossBar totemBossBar = this.totem.get(player.getUniqueId());
        if (totemBossBar != null && totemBossBar.getEffect() != null) {
            totemBossBar.getEffect().stop();
        }
    }

    @Deprecated
    public boolean toggleBar(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return false;
        }
        return this.toggleBar(cMIUser, null);
    }

    public boolean toggleBar(CMIUser cMIUser, Boolean bl) {
        TotemBossBar totemBossBar = this.getBossBar(cMIUser.getUniqueId(), BossBarType.Cooldown);
        if (totemBossBar != null && totemBossBar.getBar() != null) {
            totemBossBar.getBar().setVisible(cMIUser.getOptionState(PlayerOption.totemBossBar).booleanValue());
        }
        if (bl == null) {
            cMIUser.setOptionState(PlayerOption.totemBossBar, cMIUser.getOptionState(PlayerOption.totemBossBar) == false);
        } else {
            cMIUser.setOptionState(PlayerOption.totemBossBar, bl);
        }
        if (cMIUser.getOptionState(PlayerOption.totemBossBar).booleanValue()) {
            this.ShowTotemCooldown(cMIUser);
        } else if (cMIUser.isOnline()) {
            if (totemBossBar != null && totemBossBar.getBar() != null) {
                totemBossBar.getBar().setVisible(false);
            }
            if ((totemBossBar = this.getBossBar(cMIUser.getUniqueId(), BossBarType.Warmup)) != null && totemBossBar.getBar() != null) {
                totemBossBar.getBar().setVisible(false);
            }
        }
        return true;
    }

    public void removePlayer(Player player, BossBarType bossBarType) {
        TotemBossBar totemBossBar = this.getBossBar(player, bossBarType);
        if (totemBossBar == null) {
            return;
        }
        if (totemBossBar.getBar() != null) {
            totemBossBar.getBar().setVisible(false);
        }
        this.totem.remove(player.getUniqueId());
    }

    public synchronized void ShowTotemWarmup(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (!this.isOnWarmup(player)) {
            return;
        }
        Long l = cMIUser.getTotemWarmup();
        if (l == 0L) {
            return;
        }
        TotemBossBar totemBossBar = this.getBossBar(player, BossBarType.Warmup);
        if (totemBossBar == null) {
            return;
        }
        int n = this.getTotemWarmupTime();
        if (this.getLeftCd(l, n) < 900L) {
            this.removePlayer(player, BossBarType.Warmup);
            return;
        }
        double d = TotemManager.getLeftCdPercentage(l, n);
        if (totemBossBar.getBar() != null) {
            totemBossBar.getBar().setVisible(false);
            totemBossBar.getBar().setVisible(true);
            totemBossBar.getBar().addPlayer(player);
            totemBossBar.getBar().setTitle(CMILC.info_totem_warmup.getLocale("[time]", CMITimeManager.to24hourShort((Long)this.getLeftCd(l, n))));
            try {
                totemBossBar.getBar().setProgress(d);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    @Deprecated
    public synchronized void ShowTotemCooldown(Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        this.ShowTotemCooldown(cMIUser);
    }

    public synchronized void ShowTotemCooldown(CMIUser cMIUser) {
        if (!cMIUser.isOnline()) {
            return;
        }
        Player player = cMIUser.getPlayer();
        if (!this.isOnCd(player)) {
            return;
        }
        Long l = cMIUser.getTotemCooldown();
        if (l == 0L) {
            return;
        }
        TotemBossBar totemBossBar = this.getBossBar(player.getUniqueId(), BossBarType.Cooldown);
        if (totemBossBar == null) {
            return;
        }
        int n = this.getTotemCooldownTime();
        if (this.getLeftCd(l, n) < 900L) {
            this.removePlayer(player, BossBarType.Cooldown);
            return;
        }
        double d = TotemManager.getLeftCdPercentage(l, n);
        if (cMIUser.getOptionState(PlayerOption.totemBossBar).booleanValue() && totemBossBar.getBar() == null) {
            totemBossBar.setBar(Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]));
        }
        if (totemBossBar.getBar() != null && cMIUser.getOptionState(PlayerOption.totemBossBar).booleanValue()) {
            totemBossBar.getBar().setVisible(false);
            totemBossBar.getBar().setVisible(true);
            totemBossBar.getBar().addPlayer(player);
            totemBossBar.getBar().setTitle(CMILC.info_totem_cooldown.getLocale("[time]", CMITimeManager.to24hourShort((Long)this.getLeftCd(l, n))));
            try {
                totemBossBar.getBar().setProgress(d);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public Long getLeftCd(Player player, int n) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return 0L;
        }
        Long l = cMIUser.getTotemCooldown();
        return this.getLeftCd(l, n);
    }

    private Long getLeftCd(Long l, int n) {
        long l2 = (long)(n * 1000) + l - System.currentTimeMillis();
        if (l2 < 0L) {
            l2 = 0L;
        }
        return l2;
    }

    private static double getLeftCdPercentage(Long l, int n) {
        double d = ((double)n * 1000.0 + (double)l.longValue() - (double)System.currentTimeMillis()) / ((double)n * 1000.0);
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public void checkAllForTotemCd() {
        for (Map.Entry<UUID, TotemBossBar> entry : new HashMap<UUID, TotemBossBar>(this.totem).entrySet()) {
            Player player = CMIUser.getOnlinePlayer(entry.getKey());
            if (player == null || !player.isOnline()) continue;
            if (entry.getValue().getType() == BossBarType.Cooldown) {
                this.ShowTotemCooldown(player);
                continue;
            }
            this.ShowTotemWarmup(player);
        }
    }

    public int getRegenerationDuration() {
        return this.TotemEffectRegeneration;
    }

    public int getFireResistanceDuration() {
        return this.TotemEffectFireResistance;
    }

    public int getAbsorbtionDuration() {
        return this.TotemEffectAbsorbtion;
    }

    public static enum BossBarType {
        Cooldown,
        Warmup;

    }
}

