/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ViewRange;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.ChunkInfo;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.ViewRange.ViewRangeInfo;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ViewRangeListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLogIn(PlayerJoinEvent playerJoinEvent) {
        if (!CMIHookType.ProtocolLib.isEnabled()) {
            return;
        }
        Player player = playerJoinEvent.getPlayer();
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_15_R1)) {
            CMIHookType.ProtocolLib.setEnabled(false);
            return;
        }
        if (!CMI.getInstance().getViewRangeManager().Info.containsKey(player.getName())) {
            return;
        }
        ViewRangeInfo viewRangeInfo = CMI.getInstance().getViewRangeManager().Info.get(player.getName());
        int n = CMI.getInstance().getViewRangeManager().getRangeFromPerm(player);
        viewRangeInfo.setRange(n);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.isCancelled()) {
            return;
        }
        if (!CMIHookType.ProtocolLib.isEnabled()) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_15_R1)) {
            CMIHookType.ProtocolLib.setEnabled(false);
            return;
        }
        Player player = playerTeleportEvent.getPlayer();
        ViewRangeInfo viewRangeInfo = null;
        int n = Bukkit.getViewDistance();
        if (CMI.getInstance().getViewRangeManager().Info.containsKey(player.getName())) {
            viewRangeInfo = CMI.getInstance().getViewRangeManager().Info.get(player.getName());
            n = viewRangeInfo.getRange();
        } else if (CMI.getInstance().getConfigManager().DynamicViewRangeEnabled) {
            viewRangeInfo = new ViewRangeInfo();
            n = CMI.getInstance().getViewRangeManager().getRangeFromPerm(player);
        }
        if (viewRangeInfo == null) {
            return;
        }
        ViewRangeInfo viewRangeInfo2 = viewRangeInfo;
        if (n == Bukkit.getViewDistance()) {
            return;
        }
        if (viewRangeInfo2.getScheduleId() != -1) {
            Bukkit.getServer().getScheduler().cancelTask(viewRangeInfo2.getScheduleId());
        }
        viewRangeInfo2.setRange(n);
        int n2 = Bukkit.getViewDistance();
        Chunk chunk = playerTeleportEvent.getTo().getChunk();
        int n3 = chunk.getX();
        int n4 = chunk.getZ();
        int n5 = n2;
        while (n5 < n) {
            int n6 = n3 - n5;
            while (n6 <= n3 + n5) {
                viewRangeInfo2.addChunk(new ChunkInfo(n6, n4 + n5));
                ++n6;
            }
            n6 = n4 + n5 - 1;
            while (n6 >= n4 - n5) {
                viewRangeInfo2.addChunk(new ChunkInfo(n3 + n5, n6));
                --n6;
            }
            n6 = n3 + n5 - 1;
            while (n6 >= n3 - n5) {
                viewRangeInfo2.addChunk(new ChunkInfo(n6, n4 - n5));
                --n6;
            }
            n6 = n4 - n5 + 1;
            while (n6 <= n4 + n5 - 1) {
                viewRangeInfo2.addChunk(new ChunkInfo(n3 - n5, n6));
                ++n6;
            }
            ++n5;
        }
        viewRangeInfo2.setPlayer(player);
        viewRangeInfo2.setWorld(playerTeleportEvent.getTo().getWorld());
        viewRangeInfo2.setSpeed(1);
        viewRangeInfo2.setRunning(true);
        viewRangeInfo2.resetChunkCkecked();
        viewRangeInfo2.setTeleporting(true);
        viewRangeInfo2.setTeleportingTime(System.currentTimeMillis());
        CMI.getInstance().getViewRangeManager().Info.put(player.getName(), viewRangeInfo2);
        CMI.getInstance().getViewRangeManager().loadChunk(viewRangeInfo2);
    }
}

