/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Worth;

import com.Zrips.CMI.CMI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Recipes.CMIRecipe;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class WorthItem {
    private Material material;
    private Integer data = null;
    private Double sellPrice = 0.0;
    private Double buyPrice = null;
    private ItemStack item;
    private Recipe recipe = null;
    private Recipe exploitRecipe = null;
    private Set<Recipe> recipesFor;
    private Set<Recipe> recipesFrom;
    private Integer modelData;

    @Deprecated
    public WorthItem(ItemStack itemStack, Integer n, double d) {
        this.item = itemStack;
        this.material = itemStack.getType();
        this.data = n;
        this.sellPrice = d;
    }

    public WorthItem(ItemStack itemStack, double d) {
        this.item = itemStack;
        this.material = itemStack.getType();
        this.sellPrice = d;
    }

    public WorthItem(ItemStack itemStack) {
        this(itemStack, 0.0);
    }

    public Integer getData() {
        return this.data;
    }

    public void setData(Integer n) {
        this.data = n;
    }

    public Double getSellPrice() {
        return this.sellPrice;
    }

    public Double getPlayerSellPrice(ItemStack itemStack, boolean bl, boolean bl2) {
        double d = this.sellPrice;
        if (bl2) {
            d = CMI.getInstance().getWorthManager().getWorthByDurability(itemStack, d);
        }
        if (bl) {
            d += WorthItem.getEnchantSellPrice(itemStack);
        }
        return d;
    }

    public static double getEnchantSellPrice(ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        Double d = 0.0;
        for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
            if (entry == null) continue;
            d = d + CMI.getInstance().getWorthManager().getEnchantSellPrice((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        return d;
    }

    public void setSellPrice(double d) {
        this.sellPrice = (double)Math.round(d * 100.0) / 100.0;
        if (this.sellPrice < 0.0) {
            this.sellPrice = 0.0;
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack itemStack) {
        if (this.item == null) {
            this.item = itemStack.clone();
        }
    }

    public Double getBuyPrice() {
        return this.buyPrice == null ? this.sellPrice : this.buyPrice;
    }

    public boolean isBuyPriceSet() {
        return this.buyPrice != null;
    }

    public void setBuyPrice(Double d) {
        Double d2 = this.buyPrice = d == null ? null : Double.valueOf((double)Math.round(d * 100.0) / 100.0);
        if (this.buyPrice != null && this.buyPrice < 0.0) {
            this.buyPrice = null;
        }
    }

    public Recipe getExploitRecipe() {
        return this.exploitRecipe;
    }

    public Recipe updateExploitRecipe() {
        WorthItem worthItem;
        Double d;
        List list2;
        if (this.recipesFor == null || this.recipesFrom == null) {
            this.updateRecipes();
        }
        block0: for (Recipe recipe2 : this.recipesFor) {
            list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
            d = 0.0;
            for (Object object2 : list2) {
                worthItem = CMI.getInstance().getWorthManager().getWorth((ItemStack)object2, true);
                if (worthItem == null || !worthItem.isBuyPriceSet()) continue block0;
                d = d + (double)object2.getAmount() * worthItem.getBuyPrice();
            }
            if (!(d > 0.0) || !(this.getSellPrice() * (double)recipe2.getResult().getAmount() > d)) continue;
            this.exploitRecipe = recipe2;
            return recipe2;
        }
        block2: for (Recipe recipe2 : this.recipesFrom) {
            Object object2;
            list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
            d = 0.0;
            for (Object object2 : list2) {
                worthItem = CMI.getInstance().getWorthManager().getWorth((ItemStack)object2, true);
                if (worthItem == null || !worthItem.isBuyPriceSet()) continue block2;
                d = d + (double)object2.getAmount() * worthItem.getBuyPrice();
            }
            object2 = CMI.getInstance().getWorthManager().getWorth(recipe2.getResult(), true);
            if (object2 == null || !(d > 0.0) || !(((WorthItem)object2).getSellPrice() * (double)recipe2.getResult().getAmount() > d)) continue;
            this.exploitRecipe = recipe2;
            return recipe2;
        }
        this.exploitRecipe = null;
        return null;
    }

    public void resetRecipes() {
        this.exploitRecipe = null;
        this.recipe = null;
        this.recipesFor = null;
        this.recipesFrom = null;
    }

    public void setExploitRecipe(Recipe recipe2) {
        this.exploitRecipe = recipe2;
    }

    public void updateRecipes() {
        WorthItem worthItem;
        boolean bl;
        List list2;
        this.recipesFor = new HashSet<Recipe>();
        this.recipesFrom = new HashSet<Recipe>();
        List list3 = CMILib.getInstance().getItemManager().getItem(this.getItem()).getRecipesFor();
        for (Recipe recipe2 : list3) {
            if (this.recipe == null) {
                this.recipe = recipe2;
            }
            list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
            bl = false;
            for (ItemStack itemStack : list2) {
                worthItem = CMI.getInstance().getWorthManager().getWorth(itemStack, true);
                if (worthItem != null && worthItem.isBuyPriceSet()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.recipesFor.add(recipe2);
        }
        list3 = CMILib.getInstance().getItemManager().getItem(this.getItem()).getRecipesFrom();
        for (Recipe recipe2 : list3) {
            list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
            bl = false;
            for (ItemStack itemStack : list2) {
                worthItem = CMI.getInstance().getWorthManager().getWorth(itemStack, true);
                if (worthItem != null && worthItem.isBuyPriceSet()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.recipesFrom.add(recipe2);
        }
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Recipe recipe2) {
        this.recipe = recipe2;
    }

    public void setModelData(Integer n) {
        this.modelData = n;
    }

    public Integer getModelData() {
        return this.modelData;
    }
}

