/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Worth;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Worth.WorthEnchantment;
import com.Zrips.CMI.Modules.Worth.WorthItem;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.setworth;
import com.Zrips.CMI.commands.list.worthlist;
import com.Zrips.CMI.utils.DateFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.Enchants.CMIEnchantment;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Recipes.CMIRecipe;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class WorthManager {
    private CMI plugin;
    private LinkedHashMap<CMIMaterial, List<WorthItem>> map = new LinkedHashMap();
    private HashMap<Enchantment, HashMap<Integer, WorthEnchantment>> enchantMap = new HashMap();
    public static String fileName = "Worth.yml";
    File file = null;
    Writer writer = null;
    boolean checkedOldFile = false;
    List<String> badLore = new ArrayList<String>();
    private boolean loreBlock = false;
    private boolean requireFullDurability = false;
    private boolean devalueByDurability = false;
    private int autoGeneratePriceIncrease = 0;
    private boolean customNameBlocking = false;

    public WorthManager(CMI cMI) {
        this.plugin = cMI;
    }

    public Double getEnchantSellPrice(Enchantment enchantment, int n) {
        HashMap<Integer, WorthEnchantment> hashMap = this.enchantMap.get(enchantment);
        if (hashMap == null) {
            return 0.0;
        }
        WorthEnchantment worthEnchantment = hashMap.get(n);
        if (worthEnchantment == null) {
            worthEnchantment = hashMap.get(0);
        }
        if (worthEnchantment == null) {
            return 0.0;
        }
        return worthEnchantment.getSellPrice();
    }

    public WorthEnchantment getEnchantWorth(Enchantment enchantment, int n) {
        HashMap<Integer, WorthEnchantment> hashMap = this.enchantMap.get(enchantment);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(n);
    }

    public void addEnchantWorth(WorthEnchantment worthEnchantment) {
        HashMap<Integer, WorthEnchantment> hashMap = this.enchantMap.get(worthEnchantment.getEnchant());
        if (hashMap == null) {
            hashMap = new HashMap();
            this.enchantMap.put(worthEnchantment.getEnchant(), hashMap);
        }
        hashMap.put(worthEnchantment.getLevel(), worthEnchantment);
    }

    public void load() {
        Long l = System.currentTimeMillis();
        try {
            CMI.getInstance().safeRenameFile(fileName.toLowerCase(), "Saves" + File.separator + fileName);
            File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            if (yamlConfiguration.getKeys(false).isEmpty()) {
                return;
            }
            this.map.clear();
            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("worth");
            Map map = configurationSection.getValues(false);
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                try {
                    Map.Entry entry22;
                    Object object;
                    Object object2;
                    CMIItemStack cMIItemStack;
                    string = string.replace(">", ":");
                    Integer n = null;
                    if (string.contains(";cm{")) {
                        try {
                            n = Integer.parseInt(string.split(Pattern.quote(";cm{"), 2)[1].split("}", 2)[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        string = string.split(Pattern.quote(";cm{"), 2)[0];
                    }
                    if ((cMIItemStack = CMILib.getInstance().getItemManager().getItem(string.replace(">", ":"))) == null || cMIItemStack.getItemStack() == null) {
                        this.plugin.consoleMessage("&cCan't load worth value for " + string);
                        continue;
                    }
                    if (configurationSection.isConfigurationSection((String)entry.getKey())) {
                        object2 = configurationSection.getConfigurationSection((String)entry.getKey());
                        object = object2.getValues(false);
                        for (Map.Entry entry22 : object.entrySet()) {
                            Object object3;
                            WorthItem worthItem;
                            Object object4;
                            Double d;
                            if (((String)entry22.getKey()).equalsIgnoreCase("*")) {
                                try {
                                    Double d2 = null;
                                    d = null;
                                    if (entry22.getValue().toString().contains(";")) {
                                        d2 = Double.parseDouble(entry22.getValue().toString().split(";")[0]);
                                        d = Double.parseDouble(entry22.getValue().toString().split(";")[1]);
                                    } else {
                                        d2 = Double.parseDouble(entry22.getValue().toString());
                                    }
                                    object4 = new WorthItem(cMIItemStack.getItemStack(), d2);
                                    if (d != null) {
                                        ((WorthItem)object4).setBuyPrice(d);
                                    }
                                    ((WorthItem)object4).setModelData(n);
                                    worthItem = cMIItemStack.getCMIType();
                                    object3 = this.map.get(worthItem);
                                    if (object3 == null) {
                                        object3 = new ArrayList();
                                        this.map.put((CMIMaterial)worthItem, (List<WorthItem>)object3);
                                    }
                                    object3.add(object4);
                                    this.map.put((CMIMaterial)worthItem, (List<WorthItem>)object3);
                                }
                                catch (Exception exception) {
                                    this.plugin.consoleMessage("&cCan't load worth value for " + string + ":" + (String)entry22.getKey());
                                }
                                continue;
                            }
                            try {
                                int n2 = Integer.parseInt((String)entry22.getKey());
                                d = null;
                                object4 = null;
                                if (entry22.getValue().toString().contains(";")) {
                                    d = Double.parseDouble(entry22.getValue().toString().split(";")[0]);
                                    object4 = Double.parseDouble(entry22.getValue().toString().split(";")[1]);
                                } else {
                                    d = Double.parseDouble(entry22.getValue().toString());
                                }
                                worthItem = new WorthItem(cMIItemStack.getItemStack(), n2, d);
                                if (object4 != null) {
                                    worthItem.setBuyPrice((Double)object4);
                                }
                                worthItem.setModelData(n);
                                object3 = cMIItemStack.getCMIType();
                                List<WorthItem> list2 = this.map.get(object3);
                                if (list2 == null) {
                                    list2 = new ArrayList<WorthItem>();
                                    this.map.put((CMIMaterial)object3, list2);
                                }
                                list2.add(worthItem);
                                this.map.put((CMIMaterial)object3, list2);
                            }
                            catch (Exception exception) {
                                this.plugin.consoleMessage("&cCan't load worth value for " + string + ":" + (String)entry22.getKey());
                            }
                        }
                        continue;
                    }
                    if (!(entry.getValue() instanceof Double) && !(entry.getValue() instanceof Integer) && !(entry.getValue() instanceof String)) continue;
                    object2 = null;
                    object = null;
                    if (entry.getValue().toString().isEmpty()) continue;
                    if (entry.getValue().toString().contains(";")) {
                        object2 = Double.parseDouble(entry.getValue().toString().split(";")[0]);
                        object = Double.parseDouble(entry.getValue().toString().split(";")[1]);
                    } else {
                        object2 = Double.parseDouble(entry.getValue().toString());
                    }
                    entry22 = new WorthItem(cMIItemStack.getItemStack(), null, (Double)object2);
                    if (object != null) {
                        ((WorthItem)((Object)entry22)).setBuyPrice((Double)object);
                    }
                    ((WorthItem)((Object)entry22)).setModelData(n);
                    CMIMaterial cMIMaterial = cMIItemStack.getCMIType();
                    List<WorthItem> list3 = this.map.get(cMIMaterial);
                    if (list3 == null) {
                        list3 = new ArrayList<WorthItem>();
                        this.map.put(cMIMaterial, list3);
                    }
                    list3.add((WorthItem)((Object)entry22));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.plugin.consoleMessage("&cFailed to load worth for: " + string);
                }
            }
            this.plugin.loadMessage(this.map.size(), "worth values", System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.plugin.consoleMessage("&cFailed to load worth file");
        }
    }

    public void loadEnchtWorth() {
        Long l = System.currentTimeMillis();
        try {
            CMI.getInstance().safeRenameFile(fileName.toLowerCase(), "Saves" + File.separator + fileName);
            File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
            if (yamlConfiguration.getKeys(false).isEmpty()) {
                return;
            }
            this.enchantMap.clear();
            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("enchantWorth");
            if (configurationSection != null) {
                Map map = configurationSection.getValues(false);
                int n = 0;
                for (Map.Entry entry : map.entrySet()) {
                    String string = (String)entry.getKey();
                    try {
                        Enchantment enchantment = CMIEnchantment.getByName((String)string);
                        if (enchantment == null) {
                            this.plugin.consoleMessage("&cCan't load emnchant worth value for " + string);
                            continue;
                        }
                        List list2 = (List)entry.getValue();
                        for (String string2 : list2) {
                            Integer n2 = null;
                            Double d = null;
                            Double d2 = null;
                            if (!string2.contains("-")) continue;
                            n2 = Integer.parseInt(string2.split("-")[0]);
                            if (string2.contains(";")) {
                                d = Double.parseDouble(string2.split("-")[1].split(";")[0]);
                                d2 = Double.parseDouble(string2.split("-")[1].split(";")[1]);
                            } else {
                                d = Double.parseDouble(string2.split("-")[1]);
                            }
                            WorthEnchantment worthEnchantment = new WorthEnchantment(enchantment, n2, d, d2);
                            ++n;
                            this.addEnchantWorth(worthEnchantment);
                        }
                    }
                    catch (Exception exception) {
                        this.plugin.consoleMessage("&cFailed to load enchant worth for: " + string);
                    }
                }
                this.plugin.loadMessage(n, "enchant worth", System.currentTimeMillis() - l);
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
            this.plugin.consoleMessage("&cFailed to load enchant worth file");
        }
    }

    private void addSellPriceButton(final CMIGui cMIGui, final CMIItemStack cMIItemStack, final WorthItem worthItem, int n, CMIMaterial cMIMaterial, final double d) {
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n, cMIMaterial){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Long l = Math.round(worthItem.getSellPrice() * 100.0);
                Long l2 = Math.round(d * 100.0);
                switch (gUIClickType) {
                    case Left: {
                        worthItem.setSellPrice((double)(l - l2) / 100.0);
                        break;
                    }
                    case LeftShift: {
                        worthItem.setSellPrice(((double)l.longValue() - (double)l2.longValue() * 10.0) / 100.0);
                        break;
                    }
                    case Right: {
                        worthItem.setSellPrice((double)(l + l2) / 100.0);
                        break;
                    }
                    case RightShift: {
                        worthItem.setSellPrice(((double)l.longValue() + (double)l2.longValue() * 10.0) / 100.0);
                        break;
                    }
                }
                if (worthItem.isBuyPriceSet() && worthItem.getSellPrice() > worthItem.getBuyPrice()) {
                    worthItem.setSellPrice(worthItem.getBuyPrice());
                }
                WorthManager.this.openWorthGui(cMIGui.getPlayer(), cMIItemStack);
            }

            public void updateLooks() {
                this.clearLore();
                WorthManager.this.priceLore(this, worthItem);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(setworth.class, "setSell", "[amount]", d));
        cMIGuiButton.setGui(cMIGui);
        cMIGui.addButton(cMIGuiButton);
    }

    private void addBuyPriceButton(final CMIGui cMIGui, final CMIItemStack cMIItemStack, final WorthItem worthItem, int n, CMIMaterial cMIMaterial, final double d) {
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n, cMIMaterial){

            public void click(GUIManager.GUIClickType gUIClickType) {
                Long l = worthItem.getBuyPrice() == null ? 0L : Math.round(worthItem.getBuyPrice() * 100.0);
                Long l2 = Math.round(d * 100.0);
                switch (gUIClickType) {
                    case Left: {
                        worthItem.setBuyPrice((double)(l - l2) / 100.0);
                        break;
                    }
                    case LeftShift: {
                        worthItem.setBuyPrice(((double)l.longValue() - (double)l2.longValue() * 10.0) / 100.0);
                        break;
                    }
                    case Right: {
                        worthItem.setBuyPrice((double)(l + l2) / 100.0);
                        break;
                    }
                    case RightShift: {
                        worthItem.setBuyPrice(((double)l.longValue() + (double)l2.longValue() * 10.0) / 100.0);
                        break;
                    }
                }
                if (worthItem.getSellPrice() > worthItem.getBuyPrice()) {
                    worthItem.setBuyPrice(worthItem.getSellPrice());
                }
                WorthManager.this.openWorthGui(cMIGui.getPlayer(), cMIItemStack);
            }

            public void updateLooks() {
                this.clearLore();
                WorthManager.this.priceLore(this, worthItem);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(setworth.class, "setBuy", "[amount]", d));
        cMIGuiButton.setGui(cMIGui);
        cMIGui.addButton(cMIGuiButton);
    }

    public void openWorthGui(final Player player, CMIItemStack cMIItemStack) {
        Object object;
        WorthItem worthItem;
        cMIItemStack = cMIItemStack.clone();
        cMIItemStack.getItemStack().setAmount(1);
        WorthItem worthItem2 = CMI.getInstance().getWorthManager().getWorth(cMIItemStack.getItemStack(), true);
        CMINBT cMINBT = new CMINBT(cMIItemStack.getItemStack());
        Integer n = cMINBT.getInt("CustomModelData");
        if (n != null && worthItem2 != null && worthItem2.getModelData() == null) {
            worthItem2 = null;
        }
        if (worthItem2 == null) {
            worthItem2 = new WorthItem(cMIItemStack.getItemStack(), 0.0);
            worthItem2.setModelData(n);
            worthItem = cMIItemStack.getCMIType();
            object = this.map.get(worthItem);
            if (object == null) {
                object = new ArrayList();
                this.map.put((CMIMaterial)worthItem, (List<WorthItem>)object);
            }
            object.add(worthItem2);
            this.map.put((CMIMaterial)worthItem, (List<WorthItem>)object);
        }
        worthItem = worthItem2;
        worthItem.setItem(cMIItemStack.getItemStack());
        object = new CMIGui(player){

            public void onClose() {
                CMI.getInstance().getWorthManager().updatePriceInFile(worthItem);
                worthItem.resetRecipes();
            }
        };
        String string = "";
        if (worthItem.getModelData() != null) {
            string = " (" + worthItem.getModelData() + ")";
        }
        object.setTitle(String.valueOf(cMIItemStack.getRealName()) + string);
        object.setInvSize(GUIManager.GUIRows.r6);
        worthItem.updateExploitRecipe();
        this.addSellPriceButton((CMIGui)object, cMIItemStack, worthItem, 9, CMIMaterial.YELLOW_WOOL, 0.01);
        this.addSellPriceButton((CMIGui)object, cMIItemStack, worthItem, 10, CMIMaterial.YELLOW_WOOL, 1.0);
        this.addSellPriceButton((CMIGui)object, cMIItemStack, worthItem, 11, CMIMaterial.YELLOW_WOOL, 100.0);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(13, cMIItemStack.getItemStack().clone()){

            public void click(GUIManager.GUIClickType gUIClickType) {
                WorthManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + worthlist.class.getSimpleName() + " -missing");
            }
        };
        this.priceLore(cMIGuiButton, worthItem);
        object.addButton(cMIGuiButton);
        this.addBuyPriceButton((CMIGui)object, cMIItemStack, worthItem, 15, CMIMaterial.GREEN_WOOL, 0.01);
        this.addBuyPriceButton((CMIGui)object, cMIItemStack, worthItem, 16, CMIMaterial.GREEN_WOOL, 1.0);
        this.addBuyPriceButton((CMIGui)object, cMIItemStack, worthItem, 17, CMIMaterial.GREEN_WOOL, 100.0);
        Recipe recipe2 = worthItem.getRecipe();
        if (recipe2 != null) {
            int n2 = 0;
            int n3 = 30;
            List list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
            n3 -= list2.size() / 2;
            for (final ItemStack itemStack : CMIRecipe.getIngredientsList((Recipe)recipe2)) {
                ItemStack itemStack2 = itemStack.clone();
                final WorthItem worthItem3 = this.getWorth(itemStack2, true);
                cMIGuiButton = new CMIGuiButton(n3 + ++n2, itemStack2){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        CMI.getInstance().getWorthManager().updatePriceInFile(worthItem);
                        worthItem.resetRecipes();
                        WorthManager.this.openWorthGui(player, new CMIItemStack(itemStack));
                    }

                    public void updateLooks() {
                        if (worthItem3 == null || !worthItem3.isBuyPriceSet()) {
                            this.setName(CMILC.getIM(setworth.class, "notSetBuy", new Object[0]));
                        } else {
                            this.setName(CMILC.getIM(setworth.class, "buyPrice", "[amount]", WorthManager.this.plugin.getEconomyManager().format(worthItem3.getBuyPrice())));
                        }
                    }
                };
                if (worthItem3 == null || !worthItem3.isBuyPriceSet()) {
                    cMIGuiButton.setGlowing();
                }
                object.addButton(cMIGuiButton);
            }
        }
        object.fillEmptyButtons();
        object.open();
    }

    private void priceLore(CMIGuiButton cMIGuiButton, WorthItem worthItem) {
        ItemStack itemStack;
        Object object;
        Object object222;
        if (worthItem == null) {
            return;
        }
        Double d = worthItem.getSellPrice();
        Double d2 = worthItem.getBuyPrice();
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "sellPrice", "[amount]", d == null ? "-" : this.plugin.getEconomyManager().format(d)));
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "buyPrice", "[amount]", !worthItem.isBuyPriceSet() || d2 == null ? "-" : this.plugin.getEconomyManager().format(d2)));
        boolean bl = true;
        Recipe recipe2 = worthItem.getExploitRecipe();
        if (recipe2 == null) {
            bl = false;
            recipe2 = worthItem.getRecipe();
        }
        if (recipe2 == null) {
            return;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(recipe2.getResult());
        WorthItem worthItem2 = this.getWorth(recipe2.getResult(), true);
        List list2 = CMIRecipe.getIngredientsList((Recipe)recipe2);
        HashMap<String, ItemStack> hashMap = new HashMap<String, ItemStack>();
        for (Object object222 : list2) {
            CMIItemStack object3 = CMILib.getInstance().getItemManager().getItem((ItemStack)object222);
            short s = object3.getData();
            s = s < 0 ? (short)0 : s;
            object = object3.getType() + ":" + s;
            itemStack = (ItemStack)hashMap.get(object);
            if (itemStack == null) {
                hashMap.put((String)object, object222.clone());
                continue;
            }
            itemStack.setAmount(itemStack.getAmount() + object222.getAmount());
        }
        cMIGuiButton.addLore(" ");
        if (bl) {
            cMIGuiButton.addLore(CMILC.getIM(setworth.class, "exploit", new Object[0]));
        }
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "ingredient", new Object[0]));
        object222 = 0.0;
        Object object4 = 0.0;
        for (Map.Entry entry : hashMap.entrySet()) {
            object = CMI.getInstance().getWorthManager().getWorth((ItemStack)entry.getValue(), true);
            itemStack = CMILib.getInstance().getItemManager().getItem((ItemStack)entry.getValue());
            if (object != null && ((WorthItem)object).getSellPrice() != null) {
                object4 = (Double)object4 + (double)((ItemStack)entry.getValue()).getAmount() * ((WorthItem)object).getSellPrice();
            }
            if (object == null || !((WorthItem)object).isBuyPriceSet()) {
                cMIGuiButton.addLore(CMILC.getIM(setworth.class, "ingredients", "[price]", CMILC.getIM(setworth.class, "notSet", new Object[0]), "[ingridient]", itemStack.getRealName(), "[ingredient]", itemStack.getRealName(), "[amount]", ((ItemStack)entry.getValue()).getAmount()));
                continue;
            }
            cMIGuiButton.addLore(CMILC.getIM(setworth.class, "ingredients", "[price]", this.plugin.getEconomyManager().format((double)((ItemStack)entry.getValue()).getAmount() * ((WorthItem)object).getBuyPrice()), "[ingridient]", itemStack.getRealName(), "[ingredient]", itemStack.getRealName(), "[amount]", ((ItemStack)entry.getValue()).getAmount()));
            object222 = (Double)object222 + (double)((ItemStack)entry.getValue()).getAmount() * ((WorthItem)object).getBuyPrice();
        }
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "result", "[result]", cMIItemStack.getRealName(), "[amount]", cMIItemStack.getAmount()));
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "ingredientsPrice", "[price]", this.plugin.getEconomyManager().format((Double)object222)));
        if (worthItem2 != null && worthItem2.getSellPrice() != null) {
            cMIGuiButton.addLore(CMILC.getIM(setworth.class, "resultPrice", "[price]", this.plugin.getEconomyManager().format(worthItem2.getSellPrice() * (double)cMIItemStack.getAmount())));
        }
        cMIGuiButton.addLore(CMILC.getIM(setworth.class, "explanation", new Object[0]));
        cMIGuiButton.update();
    }

    public void closeStream() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void sellLog(Player player, HashMap<WorthItem, Integer> hashMap) {
        Object object;
        Object object2;
        Comparable<Date> comparable;
        if (!this.checkedOldFile && !((File)(comparable = new File(CMI.getInstance().getDataFolder(), "sellLogs"))).isDirectory()) {
            ((File)comparable).mkdir();
        }
        comparable = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM");
        String string = simpleDateFormat.format((Date)comparable);
        boolean bl = false;
        if (this.file != null) {
            if (!this.file.getName().equalsIgnoreCase(String.valueOf(string) + ".yml")) {
                bl = true;
                if (this.writer != null) {
                    try {
                        this.writer.flush();
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.writer = null;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.file = new File(this.plugin.getDataFolder(), "sellLogs" + File.separator + string + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }
        if (!this.checkedOldFile) {
            object2 = new File(this.plugin.getDataFolder(), "sellLog.yml");
            if (((File)object2).exists()) {
                object = new File(this.plugin.getDataFolder(), "sellLogs" + File.separator + "Old_sellLog.yml");
            }
            this.checkedOldFile = true;
        }
        try {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8"));
            }
            object2 = DateFormat.MiliToDate(System.currentTimeMillis(), "dd");
            object = this.plugin.getPlayerManager().convertLocToStringShort(new CMILocation(player.getLocation()));
            String string2 = String.valueOf(object2) + " " + player.getName() + " " + (String)object;
            if (hashMap.size() > 1) {
                this.writer.append(String.valueOf(string2) + System.lineSeparator());
                for (Map.Entry<WorthItem, Integer> entry : hashMap.entrySet()) {
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(entry.getKey().getItem());
                    this.writer.append(" sold " + cMIItemStack.getRealName() + " x " + entry.getValue() + " for " + entry.getKey().getSellPrice() * (double)entry.getValue().intValue() + System.lineSeparator());
                }
            } else {
                for (Map.Entry<WorthItem, Integer> entry : hashMap.entrySet()) {
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(entry.getKey().getItem());
                    this.writer.append(String.valueOf(string2) + " sold " + cMIItemStack.getRealName() + " x " + entry.getValue() + " for " + entry.getKey().getSellPrice() * (double)entry.getValue().intValue() + System.lineSeparator());
                }
            }
            this.writer.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updatePriceInFile() {
        this.updateWorthInFile(null, null);
    }

    public void updatePriceInFile(WorthItem worthItem) {
        this.updatePriceInFile(worthItem, null);
    }

    public void updatePriceInFile(WorthEnchantment worthEnchantment) {
        this.updatePriceInFile(null, worthEnchantment);
    }

    public void updatePriceInFile(WorthItem worthItem, WorthEnchantment worthEnchantment) {
        HashSet<WorthItem> hashSet = new HashSet<WorthItem>();
        if (worthItem != null) {
            hashSet.add(worthItem);
        }
        HashSet<WorthEnchantment> hashSet2 = new HashSet<WorthEnchantment>();
        if (worthEnchantment != null) {
            hashSet2.add(worthEnchantment);
        }
        this.updateWorthInFile(hashSet, hashSet2);
    }

    private void updateWorthInFile(Set<WorthItem> set, Set<WorthEnchantment> set2) {
        Object object;
        if (set != null) {
            for (WorthItem object2 : set) {
                object = CMIMaterial.get((ItemStack)object2.getItem());
                List<WorthItem> list2 = CMI.getInstance().getWorthManager().getMap().get(object);
                if (list2 == null) {
                    list2 = new ArrayList<WorthItem>();
                    CMI.getInstance().getWorthManager().getMap().put((CMIMaterial)object, list2);
                }
                if (list2.contains(object2)) continue;
                list2.add(object2);
            }
        }
        if (set2 != null) {
            for (WorthEnchantment worthEnchantment : set2) {
                object = this.enchantMap.get(worthEnchantment.getEnchant());
                if (object == null) {
                    object = new HashMap();
                    this.enchantMap.put(worthEnchantment.getEnchant(), (HashMap<Integer, WorthEnchantment>)object);
                }
                object.put(worthEnchantment.getLevel(), worthEnchantment);
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    ConfigReader configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + fileName);
                    configReader.addComment("worth", new String[]{"Use ingame editor /cmi setworth to change prices"});
                    TreeMap<String, List<WorthItem>> treeMap = new TreeMap<String, List<WorthItem>>();
                    for (Map.Entry<CMIMaterial, List<WorthItem>> entry : new HashMap<CMIMaterial, List<WorthItem>>(CMI.getInstance().getWorthManager().getMap()).entrySet()) {
                        treeMap.put(entry.getKey().toString(), entry.getValue());
                    }
                    for (Map.Entry entry : treeMap.entrySet()) {
                        for (WorthItem worthItem : (List)entry.getValue()) {
                            String string = worthItem.getSellPrice() + (worthItem.isBuyPriceSet() ? ";" + worthItem.getBuyPrice() : "");
                            Object object = new CMIItemStack(worthItem.getItem()).toOneLiner().replace(":", ">");
                            if (worthItem.getModelData() != null) {
                                object = String.valueOf(object) + ";cm{" + worthItem.getModelData() + "}";
                            }
                            configReader.set("worth." + (String)object, (Object)string);
                        }
                    }
                    configReader.addComment("enchantWorth", new String[]{"Use ingame editor /cmi setenchantworth to change prices"});
                    HashMap hashMap = new HashMap(WorthManager.this.enchantMap);
                    for (Map.Entry entry : hashMap.entrySet()) {
                        ArrayList arrayList = new ArrayList();
                        for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                            WorthEnchantment worthEnchantment = (WorthEnchantment)entry2.getValue();
                            String string = String.valueOf((double)((int)(worthEnchantment.getSellPrice() * 100.0)) / 100.0) + (worthEnchantment.isBuyPriceSet() ? ";" + worthEnchantment.getBuyPrice() : "");
                            arrayList.add(entry2.getKey() + "-" + string);
                        }
                        configReader.set("enchantWorth." + CMIEnchantment.getName((Enchantment)((Enchantment)entry.getKey())), (Object)arrayList);
                    }
                    configReader.save();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public WorthItem getWorth(ItemStack itemStack) {
        return this.getWorth(itemStack, false);
    }

    public boolean containsBlockedLore(CMIItemStack cMIItemStack) {
        for (String string : cMIItemStack.getLore()) {
            String string2 = CMIChatColor.stripColor((String)string).toLowerCase();
            for (String string3 : this.badLore) {
                if (!string2.contains(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRepairBeforeSell(ItemStack itemStack) {
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
        return this.requireFullDurability && cMIItemStack.getMaxDurability() > 2 && cMIItemStack.getDurability() > 0;
    }

    public double damagePercentage(ItemStack itemStack) {
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
        if (cMIItemStack.getMaxDurability() < 2) {
            return 0.0;
        }
        double d = 100.0 - (double)((cMIItemStack.getMaxDurability() - cMIItemStack.getDurability()) * 100) / (double)cMIItemStack.getMaxDurability();
        return (double)((int)(d * 100.0)) / 100.0;
    }

    public double getWorthByDurability(ItemStack itemStack, double d) {
        if (!this.devalueByDurability) {
            return d;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
        if (cMIItemStack.getMaxDurability() < 2) {
            return d;
        }
        double d2 = (double)(cMIItemStack.getMaxDurability() - cMIItemStack.getDurability()) / (double)cMIItemStack.getMaxDurability();
        return (double)((int)(d * d2 * 10000.0)) / 10000.0;
    }

    public WorthItem getWorth(ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return null;
        }
        CMIItemStack cMIItemStack = new CMIItemStack(itemStack);
        if (this.isRepairBeforeSell(itemStack)) {
            return null;
        }
        if (this.containsBlockedLore(cMIItemStack)) {
            return null;
        }
        if (this.customNameBlocking && itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() && !CMIMaterial.isPlayerHead((Material)itemStack.getType())) {
            return null;
        }
        if (this.loreBlock && itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore()) {
            return null;
        }
        List<WorthItem> list2 = this.map.get(cMIItemStack.getCMIType());
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        Integer n = cMINBT.getInt("CustomModelData");
        if (n != null) {
            for (WorthItem worthItem : list2) {
                if (worthItem == null || worthItem.getModelData() == null || !worthItem.getModelData().equals(n) || !cMIItemStack.isSimilar(worthItem.getItem())) continue;
                return worthItem;
            }
        }
        for (WorthItem worthItem : list2) {
            if (worthItem == null || !cMIItemStack.isSimilar(worthItem.getItem()) || worthItem.getSellPrice() == 0.0 && !bl) continue;
            return worthItem;
        }
        return null;
    }

    public List<ItemStack> getItems(Player player, worthType worthType2) {
        return this.getItems(player, worthType2, null);
    }

    public List<ItemStack> getItems(Player player, worthType worthType2, CMIMaterial cMIMaterial) {
        return this.getItems(player, worthType2, cMIMaterial, 0);
    }

    public List<ItemStack> getItems(Player player, worthType worthType2, CMIMaterial cMIMaterial, int n) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        block0 : switch (worthType2) {
            case all: {
                arrayList.addAll(cMIUser.getInventory().getItems(CMIPlayerInventory.CMIInventorySlot.MainInventory));
                break;
            }
            case blocks: {
                for (ItemStack itemStack : cMIUser.getInventory().getItems(CMIPlayerInventory.CMIInventorySlot.MainInventory)) {
                    if (itemStack == null || !itemStack.getType().isBlock()) continue;
                    arrayList.add(itemStack);
                }
                break;
            }
            case hand: {
                ItemStack itemStack = cMIUser.getItemInHand();
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                    return arrayList;
                }
                arrayList.add(itemStack);
                break;
            }
            case same: {
                ItemStack itemStack = cMIUser.getItemInHand();
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                    return arrayList;
                }
                ItemStack[] itemStackArray = player.getInventory().getContents();
                int n2 = itemStackArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    ItemStack itemStack2 = itemStackArray[n3];
                    if (itemStack2 != null && itemStack2.isSimilar(itemStack)) {
                        arrayList.add(itemStack2);
                    }
                    ++n3;
                }
                break;
            }
            case material: {
                int n4 = 0;
                for (ItemStack itemStack : cMIUser.getInventory().getItems(CMIPlayerInventory.CMIInventorySlot.MainInventory)) {
                    if (itemStack == null || !CMIMaterial.get((ItemStack)itemStack).equals((Object)cMIMaterial)) continue;
                    if (n > 0 && n4 > n) break block0;
                    arrayList.add(itemStack);
                    n4 += itemStack.getAmount();
                }
                break;
            }
        }
        return arrayList;
    }

    public boolean isShulkerWithItems(ItemStack itemStack) {
        if (!CMIMaterial.isShulkerBox((Material)itemStack.getType())) {
            return false;
        }
        List<ItemStack> list2 = this.plugin.getShulkerBoxManager().getShulkerBoxContents(itemStack);
        return !list2.isEmpty();
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Worth.BadLore", new String[]{"Defines lore that will prevent an item from being sold using /cmi sell.", "Color codes and capitalization are being ignored"});
        this.badLore = configReader.get("Worth.BadLore", Arrays.asList("Creative item by Gasha"));
        int n = 0;
        while (n < this.badLore.size()) {
            this.badLore.set(n, CMIChatColor.stripColor((String)this.badLore.get(n)).toLowerCase());
            ++n;
        }
        configReader.addComment("Worth.CustomNameBlocking", new String[]{"If enabled any item with custom name will not be allowed to be sold with /cmi sell command"});
        this.customNameBlocking = configReader.get("Worth.CustomNameBlocking", Boolean.valueOf(false));
        configReader.addComment("Worth.LoreBlocking", new String[]{"If enabled any item with custom lore will not be allowed to be sold with /cmi sell command"});
        this.loreBlock = configReader.get("Worth.LoreBlocking", Boolean.valueOf(false));
        configReader.addComment("Worth.RequireFullDurability", new String[]{"When enabled we will not allow to sell items which are not fully repaired"});
        this.requireFullDurability = configReader.get("Worth.RequireFullDurability", Boolean.valueOf(false));
        configReader.addComment("Worth.DevalueByDurability", new String[]{"When enabled items which doesnt have full durability will be worth less. 30% left durability will result in items worth going down by 70%", "This only works while RequireFullDurability is disabled"});
        this.devalueByDurability = configReader.get("Worth.DevalueByDurability", Boolean.valueOf(false));
        configReader.addComment("Worth.AutoGenerate.PriceIncrease", new String[]{"Value in percentages in how much more we should add to end product while auto calculating items price based on its ingredient worth", "For example one stick is worth 0.1 and diamond 44 then end result as diamond_hoe will be worth 88.2 and with extra 2% this will be changed to 89.96", "Value can be negative"});
        this.autoGeneratePriceIncrease = configReader.get("Worth.AutoGenerate.PriceIncrease", 0);
    }

    public HashMap<CMIMaterial, List<WorthItem>> getMap() {
        return this.map;
    }

    public WorthItem addWorth(WorthItem worthItem) {
        CMIMaterial cMIMaterial = CMIMaterial.get((ItemStack)worthItem.getItem());
        List<WorthItem> list2 = this.map.get(cMIMaterial);
        if (list2 == null) {
            list2 = new ArrayList<WorthItem>();
            this.map.put(cMIMaterial, list2);
        }
        list2.add(worthItem);
        this.map.put(cMIMaterial, list2);
        return worthItem;
    }

    @Deprecated
    public void openWorthListGui(Player player, int n) {
        this.openWorthListGui(player, n, false);
    }

    public void openWorthListGui(final Player player, int n, final boolean bl) {
        Object object3;
        CMIGui cMIGui = new CMIGui(player){

            public void pageChange(int n) {
                WorthManager.this.openWorthListGui(player, n, bl);
            }
        };
        cMIGui.setTitle(CMILC.getIM(worthlist.class, "title", new Object[0]));
        int n2 = 0;
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap();
        if (!bl) {
            linkedHashMap = new LinkedHashMap<CMIMaterial, List<WorthItem>>(this.plugin.getWorthManager().getMap());
            for (Map.Entry<Object, Object> object22 : linkedHashMap.entrySet()) {
                n2 += ((List)object22.getValue()).size();
            }
        } else {
            object3 = CMIMaterial.values();
            int n3 = ((CMIMaterial[])object3).length;
            int n4 = 0;
            while (n4 < n3) {
                Object object2;
                CMIMaterial cMIMaterial = object3[n4];
                if (!cMIMaterial.isLegacy() && cMIMaterial.isValidAsItemStack() && (object2 = this.getWorth(cMIMaterial.newItemStack())) == null) {
                    linkedHashMap.put(cMIMaterial, new ArrayList());
                    ++n2;
                }
                ++n4;
            }
        }
        PageInfo pageInfo = new PageInfo(45, n2, n);
        block2: for (final Map.Entry<Object, Object> entry : linkedHashMap.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                if (pageInfo.isContinue()) continue;
                if (pageInfo.isBreak()) break;
                object3 = new CMIGuiButton(((CMIMaterial)entry.getKey()).newItemStack()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        WorthManager.this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + setworth.class.getSimpleName() + " " + entry.getKey());
                    }
                };
                object3.setName(CMILC.getIM(worthlist.class, "type", "[type]", new CMIItemStack((CMIMaterial)entry.getKey()).getDisplayName()));
                cMIGui.addButton((CMIGuiButton)object3);
                continue;
            }
            for (Object object3 : (List)entry.getValue()) {
                if (pageInfo.isContinue()) continue;
                if (pageInfo.isBreak()) break block2;
                CMIGuiButton cMIGuiButton = new CMIGuiButton(((WorthItem)object3).getItem());
                cMIGuiButton.setName(CMILC.getIM(worthlist.class, "type", "[type]", new CMIItemStack(((WorthItem)object3).getItem()).getDisplayName()));
                cMIGuiButton.addLore(CMILC.getIM(worthlist.class, "worth", "[price]", this.plugin.getEconomyManager().format(((WorthItem)object3).getSellPrice())));
                cMIGui.addButton(cMIGuiButton);
            }
        }
        cMIGui.addPagination(pageInfo);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public int getAutoGeneratePriceIncrease() {
        return this.autoGeneratePriceIncrease;
    }

    public static enum worthType {
        all,
        hand,
        blocks,
        same,
        material,
        gui;


        public static worthType getByName(String string) {
            worthType[] worthTypeArray = worthType.values();
            int n = worthTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                worthType worthType2 = worthTypeArray[n2];
                if (worthType2.name().equalsIgnoreCase(string)) {
                    return worthType2;
                }
                ++n2;
            }
            return null;
        }
    }
}

