/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.NBT;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.NBT.NMS;
import com.Zrips.CMI.utils.Util;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.minecraft.server.v1_7_R4.AxisAlignedBB;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.ItemStack;
import net.minecraft.server.v1_7_R4.MinecraftServer;
import net.minecraft.server.v1_7_R4.NBTBase;
import net.minecraft.server.v1_7_R4.NBTCompressedStreamTools;
import net.minecraft.server.v1_7_R4.NBTTagCompound;
import net.minecraft.server.v1_7_R4.NBTTagDouble;
import net.minecraft.server.v1_7_R4.NBTTagFloat;
import net.minecraft.server.v1_7_R4.NBTTagList;
import net.minecraft.server.v1_7_R4.NBTTagString;
import net.minecraft.server.v1_7_R4.NetworkManager;
import net.minecraft.server.v1_7_R4.Packet;
import net.minecraft.server.v1_7_R4.PacketPlayOutMapChunk;
import net.minecraft.server.v1_7_R4.PacketPlayOutWorldParticles;
import net.minecraft.server.v1_7_R4.PlayerAbilities;
import net.minecraft.server.v1_7_R4.PlayerConnection;
import net.minecraft.server.v1_7_R4.PlayerInteractManager;
import net.minecraft.server.v1_7_R4.World;
import net.minecraft.server.v1_7_R4.WorldServer;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_7_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class v1_7_R4
implements NMS {
    @Override
    public synchronized Player getPlayer(CMIUser cMIUser) {
        try {
            GameProfile gameProfile = new GameProfile(cMIUser.getUniqueId(), cMIUser.getName());
            MinecraftServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            EntityPlayer entityPlayer = new EntityPlayer(minecraftServer, minecraftServer.getWorldServer(0), gameProfile, new PlayerInteractManager((World)minecraftServer.getWorldServer(0)));
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            if (craftPlayer != null) {
                craftPlayer.loadData();
                return craftPlayer;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized Player createFakeOperator() {
        try {
            GameProfile gameProfile = new GameProfile(CMI.getInstance().getPlayerManager().getFakeUserUUID(), CMI.getInstance().getPlayerManager().getFakeUserName());
            MinecraftServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            EntityPlayer entityPlayer = new EntityPlayer(minecraftServer, minecraftServer.getWorldServer(0), gameProfile, new PlayerInteractManager((World)minecraftServer.getWorldServer(0)));
            entityPlayer.playerConnection = new PlayerConnection(minecraftServer, new NetworkManager(false), entityPlayer);
            entityPlayer.playerConnection.networkManager.n = new InetSocketAddress("127.0.0.1", 25566);
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            craftPlayer.setOp(true);
            return craftPlayer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void unloadData(Player player) {
    }

    public NBTTagCompound getNBTTagC(File file) {
        NBTTagCompound nBTTagCompound;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return nBTTagCompound;
    }

    public NBTTagCompound getNBTTagC(Player player) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(player);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public String getWorldName(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return null;
        }
        UUID uUID = new UUID(v1_7_R4.getUUIDWorldMost(nBTTagCompound), v1_7_R4.getUUIDWorldLeast(nBTTagCompound));
        return CMI.getInstance().getUtilManager().getWorldName(uUID);
    }

    public Location getMiscLocation(NBTTagCompound nBTTagCompound) {
        org.bukkit.World world2 = v1_7_R4.getLocationWorld(nBTTagCompound);
        double[] dArray = this.getLocationPosition(nBTTagCompound);
        Float[] floatArray = this.getLocationView(nBTTagCompound);
        Location location = new Location(world2, dArray[0], dArray[1], dArray[2]);
        location.setPitch(floatArray[0].floatValue());
        location.setYaw(floatArray[1].floatValue());
        return location;
    }

    public double[] getLocationPosition(NBTTagCompound nBTTagCompound) {
        double[] dArray = new double[3];
        NBTTagList nBTTagList = nBTTagCompound.getList("Pos", 6);
        dArray[0] = nBTTagList.d(0);
        dArray[1] = nBTTagList.d(1);
        dArray[2] = nBTTagList.d(2);
        return dArray;
    }

    public Float[] getLocationView(NBTTagCompound nBTTagCompound) {
        Float[] floatArray = new Float[2];
        NBTTagList nBTTagList = nBTTagCompound.getList("Rotation", 5);
        floatArray[0] = Float.valueOf(nBTTagList.e(0));
        floatArray[1] = Float.valueOf(nBTTagList.e(1));
        return floatArray;
    }

    @Override
    public void setMiscLocation(File file, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        v1_7_R4.saveData(nBTTagCompound, file);
    }

    @Override
    public void setMiscLocation(Player player, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(player);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        this.saveData(nBTTagCompound, player);
    }

    private static NBTTagCompound setDimension(NBTTagCompound nBTTagCompound, int n) {
        nBTTagCompound.setInt("Dimension", n);
        return nBTTagCompound;
    }

    private static NBTTagCompound setLocationWorld(NBTTagCompound nBTTagCompound, long l, long l2) {
        nBTTagCompound = v1_7_R4.setUUIDWorldLeast(nBTTagCompound, l);
        nBTTagCompound = v1_7_R4.setUUIDWorldMost(nBTTagCompound, l2);
        return nBTTagCompound;
    }

    private static NBTTagCompound setUUIDWorldLeast(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDLeast", l);
        return nBTTagCompound;
    }

    public static String getName(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("bukkit");
        String string = nBTTagCompound2.getString("lastKnownName");
        return string;
    }

    private static NBTTagCompound setUUIDWorldMost(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDMost", l);
        return nBTTagCompound;
    }

    public static org.bukkit.World getLocationWorld(NBTTagCompound nBTTagCompound) {
        return Bukkit.getWorld((UUID)new UUID(v1_7_R4.getUUIDWorldMost(nBTTagCompound), v1_7_R4.getUUIDWorldLeast(nBTTagCompound)));
    }

    private static long getUUIDWorldMost(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDMost");
    }

    private static long getUUIDWorldLeast(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDLeast");
    }

    public NBTTagCompound setMiscLocation(Location location, NBTTagCompound nBTTagCompound) {
        nBTTagCompound = v1_7_R4.setLocationWorld(nBTTagCompound, location.getWorld().getUID().getLeastSignificantBits(), location.getWorld().getUID().getMostSignificantBits());
        nBTTagCompound = v1_7_R4.setDimension(nBTTagCompound, location.getWorld().getEnvironment().getId());
        nBTTagCompound = v1_7_R4.setLocationPosition(nBTTagCompound, location.getX(), location.getY(), location.getZ());
        nBTTagCompound = v1_7_R4.setLocationView(nBTTagCompound, location.getYaw(), location.getPitch());
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationPosition(NBTTagCompound nBTTagCompound, double d, double d2, double d3) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((NBTBase)new NBTTagDouble(d));
        nBTTagList.add((NBTBase)new NBTTagDouble(d2));
        nBTTagList.add((NBTBase)new NBTTagDouble(d3));
        nBTTagCompound.set("Pos", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationView(NBTTagCompound nBTTagCompound, float f, float f2) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((NBTBase)new NBTTagFloat(f));
        nBTTagList.add((NBTBase)new NBTTagFloat(f2));
        nBTTagCompound.set("Rotation", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static void saveData(NBTTagCompound nBTTagCompound, File file) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveData(NBTTagCompound nBTTagCompound, Player player) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(Util.getFile(player));
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NBTTagCompound resetMaxHp(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound == null) {
            return null;
        }
        NBTTagList nBTTagList = nBTTagCompound.getList("Attributes", 10);
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.get(n);
            if (nBTTagCompound2.hasKey("Modifiers") && nBTTagCompound2.getString("Name").equalsIgnoreCase("generic.maxHealth")) {
                nBTTagCompound2.remove("Modifiers");
            }
            ++n;
        }
        return nBTTagCompound;
    }

    @Override
    public void clearPotionEffects(Player player) {
        File file = Util.getFile(player);
        this.clearPotionEffects(file);
    }

    public void clearPotionEffects(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound.remove("ActiveEffects");
        v1_7_R4.saveData(nBTTagCompound, file);
    }

    @Override
    public void setPotionEffects(Player player, PotionEffect potionEffect) {
        File file = Util.getFile(player);
        this.setPotionEffects(potionEffect, file);
    }

    public void setPotionEffects(PotionEffect potionEffect, File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagList nBTTagList = nBTTagCompound.getList("ActiveEffects", 10);
        boolean bl = false;
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.get(n);
            if (nBTTagCompound2.getByte("Id") == potionEffect.getType().getId()) {
                bl = true;
                nBTTagCompound2.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
                nBTTagCompound2.setByte("Amplifier", (byte)potionEffect.getAmplifier());
                nBTTagCompound2.setInt("Duration", potionEffect.getDuration());
                nBTTagCompound2.setByte("ShowParticles", (byte)1);
                break;
            }
            ++n;
        }
        if (!bl) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
            nBTTagCompound3.setByte("Amplifier", (byte)potionEffect.getAmplifier());
            nBTTagCompound3.setInt("Duration", potionEffect.getDuration());
            nBTTagCompound3.setByte("Id", (byte)potionEffect.getType().getId());
            nBTTagCompound3.setByte("ShowParticles", (byte)1);
            nBTTagList.add((NBTBase)nBTTagCompound3);
        }
        v1_7_R4.saveData(nBTTagCompound, file);
    }

    @Override
    public boolean changeGodMode(Player player, boolean bl) {
        if (player == null) {
            return false;
        }
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        try {
            PlayerAbilities playerAbilities = entityPlayer.abilities;
            Field field = playerAbilities.getClass().getDeclaredField("isInvulnerable");
            field.setAccessible(true);
            field.setBoolean(playerAbilities, bl);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    @Override
    public boolean getGodMode(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        return entityPlayer.abilities.isInvulnerable;
    }

    @Override
    public void relightChunk(Chunk chunk) {
        ((CraftChunk)chunk).getHandle().initLighting();
        ((CraftChunk)chunk).getHandle().n();
    }

    @Override
    public void resendChunk(Chunk chunk, Player player) {
        try {
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), true, 65535, 0));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void unloadChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), true, 0, 0));
    }

    @Override
    public void updateCollisions(Player player, boolean bl, boolean bl2) {
    }

    @Override
    public Inventory getShulkerInv(org.bukkit.inventory.ItemStack itemStack) {
        return null;
    }

    @Override
    public Inventory getShulkerInv(Block block) {
        return null;
    }

    @Override
    public int getTickLived(UUID uUID) {
        if (uUID == null) {
            return 0;
        }
        NBTTagCompound nBTTagCompound = this.getNBTTagC(uUID);
        if (nBTTagCompound == null) {
            return 0;
        }
        if (!nBTTagCompound.hasKey("Spigot.ticksLived")) {
            return 0;
        }
        return nBTTagCompound.getInt("Spigot.ticksLived");
    }

    public NBTTagCompound getNBTTagC(UUID uUID) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(uUID);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public void showResurection(Player player) {
    }

    @Override
    public void setEntityTag(Entity entity, String string, Object object) {
    }

    @Override
    public org.bukkit.inventory.ItemStack removeEnchantNbt(org.bukkit.inventory.ItemStack itemStack, Enchantment enchantment) {
        return itemStack;
    }

    @Override
    public org.bukkit.inventory.ItemStack setNBTList(org.bukkit.inventory.ItemStack itemStack, String string, List<String> list2) {
        ItemStack itemStack2 = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (itemStack2 == null) {
            return itemStack;
        }
        try {
            NBTTagCompound nBTTagCompound = itemStack2.getTag();
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            NBTTagList nBTTagList = new NBTTagList();
            if (list2 != null) {
                for (String string2 : list2) {
                    nBTTagList.add((NBTBase)new NBTTagString(string2));
                }
            }
            if (list2 == null) {
                nBTTagCompound.remove(string);
            } else {
                nBTTagCompound.set(string, (NBTBase)nBTTagList);
            }
            itemStack2.setTag(nBTTagCompound);
            return CraftItemStack.asBukkitCopy((ItemStack)itemStack2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return itemStack;
        }
    }

    @Override
    public void updateExpBar(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.getHandle().lastSentExp = -1;
    }

    @Override
    public Command getCommand(String string) {
        return ((CraftServer)Bukkit.getServer()).getCommandMap().getCommand(string);
    }

    @Override
    public CMIDataWatcher spawnHologram(Player player, Location location, String string, org.bukkit.inventory.ItemStack itemStack) {
        return null;
    }

    @Override
    public void removeHologram(Player player, Integer n) {
    }

    @Override
    public void updateHologram(Player player, CMIDataWatcher cMIDataWatcher, String string, org.bukkit.inventory.ItemStack itemStack) {
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, org.bukkit.inventory.ItemStack itemStack) {
        return this.makeFloatingIcon(player, location, itemStack, false);
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, org.bukkit.inventory.ItemStack itemStack, boolean bl) {
        return null;
    }

    @Override
    public FakeInfo spawnClickable(Player player, Location location, Object object, boolean bl) {
        return null;
    }

    @Override
    public boolean clearSkin(Player player) {
        return false;
    }

    @Override
    public void updatePlayerViaPackets(Player player) {
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, Color color) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(0);
        cMIEffect.setSpeed(1.0f);
        cMIEffect.setColor(org.bukkit.Color.fromBGR((int)color.getBlue(), (int)color.getGreen(), (int)color.getRed()));
        this.playEffect(player, location, cMIEffect);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, float f, float f2, float f3, float f4, int n) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffectManager.CMIParticle cMIParticle, float f, float f2, float f3, float f4, int n) {
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffect cMIEffect) {
        if (location == null || cMIEffect == null || location.getWorld() == null) {
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        if (craftPlayer.getHandle().playerConnection == null) {
            return;
        }
        Effect effect2 = cMIEffect.getParticle().getEffect();
        if (effect2 == null) {
            return;
        }
        PacketPlayOutWorldParticles packetPlayOutWorldParticles = new PacketPlayOutWorldParticles(effect2.name(), (float)location.getX(), (float)location.getY(), (float)location.getZ(), (float)cMIEffect.getOffset().getX(), (float)cMIEffect.getOffset().getY(), (float)cMIEffect.getOffset().getZ(), cMIEffect.getSpeed(), cMIEffect.getAmount());
        craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutWorldParticles);
    }

    @Override
    public boolean forceTeleport(Player player, Location location) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.getHealth() == 0.0f || entityPlayer.dead) {
            return false;
        }
        if (entityPlayer.playerConnection == null) {
            return false;
        }
        if (entityPlayer.vehicle != null) {
            return false;
        }
        Location location2 = player.getLocation();
        Location location3 = location;
        WorldServer worldServer = ((CraftWorld)location2.getWorld()).getHandle();
        WorldServer worldServer2 = ((CraftWorld)location3.getWorld()).getHandle();
        if (((CraftPlayer)player).getHandle().activeContainer != ((CraftPlayer)player).getHandle().defaultContainer) {
            ((CraftPlayer)player).getHandle().closeInventory();
        }
        if (worldServer == worldServer2) {
            entityPlayer.playerConnection.teleport(location3);
        } else {
            ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(entityPlayer, worldServer2.dimension, true, location3, true);
        }
        return true;
    }

    @Override
    public CMIHitBox getBlockHitBox(CMIHitBox cMIHitBox) {
        cMIHitBox.setMin(new Vector(1, 1, 1));
        cMIHitBox.setMax(new Vector(0, 0, 0));
        return cMIHitBox;
    }

    @Override
    public CMIHitBox getEntityHitBox(CMIHitBox cMIHitBox) {
        try {
            Entity entity = cMIHitBox.getEntity();
            if (entity == null) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
                return cMIHitBox;
            }
            AxisAlignedBB axisAlignedBB = ((CraftEntity)entity).getHandle().boundingBox;
            cMIHitBox.setMin(new Vector(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c));
            cMIHitBox.setMax(new Vector(axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public Block getBlockLookingAt(Player player, int n, boolean bl) {
        if (n > 240) {
            n = 240;
        }
        if (n < 1) {
            n = 1;
        }
        ArrayList<Block> arrayList = new ArrayList<Block>();
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, n);
        ArrayList<Block> arrayList2 = new ArrayList<Block>();
        while (blockIterator.hasNext()) {
            Block block = (Block)blockIterator.next();
            arrayList.add(block);
            if (n != 0 && arrayList.size() > n) {
                arrayList.remove(0);
            }
            Material material = block.getType();
            if ((!bl || block.getType().isSolid()) && !CMIMaterial.AIR.equals(material) && !CMIMaterial.CAVE_AIR.equals(material) && !CMIMaterial.VOID_AIR.equals(material)) break;
        }
        if (arrayList.size() > 1) {
            arrayList2.add((Block)arrayList.get(arrayList.size() - 2));
        }
        if (!arrayList.isEmpty()) {
            arrayList2.add((Block)arrayList.get(arrayList.size() - 1));
        }
        return arrayList2.isEmpty() ? null : (Block)arrayList2.get(arrayList2.size() - 1);
    }

    @Override
    public Block getBlockLookingAt(org.bukkit.World world2, Vector vector, Vector vector2, boolean bl) {
        int n = (int)vector.distance(vector2) + 1;
        BlockIterator blockIterator = new BlockIterator(world2, vector, vector2, 0.05, n);
        ArrayList<Block> arrayList = new ArrayList<Block>();
        while (blockIterator.hasNext()) {
            Block block = (Block)blockIterator.next();
            arrayList.add(block);
            Material material = block.getType();
            if (!CMIMaterial.AIR.equals(material) && !CMIMaterial.CAVE_AIR.equals(material) && !CMIMaterial.VOID_AIR.equals(material)) break;
        }
        return arrayList.isEmpty() ? null : (Block)arrayList.get(arrayList.size() - 1);
    }
}

