/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.AStand;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIEvent;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.AStand.ArmorStandCopy;
import com.Zrips.CMI.Modules.AStand.ArmorStandListener;
import com.Zrips.CMI.Modules.AStand.ArmorStandListener1_8;
import com.Zrips.CMI.Modules.AStand.ArmorStandSave;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.armorstand;
import com.Zrips.CMI.events.CMIPlayerOpenArmorStandEditorEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Chat.ChatMessageEdit;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandManager {
    private CMI plugin;
    private static HashMap<UUID, Entity> last = new HashMap();
    private static HashMap<UUID, Entity> editing = new HashMap();
    private LinkedHashMap<String, ArmorStandSave> savedArmorStands = new LinkedHashMap();
    public static final String savedArmorStandLabel = "CMISavedArmorStand";
    public static boolean ArmorStandsCheckBlockPlace = true;
    public static boolean TemplatesSpecificPermission = true;

    public ArmorStandManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig(ConfigReader configReader) {
        configReader.addComment("Optimizations.ArmorStands.CheckBlockPlace", new String[]{"When set to true, plugin will check if player can manipulate armor stand by sending fake block place event and checking if any plugin would want to prevent this action", "This can help out to minimize posibility for players to manipulate armor stands when they dont have build permission in area where armorstand is standing"});
        ArmorStandsCheckBlockPlace = configReader.get("Optimizations.ArmorStands.CheckBlockPlace", Boolean.valueOf(false));
        configReader.addComment("Optimizations.ArmorStands.Templates.SpecificPermission", new String[]{"When set to true player will be required to have " + PermissionsManager.CMIPerm.command_armorstand_template_$1.getPermission("[templateName]") + " permission node to deploy saved template"});
        TemplatesSpecificPermission = configReader.get("Optimizations.ArmorStands.Templates.SpecificPermission", Boolean.valueOf(false));
    }

    public Entity getLast(Player player) {
        Entity entity = last.get(player.getUniqueId());
        if (entity == null) {
            return null;
        }
        Entity entity2 = this.plugin.getUtilManager().getClosestEntity(entity.getLocation(), 10, EntityType.ARMOR_STAND);
        if (entity2 != null && entity2.getUniqueId().toString().equals(entity.getUniqueId().toString())) {
            return entity2;
        }
        return null;
    }

    public boolean isBeingEdited(UUID uUID) {
        for (Map.Entry<UUID, Entity> entry : editing.entrySet()) {
            if (!entry.getValue().getUniqueId().equals(uUID)) continue;
            Player player = CMIUser.getOnlinePlayer(entry.getKey());
            if (player == null) {
                editing.remove(entry.getKey());
                return false;
            }
            CMIGui cMIGui = CMILib.getInstance().getGUIManager().getGui(player);
            if (cMIGui == null) {
                editing.remove(entry.getKey());
                return false;
            }
            if (!(cMIGui.getWhatShows() instanceof Entity)) {
                editing.remove(entry.getKey());
                return false;
            }
            Entity entity = (Entity)cMIGui.getWhatShows();
            if (!entity.getUniqueId().equals(uUID)) {
                editing.remove(entry.getKey());
                return false;
            }
            return true;
        }
        return false;
    }

    public UUID getEditorOf(UUID uUID) {
        for (Map.Entry<UUID, Entity> entry : editing.entrySet()) {
            if (!entry.getValue().getUniqueId().equals(uUID)) continue;
            Player player = CMIUser.getOnlinePlayer(entry.getKey());
            if (player == null) {
                editing.remove(entry.getKey());
                return null;
            }
            CMIGui cMIGui = CMILib.getInstance().getGUIManager().getGui(player);
            if (cMIGui == null) {
                editing.remove(entry.getKey());
                return null;
            }
            if (!(cMIGui.getWhatShows() instanceof Entity)) {
                editing.remove(entry.getKey());
                return null;
            }
            Entity entity = (Entity)cMIGui.getWhatShows();
            if (!entity.getUniqueId().equals(uUID)) {
                editing.remove(entry.getKey());
                return null;
            }
            return entry.getKey();
        }
        return null;
    }

    public boolean isTooFar(Player player, Entity entity) {
        Location location = player.getLocation();
        Location location2 = entity.getLocation();
        if (!location.getWorld().equals(location2.getWorld())) {
            return true;
        }
        return location.distance(location2) > 20.0;
    }

    private static void addSaveButton(CMIGui cMIGui, int n, final armorStandSaveOptions armorStandSaveOptions2) {
        final ArmorStandSave armorStandSave = (ArmorStandSave)cMIGui.getWhatShows();
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (armorStandSave.getSaveOptions().contains((Object)armorStandSaveOptions2)) {
                    armorStandSave.getSaveOptions().remove((Object)armorStandSaveOptions2);
                } else {
                    armorStandSave.getSaveOptions().add(armorStandSaveOptions2);
                }
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setItem(armorStandSave.getSaveOptions().contains((Object)armorStandSaveOptions2) ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.YELLOW_WOOL.newItemStack());
                this.setName(CMILC.getIM("armorstand", "action." + armorStandSaveOptions2.toString(), new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
    }

    private void addCopyButton(CMIGui cMIGui, int n, final armorStandActions armorStandActions2) {
        final ArmorStandCopy armorStandCopy = (ArmorStandCopy)cMIGui.getWhatShows();
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (armorStandCopy.getCopy().contains((Object)armorStandActions2)) {
                    armorStandCopy.getCopy().remove((Object)armorStandActions2);
                } else {
                    armorStandCopy.getCopy().add(armorStandActions2);
                }
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setItem(armorStandCopy.getCopy().contains((Object)armorStandActions2) ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                this.setName(CMILC.getIM("armorstand", "action." + armorStandActions2.toString(), new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
    }

    private void addCopyButton(CMIGui cMIGui, int n, final armorStandExtraActions armorStandExtraActions2) {
        final ArmorStandCopy armorStandCopy = (ArmorStandCopy)cMIGui.getWhatShows();
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (armorStandCopy.getExtraCopy().contains((Object)armorStandExtraActions2)) {
                    armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions2);
                } else {
                    armorStandCopy.getExtraCopy().add(armorStandExtraActions2);
                }
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setItem(armorStandCopy.getExtraCopy().contains((Object)armorStandExtraActions2) ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                this.setName(CMILC.getIM("armorstand", "action." + armorStandExtraActions2.toString(), new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
    }

    public boolean openCopyWindow(final Player player, final ArmorStand armorStand) {
        if (!Version.isCurrentHigher((Version)Version.v1_7_R4)) {
            return false;
        }
        if (armorStand.isDead()) {
            player.closeInventory();
            return false;
        }
        final ArmorStandCopy armorStandCopy = new ArmorStandCopy(player, armorStand, new HashSet<armorStandActions>(Arrays.asList(armorStandActions.head, armorStandActions.torso, armorStandActions.leftArm, armorStandActions.rightArm, armorStandActions.leftLeg, armorStandActions.rightLeg)), new HashSet<armorStandExtraActions>(Arrays.asList(armorStandExtraActions.size, armorStandExtraActions.glow, armorStandExtraActions.arms, armorStandExtraActions.plate, armorStandExtraActions.name)));
        CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                ArmorStandListener.acMap.put(player.getUniqueId(), armorStandCopy);
                CMILC.info(armorstand.class, (CommandSender)player, "click", new Object[0]);
            }
        };
        cMIGui.setTitle(CMILC.getIM(armorstand.class, "copyTitle", new Object[0]));
        cMIGui.setWhatShows((Object)armorStandCopy);
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.body.name())) {
            this.addCopyButton(cMIGui, 19, armorStandActions.body);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.head.name())) {
            this.addCopyButton(cMIGui, 20, armorStandActions.head);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.head);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.torso.name())) {
            this.addCopyButton(cMIGui, 21, armorStandActions.torso);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.torso);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.leftArm.name())) {
            this.addCopyButton(cMIGui, 22, armorStandActions.leftArm);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.leftArm);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.rightArm.name())) {
            this.addCopyButton(cMIGui, 23, armorStandActions.rightArm);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.rightArm);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.leftLeg.name())) {
            this.addCopyButton(cMIGui, 24, armorStandActions.leftLeg);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.leftLeg);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.rightLeg.name())) {
            this.addCopyButton(cMIGui, 25, armorStandActions.rightLeg);
        } else {
            armorStandCopy.getCopy().remove((Object)armorStandActions.rightLeg);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.arms.name())) {
            this.addCopyButton(cMIGui, 28, armorStandExtraActions.arms);
        } else {
            armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions.arms);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.glow.name())) {
            this.addCopyButton(cMIGui, 29, armorStandExtraActions.glow);
        } else {
            armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions.glow);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.plate.name())) {
            this.addCopyButton(cMIGui, 30, armorStandExtraActions.plate);
        } else {
            armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions.plate);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.size.name())) {
            this.addCopyButton(cMIGui, 31, armorStandExtraActions.size);
        } else {
            armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions.size);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.name.name())) {
            this.addCopyButton(cMIGui, 32, armorStandExtraActions.name);
        } else {
            armorStandCopy.getExtraCopy().remove((Object)armorStandExtraActions.name);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.interactable.name())) {
            this.addCopyButton(cMIGui, 33, armorStandExtraActions.interactable);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.invulnerable.name())) {
            this.addCopyButton(cMIGui, 34, armorStandExtraActions.invulnerable);
        }
        CMIGuiButton cMIGuiButton = new CMIGuiButton(53, CMILib.getInstance().getItemManager().getItem("head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNjYmY5ODgzZGQzNTlmZGYyMzg1YzkwYTQ1OWQ3Mzc3NjUzODJlYzQxMTdiMDQ4OTVhYzRkYzRiNjBmYyJ9fX0=")){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.openEditor(player, (Entity)armorStand, false);
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.ArmorStandCopy);
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    public boolean openSaveWindow(final Player player, final Entity entity) {
        if (!Version.isCurrentHigher((Version)Version.v1_7_R4)) {
            return false;
        }
        if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        if (entity.getCustomName() != null && entity.getCustomName().equals("CMIArmorStandForSit")) {
            return false;
        }
        Integer n = new CMINBT(entity).getInt("DisabledSlots");
        if (n != null && n == 0x1FFF00) {
            return false;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        ArmorStandSave armorStandSave = new ArmorStandSave(player, armorStand, new HashSet<armorStandSaveOptions>(Arrays.asList(armorStandSaveOptions.values())));
        armorStandSave.getSaveOptions().remove((Object)armorStandSaveOptions.body);
        final CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
            }
        };
        cMIGui.setTitle(CMILC.getIM(armorstand.class, "saveTitle", new Object[0]));
        cMIGui.setWhatShows((Object)armorStandSave);
        ArmorStandManager.addSaveButton(cMIGui, 10, armorStandSaveOptions.helmet);
        ArmorStandManager.addSaveButton(cMIGui, 11, armorStandSaveOptions.chest);
        ArmorStandManager.addSaveButton(cMIGui, 12, armorStandSaveOptions.offhand);
        ArmorStandManager.addSaveButton(cMIGui, 13, armorStandSaveOptions.mainhand);
        ArmorStandManager.addSaveButton(cMIGui, 14, armorStandSaveOptions.leggings);
        ArmorStandManager.addSaveButton(cMIGui, 15, armorStandSaveOptions.boots);
        ArmorStandManager.addSaveButton(cMIGui, 16, armorStandSaveOptions.name);
        ArmorStandManager.addSaveButton(cMIGui, 22, armorStandSaveOptions.visible);
        ArmorStandManager.addSaveButton(cMIGui, 28, armorStandSaveOptions.body);
        ArmorStandManager.addSaveButton(cMIGui, 29, armorStandSaveOptions.head);
        ArmorStandManager.addSaveButton(cMIGui, 30, armorStandSaveOptions.torso);
        ArmorStandManager.addSaveButton(cMIGui, 31, armorStandSaveOptions.leftArm);
        ArmorStandManager.addSaveButton(cMIGui, 32, armorStandSaveOptions.rightArm);
        ArmorStandManager.addSaveButton(cMIGui, 33, armorStandSaveOptions.leftLeg);
        ArmorStandManager.addSaveButton(cMIGui, 34, armorStandSaveOptions.rightLeg);
        ArmorStandManager.addSaveButton(cMIGui, 37, armorStandSaveOptions.arms);
        ArmorStandManager.addSaveButton(cMIGui, 38, armorStandSaveOptions.glow);
        ArmorStandManager.addSaveButton(cMIGui, 39, armorStandSaveOptions.plate);
        ArmorStandManager.addSaveButton(cMIGui, 40, armorStandSaveOptions.size);
        ArmorStandManager.addSaveButton(cMIGui, 41, armorStandSaveOptions.name);
        ArmorStandManager.addSaveButton(cMIGui, 42, armorStandSaveOptions.interactable);
        ArmorStandManager.addSaveButton(cMIGui, 43, armorStandSaveOptions.invulnerable);
        this.addFinalSaveButton(cMIGui, 48);
        this.addFinalSaveButton(cMIGui, 49);
        this.addFinalSaveButton(cMIGui, 50);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(53, CMILib.getInstance().getItemManager().getItem("head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNjYmY5ODgzZGQzNTlmZGYyMzg1YzkwYTQ1OWQ3Mzc3NjUzODJlYzQxMTdiMDQ4OTVhYzRkYzRiNjBmYyJ9fX0=")){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.openEditor(player, entity, false);
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(45, CMILib.getInstance().getItemManager().getItem("head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZiYTYzMzQ0ZjQ5ZGQxYzRmNTQ4OGU5MjZiZjNkOWUyYjI5OTE2YTZjNTBkNjEwYmI0MGE1MjczZGM4YzgyIn19fQ==")){

            public void click(GUIManager.GUIClickType gUIClickType) {
                cMIGui.getPlayer().closeInventory();
                Bukkit.dispatchCommand((CommandSender)cMIGui.getPlayer(), (String)(String.valueOf(CommandsHandler.getLabel()) + " " + armorstand.class.getSimpleName() + " list"));
            }
        };
        cMIGuiButton.setName("...");
        cMIGui.addButton(cMIGuiButton);
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    private void addFinalSaveButton(final CMIGui cMIGui, int n) {
        final ArmorStandSave armorStandSave = (ArmorStandSave)cMIGui.getWhatShows();
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ChatMessageEdit chatMessageEdit = new ChatMessageEdit((CommandSender)cMIGui.getPlayer()){

                    public void run(String string) {
                        if (!CMIText.isValidString((String)(string = CMIChatColor.stripColor((String)CMIText.getFirstVariable((String)string))))) {
                            return;
                        }
                        if (ArmorStandManager.this.savedArmorStands.containsKey(string.toLowerCase())) {
                            LC.info_alreadyexist.sendMessage((Object)cMIGui.getPlayer(), new Object[0]);
                            return;
                        }
                        String string2 = armorStandSave.serialize();
                        armorStandSave.setSerialized(string2);
                        armorStandSave.setName(string);
                        ArmorStandManager.this.savedArmorStands.put(string.toLowerCase(), armorStandSave);
                        ItemStack itemStack = armorStandSave.createItem();
                        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(cMIGui.getPlayer());
                        HashMap<Integer, ItemStack> hashMap = cMIUser.getInventory().addItem(itemStack, CMIPlayerInventory.CMIFullInventoryAction.Abort);
                        if (hashMap.isEmpty()) {
                            CMILC.info(armorstand.class, (CommandSender)cMIGui.getPlayer(), "receivedItem", new Object[0]);
                        } else {
                            LC.info_Inventory_Full.sendMessage((Object)cMIGui.getPlayer(), new Object[0]);
                        }
                        Bukkit.dispatchCommand((CommandSender)cMIGui.getPlayer(), (String)(String.valueOf(CommandsHandler.getLabel()) + " " + armorstand.class.getSimpleName() + " list"));
                        ArmorStandManager.this.save();
                    }

                    public void onDisable() {
                    }
                };
                chatMessageEdit.setCheckForCancel(true);
                CMIMessages.sendMessage((CommandSender)cMIGui.getPlayer(), (String)LC.modify_nameAddInfo.getLocale(new Object[0]));
                cMIGui.getPlayer().closeInventory();
            }

            public void updateLooks() {
                this.setItem(CMIMaterial.ORANGE_WOOL.newItemStack());
                this.setName(CMILC.getIM(armorstand.class, "saveButton", new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
    }

    public boolean openEditor(final Player player, final Entity entity, boolean bl) {
        if (!Version.isCurrentHigher((Version)Version.v1_7_R4)) {
            return false;
        }
        if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        if (entity.getCustomName() != null && entity.getCustomName().equals("CMIArmorStandForSit")) {
            return false;
        }
        Integer n = new CMINBT(entity).getInt("DisabledSlots");
        if (n != null && n == 0x1FFF00) {
            return false;
        }
        ArmorStandListener.acMap.remove(player.getUniqueId());
        if (this.plugin.getInteractiveCommandManager().getByUUID(entity.getUniqueId()) == null && !this.canInteract(player, entity, bl)) {
            return false;
        }
        if (entity.isDead()) {
            player.closeInventory();
            return false;
        }
        final ArmorStand armorStand = (ArmorStand)entity;
        CMIPlayerOpenArmorStandEditorEvent cMIPlayerOpenArmorStandEditorEvent = new CMIPlayerOpenArmorStandEditorEvent(player, armorStand);
        Bukkit.getPluginManager().callEvent((Event)cMIPlayerOpenArmorStandEditorEvent);
        if (cMIPlayerOpenArmorStandEditorEvent.isCancelled()) {
            return false;
        }
        last.put(player.getUniqueId(), entity);
        editing.put(player.getUniqueId(), entity);
        final CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                editing.remove(player.getUniqueId());
            }
        };
        cMIGui.setWhatShows((Object)entity);
        cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.ArmorStandEditor);
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        cMIGui.setTitle(CMILC.getIM(armorstand.class, "title", new Object[0]));
        CMIGuiButton cMIGuiButton = null;
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.updateitems.name())) {
            cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.helmet.getSlot()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                }
            };
            cMIGuiButton.unlockField();
            cMIGuiButton.setItem(armorStand.getHelmet());
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.chest.getSlot()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                }
            };
            cMIGuiButton.unlockField();
            cMIGuiButton.setItem(armorStand.getChestplate());
            cMIGui.addButton(cMIGuiButton);
            if (Version.isCurrentHigher((Version)Version.v1_8_R3)) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (armorStand.hasArms() || livingEntity.getEquipment().getItemInOffHand() != null) {
                    cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.offhand.getSlot()){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            if (!ArmorStandManager.this.isOk(cMIGui)) {
                                return;
                            }
                            CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                        }
                    };
                    cMIGuiButton.unlockField();
                    cMIGuiButton.setItem(livingEntity.getEquipment().getItemInOffHand().clone());
                    cMIGui.addButton(cMIGuiButton);
                }
            }
            if (armorStand.hasArms() || armorStand.getItemInHand() != null) {
                cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.mainhand.getSlot()){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        if (!ArmorStandManager.this.isOk(cMIGui)) {
                            return;
                        }
                        CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                    }
                };
                cMIGuiButton.unlockField();
                cMIGuiButton.setItem(armorStand.getItemInHand().clone());
                cMIGui.addButton(cMIGuiButton);
            }
            cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.leggings.getSlot()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                }
            };
            cMIGuiButton.unlockField();
            cMIGuiButton.setItem(armorStand.getLeggings().clone());
            cMIGui.addButton(cMIGuiButton);
            cMIGuiButton = new CMIGuiButton(armorStandEditorSlots.boots.getSlot()){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    CMIScheduler.runTask(() -> ArmorStandManager.this.updateArmorStandItems(cMIGui));
                }
            };
            cMIGuiButton.unlockField();
            cMIGuiButton.setItem(armorStand.getBoots().clone());
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.plate.name())) {
            cMIGuiButton = new CMIGuiButton(17, armorStand.hasBasePlate() ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStand armorStand2;
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    Entity entity = (Entity)cMIGui.getWhatShows();
                    armorStand2.setBasePlate(!(armorStand2 = (ArmorStand)entity).hasBasePlate());
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setItem(armorStand.hasBasePlate() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.plate.name(), new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.size.name())) {
            cMIGuiButton = new CMIGuiButton(6, armorStand.isSmall() ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStand armorStand2;
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    Entity entity = (Entity)cMIGui.getWhatShows();
                    armorStand2.setSmall(!(armorStand2 = (ArmorStand)entity).isSmall());
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setItem(armorStand.isSmall() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.size.name(), new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.visible.name())) {
            cMIGuiButton = new CMIGuiButton(5, armorStand.isVisible() ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    Entity entity = (Entity)cMIGui.getWhatShows();
                    ArmorStand armorStand2 = (ArmorStand)entity;
                    if (armorStand2.isInvisible() || !armorStand2.isVisible()) {
                        armorStand2.setInvisible(false);
                        armorStand2.setVisible(true);
                    } else {
                        armorStand2.setInvisible(true);
                        armorStand2.setVisible(false);
                    }
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setItem(armorStand.isVisible() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.visible.name(), new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.gravity.name())) {
            cMIGuiButton = new CMIGuiButton(7, armorStand.hasGravity() ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStand armorStand2;
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    Entity entity = (Entity)cMIGui.getWhatShows();
                    armorStand2.setGravity(!(armorStand2 = (ArmorStand)entity).hasGravity());
                    this.updateLooks();
                    this.update();
                    CMIGuiButton cMIGuiButton = (CMIGuiButton)cMIGui.getButtons().get(44);
                    if (cMIGuiButton != null) {
                        cMIGuiButton.updateLooks();
                        cMIGuiButton.update();
                    }
                }

                public void updateLooks() {
                    this.setItem(armorStand.hasGravity() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.gravity.name(), new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.arms.name())) {
            cMIGuiButton = new CMIGuiButton(8, CMIMaterial.STONE){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStand armorStand2;
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    Entity entity = (Entity)cMIGui.getWhatShows();
                    armorStand2.setArms(!(armorStand2 = (ArmorStand)entity).hasArms());
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setItem(armorStand.hasArms() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.arms.name(), new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.name.name())) {
            cMIGuiButton = new CMIGuiButton(16, CMIMaterial.STONE){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStand armorStand2;
                    if (!ArmorStandManager.this.isOk(cMIGui)) {
                        return;
                    }
                    final Entity entity = (Entity)cMIGui.getWhatShows();
                    if (gUIClickType == GUIManager.GUIClickType.MiddleMouse || gUIClickType == GUIManager.GUIClickType.Q) {
                        ChatMessageEdit chatMessageEdit = new ChatMessageEdit((CommandSender)player, entity.getCustomName() == null ? (entity.getName() == null ? CMIEntityType.getRealNameByType((EntityType)entity.getType()) : entity.getName()) : entity.getCustomName()){

                            public void run(String string) {
                                entity.setCustomName(CMIChatColor.translate((String)string));
                                ArmorStandManager.this.openEditor(player, entity, false);
                            }

                            public void onDisable() {
                                ArmorStandManager.this.openEditor(player, entity, false);
                            }
                        };
                        chatMessageEdit.setCheckForCancel(true);
                        chatMessageEdit.printMessage();
                        player.closeInventory();
                        return;
                    }
                    armorStand2.setCustomNameVisible(!(armorStand2 = (ArmorStand)entity).isCustomNameVisible());
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setItem(armorStand.isCustomNameVisible() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                    this.setName(CMILC.getIM("armorstand", armorStandExtraActions.name.name(), new Object[0]));
                    this.clearLore();
                    this.addLore(CMILC.getIM("armorstand", "nameEdit", new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        try {
            if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.glow.name())) {
                cMIGuiButton = new CMIGuiButton(15, CMIMaterial.STONE){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        ArmorStand armorStand2;
                        if (!ArmorStandManager.this.isOk(cMIGui)) {
                            return;
                        }
                        Entity entity = (Entity)cMIGui.getWhatShows();
                        armorStand2.setGlowing(!(armorStand2 = (ArmorStand)entity).isGlowing());
                        this.updateLooks();
                        this.update();
                    }

                    public void updateLooks() {
                        this.setItem(armorStand.isGlowing() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                        this.setName(CMILC.getIM("armorstand", armorStandExtraActions.glow.name(), new Object[0]));
                    }
                };
                cMIGui.addButton(cMIGuiButton);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.invulnerable.name())) {
                cMIGuiButton = new CMIGuiButton(14, CMIMaterial.STONE){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        ArmorStand armorStand2;
                        if (!ArmorStandManager.this.isOk(cMIGui)) {
                            return;
                        }
                        Entity entity = (Entity)cMIGui.getWhatShows();
                        armorStand2.setInvulnerable(!(armorStand2 = (ArmorStand)entity).isInvulnerable());
                        this.updateLooks();
                        this.update();
                    }

                    public void updateLooks() {
                        this.setItem(armorStand.isInvulnerable() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                        this.setName(CMILC.getIM("armorstand", armorStandExtraActions.invulnerable.name(), new Object[0]));
                    }
                };
                cMIGui.addButton(cMIGuiButton);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandExtraActions.interactable.name())) {
                cMIGuiButton = new CMIGuiButton(26, CMIMaterial.STONE){

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        ArmorStand armorStand2;
                        if (!ArmorStandManager.this.isOk(cMIGui)) {
                            return;
                        }
                        Entity entity = (Entity)cMIGui.getWhatShows();
                        armorStand2.setMarker(!(armorStand2 = (ArmorStand)entity).isMarker());
                        this.updateLooks();
                        this.update();
                    }

                    public void updateLooks() {
                        this.setItem(armorStand.isMarker() ? CMIMaterial.GREEN_WOOL.newItemStack() : CMIMaterial.RED_WOOL.newItemStack());
                        this.setName(CMILC.getIM("armorstand", armorStandExtraActions.interactable.name(), new Object[0]));
                    }
                };
                cMIGui.addButton(cMIGuiButton);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        cMIGuiButton = new CMIGuiButton(41, CMIMaterial.PAPER){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.plugin.getArmorStandManager().openCopyWindow(player, armorStand);
            }

            public void updateLooks() {
                this.setName(CMILC.getIM(armorstand.class, "copyLabel", new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(33, CMIMaterial.COMPASS){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.openPositionEditor(player, entity);
            }

            public void updateLooks() {
                this.setName(CMILC.getIM(armorstand.class, "positionLabel", new Object[0]));
            }
        };
        cMIGui.addButton(cMIGuiButton);
        if (PermissionsManager.CMIPerm.command_armorstand_admin.hasPermission((CommandSender)player)) {
            cMIGuiButton = new CMIGuiButton(43, CMIMaterial.CHEST){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStandManager.this.openSaveWindow(player, entity);
                }

                public void updateLooks() {
                    this.setName(CMILC.getIM(armorstand.class, "saveLabel", new Object[0]));
                }
            };
            cMIGui.addButton(cMIGuiButton);
        }
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    public boolean openPositionEditor(final Player player, final Entity entity) {
        CMIGuiButton cMIGuiButton;
        if (!Version.isCurrentHigher((Version)Version.v1_7_R4)) {
            return false;
        }
        if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        if (entity.getCustomName() != null && entity.getCustomName().equals("CMIArmorStandForSit")) {
            return false;
        }
        Integer n = new CMINBT(entity).getInt("DisabledSlots");
        if (n != null && n == 0x1FFF00) {
            return false;
        }
        ArmorStandListener.acMap.remove(player.getUniqueId());
        if (entity.isDead()) {
            player.closeInventory();
            return false;
        }
        last.put(player.getUniqueId(), entity);
        editing.put(player.getUniqueId(), entity);
        final ArmorStand armorStand = (ArmorStand)entity;
        final CMIGui cMIGui = new CMIGui(player){

            public void onClose() {
                editing.remove(player.getUniqueId());
            }
        };
        cMIGui.setWhatShows((Object)entity);
        cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.ArmorStandEditor);
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        cMIGui.setTitle(CMILC.getIM(armorstand.class, "title", new Object[0]));
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.body.name())) {
            cMIGuiButton = new CMIGuiButton(40, CMIMaterial.BROWN_WOOL){

                public void click(GUIManager.GUIClickType gUIClickType) {
                    ArmorStandManager.this.plugin.getArmorStandManager().changeAngle(cMIGui, armorStandActions.body, armorStandPoseC.x, ArmorStandManager.this.getValue(gUIClickType));
                    this.updateLooks();
                    this.update();
                }

                public void updateLooks() {
                    this.setName(CMILC.getIM("armorstand", armorStandActions.body.name(), "[amount]", ArmorStandManager.getAngle(armorStand, armorStandActions.body, armorStandPoseC.x)));
                }
            };
            cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation", new Object[0]));
            cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation2", new Object[0]));
            cMIGui.addButton(cMIGuiButton);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.head.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.head, 10);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.torso.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.torso, 11);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.leftArm.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.leftArm, 12);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.rightArm.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.rightArm, 13);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.leftLeg.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.leftLeg, 14);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.rightLeg.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.rightLeg, 15);
        }
        if (PermissionsManager.CMIPerm.command_armorstand_$1.hasPermission((CommandSender)player, armorStandActions.pos.name())) {
            this.setAngleButtons(cMIGui, armorStand, armorStandActions.pos, 16);
        }
        cMIGuiButton = new CMIGuiButton(53, CMILib.getInstance().getItemManager().getItem("head:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmNjYmY5ODgzZGQzNTlmZGYyMzg1YzkwYTQ1OWQ3Mzc3NjUzODJlYzQxMTdiMDQ4OTVhYzRkYzRiNjBmYyJ9fX0=")){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.openEditor(player, entity, false);
            }
        };
        cMIGuiButton.setName(LC.info_Back.getLocale(new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
        return true;
    }

    private int getValue(GUIManager.GUIClickType gUIClickType) {
        switch (gUIClickType) {
            case Left: {
                return 1;
            }
            case LeftShift: {
                return 10;
            }
            case MiddleMouse: 
            case Q: {
                return 0;
            }
            case Right: {
                return -1;
            }
            case RightShift: {
                return -10;
            }
        }
        return 0;
    }

    private void setAngleButtons(final CMIGui cMIGui, final ArmorStand armorStand, final armorStandActions armorStandActions2, int n) {
        CMIGuiButton cMIGuiButton = new CMIGuiButton(n, CMIMaterial.BROWN_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.plugin.getArmorStandManager().changeAngle(cMIGui, armorStandActions2, armorStandPoseC.x, ArmorStandManager.this.getValue(gUIClickType));
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setName(CMILC.getIM("armorstand", armorStandActions2.name(), "[coord]", CMILC.getIM("armorstand", "coordX", new Object[0]), "[amount]", ArmorStandManager.getAngle(armorStand, armorStandActions2, armorStandPoseC.x)));
            }
        };
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation", new Object[0]));
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation2", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(n + 9, CMIMaterial.BLUE_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                if (!armorStandActions2.equals((Object)armorStandActions.pos) || armorStandActions2.equals((Object)armorStandActions.pos) && !armorStand.hasGravity()) {
                    ArmorStandManager.this.plugin.getArmorStandManager().changeAngle(cMIGui, armorStandActions2, armorStandPoseC.y, ArmorStandManager.this.getValue(gUIClickType));
                    this.updateLooks();
                    this.update();
                }
            }

            public void updateLooks() {
                this.setName(CMILC.getIM("armorstand", armorStandActions2.name(), "[coord]", CMILC.getIM("armorstand", "coordY", new Object[0]), "[amount]", ArmorStandManager.getAngle(armorStand, armorStandActions2, armorStandPoseC.y)));
            }
        };
        if (armorStandActions2.equals((Object)armorStandActions.pos) && armorStand.hasGravity()) {
            cMIGuiButton.addLore(CMILC.getIM("armorstand", "disableGravity", new Object[0]));
        }
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation", new Object[0]));
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation2", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(n + 18, CMIMaterial.PURPLE_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                ArmorStandManager.this.plugin.getArmorStandManager().changeAngle(cMIGui, armorStandActions2, armorStandPoseC.z, ArmorStandManager.this.getValue(gUIClickType));
                this.updateLooks();
                this.update();
            }

            public void updateLooks() {
                this.setName(CMILC.getIM("armorstand", armorStandActions2.name(), "[coord]", CMILC.getIM("armorstand", "coordZ", new Object[0]), "[amount]", ArmorStandManager.getAngle(armorStand, armorStandActions2, armorStandPoseC.z)));
            }
        };
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation", new Object[0]));
        cMIGuiButton.addLore(CMILC.getIM("armorstand", "explanation2", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
    }

    public boolean isOk(CMIGui cMIGui) {
        if (!(cMIGui.getWhatShows() instanceof Entity)) {
            return false;
        }
        if (this.isTooFar(cMIGui.getPlayer(), (Entity)cMIGui.getWhatShows())) {
            CMILC.info((Object)this, (CommandSender)cMIGui.getPlayer(), "tooFar", new Object[0]);
            cMIGui.getPlayer().closeInventory();
            return false;
        }
        Entity entity = (Entity)cMIGui.getWhatShows();
        if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) {
            return false;
        }
        ArmorStand armorStand = (ArmorStand)entity;
        if (armorStand.isDead()) {
            cMIGui.getPlayer().closeInventory();
            return false;
        }
        return true;
    }

    private static double getAngle(ArmorStand armorStand, armorStandActions armorStandActions2, armorStandPoseC armorStandPoseC2) {
        EulerAngle eulerAngle = null;
        switch (armorStandActions2) {
            case head: {
                eulerAngle = armorStand.getHeadPose();
                break;
            }
            case leftArm: {
                eulerAngle = armorStand.getLeftArmPose();
                break;
            }
            case torso: {
                eulerAngle = armorStand.getBodyPose();
                break;
            }
            case leftLeg: {
                eulerAngle = armorStand.getLeftLegPose();
                break;
            }
            case rightArm: {
                eulerAngle = armorStand.getRightArmPose();
                break;
            }
            case rightLeg: {
                eulerAngle = armorStand.getRightLegPose();
                break;
            }
            case pos: {
                Location location = armorStand.getLocation();
                switch (armorStandPoseC2) {
                    case x: {
                        return (double)((int)(location.getX() * 100.0)) / 100.0;
                    }
                    case y: {
                        return (double)((int)(location.getY() * 100.0)) / 100.0;
                    }
                    case z: {
                        return (double)((int)(location.getZ() * 100.0)) / 100.0;
                    }
                }
                break;
            }
            case body: {
                return armorStand.getLocation().getYaw();
            }
        }
        if (eulerAngle != null) {
            switch (armorStandPoseC2) {
                case x: {
                    return (double)((int)(Math.toDegrees(eulerAngle.getX()) * 100.0)) / 100.0;
                }
                case y: {
                    return (double)((int)(Math.toDegrees(eulerAngle.getY()) * 100.0)) / 100.0;
                }
                case z: {
                    return (double)((int)(Math.toDegrees(eulerAngle.getZ()) * 100.0)) / 100.0;
                }
            }
        }
        return 0.0;
    }

    private static EulerAngle getEulerAngle(ArmorStand armorStand, armorStandActions armorStandActions2, armorStandPoseC armorStandPoseC2) {
        EulerAngle eulerAngle = null;
        switch (armorStandActions2) {
            case head: {
                eulerAngle = armorStand.getHeadPose();
                break;
            }
            case leftArm: {
                eulerAngle = armorStand.getLeftArmPose();
                break;
            }
            case torso: {
                eulerAngle = armorStand.getBodyPose();
                break;
            }
            case leftLeg: {
                eulerAngle = armorStand.getLeftLegPose();
                break;
            }
            case rightArm: {
                eulerAngle = armorStand.getRightArmPose();
                break;
            }
            case rightLeg: {
                eulerAngle = armorStand.getRightLegPose();
                break;
            }
        }
        return eulerAngle;
    }

    private static void duplicate(armorStandActions armorStandActions2, ArmorStand armorStand, ArmorStand armorStand2) {
        ArmorStandManager.setAngle(armorStand2, armorStandActions2, armorStandPoseC.x, ArmorStandManager.getEulerAngle(armorStand, armorStandActions2, armorStandPoseC.x));
        ArmorStandManager.setAngle(armorStand2, armorStandActions2, armorStandPoseC.y, ArmorStandManager.getEulerAngle(armorStand, armorStandActions2, armorStandPoseC.y));
        ArmorStandManager.setAngle(armorStand2, armorStandActions2, armorStandPoseC.z, ArmorStandManager.getEulerAngle(armorStand, armorStandActions2, armorStandPoseC.z));
    }

    public void duplicate(ArmorStand armorStand, ArmorStand armorStand2, Set<armorStandActions> set) {
        if (armorStand == null || armorStand.isDead() || armorStand2 == null || armorStand2.isDead()) {
            return;
        }
        if (set.contains((Object)armorStandActions.body)) {
            Location object = armorStand2.getLocation();
            object.setYaw(armorStand.getLocation().getYaw());
            armorStand2.teleport(object);
        }
        for (armorStandActions armorStandActions2 : set) {
            ArmorStandManager.duplicate(armorStandActions2, armorStand, armorStand2);
        }
    }

    public void duplicateExtra(ArmorStand armorStand, ArmorStand armorStand2, Set<armorStandExtraActions> set) {
        if (armorStand == null || armorStand.isDead() || armorStand2 == null || armorStand2.isDead()) {
            return;
        }
        for (armorStandExtraActions armorStandExtraActions2 : set) {
            switch (armorStandExtraActions2) {
                case arms: {
                    armorStand2.setArms(armorStand.hasArms());
                    break;
                }
                case glow: {
                    armorStand2.setGlowing(armorStand.isGlowing());
                    break;
                }
                case gravity: {
                    armorStand2.setGravity(armorStand.hasGravity());
                    break;
                }
                case interactable: {
                    armorStand2.setMarker(armorStand.isMarker());
                    break;
                }
                case invulnerable: {
                    armorStand2.setInvulnerable(armorStand.isInvulnerable());
                    break;
                }
                case name: {
                    armorStand2.setCustomNameVisible(armorStand.isCustomNameVisible());
                    break;
                }
                case plate: {
                    armorStand2.setBasePlate(armorStand.hasBasePlate());
                    break;
                }
                case size: {
                    armorStand2.setSmall(armorStand.isSmall());
                    break;
                }
                case visible: {
                    armorStand2.setVisible(armorStand.isVisible());
                    break;
                }
            }
        }
    }

    private boolean canBuild(Player player, Location location) {
        if (player == null) {
            return true;
        }
        if (PermissionsManager.CMIPerm.command_armorstand_movebypass.hasPermission((CommandSender)player)) {
            return true;
        }
        PlayerAnimationEvent playerAnimationEvent = new PlayerAnimationEvent(player);
        Bukkit.getPluginManager().callEvent((Event)playerAnimationEvent);
        BlockPlaceEvent blockPlaceEvent = CMIEvent.placeBlockEvent(location.getBlock(), player);
        Bukkit.getPluginManager().callEvent((Event)blockPlaceEvent);
        return !blockPlaceEvent.isCancelled();
    }

    public boolean canInteract(Player player, Entity entity, boolean bl) {
        PlayerAnimationEvent playerAnimationEvent = new PlayerAnimationEvent(player);
        Bukkit.getPluginManager().callEvent((Event)playerAnimationEvent);
        if (bl && Version.isCurrentEqualOrHigher((Version)Version.v1_8_R1) && !ArmorStandListener1_8.checkInteract(player, entity)) {
            return false;
        }
        try {
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_8_R1) && !ArmorStandListener1_8.checkManipulation(player, entity)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ArmorStandsCheckBlockPlace) {
            BlockPlaceEvent blockPlaceEvent;
            block8: {
                blockPlaceEvent = CMIEvent.placeBlockEvent(entity.getLocation().getBlock(), player);
                Bukkit.getPluginManager().callEvent((Event)blockPlaceEvent);
                if (!blockPlaceEvent.isCancelled()) break block8;
                return false;
            }
            try {
                blockPlaceEvent.setCancelled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void changeAngle(CMIGui cMIGui, armorStandActions armorStandActions2, armorStandPoseC armorStandPoseC2, int n) {
        if (!this.isOk(cMIGui)) {
            return;
        }
        Entity entity = (Entity)cMIGui.getWhatShows();
        this.changeAngle((ArmorStand)entity, cMIGui.getPlayer(), armorStandActions2, armorStandPoseC2, n);
    }

    public void changeAngle(ArmorStand armorStand, Player player, armorStandActions armorStandActions2, armorStandPoseC armorStandPoseC2, int n) {
        double d = (double)n / 100.0;
        EulerAngle eulerAngle = null;
        switch (armorStandActions2) {
            case head: {
                eulerAngle = armorStand.getHeadPose();
                break;
            }
            case leftArm: {
                eulerAngle = armorStand.getLeftArmPose();
                break;
            }
            case torso: {
                eulerAngle = armorStand.getBodyPose();
                break;
            }
            case leftLeg: {
                eulerAngle = armorStand.getLeftLegPose();
                break;
            }
            case rightArm: {
                eulerAngle = armorStand.getRightArmPose();
                break;
            }
            case rightLeg: {
                eulerAngle = armorStand.getRightLegPose();
                break;
            }
            case pos: {
                switch (armorStandPoseC2) {
                    case x: {
                        Location location = armorStand.getLocation().clone().add(d, 0.0, 0.0);
                        if (this.canBuild(player, location)) {
                            armorStand.teleport(location);
                        }
                        return;
                    }
                    case y: {
                        Location location = armorStand.getLocation().clone().add(0.0, d, 0.0);
                        if (this.canBuild(player, location)) {
                            armorStand.teleport(location);
                        }
                        return;
                    }
                    case z: {
                        Location location = armorStand.getLocation().clone().add(0.0, 0.0, d);
                        if (this.canBuild(player, location)) {
                            armorStand.teleport(location);
                        }
                        return;
                    }
                }
                break;
            }
            case body: {
                Float f = Float.valueOf(armorStand.getLocation().getYaw() + (float)n);
                f = Float.valueOf(f.floatValue() < 0.0f ? 360.0f + f.floatValue() : f.floatValue());
                f = Float.valueOf(f.floatValue() >= 360.0f ? (360.0f - f.floatValue() != 0.0f ? -(360.0f - f.floatValue()) : 0.0f) : f.floatValue());
                Location location = armorStand.getLocation().clone();
                location.setYaw(f.floatValue());
                if (this.canBuild(player, location)) {
                    armorStand.teleport(location);
                }
                return;
            }
        }
        if (eulerAngle != null) {
            if (n == 0) {
                switch (armorStandPoseC2) {
                    case x: {
                        eulerAngle = eulerAngle.setX(0.0);
                        break;
                    }
                    case y: {
                        eulerAngle = eulerAngle.setY(0.0);
                        break;
                    }
                    case z: {
                        eulerAngle = eulerAngle.setZ(0.0);
                        break;
                    }
                }
            } else {
                d = Math.PI / (double)(360 / n);
                switch (armorStandPoseC2) {
                    case x: {
                        eulerAngle = eulerAngle.add(d, 0.0, 0.0);
                        break;
                    }
                    case y: {
                        eulerAngle = eulerAngle.add(0.0, d, 0.0);
                        break;
                    }
                    case z: {
                        eulerAngle = eulerAngle.add(0.0, 0.0, d);
                        break;
                    }
                }
            }
        }
        switch (armorStandActions2) {
            case head: {
                armorStand.setHeadPose(eulerAngle);
                break;
            }
            case leftArm: {
                armorStand.setLeftArmPose(eulerAngle);
                break;
            }
            case torso: {
                armorStand.setBodyPose(eulerAngle);
                break;
            }
            case leftLeg: {
                armorStand.setLeftLegPose(eulerAngle);
                break;
            }
            case rightArm: {
                armorStand.setRightArmPose(eulerAngle);
                break;
            }
            case rightLeg: {
                armorStand.setRightLegPose(eulerAngle);
                break;
            }
        }
    }

    private static void setAngle(ArmorStand armorStand, armorStandActions armorStandActions2, armorStandPoseC armorStandPoseC2, EulerAngle eulerAngle) {
        switch (armorStandActions2) {
            case head: {
                armorStand.setHeadPose(eulerAngle);
                break;
            }
            case leftArm: {
                armorStand.setLeftArmPose(eulerAngle);
                break;
            }
            case torso: {
                armorStand.setBodyPose(eulerAngle);
                break;
            }
            case leftLeg: {
                armorStand.setLeftLegPose(eulerAngle);
                break;
            }
            case rightArm: {
                armorStand.setRightArmPose(eulerAngle);
                break;
            }
            case rightLeg: {
                armorStand.setRightLegPose(eulerAngle);
                break;
            }
        }
    }

    public void switchArmorStandArms(CMIGui cMIGui) {
        ArmorStand armorStand;
        if (!this.isOk(cMIGui)) {
            return;
        }
        Entity entity = (Entity)cMIGui.getWhatShows();
        armorStand.setArms(!(armorStand = (ArmorStand)entity).hasArms());
    }

    public void updateArmorStandItems(CMIGui cMIGui) {
        if (!this.isOk(cMIGui)) {
            return;
        }
        Entity entity = (Entity)cMIGui.getWhatShows();
        ArmorStand armorStand = (ArmorStand)entity;
        ItemStack itemStack = cMIGui.getInv().getItem(armorStandEditorSlots.helmet.getSlot());
        armorStand.setHelmet(itemStack);
        ItemStack itemStack2 = cMIGui.getInv().getItem(armorStandEditorSlots.chest.getSlot());
        armorStand.setChestplate(itemStack2);
        itemStack2 = cMIGui.getInv().getItem(armorStandEditorSlots.leggings.getSlot());
        armorStand.setLeggings(itemStack2);
        itemStack2 = cMIGui.getInv().getItem(armorStandEditorSlots.boots.getSlot());
        armorStand.setBoots(itemStack2);
        itemStack2 = cMIGui.getInv().getItem(armorStandEditorSlots.mainhand.getSlot());
        armorStand.setItemInHand(itemStack2);
        if (Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            LivingEntity livingEntity = (LivingEntity)entity;
            itemStack2 = cMIGui.getInv().getItem(armorStandEditorSlots.offhand.getSlot());
            livingEntity.getEquipment().setItemInOffHand(itemStack2);
        }
    }

    public ArmorStandSave getSavedArmorStand(String string) {
        if (string == null) {
            return null;
        }
        return this.savedArmorStands.get(string.toLowerCase());
    }

    public void save() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + "armorStands.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        for (Map.Entry<String, ArmorStandSave> entry : this.savedArmorStands.entrySet()) {
            configReader.get(entry.getValue().getName(), entry.getValue().serialize());
        }
        configReader.save();
    }

    public void load() {
        Long l = System.currentTimeMillis();
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + "armorStands.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        Set set = configReader.getC().getKeys(false);
        this.savedArmorStands.clear();
        for (String string : set) {
            String string2 = configReader.get(string, "");
            if (string2.isEmpty()) continue;
            this.savedArmorStands.put(string.toLowerCase(), new ArmorStandSave(string, string2));
        }
        this.plugin.loadMessage(this.savedArmorStands.size(), "ArmorStand templates", System.currentTimeMillis() - l);
    }

    public HashMap<String, ArmorStandSave> getSavedArmorStands() {
        return this.savedArmorStands;
    }

    public void removeSavedArmorStand(String string) {
        this.savedArmorStands.remove(string.toLowerCase());
    }

    public static enum armorStandActions {
        head,
        body,
        torso,
        leftArm,
        rightArm,
        leftLeg,
        rightLeg,
        pos;


        public static armorStandActions getByName(String string) {
            armorStandActions[] armorStandActionsArray = armorStandActions.values();
            int n = armorStandActionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                armorStandActions armorStandActions2 = armorStandActionsArray[n2];
                if (armorStandActions2.name().equalsIgnoreCase(string)) {
                    return armorStandActions2;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum armorStandEditorSlots {
        helmet(11),
        chest(20),
        offhand(21),
        mainhand(19),
        leggings(29),
        boots(38);

        private int slot;

        private armorStandEditorSlots(int n2) {
            this.slot = n2;
        }

        public int getSlot() {
            return this.slot;
        }

        public static armorStandEditorSlots getBySlot(int n) {
            armorStandEditorSlots[] armorStandEditorSlotsArray = armorStandEditorSlots.values();
            int n2 = armorStandEditorSlotsArray.length;
            int n3 = 0;
            while (n3 < n2) {
                armorStandEditorSlots armorStandEditorSlots2 = armorStandEditorSlotsArray[n3];
                if (armorStandEditorSlots2.getSlot() == n) {
                    return armorStandEditorSlots2;
                }
                ++n3;
            }
            return null;
        }
    }

    public static enum armorStandExtraActions {
        updateitems,
        plate,
        size,
        visible,
        arms,
        gravity,
        glow,
        invulnerable,
        name,
        interactable;


        public static armorStandExtraActions getByName(String string) {
            armorStandExtraActions[] armorStandExtraActionsArray = armorStandExtraActions.values();
            int n = armorStandExtraActionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                armorStandExtraActions armorStandExtraActions2 = armorStandExtraActionsArray[n2];
                if (armorStandExtraActions2.name().equalsIgnoreCase(string)) {
                    return armorStandExtraActions2;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum armorStandPoseC {
        x,
        y,
        z;

    }

    public static enum armorStandSaveOptions {
        helmet,
        chest,
        offhand,
        mainhand,
        leggings,
        boots,
        name,
        body,
        plate,
        size,
        visible,
        arms,
        gravity,
        glow,
        invulnerable,
        interactable,
        head(new Vector(-30, -50, -30), new Vector(30, 50, 30)),
        torso(new Vector(-5, -20, -5), new Vector(5, 20, 5)),
        leftArm(new Vector(-160, -35, -150), new Vector(20, 40, 5), new Vector(-10.0, 0.0, -10.0)),
        rightArm(new Vector(-160, -40, -5), new Vector(20, 35, 150), new Vector(-14.99, 0.0, 10.0)),
        leftLeg(new Vector(-85, -10, -35), new Vector(25, 10, 5), new Vector(-1.0, 0.0, -1.0)),
        rightLeg(new Vector(-85, -10, -5), new Vector(25, 10, 35), new Vector(1.0, 0.0, 1.0));

        private Vector defaults = new Vector(0.0, 0.0, 0.0);
        private Vector min = new Vector(0, 0, 0);
        private Vector max = new Vector(0, 0, 0);

        private armorStandSaveOptions() {
        }

        private armorStandSaveOptions(Vector vector, Vector vector2, Vector vector3) {
            this.min = vector;
            this.max = vector2;
            this.defaults = vector3;
        }

        private armorStandSaveOptions(Vector vector, Vector vector2) {
            this.min = vector;
            this.max = vector2;
        }

        public static armorStandSaveOptions getByName(String string) {
            armorStandSaveOptions[] armorStandSaveOptionsArray = armorStandSaveOptions.values();
            int n = armorStandSaveOptionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                armorStandSaveOptions armorStandSaveOptions2 = armorStandSaveOptionsArray[n2];
                if (armorStandSaveOptions2.name().equalsIgnoreCase(string)) {
                    return armorStandSaveOptions2;
                }
                ++n2;
            }
            return null;
        }

        public Vector getDefault() {
            return this.defaults;
        }

        public Vector getMin() {
            return this.min;
        }

        public Vector getMax() {
            return this.max;
        }
    }
}

