/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Placeholders;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import com.Zrips.CMI.AllListeners.NoTargetListener;
import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIExperience;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.BungeeCord.BungeeCordServer;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.CustomText.CTextManager;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Homes.CmiHome;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Jail.CMIJail;
import com.Zrips.CMI.Modules.Jail.CMIJailCell;
import com.Zrips.CMI.Modules.Kits.Kit;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Placeholders.PlaceholderCache;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayTimeFormat;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.Modules.Ranks.CMIRank;
import com.Zrips.CMI.Modules.Sheduler.Schedule;
import com.Zrips.CMI.Modules.SilentChest.silentChestListener;
import com.Zrips.CMI.Modules.Statistics.StatsManager;
import com.Zrips.CMI.Modules.Worth.WorthItem;
import com.Zrips.CMI.commands.list.stats;
import com.Zrips.CMI.commands.list.weather;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIBiome;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Equations.Parser;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;

public class Placeholder {
    private CMI plugin;
    Pattern placeholderKeepPatern = Pattern.compile("(\\%\\%)([^\\\"^\\%^ ]+)(\\%\\%)(\\B)");
    Pattern placeholderOthersKeepPatern = Pattern.compile("(?i)(\\%parseother_)((\\{)([^\\\"^\\%^ ^\\{^\\}]+)(\\}))([^(\\}\\%).]+)(\\}\\%)");
    Pattern placeholderPatern = Pattern.compile("(%)([^% \"]+)(%)");
    Pattern placeholderPatern2 = Pattern.compile("(\\{)([^\"^%^ ^{^}]+)(\\})");
    private static ChatFilterRule numericalRule = new ChatFilterRule().setPattern("(\\$)(\\d)");
    Random random = new Random(System.nanoTime());
    private static final String checkItem = "%checkitem_";
    private int maxDepth = 4;
    private HashMap<String, String> randomCache = new HashMap();
    private Player lastRandomPlayer = null;
    private HashMap<Integer, Player> randomPlayers = new HashMap();

    public Placeholder(CMI cMI) {
        this.plugin = cMI;
    }

    public List<String> updatePlaceHolders(Player player, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            arrayList.set(n, this.updatePlaceHolders(player, list2.get(n)));
            ++n;
        }
        return arrayList;
    }

    public CMIPlaceholderType getPlaceHolderType(Player player, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("%") && !string.equals(this.translateOwnPlaceHolder(player, string))) {
            return CMIPlaceholderType.CMI;
        }
        if (string.contains("{") && !string.equals(this.translateOwnPlaceHolder(player, string))) {
            return CMIPlaceholderType.CMI;
        }
        if (CMIHookType.PlaceholderAPI.isEnabled()) {
            try {
                if (string.contains("%") && me.clip.placeholderapi.PlaceholderAPI.containsPlaceholders((String)string)) {
                    return CMIPlaceholderType.PAPI;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (CMIHookType.MVdWPlaceholderAPI.isEnabled()) {
            try {
                if (string.contains("{") && CMIChatColor.stripHexColor((String)string).equals(string) && !string.equals(PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)string))) {
                    return CMIPlaceholderType.MVdW;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static void reportIssue() {
        CMIMessages.consoleMessage((String)"&c[CMI] Placeholder got blocked due to security concerns (%checkitem_...%)");
    }

    public String updatePlaceHolders(UUID uUID, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("{")) {
            string = this.translateOwnPlaceHolder(uUID, string);
        }
        if (string.contains("%")) {
            string = this.translateOwnPlaceHolder(uUID, string);
        }
        if (CMIHookType.MVdWPlaceholderAPI.isEnabled() && string.contains("{")) {
            Player player = CMIUser.getOnlinePlayer(uUID);
            if (CMIChatColor.stripHexColor((String)string).equals(string)) {
                string = PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)string);
            }
        }
        if (CMIHookType.PlaceholderAPI.isEnabled()) {
            try {
                if (string.contains("%")) {
                    if (!string.toLowerCase().contains(checkItem) || !this.plugin.getConfigManager().isExploitPatcherCheckItem()) {
                        string = me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)CMIUser.getOnlinePlayer(uUID), (String)string);
                    } else {
                        Placeholder.reportIssue();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public String updatePlaceHolders(String string) {
        UUID uUID = null;
        return this.updatePlaceHolders(uUID, string);
    }

    public String updatePlaceHolders(Player player, String string) {
        if (string == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.contains("{")) {
            Matcher matcher = this.placeholderOthersKeepPatern.matcher(string);
            while (matcher.find()) {
                try {
                    if (!string.contains("%")) break;
                    String throwable = matcher.group();
                    int n = this.random.nextInt(Integer.MAX_VALUE);
                    String string2 = "|" + n + "|";
                    hashMap.put(string2, throwable);
                    string = string.replaceFirst(Pattern.quote(throwable), Matcher.quoteReplacement(string2));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            string = this.translateOwnPlaceHolder(player, string);
            if (string.contains("%")) {
                string = this.translateOwnPlaceHolder(player, string);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                string = string.replace((CharSequence)entry.getKey(), Matcher.quoteReplacement((String)entry.getValue()));
            }
        } else if (string.contains("%")) {
            string = this.translateOwnPlaceHolder(player, string);
        }
        if (CMIHookType.MVdWPlaceholderAPI.isEnabled() && string.contains("{")) {
            try {
                if (CMIChatColor.stripHexColor((String)string).equals(string)) {
                    string = PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)string);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (CMIHookType.PlaceholderAPI.isEnabled()) {
            try {
                if (string.contains("%")) {
                    if (!string.toLowerCase().contains(checkItem) || !this.plugin.getConfigManager().isExploitPatcherCheckItem()) {
                        string = me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)player, (String)string);
                    } else {
                        Placeholder.reportIssue();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean hasMetaValue(CMIUser cMIUser, String string) {
        return cMIUser.getMeta().getMap().containsKey(string.toLowerCase());
    }

    public boolean containsPlaceHolder(String string) {
        Matcher matcher = this.placeholderPatern.matcher(string);
        if (matcher.find()) {
            return true;
        }
        matcher = this.placeholderPatern2.matcher(string);
        return matcher.find();
    }

    public String replacePlaceHolders(String string, String string2) {
        String string3;
        Matcher matcher = this.placeholderPatern.matcher(string);
        while (matcher.find()) {
            string3 = matcher.group();
            string = string.replaceFirst(Pattern.quote(string3), Matcher.quoteReplacement(string2));
        }
        matcher = this.placeholderPatern2.matcher(string);
        while (matcher.find()) {
            string3 = matcher.group();
            string = string.replaceFirst(Pattern.quote(string3), Matcher.quoteReplacement(string2));
        }
        return string;
    }

    public String coolDownPlaceHolders(String string, Player player) {
        String string2;
        if (!string.toLowerCase().contains("parseother")) {
            return string;
        }
        Matcher matcher = this.placeholderPatern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            if (string2.equalsIgnoreCase(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string2))) continue;
            string = string.replaceFirst(Pattern.quote(string2), "%|" + Matcher.quoteReplacement(string2.substring(1, string2.length() - 1)) + "|%");
        }
        matcher = this.placeholderPatern2.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            if (string2.equalsIgnoreCase(this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, string2))) continue;
            string = string.replaceFirst(Pattern.quote(string2), "{|" + Matcher.quoteReplacement(string2.substring(1, string2.length() - 1)) + "|}");
        }
        return string;
    }

    public String coolDownPlaceHolders(String string) {
        String string2;
        Matcher matcher = this.placeholderPatern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            string = string.replaceFirst(Pattern.quote(string2), "%|" + Matcher.quoteReplacement(string2.substring(1, string2.length() - 1)) + "|%");
        }
        matcher = this.placeholderPatern2.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group();
            string = string.replaceFirst(Pattern.quote(string2), "{|" + Matcher.quoteReplacement(string2.substring(1, string2.length() - 1)) + "|}");
        }
        return string;
    }

    public String translatePAPIPlaceHolder(Player player, CMIPlaceHolders cMIPlaceHolders, String string) {
        if (string.contains("{")) {
            return this.translateOwnPlaceHolder(player, string);
        }
        UUID uUID = null;
        if (player != null) {
            uUID = player.getUniqueId();
        }
        Object object = cMIPlaceHolders.getCachedValue(uUID);
        String string2 = null;
        string2 = object != null ? (String)object : this.getValue(uUID, cMIPlaceHolders, string);
        string2 = CTextManager.clean(string2);
        if (cMIPlaceHolders.isCache() && object == null && cMIPlaceHolders.getCachedValue(uUID) == null) {
            cMIPlaceHolders.addCachedValue(uUID, string2, 50);
        }
        return string2 == null ? "" : string2;
    }

    public String translateOwnPlaceHolder(Player player, String string) {
        return this.translateOwnPlaceHolder(player == null ? null : player.getUniqueId(), string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String matchInception(UUID uUID, String string, int n) {
        if (!string.contains("{")) return string;
        Matcher matcher = this.placeholderPatern2.matcher(string);
        int n2 = 0;
        try {
            while (true) {
                String string2;
                String string3;
                if (!matcher.find()) {
                    return string;
                }
                if (++n2 > 10) {
                    return string;
                }
                String string4 = matcher.group(2);
                if (!string.contains("{")) {
                    return string;
                }
                CMIPlaceHolders cMIPlaceHolders = CMIPlaceHolders.getByNameExact(string4);
                if (cMIPlaceHolders == null) {
                    if (!CMIHookType.PlaceholderAPI.isEnabled()) continue;
                    try {
                        string3 = CMIUser.getOnlinePlayer(uUID);
                        string2 = matcher.group();
                        if (string2.startsWith("{#")) continue;
                        if (!string4.toLowerCase().contains(checkItem) || !this.plugin.getConfigManager().isExploitPatcherCheckItem()) {
                            String string5 = me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((Player)string3, (String)("%" + string4 + "%"));
                            if (string5 == null) {
                                string5 = "";
                            }
                            if (string5.equalsIgnoreCase("%" + string4 + "%")) continue;
                            string = string.replaceFirst(Pattern.quote(string2), Matcher.quoteReplacement(string5));
                            continue;
                        }
                        Placeholder.reportIssue();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                string3 = matcher.group();
                string2 = this.getValue(uUID, cMIPlaceHolders, string3);
                if (string2 == null) {
                    string2 = "";
                }
                string = string.replaceFirst(Pattern.quote(string3), Matcher.quoteReplacement(string2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public String translateOwnPlaceHolder(UUID uUID, String string) {
        Object object;
        Map.Entry entry2;
        Matcher matcher;
        HashMap<Object, Object> hashMap;
        if (string == null) {
            return null;
        }
        if (string.contains("{")) {
            hashMap = new HashMap<Object, Object>();
            matcher = this.placeholderOthersKeepPatern.matcher(string);
            while (matcher.find()) {
                try {
                    if (!string.contains("%")) break;
                    entry2 = matcher.group();
                    int n = this.random.nextInt(Integer.MAX_VALUE);
                    object = "|" + n + "|";
                    hashMap.put(object, entry2);
                    string = string.replaceFirst(Pattern.quote(entry2), Matcher.quoteReplacement((String)object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            string = this.matchInception(uUID, string, 0);
            for (Map.Entry entry2 : hashMap.entrySet()) {
                string = string.replace((CharSequence)entry2.getKey(), (CharSequence)entry2.getValue());
            }
        }
        if (string.contains("%")) {
            hashMap = new HashMap();
            matcher = this.placeholderKeepPatern.matcher(string);
            while (matcher.find()) {
                try {
                    if (!string.contains("%")) break;
                    entry2 = matcher.group();
                    int n = this.random.nextInt(Integer.MAX_VALUE);
                    object = "|" + n + "|";
                    hashMap.put(object, ((String)((Object)entry2)).substring(1, ((String)((Object)entry2)).length() - 1));
                    string = string.replaceFirst(Pattern.quote(entry2), Matcher.quoteReplacement((String)object));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            entry2 = this.placeholderPatern.matcher(string);
            while (((Matcher)((Object)entry2)).find()) {
                try {
                    String string2 = ((Matcher)((Object)entry2)).group(2);
                    if (!string.contains("%")) break;
                    object = CMIPlaceHolders.getByNameExact(string2);
                    if (object == null) continue;
                    String string3 = ((Matcher)((Object)entry2)).group();
                    Object object2 = ((CMIPlaceHolders)((Object)object)).getCachedValue(uUID);
                    String string4 = null;
                    string4 = object2 != null ? (String)object2 : this.getValue(uUID, (CMIPlaceHolders)((Object)object), string3);
                    if (((CMIPlaceHolders)((Object)object)).isCache() && object2 == null && ((CMIPlaceHolders)((Object)object)).getCachedValue(uUID) == null) {
                        ((CMIPlaceHolders)((Object)object)).addCachedValue(uUID, string4, 50);
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                    string4 = CTextManager.clean(string4);
                    string = string.replaceFirst(Pattern.quote(string3), Matcher.quoteReplacement(string4));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            for (Map.Entry entry3 : hashMap.entrySet()) {
                string = string.replace((CharSequence)entry3.getKey(), (CharSequence)entry3.getValue());
            }
        }
        return string;
    }

    public String getValue(Player player, CMIPlaceHolders cMIPlaceHolders) {
        return this.getValue(player, cMIPlaceHolders, null);
    }

    public String getValue(Player player, CMIPlaceHolders cMIPlaceHolders, String string) {
        return this.getValue(player != null ? player.getUniqueId() : null, cMIPlaceHolders, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getValue(UUID uUID, CMIPlaceHolders cMIPlaceHolders, String string) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(uUID);
        Player player = null;
        if (cMIUser != null && cMIUser.isOnline()) {
            player = cMIUser.getPlayer();
        }
        if (cMIPlaceHolders == null) {
            return null;
        }
        if (cMIUser != null) {
            switch (cMIPlaceHolders) {
                case cmi_user_charges_left: {
                    return String.valueOf(cMIUser.getPCharge().getCharges());
                }
                case cmi_user_charges_max: {
                    return String.valueOf(cMIUser.getPCharge().getMaxCharges());
                }
                case cmi_user_charges_time: {
                    return String.valueOf(cMIUser.getPCharge().getLeftTime());
                }
                case cmi_user_charges_cooldown: {
                    return String.valueOf(cMIUser.getPCharge().getCooldown());
                }
                case cmi_user_display_name: {
                    return cMIUser.getDisplayName();
                }
                case cmi_user_nickname: {
                    String string2;
                    if (cMIUser.getNickName() == null) {
                        string2 = cMIUser.getName();
                        return string2;
                    }
                    string2 = cMIUser.getNickName();
                    return string2;
                }
                case cmi_user_cleannickname: {
                    String string3;
                    if (cMIUser.getNickName() == null) {
                        string3 = cMIUser.getName();
                        return string3;
                    }
                    string3 = CMIChatColor.stripColor((String)cMIUser.getNickName());
                    return string3;
                }
                case cmi_user_cuffed: {
                    return this.variable(cMIUser.isCuffed());
                }
                case cmi_user_deathloc: {
                    Location location = cMIUser.getDeathLoc();
                    if (location == null) return null;
                    if (location.getWorld() == null) {
                        return null;
                    }
                    return LC.Location_Full.getLocale(new Object[]{location});
                }
                case cmi_user_backloc: {
                    Location location = cMIUser.getLastTeleportLocation();
                    if (location == null) return null;
                    if (location.getWorld() == null) {
                        return null;
                    }
                    return LC.Location_Full.getLocale(new Object[]{location});
                }
                case cmi_user_totalexp: {
                    return String.valueOf(cMIUser.getTotalExp());
                }
                case cmi_user_exp: {
                    return String.valueOf(cMIUser.getExpForCurrentLevel());
                }
                case cmi_user_expp: {
                    return String.valueOf((double)((int)((double)cMIUser.getExpForCurrentLevel() * 100.0 / (double)(CMIExperience.getTotalExpToLevel(cMIUser.getLevel() + 1) - CMIExperience.getTotalExpToLevel(cMIUser.getLevel())) * 100.0)) / 100.0);
                }
                case cmi_user_missingexp: {
                    return String.valueOf(cMIUser.getMissingExp());
                }
                case cmi_user_missingexpp: {
                    return String.valueOf((double)((int)((double)cMIUser.getMissingExp() * 100.0 / (double)(CMIExperience.getTotalExpToLevel(cMIUser.getLevel() + 1) - CMIExperience.getTotalExpToLevel(cMIUser.getLevel())) * 100.0)) / 100.0);
                }
                case cmi_user_level: {
                    return String.valueOf(cMIUser.getLevel());
                }
                case cmi_user_muted: {
                    return this.variable(cMIUser.isMuted());
                }
                case cmi_user_inpvp: {
                    return this.variable(cMIUser.isInCombatWithPlayer());
                }
                case cmi_user_god: {
                    return this.variable(cMIUser.isGod());
                }
                case cmi_user_mail_count: {
                    return String.valueOf(cMIUser.getMails().size());
                }
                case cmi_user_warning_count: {
                    return String.valueOf(cMIUser.getWarnings().size());
                }
                case cmi_user_warning_points: {
                    return String.valueOf(cMIUser.getWarningPoints());
                }
                case cmi_user_afk: {
                    return this.variable(cMIUser.isAfk());
                }
                case cmi_user_afk_symbol: {
                    String string4;
                    if (cMIUser.isAfk()) {
                        string4 = CMILC.info_afkSymbolOn.getLocale(new Object[0]);
                        return string4;
                    }
                    string4 = CMILC.info_afkSymbolOff.getLocale(new Object[0]);
                    return string4;
                }
                case cmi_user_afk_msg: {
                    if (!cMIUser.isAfk()) {
                        return "";
                    }
                    if (cMIUser.getAfkReason() == null) {
                        return "";
                    }
                    String string5 = cMIUser.getAfkReason();
                    return string5;
                }
                case cmi_user_afk_for: {
                    if (!cMIUser.isAfk()) {
                        return "";
                    }
                    String string6 = CMITimeManager.to24hourShort((Long)(System.currentTimeMillis() - cMIUser.getAfkInfo().getAfkFrom()));
                    return string6;
                }
                case cmi_user_afk_in: {
                    if (this.plugin.getAfkManager().getLastAction(cMIUser) == null) {
                        return CMITimeManager.to24hourShort((Long)this.plugin.getAfkManager().getAwayTrigerTime());
                    }
                    if (cMIUser.isAfk()) {
                        return "";
                    }
                    String string7 = CMITimeManager.to24hourShort((Long)(this.plugin.getAfkManager().getAwayTrigerTime() - (System.currentTimeMillis() - this.plugin.getAfkManager().getLastAction(cMIUser))));
                    return string7;
                }
                case cmi_user_joinedcounter: {
                    return this.variable(cMIUser.isJoinedCounter());
                }
                case cmi_user_name: {
                    return cMIUser.getName();
                }
                case cmi_user_uuid: {
                    if (cMIUser.getUniqueId() != null) return cMIUser.getUniqueId().toString();
                    return "";
                }
                case cmi_user_banned: {
                    return this.variable(cMIUser.isBanned());
                }
                case cmi_user_homeamount: {
                    return String.valueOf(cMIUser.getValidHomeCount());
                }
                case cmi_user_homelist: {
                    return cMIUser.getHomes().values().stream().map(CmiHome::getName).collect(Collectors.joining(LC.info_ListSpliter.getLocale(new Object[0])));
                }
                case cmi_user_balance_formated: 
                case cmi_user_balance_formatted: 
                case vault_eco_balance_formatted: {
                    return String.valueOf(cMIUser.getFormatedBalance());
                }
                case cmi_user_balance: {
                    return String.valueOf(cMIUser.getBalance());
                }
                case cmi_user_vanished_symbol: {
                    String string8;
                    if (cMIUser.isVanished()) {
                        string8 = CMILC.info_vanishSymbolOn.getLocale(new Object[0]);
                        return string8;
                    }
                    string8 = CMILC.info_vanishSymbolOff.getLocale(new Object[0]);
                    return string8;
                }
                case cmi_user_pweather: {
                    if (!cMIUser.isOnline()) {
                        return "";
                    }
                    WeatherType weatherType = cMIUser.getPlayer().getPlayerWeather();
                    return weatherType != null ? (weatherType.equals((Object)WeatherType.DOWNFALL) ? CMILC.getIM(weather.class, "rainy", new Object[0]) : CMILC.getIM(weather.class, "sunny", new Object[0])) : LC.info_notSet.getLocale(new Object[0]);
                }
                case cmi_user_weather: {
                    if (!cMIUser.isOnline()) {
                        return "";
                    }
                    String string9 = cMIUser.getWorld().hasStorm() ? CMILC.getIM(weather.class, "rainy", new Object[0]) : CMILC.getIM(weather.class, "sunny", new Object[0]);
                    if (!cMIUser.getWorld().isThundering()) return string9;
                    return CMILC.getIM(weather.class, "thundering", new Object[0]);
                }
                case cmi_user_weatherduration: {
                    if (!cMIUser.isOnline()) {
                        return "";
                    }
                    World world2 = cMIUser.getWorld();
                    long l = !world2.isThundering() ? world2.getWeatherDuration() : world2.getThunderDuration();
                    if (!world2.isThundering()) return CMITimeManager.to24hourShort((Long)(l * 50L));
                    l = world2.getThunderDuration();
                    return CMITimeManager.to24hourShort((Long)(l * 50L));
                }
                case cmi_user_baltop: {
                    int n = cMIUser.getEconomyAccount().getBalTopPosition();
                    if (n != 0) return String.valueOf(n);
                    this.plugin.getEconomyManager().getBalTopMap();
                    return String.valueOf(n);
                }
                case cmi_user_prefix: {
                    return CMIChatColor.translate((String)cMIUser.getPrefix());
                }
                case cmi_user_suffix: {
                    return CMIChatColor.translate((String)cMIUser.getSuffix());
                }
                case cmi_user_nameplate_prefix: {
                    return CMIChatColor.translate((String)cMIUser.getNamePlatePrefix());
                }
                case cmi_user_nameplate_suffix: {
                    return CMIChatColor.translate((String)cMIUser.getNamePlateSuffix());
                }
                case cmi_user_group: {
                    return cMIUser.getGroupName();
                }
                case cmi_user_tfly: {
                    long l;
                    if (cMIUser.getTfly() == 0L) {
                        l = 0L;
                        return String.valueOf(l);
                    }
                    l = (cMIUser.getTfly() - System.currentTimeMillis()) / 1000L;
                    return String.valueOf(l);
                }
                case cmi_user_tfly_formated: 
                case cmi_user_tfly_formatted: {
                    String string10;
                    if (cMIUser.getTfly() == 0L) {
                        string10 = CMITimeManager.to24hourShort((Long)0L);
                        return String.valueOf(string10);
                    }
                    string10 = CMITimeManager.to24hourShort((Long)(cMIUser.getTfly() - System.currentTimeMillis()));
                    return String.valueOf(string10);
                }
                case cmi_user_flightcharge: {
                    double d;
                    if (cMIUser.getFlightCharge() != null && cMIUser.getFlightCharge().getCharge() != null) {
                        d = (double)((int)(cMIUser.getFlightCharge().getCharge() * 100.0)) / 100.0;
                        return String.valueOf(d);
                    }
                    d = 0.0;
                    return String.valueOf(d);
                }
                case cmi_user_tgod: {
                    long l;
                    if (cMIUser.getTgod() == 0L) {
                        l = 0L;
                        return String.valueOf(l);
                    }
                    l = (cMIUser.getTgod() - System.currentTimeMillis()) / 1000L;
                    return String.valueOf(l);
                }
                case cmi_user_tgod_formated: 
                case cmi_user_tgod_formatted: {
                    String string11;
                    if (cMIUser.getTgod() == 0L) {
                        string11 = CMITimeManager.to24hourShort((Long)0L);
                        return String.valueOf(string11);
                    }
                    string11 = CMITimeManager.to24hourShort((Long)(cMIUser.getTgod() - System.currentTimeMillis()));
                    return String.valueOf(string11);
                }
                case cmi_user_votecount: {
                    return String.valueOf(cMIUser.getVotifierVotes());
                }
                case cmi_user_dailyvotecount: {
                    return String.valueOf(cMIUser.getDailyVoteCount());
                }
                case cmi_user_chatcolor: {
                    String string12;
                    if (cMIUser.getChatMessageFormat() == null) {
                        string12 = "";
                        return String.valueOf(string12);
                    }
                    string12 = cMIUser.getChatMessageFormat().toString();
                    return String.valueOf(string12);
                }
                case cmi_user_spy: {
                    return this.variable(cMIUser.getOptionState(PlayerOption.chatSpy));
                }
                case cmi_user_cmdspy: {
                    return this.variable(cMIUser.getOptionState(PlayerOption.cmdSpy));
                }
                case cmi_user_signspy: {
                    return this.variable(cMIUser.getOptionState(PlayerOption.signSpy));
                }
                case cmi_user_rank: 
                case cmi_user_rank_displayname: {
                    CMIRank cMIRank = cMIUser.getRank();
                    if (cMIRank == null) {
                        return "";
                    }
                    String string13 = cMIRank.getDisplayName();
                    return string13;
                }
                case cmi_user_rank_name: {
                    CMIRank cMIRank = cMIUser.getRank();
                    if (cMIRank == null) {
                        return "";
                    }
                    String string14 = cMIRank.getName();
                    return string14;
                }
                case cmi_user_nextranks: {
                    CMIRank cMIRank = cMIUser.getRank();
                    String string15 = "";
                    if (cMIRank == null) {
                        return "";
                    }
                    Iterator<CMIRank> iterator = cMIRank.getNextRanks().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return string15;
                        }
                        CMIRank cMIRank2 = iterator.next();
                        if (!string15.isEmpty()) {
                            string15 = String.valueOf(string15) + ChatColor.RESET + LC.info_ListSpliter.getLocale(new Object[0]);
                        }
                        string15 = String.valueOf(string15) + ChatColor.WHITE + cMIRank2.getDisplayName();
                    }
                }
                case cmi_user_nextvalidranks: {
                    CMIRank cMIRank = cMIUser.getRank();
                    if (cMIRank == null) {
                        return "";
                    }
                    String string16 = "";
                    Iterator<CMIRank> iterator = cMIRank.getNextValidRankUps(cMIUser).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return string16;
                        }
                        CMIRank cMIRank3 = iterator.next();
                        if (!string16.isEmpty()) {
                            string16 = String.valueOf(string16) + ChatColor.RESET + LC.info_ListSpliter.getLocale(new Object[0]);
                        }
                        string16 = String.valueOf(string16) + ChatColor.WHITE + cMIRank3.getDisplayName();
                    }
                }
                case cmi_user_canrankup: {
                    boolean bl;
                    CMIRank cMIRank = cMIUser.getRank();
                    if (cMIRank == null) {
                        return "";
                    }
                    List<CMIRank> list2 = cMIRank.getNextValidRankUps(cMIUser);
                    if (list2 == null) {
                        return "";
                    }
                    if (list2.isEmpty()) {
                        bl = false;
                        return this.variable(bl);
                    }
                    bl = true;
                    return this.variable(bl);
                }
                case cmi_user_country: {
                    return cMIUser.getCountry();
                }
                case cmi_user_city: {
                    return cMIUser.getCity();
                }
                case cmi_user_glow_code: {
                    if (cMIUser.getGlow() == null) {
                        return "";
                    }
                    if (!cMIUser.isOnline()) return CMIChatColor.getColor((String)cMIUser.getGlow().toString()).getBukkitColorCode();
                    Team team = CMI.getInstance().getSB().getPlayerTeam((OfflinePlayer)cMIUser.getPlayer());
                    if (team == null) return "";
                    if (team.getColor() != null) return CMIChatColor.getColor((String)team.getColor().toString()).getBukkitColorCode();
                    return "";
                }
                case cmi_user_glow_name: {
                    if (cMIUser.getGlow() == null) {
                        return "";
                    }
                    if (!cMIUser.isOnline()) return CMIText.firstToUpperCase((String)CMIChatColor.getColor((String)cMIUser.getGlow().toString()).toString());
                    Team team = CMI.getInstance().getSB().getPlayerTeam((OfflinePlayer)cMIUser.getPlayer());
                    if (team == null) return "";
                    if (team.getColor() != null) return CMIText.firstToUpperCase((String)CMIChatColor.getColor((String)team.getColor().toString()).getCleanName());
                    return "";
                }
                case cmi_user_name_colorcode: {
                    if (cMIUser.getNamePlateNameColor() == null) {
                        return "";
                    }
                    String string17 = CMIChatColor.getColor((String)cMIUser.getNamePlateNameColor().toString()).getBukkitColorCode();
                    return string17;
                }
                case cmi_user_country_code: {
                    return cMIUser.getCountryCode();
                }
                case cmi_user_jailed: {
                    return this.variable(cMIUser.isJailed());
                }
                case cmi_user_jailname: {
                    if (cMIUser.getCell() == null) {
                        return "";
                    }
                    String string18 = cMIUser.getCell().getJail().getName();
                    return string18;
                }
                case cmi_user_jailcell: {
                    if (cMIUser.getCell() == null) {
                        return "";
                    }
                    String string19 = String.valueOf(cMIUser.getCell().getId());
                    return string19;
                }
                case cmi_user_jailtime: {
                    if (!cMIUser.isJailed()) {
                        return null;
                    }
                    if (cMIUser.getJailedUntil() == null) return "";
                    if (cMIUser.getJailedUntil() < System.currentTimeMillis()) return "";
                    String string20 = CMITimeManager.to24hourShort((Long)(cMIUser.getJailedUntil() - System.currentTimeMillis()));
                    return string20;
                }
                case cmi_user_jailreason: {
                    if (cMIUser.getJailedUntil() == null) return "";
                    if (cMIUser.getJailedUntil() < System.currentTimeMillis()) return "";
                    if (cMIUser.getJailedReason() == null) return "";
                    String string21 = CMIChatColor.translate((String)cMIUser.getJailedReason());
                    return string21;
                }
                case cmi_user_jailedby: {
                    String string22;
                    if (cMIUser.getJailedUntil() == null) return "";
                    if (cMIUser.getJailedUntil() < System.currentTimeMillis()) {
                        return "";
                    }
                    if (cMIUser.getJailedBy() == null) {
                        string22 = LC.info_Console.getLocale(new Object[0]);
                        return string22;
                    }
                    if (CMIUser.getUser(cMIUser.getJailedBy()) == null) return "NA";
                    string22 = CMIUser.getUser(cMIUser.getJailedBy()).getDisplayName(false);
                    return string22;
                }
                case cmi_user_playtime_formatted: {
                    return CMITimeManager.to24hourShort((Long)cMIUser.getTotalPlayTime(false));
                }
                case cmi_user_playtime_hoursf: {
                    return String.valueOf(cMIUser.getTotalPlayTime(false) / 1000L / 60L / 60L);
                }
                case cmi_user_playtime_hours: {
                    return String.valueOf(cMIUser.getTotalPlayTime(false) / 1000L / 60L / 60L % 24L);
                }
                case cmi_user_playtime_hourst: {
                    return String.valueOf((double)((int)(100.0 * ((double)(cMIUser.getTotalPlayTime(false) / 1000L / 60L) / 60.0))) / 100.0);
                }
                case cmi_user_playtime_minutes: {
                    long l = cMIUser.getTotalPlayTime(false) / 1000L / 60L / 60L;
                    l = l * 1000L * 60L * 60L;
                    return String.valueOf((cMIUser.getTotalPlayTime(false) - l) / 1000L / 60L);
                }
                case cmi_user_playtime_minutest: {
                    return String.valueOf(cMIUser.getTotalPlayTime(false) / 1000L / 60L);
                }
                case cmi_user_playtime_seconds: {
                    long l = cMIUser.getTotalPlayTime(false) / 1000L / 60L;
                    l = l * 1000L * 60L;
                    return String.valueOf((cMIUser.getTotalPlayTime(false) - l) / 1000L);
                }
                case cmi_user_playtime_secondst: {
                    return String.valueOf(cMIUser.getTotalPlayTime(false) / 1000L);
                }
                case cmi_user_prewards_count: {
                    return String.valueOf(this.plugin.getPlayTimeRewardManager().getClaimableRewardCount(cMIUser));
                }
                case cmi_user_playtime_days: {
                    return String.valueOf(cMIUser.getTotalPlayTime(false) / 1000L / 60L / 60L / 24L);
                }
                case cmi_user_playtime_dayst: {
                    return String.valueOf((double)((int)(100.0 * ((double)(cMIUser.getTotalPlayTime(false) / 1000L / 60L) / 60.0 / 24.0))) / 100.0);
                }
                case cmi_user_online: {
                    return this.variable(cMIUser.isOnline());
                }
                case cmi_user_world_formatted: {
                    return CMIWorld.getWorldNameFormatted((World)cMIUser.getWorld());
                }
                case cmi_user_stats_$1: {
                    String[] stringArray;
                    List<String> list3 = cMIPlaceHolders.getComplexValues(string);
                    if (list3.isEmpty()) {
                        return "";
                    }
                    String string23 = list3.get(0);
                    String string24 = null;
                    if (string23.contains(":")) {
                        stringArray = string23.split(":", 2);
                        string24 = stringArray[1];
                        string23 = stringArray[0];
                    }
                    if ((stringArray = StatsManager.CMIStatistic.getByName(string23)) == null) {
                        return "";
                    }
                    Long l = cMIUser.getStatistic((StatsManager.CMIStatistic)stringArray, string24);
                    switch (stringArray.getType()) {
                        case Distance: {
                            return stats.convertDistance(l);
                        }
                        case Damage: 
                        case Number: {
                            return String.valueOf(l);
                        }
                        case Time: {
                            return CMITimeManager.to24hourShort((Long)l);
                        }
                    }
                    return String.valueOf(l);
                }
                case cmi_user_kitcd_$1: {
                    List<String> list4 = cMIPlaceHolders.getComplexValues(string);
                    if (list4.isEmpty()) {
                        return "";
                    }
                    Kit kit2 = this.plugin.getKitsManager().getKit(cMIUser.getPlayer(), list4.get(0), true);
                    string = "-";
                    if (kit2 == null) return string;
                    Long l = cMIUser.getKitUseTimeIn(kit2);
                    if (l == null) return string;
                    if (l == 0L) return string;
                    return CMITimeManager.to24hourShort((Long)cMIUser.getKitUseTimeIn(kit2));
                }
                case cmi_user_kit_available: {
                    if (player == null) {
                        return "";
                    }
                    Object object = cMIPlaceHolders.getCachedValue(player.getUniqueId());
                    if (object != null) return String.valueOf(object);
                    HashMap<String, List<Kit>> hashMap = this.plugin.getKitsManager().getValidKitsForPlayer(player, false);
                    if (hashMap == null) return String.valueOf(0);
                    int n = 0;
                    Iterator<Map.Entry<String, List<Kit>>> iterator = hashMap.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            cMIPlaceHolders.addCachedValue(player.getUniqueId(), String.valueOf(n), 5000);
                            return String.valueOf(n);
                        }
                        Map.Entry<String, List<Kit>> entry = iterator.next();
                        n += entry.getValue().size();
                    }
                }
                case cmi_user_kit_available_$1: {
                    List<String> list5 = cMIPlaceHolders.getComplexValues(string);
                    if (list5.isEmpty()) {
                        return "";
                    }
                    Kit kit3 = this.plugin.getKitsManager().getKit(cMIUser.getPlayer(), list5.get(0), true);
                    if (kit3 == null) return this.variable(false);
                    if (cMIUser.getLeftKitUseTimes(kit3) != 0) return this.variable(cMIUser.canUseKit(kit3));
                    if (PermissionsManager.CMIPerm.kit_bypass_onetimeuse.hasPermission((CommandSender)player, 5000L, new String[0])) return this.variable(cMIUser.canUseKit(kit3));
                    return this.variable(false);
                }
                case cmi_user_kit_hasaccess_$1: {
                    boolean bl;
                    List<String> list6 = cMIPlaceHolders.getComplexValues(string);
                    if (list6.isEmpty()) {
                        return "";
                    }
                    Kit kit4 = this.plugin.getKitsManager().getKit(cMIUser.getPlayer(), list6.get(0), false);
                    if (kit4 != null) {
                        bl = true;
                        return this.variable(bl);
                    }
                    bl = false;
                    return this.variable(bl);
                }
                case cmi_user_meta_$1: {
                    List<String> list7 = cMIPlaceHolders.getComplexValues(string);
                    if (!list7.isEmpty()) return cMIUser.getMeta().getValue(list7.get(0));
                    return "";
                }
                case cmi_user_metaint_$1: {
                    List<String> list8 = cMIPlaceHolders.getComplexValues(string);
                    if (list8.isEmpty()) {
                        return "";
                    }
                    try {
                        return String.valueOf((int)Double.parseDouble(cMIUser.getMeta().getValue(list8.get(0))));
                    }
                    catch (Exception exception) {
                        return cMIUser.getMeta().getValue(list8.get(0));
                    }
                }
                case cmi_user_rank_percent_$1: {
                    List<String> list9 = cMIPlaceHolders.getComplexValues(string);
                    if (list9.isEmpty()) {
                        return "";
                    }
                    CMIRank cMIRank = this.plugin.getRankManager().getRank(list9.get(0));
                    if (cMIRank != null) return String.valueOf((double)((int)(this.plugin.getRankManager().getOverallDonePercentage(cMIUser, cMIRank) * 100.0)) / 100.0);
                    return "";
                }
                case cmi_user_nextrankpercent: {
                    if (cMIUser.getRank() == null) {
                        return "";
                    }
                    List<CMIRank> list10 = cMIUser.getRank().getNextRanks();
                    if (list10.isEmpty()) {
                        return "";
                    }
                    CMIRank cMIRank = list10.get(0);
                    if (cMIRank != null) return String.valueOf((double)((int)(this.plugin.getRankManager().getOverallDonePercentage(cMIUser, cMIRank) * 100.0)) / 100.0);
                    return "";
                }
                case cmi_user_bungeeserver: {
                    if (!this.plugin.getBungeeCordManager().isBungeeCord()) {
                        return "";
                    }
                    BungeeCordServer bungeeCordServer = this.plugin.getBungeeCordManager().getPlayerServer(cMIUser.getUniqueId());
                    if (bungeeCordServer == null) {
                        return "";
                    }
                    String string25 = bungeeCordServer.getName();
                    return string25;
                }
                case cmi_user_holo_page_$1: {
                    List<String> list11 = cMIPlaceHolders.getComplexValues(string);
                    if (list11.isEmpty()) {
                        return "";
                    }
                    CMIHologram cMIHologram = this.plugin.getHologramManager().getByName(list11.get(0));
                    if (cMIHologram != null) return String.valueOf(cMIHologram.getPlayerPage(cMIUser.getUniqueId()));
                    return "";
                }
                case cmi_user_toggle_$1: 
                case cmi_user_togglename_$1: {
                    String string26;
                    List<String> list12 = cMIPlaceHolders.getComplexValues(string);
                    if (list12.isEmpty()) {
                        return "";
                    }
                    Boolean bl = null;
                    switch (list12.get(0).toLowerCase()) {
                        case "pay": {
                            bl = cMIUser.getOptionState(PlayerOption.acceptingMoney);
                            break;
                        }
                        case "tp": {
                            bl = cMIUser.getOptionState(PlayerOption.acceptingTPA);
                            break;
                        }
                        case "msg": {
                            bl = cMIUser.getOptionState(PlayerOption.acceptingPM);
                            break;
                        }
                        case "compass": {
                            bl = cMIUser.getOptionState(PlayerOption.bassBarCompass);
                            break;
                        }
                        case "sospy": 
                        case "chatSpy": {
                            bl = cMIUser.getOptionState(PlayerOption.chatSpy);
                            break;
                        }
                        case "sispy": 
                        case "signSpy": {
                            bl = cMIUser.getOptionState(PlayerOption.signSpy);
                            break;
                        }
                        case "cmdSpy": 
                        case "cospy": {
                            bl = cMIUser.getOptionState(PlayerOption.cmdSpy);
                            break;
                        }
                        case "tagsound": {
                            bl = cMIUser.getOptionState(PlayerOption.tagSound);
                            break;
                        }
                        case "chatbubble": {
                            bl = cMIUser.getOptionState(PlayerOption.chatbubble);
                            break;
                        }
                        case "schest": {
                            bl = silentChestListener.ToggledSilentChest.containsKey(cMIUser.getUniqueId());
                            break;
                        }
                        case "staffchat": {
                            bl = this.plugin.getChatFormatManager().getStaffChats().contains(cMIUser.getUniqueId());
                            break;
                        }
                        case "autoflightrecharge": {
                            bl = cMIUser.getFlightCharge().isAutoRecharge();
                            break;
                        }
                        case "notarget": {
                            bl = NoTargetListener.isInNoTargetPlayers(cMIUser.getUniqueId());
                            break;
                        }
                        case "totem": {
                            bl = cMIUser.getOptionState(PlayerOption.totemBossBar);
                            break;
                        }
                        case "hologram": {
                            bl = cMIUser.getOptionState(PlayerOption.visibleHolograms);
                            break;
                        }
                        case "shiftedit": {
                            bl = cMIUser.getOptionState(PlayerOption.shiftSignEdit);
                            break;
                        }
                        default: {
                            PlayerOption playerOption = PlayerOption.get(list12.get(0).toLowerCase());
                            if (playerOption == null) break;
                            bl = cMIUser.getOptionState(playerOption);
                        }
                    }
                    if (bl == null) {
                        return "";
                    }
                    if (cMIPlaceHolders.equals((Object)CMIPlaceHolders.cmi_user_togglename_$1)) {
                        return this.variable(bl);
                    }
                    if (bl.booleanValue()) {
                        string26 = String.valueOf(1);
                        return string26;
                    }
                    string26 = String.valueOf(0);
                    return string26;
                }
            }
        }
        if (player != null) {
            switch (cMIPlaceHolders) {
                case cmi_user_itemcount_$1: {
                    List<String> list13 = cMIPlaceHolders.getComplexValues(string);
                    if (list13.size() < 1) {
                        return "";
                    }
                    CMIMaterial cMIMaterial = CMIMaterial.get((String)list13.get(0));
                    if (cMIMaterial == CMIMaterial.NONE) {
                        return "";
                    }
                    int n = 0;
                    ItemStack[] itemStackArray = player.getInventory().getContents();
                    int n2 = itemStackArray.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            return String.valueOf(n);
                        }
                        ItemStack itemStack = itemStackArray[n3];
                        if (itemStack != null && CMIMaterial.get((ItemStack)itemStack) == cMIMaterial) {
                            n += itemStack.getAmount();
                        }
                        ++n3;
                    }
                }
                case cmi_user_maxhomes: {
                    return String.valueOf(this.plugin.getHomeManager().getMaxHomes(player));
                }
                case cmi_user_sneaking: {
                    return this.variable(player.isSneaking());
                }
                case cmi_user_ping: {
                    return String.valueOf(this.plugin.getReflectionManager().getPing(player));
                }
                case cmi_user_gamemode: {
                    return CMIText.firstToUpperCase((String)player.getGameMode().toString());
                }
                case cmi_user_op: {
                    return this.variable(player.isOp());
                }
                case cmi_user_canfly: {
                    return this.variable(player.getAllowFlight());
                }
                case cmi_user_flying: {
                    return this.variable(player.isFlying());
                }
                case player_world: 
                case cmi_player_world: {
                    return player.getWorld().getName();
                }
                case player_x: 
                case cmi_player_x: {
                    return String.valueOf(player.getLocation().getBlockX());
                }
                case player_y: 
                case cmi_player_y: {
                    return String.valueOf(player.getLocation().getBlockY());
                }
                case player_z: 
                case cmi_player_z: {
                    return String.valueOf(player.getLocation().getBlockZ());
                }
                case player_biome: 
                case cmi_player_biome: {
                    return String.valueOf(new CMIBiome(player.getLocation().getBlock().getBiome()).getBiomeName());
                }
                case cmi_iteminhand_displayname: {
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
                    if (cMIItemStack == null) return "N/A";
                    String string27 = cMIItemStack.getDisplayName();
                    return string27;
                }
                case cmi_iteminhand_realname: {
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
                    if (cMIItemStack == null) return "N/A";
                    String string28 = CMIChatColor.translate((String)cMIItemStack.getRealName());
                    return string28;
                }
                case cmi_iteminhand_type: {
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
                    if (cMIItemStack == null) return "AIR";
                    String string29 = cMIItemStack.getType().name();
                    return string29;
                }
                case cmi_iteminhand_itemdata: {
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(itemStack);
                    if (cMIItemStack == null) return "";
                    String string30 = String.valueOf(cMIItemStack.getData());
                    return string30;
                }
                case cmi_iteminhand_worth: {
                    String string31;
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(itemStack);
                    if (worthItem == null) {
                        string31 = CMILC.getIM("worth", "worthless", new Object[0]);
                        return string31;
                    }
                    string31 = this.plugin.getEconomyManager().format(worthItem.getSellPrice() * (double)itemStack.getAmount());
                    return string31;
                }
                case cmi_iteminhand_worthc: {
                    String string32;
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(itemStack);
                    if (worthItem == null) {
                        string32 = String.valueOf(0);
                        return string32;
                    }
                    string32 = String.valueOf(worthItem.getSellPrice() * (double)itemStack.getAmount());
                    return string32;
                }
                case cmi_iteminhand_worth_one: {
                    String string33;
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(itemStack);
                    if (worthItem == null) {
                        string33 = CMILC.getIM("worth", "worthless", new Object[0]);
                        return string33;
                    }
                    string33 = this.plugin.getEconomyManager().format(worthItem.getSellPrice());
                    return string33;
                }
                case cmi_iteminhand_worthc_one: {
                    String string34;
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        itemStack = new ItemStack(Material.AIR);
                    }
                    itemStack = itemStack.clone();
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(itemStack);
                    if (worthItem == null) {
                        string34 = String.valueOf(0);
                        return string34;
                    }
                    string34 = String.valueOf(worthItem.getSellPrice());
                    return string34;
                }
                case cmi_iteminhand_amount: {
                    ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(player);
                    if (itemStack == null) {
                        return String.valueOf(0);
                    }
                    itemStack = itemStack.clone();
                    return String.valueOf(itemStack.getAmount());
                }
                case cmi_iteminhand_durability: {
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(CMILib.getInstance().getReflectionManager().getItemInMainHand(player));
                    if (cMIItemStack != null) return String.valueOf(cMIItemStack.getMaxDurability() - cMIItemStack.getDurability());
                    return String.valueOf(0);
                }
                case cmi_user_maxperm_$1_$2: {
                    List<String> list14 = cMIPlaceHolders.getComplexValues(string);
                    if (list14.size() < 2) {
                        return "";
                    }
                    try {
                        Integer n;
                        String string35 = list14.get(0);
                        Integer n4 = n = Integer.valueOf(Integer.parseInt(list14.get(1)));
                        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(player, string35);
                        if (permissionInfo.getMaxValue() == null) return String.valueOf(n4);
                        n4 = permissionInfo.getMaxValue().intValue() > n4 ? permissionInfo.getMaxValue().intValue() : n4.intValue();
                        return String.valueOf(n4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return "";
                    }
                }
            }
        }
        switch (cMIPlaceHolders) {
            case cmi_p_$1_display_name: {
                List<String> list15 = cMIPlaceHolders.getComplexValues(string);
                if (list15.isEmpty()) {
                    return "";
                }
                cMIUser = CMIUser.getUser(list15.get(0));
                if (cMIUser != null) return cMIUser.getDisplayName();
                return "";
            }
            case cmi_user_uuid_$1: {
                List<String> list16 = cMIPlaceHolders.getComplexValues(string);
                if (list16.isEmpty()) {
                    return "";
                }
                cMIUser = CMIUser.getUser(list16.get(0));
                if (cMIUser != null) return cMIUser.getUniqueId().toString();
                return "";
            }
            case cmi_afk_count: {
                return String.valueOf(this.plugin.getAfkManager().getAfkPlayerCount());
            }
            case cmi_maintenance_state: {
                return this.variable(this.plugin.getConfigManager().isMaintenance());
            }
            case cmi_maintenance_message: {
                if (this.plugin.getConfigManager().getMaintenanceMessage() == null) {
                    return "";
                }
                String string36 = CMIChatColor.translate((String)this.plugin.getConfigManager().getMaintenanceMessage());
                return string36;
            }
            case cmi_color_$1: {
                List<String> list17 = cMIPlaceHolders.getComplexValues(string);
                if (list17.isEmpty()) {
                    return "";
                }
                try {
                    return CMIChatColor.translate((String)CMIText.replaceUnderScoreSpace((String)list17.get(0)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_tps_$1_colored: {
                List<String> list18 = cMIPlaceHolders.getComplexValues(string);
                if (list18.isEmpty()) {
                    return "";
                }
                try {
                    Integer n = Integer.parseInt(list18.get(0));
                    double d = this.plugin.getLagMeter().getTPS(n * 20);
                    return String.valueOf(this.plugin.getUtilManager().getTpsColor(d).getBukkitColorCode()) + String.valueOf((double)((int)(d * 10.0)) / 10.0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_tps_1: {
                return String.valueOf((double)((int)(this.plugin.getLagMeter().getTPS(20) * 10.0)) / 10.0);
            }
            case cmi_tps_60: {
                return String.valueOf((double)((int)(this.plugin.getLagMeter().getTPS(1200) * 10.0)) / 10.0);
            }
            case cmi_tps_300: {
                return String.valueOf((double)((int)(this.plugin.getLagMeter().getTPS(12000) * 10.0)) / 10.0);
            }
            case server_online: 
            case cmi_server_online: {
                int n = 0;
                Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return String.valueOf(n);
                    }
                    Player player2 = (Player)iterator.next();
                    if (player != null && !player.canSee(player2) || this.plugin.getPlayerManager().getUser(player2).isVanished()) continue;
                    ++n;
                }
            }
            case cmi_server_uptime: {
                return CMITimeManager.to24hourShort((Long)(System.currentTimeMillis() - CMI.getInstance().getServerStartupTime()));
            }
            case cmi_chat_range: {
                int n = this.plugin.getChatFormatManager().getChatGeneralRange(null);
                if (n == 0) {
                    return "9999+";
                }
                if (n >= 0) return String.valueOf(n);
                return "-";
            }
            case cmi_server_uptime_seconds: {
                return String.valueOf((System.currentTimeMillis() - CMI.getInstance().getServerStartupTime()) / 1000L);
            }
            case cmi_server_worlds: {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = Bukkit.getWorlds().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return stringBuilder.toString();
                    }
                    World world3 = (World)iterator.next();
                    if (!stringBuilder.toString().isEmpty()) {
                        stringBuilder.append(LC.info_ListSpliter.getLocale(new Object[0]));
                    }
                    stringBuilder.append(world3.getName());
                }
            }
            case cmi_chatmute_time: {
                if (this.plugin.getChatFormatManager().getChatMutedUntil() == null) {
                    return "";
                }
                long l = this.plugin.getChatFormatManager().getChatMutedUntil() - System.currentTimeMillis();
                if (l >= 0L) return CMITimeManager.to24hourShort((Long)l);
                return "";
            }
            case cmi_chatmute_reason: {
                if (this.plugin.getChatFormatManager().getChatMutedUntil() == null) {
                    return "";
                }
                long l = this.plugin.getChatFormatManager().getChatMutedUntil() - System.currentTimeMillis();
                if (l < 0L) {
                    return "";
                }
                String string37 = this.plugin.getChatFormatManager().getChatMutedReason();
                if (string37 != null) return string37;
                return "";
            }
            case cmi_server_vanished: {
                return String.valueOf(this.plugin.getVanishManager().getVanishedOnlineList().size());
            }
            case cmi_server_users: {
                return String.valueOf(this.plugin.getPlayerManager().getTotalUserCount());
            }
            case server_online_$1: 
            case cmi_server_online_$1: {
                int n = 0;
                List<String> list19 = cMIPlaceHolders.getComplexValues(string);
                if (list19.isEmpty()) {
                    return "";
                }
                String string38 = list19.get(0);
                Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return String.valueOf(n);
                    }
                    Player player3 = (Player)iterator.next();
                    if (player != null && !player.canSee(player3) || this.plugin.getPlayerManager().getUser(player3).isVanished() || !player3.getWorld().getName().replace("_", "").equalsIgnoreCase(string38)) continue;
                    ++n;
                }
            }
            case server_max_players: 
            case cmi_server_max_players: {
                return String.valueOf(Bukkit.getMaxPlayers());
            }
            case server_unique_joins: 
            case cmi_server_unique_joins: {
                return String.valueOf(Bukkit.getOfflinePlayers().length);
            }
            case onlineplayers_names: 
            case cmi_onlineplayers_names: {
                String string39 = "";
                Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return string39;
                    }
                    Player player4 = (Player)iterator.next();
                    if (player != null && !player.canSee(player4) || this.plugin.getPlayerManager().getUser(player4).isVanished()) continue;
                    if (!string39.isEmpty()) {
                        string39 = String.valueOf(string39) + ", ";
                    }
                    string39 = String.valueOf(string39) + player4.getName();
                }
            }
            case onlineplayers_displaynames: 
            case cmi_onlineplayers_displaynames: {
                String string40 = "";
                Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return string40;
                    }
                    Player player5 = (Player)iterator.next();
                    if (player != null && !player.canSee(player5) || this.plugin.getPlayerManager().getUser(player5).isVanished()) continue;
                    if (!string40.isEmpty()) {
                        string40 = String.valueOf(string40) + ChatColor.RESET + ", ";
                    }
                    CMIUser cMIUser2 = this.plugin.getPlayerManager().getUser(player5);
                    string40 = String.valueOf(string40) + ChatColor.WHITE + cMIUser2.getDisplayName(false);
                }
            }
            case cmi_random_player_name: {
                Player player6;
                this.lastRandomPlayer = player6 = this.plugin.getUtilManager().getRandomOnlinePlayer();
                if (player6 == null) {
                    return "";
                }
                String string41 = player6.getName();
                return string41;
            }
            case cmi_lastrandom_player_name: {
                if (this.lastRandomPlayer == null) {
                    return "";
                }
                String string42 = this.lastRandomPlayer.getName();
                return string42;
            }
            case cmi_equation_$1: {
                List<String> list20 = cMIPlaceHolders.getComplexValues(string);
                if (list20.isEmpty()) {
                    return "";
                }
                try {
                    Parser parser = new Parser(list20.get(0));
                    return String.valueOf((double)((int)(parser.getValue() * 100.0)) / 100.0);
                }
                catch (Throwable throwable) {
                    CMIMessages.consoleMessage((String)("&e[CMI] Invalid equation placeholder  " + cMIPlaceHolders.getFull() + " -> " + list20.get(0)));
                    return "";
                }
            }
            case cmi_equationint_$1: {
                List<String> list21 = cMIPlaceHolders.getComplexValues(string);
                if (list21.isEmpty()) {
                    return "";
                }
                try {
                    Parser parser = new Parser(list21.get(0));
                    return String.valueOf((int)parser.getValue());
                }
                catch (Throwable throwable) {
                    CMIMessages.consoleMessage((String)("&e[CMI] Invalid equation placeholder  " + cMIPlaceHolders.getFull() + " -> " + list21.get(0)));
                    throwable.printStackTrace();
                    return "";
                }
            }
            case cmi_worth_buy_$1: 
            case cmi_worthc_buy_$1: {
                List<String> list22 = cMIPlaceHolders.getComplexValues(string);
                if (list22.isEmpty()) {
                    return "";
                }
                try {
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(list22.get(0));
                    if (cMIItemStack == null) {
                        return "";
                    }
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(cMIItemStack.getItemStack());
                    if (worthItem == null) {
                        return "";
                    }
                    if (!cMIPlaceHolders.equals((Object)CMIPlaceHolders.cmi_worthc_buy_$1)) return this.plugin.getEconomyManager().format(worthItem.getBuyPrice() * (double)cMIItemStack.getAmount());
                    return String.valueOf(worthItem.getBuyPrice() * (double)cMIItemStack.getAmount());
                }
                catch (Exception exception) {
                    CMIMessages.consoleMessage((String)("&e[CMI] Invalid equation placeholder  " + cMIPlaceHolders.getFull() + " -> " + list22.get(0)));
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_schedule_nextin_$1: {
                List<String> list23 = cMIPlaceHolders.getComplexValues(string);
                if (list23.isEmpty()) {
                    return "";
                }
                try {
                    Schedule schedule2 = this.plugin.getSchedulerManager().getSchedule(list23.get(0), false);
                    if (schedule2 == null) {
                        return "";
                    }
                    long l = schedule2.getPerformOn() - System.currentTimeMillis();
                    if (l >= 0L) return CMITimeManager.to24hourShort((Long)l);
                    return "";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_schedule_endat_$1: {
                List<String> list24 = cMIPlaceHolders.getComplexValues(string);
                if (list24.isEmpty()) {
                    return "";
                }
                try {
                    Schedule schedule3 = this.plugin.getSchedulerManager().getSchedule(list24.get(0), false);
                    if (schedule3 == null) {
                        return "";
                    }
                    long l = schedule3.getPerformOn() - System.currentTimeMillis();
                    if (l < 0L) {
                        return "";
                    }
                    double d = (double)schedule3.getLastPerformedOn().longValue() + schedule3.getTotalCommandDelay() * 1000.0 - (double)System.currentTimeMillis();
                    if (d < 0.0) {
                        return "";
                    }
                    l = (long)d;
                    return CMITimeManager.to24hourShort((Long)l);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_baltop_name_$1: {
                List<String> list25 = cMIPlaceHolders.getComplexValues(string);
                if (list25.isEmpty()) {
                    return "";
                }
                try {
                    int n = Integer.parseInt(list25.get(0));
                    SortedMap<Double, UUID> sortedMap = this.plugin.getEconomyManager().getBalTopMap();
                    if (this.plugin.getEconomyManager().isRecalculatingTop() == null) return "";
                    if (sortedMap.isEmpty()) return "";
                    if (sortedMap.size() < n) {
                        return "";
                    }
                    int n5 = 0;
                    SortedMap<Double, UUID> sortedMap2 = sortedMap;
                    synchronized (sortedMap2) {
                        Iterator<UUID> iterator = sortedMap.values().iterator();
                        do {
                            CMIUser cMIUser3;
                            if (!iterator.hasNext()) return "";
                            UUID uUID2 = iterator.next();
                            if (++n5 != n || (cMIUser3 = this.plugin.getPlayerManager().getUser(uUID2)) == null) continue;
                            return cMIUser3.getDisplayName(false);
                        } while (n5 <= n);
                        return "";
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return "";
            }
            case cmi_playtimetop_name_$1: {
                List<String> list26 = cMIPlaceHolders.getComplexValues(string);
                if (list26.isEmpty()) {
                    return "";
                }
                try {
                    if (!this.plugin.getStatsManager().isDataLoaded()) {
                        this.plugin.getStatsManager().loadStats(null, null);
                        return "";
                    }
                    int n = Integer.parseInt(list26.get(0));
                    CMIUser cMIUser4 = this.plugin.getStatsManager().getUserByPlace(n);
                    if (cMIUser4 != null) return cMIUser4.getDisplayName(false);
                    return "";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_playtimetop_time_$1: {
                List<String> list27 = cMIPlaceHolders.getComplexValues(string);
                if (list27.isEmpty()) {
                    return "";
                }
                if (!this.plugin.getStatsManager().isDataLoaded()) {
                    this.plugin.getStatsManager().loadStats(null, null);
                    return "";
                }
                try {
                    int n = Integer.parseInt(list27.get(0));
                    Long l = this.plugin.getStatsManager().getTimeByPlace(n);
                    if (l != null) return CMIPlayTimeFormat.formatPlaytimePlaceholder(l);
                    return "";
                }
                catch (Exception exception) {
                    this.informFailed(string);
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_weather_$1: {
                List<String> list28 = cMIPlaceHolders.getComplexValues(string);
                if (list28.isEmpty()) {
                    return "";
                }
                World world4 = this.plugin.getUtilManager().getWorld(list28.get(0));
                if (world4 == null) {
                    return "";
                }
                String string43 = world4.hasStorm() ? CMILC.getIM(weather.class, "rainy", new Object[0]) : CMILC.getIM(weather.class, "sunny", new Object[0]);
                if (!world4.isThundering()) return string43;
                return CMILC.getIM(weather.class, "thundering", new Object[0]);
            }
            case cmi_weatherduration_$1: {
                List<String> list29 = cMIPlaceHolders.getComplexValues(string);
                if (list29.isEmpty()) {
                    return "";
                }
                World world5 = this.plugin.getUtilManager().getWorld(list29.get(0));
                if (world5 == null) {
                    return "";
                }
                long l = world5.getWeatherDuration();
                if (!world5.isThundering()) return CMITimeManager.to24hourShort((Long)(l * 50L));
                l = world5.getThunderDuration();
                return CMITimeManager.to24hourShort((Long)(l * 50L));
            }
            case cmi_votetop_$1: {
                List<String> list30 = cMIPlaceHolders.getComplexValues(string);
                if (list30.isEmpty()) {
                    return "";
                }
                try {
                    int n = Integer.parseInt(list30.get(0));
                    TreeMap<Double, CMIUser> treeMap = new TreeMap<Double, CMIUser>((SortedMap<Double, CMIUser>)this.plugin.getVotifierManager().getTop());
                    int n6 = 0;
                    Iterator iterator = treeMap.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return "";
                        }
                        Map.Entry entry = iterator.next();
                        if (((CMIUser)entry.getValue()).getName(false) == null) continue;
                        if (++n6 == n) {
                            return ((CMIUser)entry.getValue()).getDisplayName(false);
                        }
                        if (n6 > n) break;
                    }
                    return "";
                }
                catch (Exception exception) {
                    this.informFailed(string);
                }
                return "";
            }
            case cmi_votetopcount_$1: {
                List<String> list31 = cMIPlaceHolders.getComplexValues(string);
                if (list31.isEmpty()) {
                    return "";
                }
                try {
                    int n = Integer.parseInt(list31.get(0));
                    TreeMap<Double, CMIUser> treeMap = new TreeMap<Double, CMIUser>((SortedMap<Double, CMIUser>)this.plugin.getVotifierManager().getTop());
                    int n7 = 0;
                    Iterator iterator = treeMap.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return "";
                        }
                        Map.Entry entry = iterator.next();
                        if (((CMIUser)entry.getValue()).getName(false) == null) continue;
                        if (++n7 == n) {
                            return String.valueOf(((Double)entry.getKey()).intValue());
                        }
                        if (n7 > n) break;
                    }
                    return "";
                }
                catch (Exception exception) {
                    this.informFailed(string);
                }
                return "";
            }
            case cmi_bungee_total_$1: {
                List<String> list32 = cMIPlaceHolders.getComplexValues(string);
                if (list32.isEmpty()) {
                    return "0";
                }
                try {
                    String string44 = list32.get(0);
                    BungeeCordServer bungeeCordServer = this.plugin.getBungeeCordManager().getServer(string44);
                    if (bungeeCordServer == null) {
                        return "0";
                    }
                    bungeeCordServer.update();
                    return String.valueOf(bungeeCordServer.getMaxPlayers());
                }
                catch (Exception exception) {
                    this.informFailed(string);
                    return "0";
                }
            }
            case cmi_bungee_current_$1: {
                List<String> list33 = cMIPlaceHolders.getComplexValues(string);
                if (list33.size() < 1) {
                    return "0";
                }
                try {
                    String string45 = list33.get(0);
                    BungeeCordServer bungeeCordServer = this.plugin.getBungeeCordManager().getServer(string45);
                    if (bungeeCordServer == null) {
                        return "0";
                    }
                    bungeeCordServer.update();
                    if (bungeeCordServer.isOnline()) return String.valueOf(bungeeCordServer.getCurrentPlayers());
                    return "0";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "0";
                }
            }
            case cmi_bungee_motd_$1: {
                List<String> list34 = cMIPlaceHolders.getComplexValues(string);
                if (list34.size() < 1) {
                    return "";
                }
                try {
                    String string46 = list34.get(0);
                    BungeeCordServer bungeeCordServer = this.plugin.getBungeeCordManager().getServer(string46);
                    if (bungeeCordServer == null) {
                        return "";
                    }
                    bungeeCordServer.update();
                    return bungeeCordServer.getMotd();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_bungee_onlinestatus_$1: {
                List<String> list35 = cMIPlaceHolders.getComplexValues(string);
                if (list35.size() < 1) {
                    return "";
                }
                try {
                    String string47;
                    String string48 = list35.get(0);
                    BungeeCordServer bungeeCordServer = this.plugin.getBungeeCordManager().getServer(string48);
                    if (bungeeCordServer == null) {
                        return "";
                    }
                    bungeeCordServer.update();
                    if (bungeeCordServer.isOnline()) {
                        string47 = LC.info_bungee_Online.getLocale(new Object[0]);
                        return string47;
                    }
                    string47 = LC.info_bungee_Offline.getLocale(new Object[0]);
                    return string47;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_baltop_money_$1: 
            case cmi_baltop_shortmoney_$1: {
                List<String> list36 = cMIPlaceHolders.getComplexValues(string);
                if (list36.isEmpty()) {
                    return "0";
                }
                try {
                    int n = Integer.parseInt(list36.get(0));
                    SortedMap<Double, UUID> sortedMap = this.plugin.getEconomyManager().getBalTopMap();
                    if (this.plugin.getEconomyManager().isRecalculatingTop() == null) return "0";
                    if (sortedMap.isEmpty()) {
                        return "0";
                    }
                    int n8 = 0;
                    SortedMap<Double, UUID> sortedMap3 = sortedMap;
                    synchronized (sortedMap3) {
                        Iterator<Map.Entry<Double, UUID>> iterator = sortedMap.entrySet().iterator();
                        do {
                            if (!iterator.hasNext()) return "";
                            Map.Entry<Double, UUID> entry = iterator.next();
                            if (++n8 != n) continue;
                            if (cMIPlaceHolders != CMIPlaceHolders.cmi_baltop_shortmoney_$1) return this.plugin.getEconomyManager().format(entry.getKey());
                            return this.plugin.getPlayerManager().getUser(entry.getValue()).getEconomyAccount().getFormatedBalance(null, true);
                        } while (n8 <= n);
                        return "";
                    }
                }
                catch (Exception exception) {
                    this.informFailed(string);
                }
                return "";
            }
            case cmi_worth_sell_$1: 
            case cmi_worthc_sell_$1: {
                List<String> list37 = cMIPlaceHolders.getComplexValues(string);
                if (list37.size() < 1) {
                    return "";
                }
                try {
                    CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(list37.get(0));
                    if (cMIItemStack == null) {
                        return "";
                    }
                    WorthItem worthItem = this.plugin.getWorthManager().getWorth(cMIItemStack.getItemStack());
                    if (worthItem == null) {
                        return "";
                    }
                    if (!cMIPlaceHolders.equals((Object)CMIPlaceHolders.cmi_worthc_sell_$1)) return this.plugin.getEconomyManager().format(worthItem.getSellPrice() * (double)cMIItemStack.getAmount());
                    return String.valueOf(worthItem.getSellPrice() * (double)cMIItemStack.getAmount());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }
            case cmi_random_$1_$2: {
                List<String> list38 = cMIPlaceHolders.getComplexValues(string);
                if (list38.size() < 2) {
                    return "";
                }
                try {
                    int n = Integer.parseInt(list38.get(0));
                    int n9 = Integer.parseInt(list38.get(1));
                    int n10 = n9 - n + 1;
                    n10 = n10 < 0 ? -n10 : n10;
                    int n11 = this.random.nextInt(n10);
                    String string49 = String.valueOf(n11 + n);
                    this.randomCache.put(cMIUser == null || cMIUser.getName(false) == null ? "server" : cMIUser.getName(false).toLowerCase(), string49);
                    return String.valueOf(string49);
                }
                catch (Exception exception) {
                    return "";
                }
            }
            case cmi_lastrandom_$1: {
                List<String> list39 = cMIPlaceHolders.getComplexValues(string);
                if (list39.size() < 1) {
                    return "";
                }
                String string50 = this.randomCache.get(list39.get(0).toLowerCase());
                if (string50 == null) {
                    return "";
                }
                String string51 = string50;
                return string51;
            }
            case cmi_jail_username_$1_$2: {
                List<String> list40 = cMIPlaceHolders.getComplexValues(string);
                if (list40.size() < 2) {
                    return "";
                }
                String string52 = list40.get(0);
                String string53 = list40.get(1);
                CMIJail cMIJail = this.plugin.getJailManager().getByName(string52);
                if (cMIJail == null) {
                    return "";
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string53);
                }
                catch (Exception exception) {
                    return "";
                }
                CMIJailCell cMIJailCell = cMIJail.getCells().get(n);
                if (cMIJailCell == null) return "";
                if (cMIJailCell.getJailed().isEmpty()) {
                    return "";
                }
                UUID uUID3 = null;
                Iterator<UUID> iterator = cMIJailCell.getJailed().iterator();
                while (true) {
                    UUID uUID4;
                    if (!iterator.hasNext()) {
                        if (uUID3 != null) break;
                        return "";
                    }
                    uUID3 = uUID4 = iterator.next();
                }
                CMIUser cMIUser5 = this.plugin.getPlayerManager().getUser(uUID3);
                if (cMIUser5.isJailed()) return cMIUser5.getDisplayName(false);
                return "";
            }
            case cmi_jail_reason_$1_$2: {
                List<String> list41 = cMIPlaceHolders.getComplexValues(string);
                if (list41.size() < 2) {
                    return "";
                }
                String string54 = list41.get(0);
                String string55 = list41.get(1);
                CMIJail cMIJail = this.plugin.getJailManager().getByName(string54);
                if (cMIJail == null) {
                    return "";
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string55);
                }
                catch (Exception exception) {
                    return "";
                }
                CMIJailCell cMIJailCell = cMIJail.getCells().get(n);
                if (cMIJailCell == null) return "";
                if (cMIJailCell.getJailed().isEmpty()) {
                    return "";
                }
                UUID uUID5 = null;
                Iterator<UUID> iterator = cMIJailCell.getJailed().iterator();
                while (true) {
                    UUID uUID6;
                    if (!iterator.hasNext()) {
                        if (uUID5 != null) break;
                        return "";
                    }
                    uUID5 = uUID6 = iterator.next();
                }
                CMIUser cMIUser6 = this.plugin.getPlayerManager().getUser(uUID5);
                if (!cMIUser6.isJailed()) {
                    return "";
                }
                if (cMIUser6.getJailedReason() == null) {
                    return "";
                }
                String string56 = cMIUser6.getJailedReason();
                return string56;
            }
            case cmi_jail_time_$1_$2: {
                List<String> list42 = cMIPlaceHolders.getComplexValues(string);
                if (list42.size() < 2) {
                    return "";
                }
                String string57 = list42.get(0);
                String string58 = list42.get(1);
                CMIJail cMIJail = this.plugin.getJailManager().getByName(string57);
                if (cMIJail == null) {
                    return "";
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string58);
                }
                catch (Exception exception) {
                    return "";
                }
                CMIJailCell cMIJailCell = cMIJail.getCells().get(n);
                if (cMIJailCell == null) return "";
                if (cMIJailCell.getJailed().isEmpty()) {
                    return "";
                }
                UUID uUID7 = null;
                Iterator<UUID> iterator = cMIJailCell.getJailed().iterator();
                while (true) {
                    UUID uUID8;
                    if (!iterator.hasNext()) {
                        if (uUID7 != null) break;
                        return "";
                    }
                    uUID7 = uUID8 = iterator.next();
                }
                CMIUser cMIUser7 = this.plugin.getPlayerManager().getUser(uUID7);
                if (cMIUser7.isJailed()) return CMITimeManager.to24hourShort((Long)(cMIUser7.getJailedUntil() - System.currentTimeMillis()));
                return "";
            }
            case server_time_$1: 
            case cmi_server_time_$1: {
                List<String> list43 = cMIPlaceHolders.getComplexValues(string);
                if (!list43.isEmpty()) return new SimpleDateFormat(list43.get(0)).format(Calendar.getInstance().getTime());
                return "";
            }
            case server_time_$1_$2: 
            case cmi_server_time_$1_$2: {
                List<String> list44 = cMIPlaceHolders.getComplexValues(string);
                if (list44.isEmpty()) {
                    return "";
                }
                if (list44.size() < 2) {
                    return "";
                }
                try {
                    TimeZone timeZone = TimeZone.getTimeZone(list44.get(1));
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(list44.get(0));
                    simpleDateFormat.setTimeZone(timeZone);
                    return simpleDateFormat.format(Calendar.getInstance().getTime());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return "";
                }
            }
            case world_time12_$1: 
            case cmi_world_time12_$1: {
                List<String> list45 = cMIPlaceHolders.getComplexValues(string);
                if (list45.isEmpty()) {
                    return "";
                }
                World world6 = this.plugin.getUtilManager().getWorld(list45.get(0));
                if (world6 != null) return CMITimeManager.to12hour((Long)world6.getTime());
                return "";
            }
            case world_time24_$1: 
            case cmi_world_time24_$1: {
                List<String> list46 = cMIPlaceHolders.getComplexValues(string);
                if (list46.isEmpty()) {
                    return "";
                }
                World world7 = this.plugin.getUtilManager().getWorld(list46.get(0));
                if (world7 != null) return CMITimeManager.to24hour((Long)world7.getTime());
                return "";
            }
        }
        return null;
    }

    private void informFailed(String string) {
        this.plugin.consoleMessage("&cInccorrect placeholder format for " + string);
    }

    private String variable(Boolean bl) {
        return bl != false ? LC.info_variables_True.getLocale(new Object[0]) : LC.info_variables_False.getLocale(new Object[0]);
    }

    public static enum CMIPlaceHolders {
        cmi_user_charges_left("Remaining count of spawner charges", new String[0]),
        cmi_user_charges_max("Maximum allowed amount of spawner charges", new String[0]),
        cmi_user_charges_time("Time until next spawner charge", new String[0]),
        cmi_user_charges_cooldown("Spawner charge cooldown", new String[0]),
        cmi_user_display_name("Formatted players display name", new String[0]),
        cmi_p_$1_display_name("Formatted target players display name", "playerName"),
        cmi_user_cleannickname("Players nick name if set or players name otherwise. No color codes", new String[0]),
        cmi_user_nickname("Players nick name if set or players name otherwise", new String[0]),
        cmi_user_name("Original players name", new String[0]),
        cmi_user_uuid("Player uuid", new String[0]),
        cmi_user_uuid_$1("Player uuid by name", "playerName"),
        cmi_user_deathloc("Players last death location", new String[0]),
        cmi_user_backloc("Players back location", new String[0]),
        cmi_user_cuffed("Identification if player is cuffed", new String[0]),
        cmi_user_muted("Identification if player is muted", new String[0]),
        cmi_user_inpvp("Identification if player is in pvp mode", new String[0]),
        cmi_user_god("Identification if player has god mode enabled", new String[0]),
        cmi_user_sneaking("Identification if player is sneaking", new String[0]),
        cmi_user_mail_count("Amount of mails player have", new String[0]),
        cmi_user_warning_count("Amount of warnings player have", new String[0]),
        cmi_user_warning_points("Amount of warning points player have", new String[0]),
        cmi_user_afk("Afk state", new String[0]),
        cmi_user_afk_symbol("Afk symbool", new String[0]),
        cmi_user_afk_msg("Afk message if present", new String[0]),
        cmi_user_afk_for("Time for how long player is in afk mode", new String[0]),
        cmi_user_afk_in("Time when player enters auto afk mode", new String[0]),
        cmi_user_spy("Spy state", new String[0]),
        cmi_user_cmdspy("Command spy state", new String[0]),
        cmi_user_signspy("Sign spy state", new String[0]),
        cmi_user_joinedcounter("Indication if player is joined counter", new String[0]),
        cmi_user_banned("Indication if player is banned", new String[0]),
        cmi_user_maxhomes("Max amount of homes player can have", new String[0]),
        cmi_user_homeamount("Amount of homes player has", new String[0]),
        cmi_user_homelist("List of players homes", new String[0]),
        cmi_user_missingexp("Missing exp amount until next level", new String[0]),
        cmi_user_missingexpp("Missing exp in percentage until next level", new String[0]),
        cmi_user_exp("Current exp amount for current level", new String[0]),
        cmi_user_expp("Current exp in percentage for current level", new String[0]),
        cmi_user_totalexp("Total amount of exp player have", new String[0]),
        cmi_user_level("Players level", new String[0]),
        cmi_user_ping("Ping", new String[0]),
        cmi_user_gamemode("Game mode", new String[0]),
        cmi_user_op("OP state", new String[0]),
        cmi_user_pweather("Player weather", new String[0]),
        cmi_user_weather("Weather at players world", new String[0]),
        cmi_user_weatherduration("Weather duration at players world", new String[0]),
        cmi_user_canfly("Players ability to fly", new String[0]),
        cmi_user_flying("Is player currently flying", new String[0]),
        cmi_user_vanished_symbol("Vanish symbol", new String[0]),
        cmi_user_balance_formated(true),
        cmi_user_balance_formatted("Formatted users balance", new String[0]),
        cmi_user_balance("Clean users balance", new String[0]),
        cmi_user_prefix("Players prefix set by permission plugin", new String[0]),
        cmi_user_suffix("Players suffix set by permission plugin", new String[0]),
        cmi_user_group("Players main permission group name", new String[0]),
        cmi_user_nameplate_prefix("Players nameplate prefix", new String[0]),
        cmi_user_nameplate_suffix("Players nameplate suffix", new String[0]),
        cmi_user_tfly("Left temp fly amount in seconds", new String[0]),
        cmi_user_tfly_formated(true),
        cmi_user_tfly_formatted("Formatted temp fly amount", new String[0]),
        cmi_user_flightcharge("Flight charge amount", new String[0]),
        cmi_user_tgod("Time in seconds for temp god mode", new String[0]),
        cmi_user_tgod_formated(true),
        cmi_user_tgod_formatted("Formatted time for temp god mode", new String[0]),
        cmi_user_votecount("Amount of votes", new String[0]),
        cmi_user_dailyvotecount("Daily vote count", new String[0]),
        cmi_user_chatcolor("Player chatcolor", new String[0]),
        cmi_user_rank(true),
        cmi_user_rank_displayname("Current rank display name", new String[0]),
        cmi_user_rank_name("Current rank name", new String[0]),
        cmi_user_nextranks("List of next ranks", new String[0]),
        cmi_user_nextrankpercent("Percentage done for next rank", new String[0]),
        cmi_user_nextvalidranks("Rank list to which player can rank up to", new String[0]),
        cmi_user_canrankup("Returns true if player can rank up", new String[0]),
        cmi_user_country("Users country from geoip feature. Example: Germany", new String[0]),
        cmi_user_country_code("Users country code from geoip feature. Example: UK", new String[0]),
        cmi_user_city("Users city name from geoip feature", new String[0]),
        cmi_user_name_colorcode("Bukkit color code from nameplate command and -c: variable", new String[0]),
        cmi_user_glow_code("Bukkit color code from glow command.", new String[0]),
        cmi_user_glow_name("Color name from glow command. Example: Red", new String[0]),
        cmi_user_jailed("True or false if player is jailed", new String[0]),
        cmi_user_jailname("Jail name user currently is in. Example: Prison", new String[0]),
        cmi_user_jailcell("Jail cell id user currently is in. Example: 1", new String[0]),
        cmi_user_jailtime("Left jail time. Example: 1hour 5minutes", new String[0]),
        cmi_user_jailreason("Jailed reason", new String[0]),
        cmi_user_jailedby("Jailer name", new String[0]),
        cmi_user_bungeeserver("Bungee server name", new String[0]),
        cmi_user_playtime_formatted("Formatted playtime", new String[0]),
        cmi_user_playtime_days("Playtime in days", new String[0]),
        cmi_user_playtime_dayst("Playtime in days with fraction", new String[0]),
        cmi_user_playtime_hours("Playtime in hours", new String[0]),
        cmi_user_playtime_hoursf("Total playtime in hours", new String[0]),
        cmi_user_playtime_hourst("Total playtime in hours with fraction", new String[0]),
        cmi_user_playtime_minutes("Playtime in minutes", new String[0]),
        cmi_user_playtime_minutest("Total playtime in minutes", new String[0]),
        cmi_user_playtime_seconds("Playtime in minutes", new String[0]),
        cmi_user_playtime_secondst("Total playtime in minutes", new String[0]),
        cmi_user_prewards_count("Number of claimable prewards", new String[0]),
        cmi_user_world_formatted("Current players world name by using custom identification", new String[0]),
        cmi_user_online("Returns player online status", new String[0]),
        cmi_user_itemcount_$1("Number of items in players inventory by provided material", "itemIdName(:data)"),
        cmi_user_maxperm_$1_$2("Maximum value by provided permission node, and if it doesn't exist, returns default value", "corePerm", "defaultValue"),
        cmi_user_toggle_$1("Outputs 1 or 0 if defined feature is toggled on or off", "msg|pay|tp|compass|sospy|sispy|cospy|schest|autoflightrecharge|totem|shiftedit|tagsound|chatbubble"),
        cmi_user_togglename_$1("Outputs formatted True or False if defined feature is toggled on or off", "msg|pay|tp|compass|sospy|sispy|cospy|schest|autoflightrecharge|totem|shiftedit|tagsound|chatbubble"),
        cmi_user_holo_page_$1("Outputs page number of hologram player is in at the moment", "hologramName"),
        cmi_equation_$1("Result of provided mathematical equation with fraction", "equation"),
        cmi_equationint_$1("Result of provided mathematical equation without fraction", "equation"),
        cmi_color_$1("Colorizes text, replace spaces with _, underscore can be added by doubling it like __", "text"),
        cmi_iteminhand_displayname("Items in main hand display name or formatted material name", new String[0]),
        cmi_iteminhand_realname("Items in main hand formatted material name", new String[0]),
        cmi_iteminhand_type("Items in main hand material name", new String[0]),
        cmi_iteminhand_itemdata("Items in main hand data value. As of 1.13+ returns 0", new String[0]),
        cmi_iteminhand_amount("Amount of items in main hand", new String[0]),
        cmi_iteminhand_durability("Items in main hand left durability", new String[0]),
        cmi_iteminhand_worth("Returns total worth value of items in main hand", new String[0]),
        cmi_iteminhand_worth_one("Returns worth value of one item from main hand", new String[0]),
        cmi_iteminhand_worthc("Returns total worth value of items in main hand without formatting", new String[0]),
        cmi_iteminhand_worthc_one("Returns worth value of one item from main hand without formatting", new String[0]),
        cmi_schedule_nextin_$1("Left time until next schedule trigger", "schedName"),
        cmi_schedule_endat_$1("Left time until scheduler triggers last command", "schedName"),
        cmi_baltop_name_$1("Name of player from a provided place in a list", "1-10"),
        cmi_baltop_money_$1("Balance of player from a provided place in a list", "1-10"),
        cmi_baltop_shortmoney_$1("Balance of player from a provided place in a list", "1-10"),
        cmi_playtimetop_name_$1("Name of player from a provided place in a list", "1-10"),
        cmi_playtimetop_time_$1("Playtime of player from a provided place in a list", "1-10"),
        cmi_votetop_$1("Name of player from a provided place in a list", "1-10"),
        cmi_votetopcount_$1("Vote count of player from a provided place in a list", "1-10"),
        cmi_worth_buy_$1("Value of the item", "itemIdName(:data)"),
        cmi_worth_sell_$1("Sell value of the item", "itemIdName(:data)"),
        cmi_worthc_buy_$1("Value of the item without formatting", "itemIdName(:data)"),
        cmi_worthc_sell_$1("Sell value of the item without formatting", "itemIdName(:data)"),
        cmi_bungee_total_$1("Total allowed amount of players in defined server", "serverName"),
        cmi_bungee_current_$1("Current amount of players in defined server", "serverName"),
        cmi_bungee_motd_$1("Motd of defined server", "serverName"),
        cmi_bungee_onlinestatus_$1("True/false of servers online status", "serverName"),
        cmi_tps_1("Ttps from last 1 second", new String[0]),
        cmi_tps_60("Tps from last 60 seconds", new String[0]),
        cmi_tps_300("Tps from last 5 minutes", new String[0]),
        cmi_tps_$1_colored("Tps from defined range", "range"),
        cmi_random_player_name("Returns random online player name", false, new String[0]),
        cmi_lastrandom_player_name("Returns last random online player name", false, new String[0]),
        cmi_random_$1_$2("Random number from defined range", false, "from", "to"),
        cmi_lastrandom_$1("Last random number assigned to player from random placeholder", false, "playerName"),
        cmi_user_rank_percent_$1("Percentage of defined rank rankup progress", "rankName"),
        cmi_user_meta_$1("Players metadate by defined key", "key"),
        cmi_user_metaint_$1("Players metadate by defined key as number", "key"),
        cmi_chatmute_time("Provides left time for global chat mute", new String[0]),
        cmi_chatmute_reason("Provides reason for global chat mute", new String[0]),
        cmi_user_baltop("Player position in baltop", new String[0]),
        cmi_user_stats_$1("Player statistics", "mainStat(:optionalSubStat)"),
        cmi_user_kitcd_$1("Cooldown of defined kit", "kitName"),
        cmi_user_kit_available("Amount of kits you can claim", new String[0]),
        cmi_user_kit_available_$1("True/false if kit is available", "kitName"),
        cmi_user_kit_hasaccess_$1("True/false if user can use this kit", "kitName"),
        cmi_jail_time_$1_$2("Time of a jail cell", "jailName", "cellId"),
        cmi_jail_username_$1_$2("Name of user who is jailed in particular cell", "jailName", "cellId"),
        cmi_jail_reason_$1_$2("Reason of particular jail cell", "jailName", "cellId"),
        cmi_weather_$1("World weather", "worldName"),
        cmi_weatherduration_$1("World weather duration", "worldName"),
        cmi_afk_count("Number of afk players", new String[0]),
        cmi_maintenance_state("Maintenance state", new String[0]),
        cmi_maintenance_message("Maintenance message", new String[0]),
        cmi_chat_range("Range for chat messages", new String[0]),
        cmi_server_uptime("How long server is running", new String[0]),
        cmi_server_uptime_seconds("How long server is running in seconds", new String[0]),
        cmi_server_worlds("List of all existing worlds on server in a list format", new String[0]),
        cmi_server_vanished("Online vanished player count", new String[0]),
        cmi_server_users("Recorder user count", new String[0]),
        player_world("Current players world name", true, new String[0]),
        cmi_player_world("Current players world name", new String[0]),
        player_x("Current players x position", true, new String[0]),
        cmi_player_x("Current players x position", new String[0]),
        player_y("Current players y position", true, new String[0]),
        cmi_player_y("Current players y position", new String[0]),
        player_z("Current players z position", true, new String[0]),
        cmi_player_z("Current players z position", new String[0]),
        player_biome("Current players biome name", true, new String[0]),
        cmi_player_biome("Current players biome name", new String[0]),
        vault_eco_balance_formatted("Formatted players balance. Deprecated", true, new String[0]),
        server_online("Online player amount", true, new String[0]),
        cmi_server_online("Online player count", new String[0]),
        server_max_players("Max allowed players", true, new String[0]),
        cmi_server_max_players("Max allowed players", new String[0]),
        server_online_$1("Online amount in particular world. Don't use _ in world name", true, true, "worldName"),
        cmi_server_online_$1("Online amount in particular world. Don't use _ in world name", "worldName"),
        server_unique_joins("Unique player joins to the server", true, new String[0]),
        cmi_server_unique_joins("Unique player joins to the server", new String[0]),
        onlineplayers_names("Formatted list of online players", true, new String[0]),
        cmi_onlineplayers_names("Formatted list of online players", new String[0]),
        onlineplayers_displaynames("Formatted list of online players by using their display names if possible", true, new String[0]),
        cmi_onlineplayers_displaynames("Formatted list of online players by using their display names if possible", new String[0]),
        server_time_$1_$2("Time of server by defined format and timezone", true, true, "timeFormat", "timeZone"),
        cmi_server_time_$1_$2("Time of server by defined format and timezone", "timeFormat", "timeZone"),
        server_time_$1("Local server time", true, true, "timeFormat"),
        cmi_server_time_$1("Local server time", "timeFormat"),
        world_time12_$1("World time in 12 hour format", true, true, "worldName"),
        cmi_world_time12_$1("World time in 12 hour format", "worldName"),
        world_time24_$1("World time in 24 hour format", true, true, "worldName"),
        cmi_world_time24_$1("World time in 24 hour format", "worldName");

        static LinkedHashMap<String, CMIPlaceHolders> byNameStatic;
        static LinkedHashMap<String, LinkedHashSet<CMIPlaceHolders>> byNameComplex;
        private static int count;
        private int MAX_ENTRIES = 20;
        LinkedHashMap<UUID, PlaceholderCache> map = new LinkedHashMap<UUID, PlaceholderCache>(this, this.MAX_ENTRIES + 1, 0.75f, false){
            final /* synthetic */ CMIPlaceHolders this$1;
            {
                this.this$1 = cMIPlaceHolders;
                super(n, f, bl);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<UUID, PlaceholderCache> entry) {
                return this.size() > this.this$1.MAX_ENTRIES;
            }
        };
        private String[] vars;
        private List<Integer> groups = new ArrayList<Integer>();
        private ChatFilterRule rule = null;
        private boolean hidden = false;
        private boolean cache = true;
        private String desc = null;

        static {
            byNameStatic = new LinkedHashMap();
            byNameComplex = new LinkedHashMap();
            count = 0;
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n = cMIPlaceHoldersArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIPlaceHolders cMIPlaceHolders = cMIPlaceHoldersArray[n2];
                if (!cMIPlaceHolders.isHidden()) {
                    ++count;
                }
                String string = cMIPlaceHolders.toString();
                if (!cMIPlaceHolders.isComplex()) {
                    byNameStatic.put(string.toLowerCase(), cMIPlaceHolders);
                } else {
                    String[] stringArray = string.split("_");
                    String string2 = String.valueOf(stringArray[0]) + "_" + stringArray[1];
                    LinkedHashSet<CMIPlaceHolders> linkedHashSet = byNameComplex.getOrDefault(string2, new LinkedHashSet());
                    linkedHashSet.add(cMIPlaceHolders);
                    byNameComplex.put(string2, linkedHashSet);
                }
                ++n2;
            }
        }

        private CMIPlaceHolders() {
        }

        private CMIPlaceHolders(String string2, boolean bl, String ... stringArray) {
            this(string2, false, bl, stringArray);
        }

        private CMIPlaceHolders(boolean bl) {
            this(null, bl, true, new String[0]);
        }

        private CMIPlaceHolders(String string2, String ... stringArray) {
            this(string2, false, true, stringArray);
        }

        private CMIPlaceHolders(String string2, boolean bl, boolean bl2, String ... stringArray) {
            this.desc = string2;
            this.vars = stringArray;
            this.hidden = bl;
            this.cache = bl2;
            try {
                Matcher matcher = numericalRule.getMatcher(this.toString());
                if (matcher != null) {
                    this.rule = new ChatFilterRule();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("(%)" + this.toString().replaceAll("\\$\\d", "([^\"%]*)") + "(%)");
                    arrayList.add("(\\{)" + this.toString().replaceAll("\\$\\d", "([^\"%]*)") + "(\\})");
                    this.rule.setPattern(arrayList);
                    while (matcher.find()) {
                        try {
                            int n2 = Integer.parseInt(matcher.group(2));
                            this.groups.add(n2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public static int getCount() {
            return count;
        }

        public Object getCachedValue(UUID uUID) {
            if (!this.isCache() || this.isComplex() || uUID == null) {
                return null;
            }
            PlaceholderCache placeholderCache = this.map.get(uUID);
            if (placeholderCache == null || System.currentTimeMillis() > placeholderCache.getValidUntil()) {
                return null;
            }
            return placeholderCache.getValue();
        }

        public void addCachedValue(UUID uUID, String string, int n) {
            PlaceholderCache placeholderCache = this.map.get(uUID);
            if (placeholderCache == null) {
                placeholderCache = new PlaceholderCache();
            }
            placeholderCache.setValue(string);
            placeholderCache.setValidUntil(System.currentTimeMillis() + (long)n);
            this.map.put(uUID, placeholderCache);
        }

        public static CMIPlaceHolders getByName(String string) {
            if (string.startsWith("%") || string.startsWith("{")) {
                string = string.replace("%", "").replace("{", "").replace("}", "");
            }
            String string2 = string;
            CMIPlaceHolders cMIPlaceHolders = byNameStatic.get(string);
            if (cMIPlaceHolders != null) {
                return cMIPlaceHolders;
            }
            String[] stringArray = string.split("_");
            if (stringArray.length < 3) {
                return null;
            }
            String string3 = String.valueOf(stringArray[0]) + "_" + stringArray[1];
            Set set = byNameComplex.get(string3);
            if (set == null) {
                return null;
            }
            for (CMIPlaceHolders cMIPlaceHolders2 : set) {
                if (cMIPlaceHolders2.getComplexRegexMatchers(string2).isEmpty()) continue;
                return cMIPlaceHolders2;
            }
            return null;
        }

        public static CMIPlaceHolders getByNameExact(String string) {
            return CMIPlaceHolders.getByName(string);
        }

        public String getFull() {
            if (this.isComplex()) {
                String string = this.name();
                int n = 0;
                String[] stringArray = this.name().split("_");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray[n3];
                    if (string2.startsWith("$")) {
                        if (this.vars.length >= n - 1) {
                            string = string.replace(string2, "[" + this.vars[n] + "]");
                        }
                        ++n;
                    }
                    ++n3;
                }
                return "%" + string + "%";
            }
            return "%" + this.name() + "%";
        }

        public String getMVdW() {
            if (this.isComplex()) {
                String string = this.name();
                int n = 0;
                String[] stringArray = this.name().split("_");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray[n3];
                    if (string2.startsWith("$")) {
                        if (this.vars.length >= n - 1) {
                            string = string.replace(string2, "*");
                        }
                        ++n;
                    }
                    ++n3;
                }
                return string;
            }
            return this.name();
        }

        /*
         * Unable to fully structure code
         */
        public List<String> getComplexRegexMatchers(String var1_1) {
            var2_2 = new ArrayList<String>();
            if (!this.isComplex()) {
                return var2_2;
            }
            if (!var1_1.startsWith("%") && !var1_1.endsWith("%")) {
                var1_1 = "%" + var1_1 + "%";
            }
            if ((var3_3 = this.getRule().getMatcher(var1_1)) != null) ** GOTO lbl10
            return var2_2;
lbl-1000:
            // 1 sources

            {
                var2_2.add(var3_3.group());
lbl10:
                // 2 sources

                ** while (var3_3.find())
            }
lbl11:
            // 1 sources

            return var2_2;
        }

        public List<String> getComplexValues(String string) {
            Matcher matcher;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!this.isComplex() || string == null) {
                return arrayList;
            }
            if (!string.startsWith("%") && !string.endsWith("%")) {
                string = "%" + string + "%";
            }
            if ((matcher = this.getRule().getMatcher(string)) == null) {
                return arrayList;
            }
            if (matcher.find()) {
                try {
                    for (Integer n : this.groups) {
                        arrayList.add(matcher.group(n + 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return arrayList;
        }

        public boolean isComplex() {
            return this.rule != null;
        }

        public ChatFilterRule getRule() {
            return this.rule;
        }

        public void setRule(ChatFilterRule chatFilterRule) {
            this.rule = chatFilterRule;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean isCache() {
            return this.cache;
        }
    }

    public static enum CMIPlaceholderType {
        CMI,
        PAPI,
        MVdW;

    }
}

