/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.TimedCommands;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.tp.Teleportations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TimedCommandManager {
    private CMI plugin;
    private CMITask autoTimerBukkitId = null;
    private long nextIn = -1L;
    private boolean delay = false;
    public Set<CMIUser> timed = new HashSet<CMIUser>();
    private Runnable autoTimer = new Runnable(){

        @Override
        public void run() {
            if (!TimedCommandManager.this.timed.isEmpty()) {
                TimedCommandManager.this.checkUsers();
            }
        }
    };

    public TimedCommandManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void addTimed(CMIUser cMIUser) {
        if (!cMIUser.isOnline()) {
            return;
        }
        this.timed.add(cMIUser);
        if (CMIModule.timedCommands.isEnabled() && (this.autoTimerBukkitId == null || this.delay)) {
            this.delay = false;
            if (this.autoTimerBukkitId != null) {
                this.autoTimerBukkitId.cancel();
            }
            this.autoTimerBukkitId = CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.autoTimer, (long)0L, (long)20L);
        }
    }

    public void stop() {
        if (this.autoTimerBukkitId == null) {
            return;
        }
        this.autoTimerBukkitId.cancel();
        this.autoTimerBukkitId = null;
    }

    private void checkUsers() {
        ArrayList<CMIUser> arrayList = new ArrayList<CMIUser>();
        for (CMIUser cMIUser : this.timed) {
            if (!cMIUser.isOnline()) {
                arrayList.add(cMIUser);
                continue;
            }
            boolean bl = this.checkTFly(cMIUser, false);
            boolean bl2 = this.checkTGod(cMIUser, false);
            if (!bl2 && cMIUser.getTgod() != -1L || !bl && cMIUser.getTfly() != -1L) continue;
            arrayList.add(cMIUser);
        }
        this.timed.removeAll(arrayList);
        long l = (this.nextIn - System.currentTimeMillis()) / 1000L;
        if (l > 11L) {
            if (this.autoTimerBukkitId != null) {
                this.autoTimerBukkitId.cancel();
            }
            this.delay = true;
            this.autoTimerBukkitId = CMIScheduler.scheduleSyncRepeatingTask((Runnable)this.autoTimer, (long)((l - 10L) * 20L), (long)20L);
        }
        this.nextIn = -1L;
    }

    private void updateNextIn(Long l) {
        if (this.nextIn == -1L || this.nextIn > l) {
            this.nextIn = l;
        }
    }

    public boolean checkTFly(CMIUser cMIUser, boolean bl) {
        if (cMIUser.getTfly() == 0L) {
            return false;
        }
        this.updateNextIn(cMIUser.getTfly());
        if (cMIUser.getTfly() > 0L && cMIUser.getTfly() - 10000L < System.currentTimeMillis() && cMIUser.isOnline()) {
            CMIScheduler.runTaskAsynchronously(() -> {
                if (cMIUser.getTfly() != 0L && cMIUser.isOnline()) {
                    CMIActionBar.send((Player)cMIUser.getPlayer(), (String)CMILC.getIM("tfly", "willBeDisabled", "[time]", CMITimeManager.to24hourShort((Long)(cMIUser.getTfly() - System.currentTimeMillis() + 1000L))));
                }
            });
        }
        if (cMIUser.getTfly() == -1L && !bl) {
            return true;
        }
        if (cMIUser.getTfly() > System.currentTimeMillis()) {
            return false;
        }
        Player player = cMIUser.getPlayer(false);
        if (player == null) {
            return true;
        }
        if (player.isFlying()) {
            Location location = TimedCommandManager.getSafeLocation(player.getLocation());
            if (cMIUser.isOnline()) {
                if (!this.plugin.getTeleportations().teleport((CommandSender)player, player, player.getLocation(), true, false, Teleportations.TeleportType.TimedCommand)) {
                    return true;
                }
            } else {
                this.plugin.getNMS().setMiscLocation(player, location);
                this.plugin.save(player);
            }
        }
        player.setFlying(false);
        player.setAllowFlight(false);
        if (player.isOnline()) {
            player.sendMessage(CMILC.getIM("tfly", "disabled", new Object[0]));
        }
        cMIUser.setTfly(0L, !bl);
        cMIUser.clearCachedFlyModes();
        return true;
    }

    public boolean checkTGod(CMIUser cMIUser, boolean bl) {
        if (cMIUser.getTgod() == 0L) {
            return false;
        }
        this.updateNextIn(cMIUser.getTgod());
        if (cMIUser.getTgod() > 0L && cMIUser.getTgod() - 10000L < System.currentTimeMillis() && cMIUser.isOnline()) {
            CMIScheduler.runTaskAsynchronously(() -> {
                if (cMIUser.getTgod() != 0L && cMIUser.isOnline()) {
                    CMIActionBar.send((Player)cMIUser.getPlayer(), (String)CMILC.getIM("tgod", "willBeDisabled", "[time]", CMITimeManager.to24hourShort((Long)(cMIUser.getTgod() - System.currentTimeMillis() + 1000L))));
                }
            });
        }
        if (cMIUser.getTgod() == -1L && !bl) {
            return true;
        }
        if (cMIUser.getTgod() > System.currentTimeMillis()) {
            return false;
        }
        Player player = cMIUser.getPlayer(false);
        if (player == null) {
            return false;
        }
        player.setNoDamageTicks(10);
        if (player.isOnline()) {
            player.sendMessage(CMILC.getIM("tgod", "disabled", new Object[0]));
        }
        cMIUser.setTgod(0L, !bl);
        return true;
    }

    private static Location getSafeLocation(Location location) {
        Block block;
        int n = location.getBlockY();
        int n2 = 0;
        while (n2 <= n) {
            block = location.clone().add(0.0, (double)(-n2), 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return location.clone().add(0.0, (double)(-n2 + 1), 0.0);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 <= location.getWorld().getMaxHeight() - n) {
            block = location.clone().add(0.0, (double)n2, 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return location.clone().add(0.0, (double)(n2 + 1), 0.0);
            }
            ++n2;
        }
        return location;
    }
}

