/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.NBT;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.NBT.NMS;
import com.Zrips.CMI.utils.Util;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.minecraft.server.v1_16_R2.AxisAlignedBB;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.CriterionTriggers;
import net.minecraft.server.v1_16_R2.DedicatedServer;
import net.minecraft.server.v1_16_R2.EntityArmorStand;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityItem;
import net.minecraft.server.v1_16_R2.EntityLiving;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.EntitySlime;
import net.minecraft.server.v1_16_R2.EntityTypes;
import net.minecraft.server.v1_16_R2.EnumDirection;
import net.minecraft.server.v1_16_R2.EnumItemSlot;
import net.minecraft.server.v1_16_R2.EnumProtocolDirection;
import net.minecraft.server.v1_16_R2.IBlockAccess;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.Items;
import net.minecraft.server.v1_16_R2.MinecraftServer;
import net.minecraft.server.v1_16_R2.MobEffect;
import net.minecraft.server.v1_16_R2.MobEffects;
import net.minecraft.server.v1_16_R2.MovingObjectPosition;
import net.minecraft.server.v1_16_R2.MovingObjectPositionBlock;
import net.minecraft.server.v1_16_R2.NBTBase;
import net.minecraft.server.v1_16_R2.NBTCompressedStreamTools;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NBTTagDouble;
import net.minecraft.server.v1_16_R2.NBTTagFloat;
import net.minecraft.server.v1_16_R2.NBTTagList;
import net.minecraft.server.v1_16_R2.NBTTagString;
import net.minecraft.server.v1_16_R2.NetworkManager;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutAbilities;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityEffect;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R2.PacketPlayOutMapChunk;
import net.minecraft.server.v1_16_R2.PacketPlayOutMount;
import net.minecraft.server.v1_16_R2.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_16_R2.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R2.PacketPlayOutPosition;
import net.minecraft.server.v1_16_R2.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R2.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_16_R2.PacketPlayOutWorldParticles;
import net.minecraft.server.v1_16_R2.PlayerConnection;
import net.minecraft.server.v1_16_R2.PlayerInteractManager;
import net.minecraft.server.v1_16_R2.PlayerList;
import net.minecraft.server.v1_16_R2.RayTrace;
import net.minecraft.server.v1_16_R2.StatisticList;
import net.minecraft.server.v1_16_R2.Vec3D;
import net.minecraft.server.v1_16_R2.Vector3f;
import net.minecraft.server.v1_16_R2.VoxelShape;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_16_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_16_R2.CraftServer;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftRayTraceResult;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class v1_16_R2
implements NMS {
    private boolean informed = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Player getPlayer(CMIUser cMIUser) {
        try {
            if (cMIUser.isFakeAccount().booleanValue()) {
                return null;
            }
            File file = Util.getFile(cMIUser.getUniqueId());
            if (!file.canRead() || !file.exists()) {
                return null;
            }
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            GameProfile gameProfile = new GameProfile(cMIUser.getUniqueId(), cMIUser.getName(false));
            WorldServer worldServer = dedicatedServer.E();
            EntityPlayer entityPlayer = new EntityPlayer((MinecraftServer)dedicatedServer, worldServer, gameProfile, new PlayerInteractManager(worldServer));
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            if (craftPlayer != null) {
                craftPlayer.loadData();
                return craftPlayer;
            }
        }
        finally {
            return null;
        }
    }

    @Override
    public Player createFakeOperator() {
        try {
            GameProfile gameProfile = new GameProfile(CMI.getInstance().getPlayerManager().getFakeUserUUID(), CMI.getInstance().getPlayerManager().getFakeUserName());
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            WorldServer worldServer = (WorldServer)dedicatedServer.getWorlds().iterator().next();
            EntityPlayer entityPlayer = new EntityPlayer((MinecraftServer)dedicatedServer, worldServer, gameProfile, new PlayerInteractManager(worldServer));
            entityPlayer.playerConnection = new PlayerConnection((MinecraftServer)dedicatedServer, new NetworkManager(EnumProtocolDirection.SERVERBOUND), entityPlayer);
            entityPlayer.playerConnection.networkManager.socketAddress = new InetSocketAddress("127.0.0.1", 25566);
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            craftPlayer.setOp(true);
            return craftPlayer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void unloadData(Player player) {
        try {
            if (player == null || player.isOnline()) {
                return;
            }
            EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
            if (entityPlayer == null) {
                return;
            }
            WorldServer worldServer = entityPlayer.getWorldServer();
            if (worldServer == null) {
                return;
            }
            worldServer.removePlayer(entityPlayer);
            entityPlayer.getAdvancementData().a();
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            PlayerList playerList = dedicatedServer.getPlayerList();
            playerList.players.remove(entityPlayer);
            ((CraftServer)Bukkit.getServer()).getScoreboardManager().removePlayer((Player)entityPlayer.getBukkitEntity());
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public NBTTagCompound getNBTTagC(File file) {
        NBTTagCompound nBTTagCompound;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return nBTTagCompound;
    }

    public NBTTagCompound getNBTTagC(UUID uUID) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(uUID);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public String getWorldName(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return null;
        }
        UUID uUID = new UUID(v1_16_R2.getUUIDWorldMost(nBTTagCompound), v1_16_R2.getUUIDWorldLeast(nBTTagCompound));
        return CMI.getInstance().getUtilManager().getWorldName(uUID);
    }

    @Override
    public void setMiscLocation(File file, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        v1_16_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setMiscLocation(Player player, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(player.getUniqueId());
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        this.saveData(nBTTagCompound, player);
    }

    private static NBTTagCompound setDimension(NBTTagCompound nBTTagCompound, int n) {
        nBTTagCompound.setInt("Dimension", n);
        return nBTTagCompound;
    }

    private static NBTTagCompound setLocationWorld(NBTTagCompound nBTTagCompound, long l, long l2) {
        nBTTagCompound = v1_16_R2.setUUIDWorldLeast(nBTTagCompound, l);
        nBTTagCompound = v1_16_R2.setUUIDWorldMost(nBTTagCompound, l2);
        return nBTTagCompound;
    }

    private static NBTTagCompound setUUIDWorldLeast(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDLeast", l);
        return nBTTagCompound;
    }

    private static NBTTagCompound setUUIDWorldMost(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDMost", l);
        return nBTTagCompound;
    }

    private static long getUUIDWorldMost(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDMost");
    }

    private static long getUUIDWorldLeast(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDLeast");
    }

    public NBTTagCompound setMiscLocation(Location location, NBTTagCompound nBTTagCompound) {
        nBTTagCompound = v1_16_R2.setLocationWorld(nBTTagCompound, location.getWorld().getUID().getLeastSignificantBits(), location.getWorld().getUID().getMostSignificantBits());
        nBTTagCompound = v1_16_R2.setDimension(nBTTagCompound, location.getWorld().getEnvironment().getId());
        nBTTagCompound = v1_16_R2.setLocationPosition(nBTTagCompound, location.getX(), location.getY(), location.getZ());
        nBTTagCompound = v1_16_R2.setLocationView(nBTTagCompound, location.getYaw(), location.getPitch());
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationPosition(NBTTagCompound nBTTagCompound, double d, double d2, double d3) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((Object)NBTTagDouble.a((double)d));
        nBTTagList.add((Object)NBTTagDouble.a((double)d2));
        nBTTagList.add((Object)NBTTagDouble.a((double)d3));
        nBTTagCompound.set("Pos", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationView(NBTTagCompound nBTTagCompound, float f, float f2) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((Object)NBTTagFloat.a((float)f));
        nBTTagList.add((Object)NBTTagFloat.a((float)f2));
        nBTTagCompound.set("Rotation", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static void saveData(NBTTagCompound nBTTagCompound, File file) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveData(NBTTagCompound nBTTagCompound, Player player) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(Util.getFile(player));
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearPotionEffects(Player player) {
        File file = Util.getFile(player);
        this.clearPotionEffects(file);
    }

    public void clearPotionEffects(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound.remove("ActiveEffects");
        v1_16_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setPotionEffects(Player player, PotionEffect potionEffect) {
        File file = Util.getFile(player);
        this.setPotionEffects(potionEffect, file);
    }

    public void setPotionEffects(PotionEffect potionEffect, File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagList nBTTagList = nBTTagCompound.getList("ActiveEffects", 10);
        boolean bl = false;
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.getCompound(n);
            if (nBTTagCompound2.getByte("Id") == potionEffect.getType().getId()) {
                bl = true;
                nBTTagCompound2.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
                nBTTagCompound2.setByte("Amplifier", (byte)potionEffect.getAmplifier());
                nBTTagCompound2.setInt("Duration", potionEffect.getDuration());
                nBTTagCompound2.setByte("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
                nBTTagList.a(n, (NBTBase)nBTTagCompound2);
                break;
            }
            ++n;
        }
        if (!bl) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
            nBTTagCompound3.setByte("Amplifier", (byte)potionEffect.getAmplifier());
            nBTTagCompound3.setInt("Duration", potionEffect.getDuration());
            nBTTagCompound3.setByte("Id", (byte)potionEffect.getType().getId());
            nBTTagCompound3.setByte("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
            nBTTagList.add((Object)nBTTagCompound3);
        }
        nBTTagCompound.set("ActiveEffects", (NBTBase)nBTTagList);
        v1_16_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void relightChunk(Chunk chunk) {
    }

    @Override
    public void resendChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 65535));
    }

    @Override
    public void unloadChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 0));
    }

    @Override
    public void updateCollisions(Player player, boolean bl, boolean bl2) {
    }

    public static void sendPacket(Player player, PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutScoreboardTeam);
    }

    @Override
    public Inventory getShulkerInv(ItemStack itemStack) {
        if (!CMIMaterial.get((ItemStack)itemStack).isShulkerBox()) {
            return null;
        }
        try {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
            }
            if (!(itemMeta instanceof BlockStateMeta)) {
            }
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            if (!blockStateMeta.hasBlockState()) {
            }
            if (blockStateMeta.getBlockState() == null) {
            }
            if (!(blockStateMeta.getBlockState() instanceof ShulkerBox)) {
            }
            ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
            if (shulkerBox.getInventory() == null) {
            }
            return shulkerBox.getInventory();
        }
        finally {
            return null;
        }
    }

    @Override
    public Inventory getShulkerInv(Block block) {
        if (!CMIMaterial.get((Block)block).isShulkerBox()) {
            return null;
        }
        if (!(block.getState() instanceof ShulkerBox)) {
            return null;
        }
        ShulkerBox shulkerBox = (ShulkerBox)block.getState();
        if (shulkerBox.getInventory() == null) {
            return null;
        }
        return shulkerBox.getInventory();
    }

    @Override
    public int getTickLived(UUID uUID) {
        if (uUID == null) {
            return 0;
        }
        NBTTagCompound nBTTagCompound = this.getNBTTagC(uUID);
        if (nBTTagCompound == null) {
            return 0;
        }
        if (!nBTTagCompound.hasKey("Spigot.ticksLived")) {
            return 0;
        }
        return nBTTagCompound.getInt("Spigot.ticksLived");
    }

    @Override
    public void showResurection(Player player) {
        this.showResurection(player, new ItemStack(Material.TOTEM_OF_UNDYING));
    }

    public void showResurection(Player player, ItemStack itemStack) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer instanceof EntityPlayer) {
            EntityPlayer entityPlayer2 = entityPlayer;
            entityPlayer2.b(StatisticList.ITEM_USED.b((Object)Items.TOTEM_OF_UNDYING));
            CriterionTriggers.B.a(entityPlayer2, CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        entityPlayer.setHealth(1.0f);
        entityPlayer.removeAllEffects();
        if (CMI.getInstance().getTotemManager().getRegenerationDuration() > 0) {
            entityPlayer.addEffect(new MobEffect(MobEffects.REGENERATION, CMI.getInstance().getTotemManager().getRegenerationDuration() * 20, 1));
        }
        if (CMI.getInstance().getTotemManager().getFireResistanceDuration() > 0) {
            entityPlayer.addEffect(new MobEffect(MobEffects.FIRE_RESISTANCE, CMI.getInstance().getTotemManager().getFireResistanceDuration() * 20, 1));
        }
        if (CMI.getInstance().getTotemManager().getAbsorbtionDuration() > 0) {
            entityPlayer.addEffect(new MobEffect(MobEffects.ABSORBTION, CMI.getInstance().getTotemManager().getAbsorbtionDuration() * 20, 1));
        }
        entityPlayer.world.broadcastEntityEffect((net.minecraft.server.v1_16_R2.Entity)entityPlayer, (byte)35);
    }

    @Override
    public void setEntityTag(Entity entity, String string, Object object) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        net.minecraft.server.v1_16_R2.Entity entity2 = ((CraftEntity)entity).getHandle();
        NBTTagCompound nBTTagCompound2 = entity2.save(nBTTagCompound);
        if (object instanceof String) {
            nBTTagCompound2.setString(string, (String)object);
        } else if (object instanceof Short) {
            nBTTagCompound2.setShort(string, ((Short)object).shortValue());
        } else if (object instanceof Byte) {
            nBTTagCompound2.setByte(string, ((Byte)object).byteValue());
        }
        entity2.load(nBTTagCompound);
    }

    @Override
    public ItemStack removeEnchantNbt(ItemStack itemStack, Enchantment enchantment) {
        net.minecraft.server.v1_16_R2.ItemStack itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (itemStack2 == null) {
            return null;
        }
        try {
            String string = enchantment.getKey().getKey();
            NBTTagCompound nBTTagCompound = itemStack2.getTag();
            boolean bl = false;
            if (nBTTagCompound != null && nBTTagCompound.hasKey("ench")) {
                NBTTagList nBTTagList = nBTTagCompound.getList("ench", 10);
                int n = 0;
                while (n < nBTTagList.size()) {
                    if (nBTTagList.getCompound(n).getString("id").equalsIgnoreCase(string)) {
                        nBTTagList.remove(n);
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    nBTTagCompound.set("ench", (NBTBase)nBTTagList);
                }
                itemStack2.setTag(nBTTagCompound);
            }
            if (bl) {
                return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R2.ItemStack)itemStack2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public ItemStack setNBTList(ItemStack itemStack, String string, List<String> list2) {
        net.minecraft.server.v1_16_R2.ItemStack itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (itemStack2 == null) {
            return null;
        }
        try {
            NBTTagCompound nBTTagCompound = itemStack2.getTag();
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            NBTTagList nBTTagList = new NBTTagList();
            if (list2 != null) {
                for (String string2 : list2) {
                    nBTTagList.add((Object)NBTTagString.a((String)string2));
                }
            }
            if (list2 == null) {
                nBTTagCompound.remove(string);
            } else {
                nBTTagCompound.set(string, (NBTBase)nBTTagList);
            }
            itemStack2.setTag(nBTTagCompound);
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R2.ItemStack)itemStack2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean changeGodMode(Player player, boolean bl) {
        if (player == null) {
            return false;
        }
        player.setInvulnerable(bl);
        return true;
    }

    @Override
    public boolean getGodMode(Player player) {
        return player.isInvulnerable();
    }

    @Override
    public void updateExpBar(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.getHandle().lastSentExp = -1;
    }

    @Override
    public Command getCommand(String string) {
        return ((CraftServer)Bukkit.getServer()).getCommandMap().getCommand(string);
    }

    private static EntityArmorStand createStand(Location location, String string, boolean bl) {
        double d = location.getX();
        double d2 = location.getZ();
        double d3 = location.getY();
        if (bl) {
            d += 0.05;
            d2 -= 0.2;
            d3 -= 0.3;
        } else {
            d3 -= 0.45;
        }
        EntityArmorStand entityArmorStand = new EntityArmorStand((net.minecraft.server.v1_16_R2.World)((CraftWorld)location.getWorld()).getHandle(), d, d3, d2);
        entityArmorStand.setInvisible(true);
        entityArmorStand.setArms(false);
        entityArmorStand.setMarker(true);
        entityArmorStand.setNoGravity(true);
        entityArmorStand.setBasePlate(true);
        entityArmorStand.setSmall(bl);
        if (bl) {
            entityArmorStand.setRightArmPose(new Vector3f(-15.0f, -45.0f, 0.0f));
        }
        if (string != null && !string.isEmpty()) {
            IChatBaseComponent iChatBaseComponent = CraftChatMessage.fromString((String)CMIChatColor.translate((String)string))[0];
            entityArmorStand.setCustomName(iChatBaseComponent);
            if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
                entityArmorStand.setCustomNameVisible(false);
            } else {
                entityArmorStand.setCustomNameVisible(true);
            }
        } else {
            entityArmorStand.setCustomNameVisible(false);
        }
        return entityArmorStand;
    }

    @Override
    public CMIDataWatcher spawnHologram(Player player, Location location, String string, ItemStack itemStack) {
        EntityArmorStand entityArmorStand = v1_16_R2.createStand(location, string, itemStack != null);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutSpawnEntity((net.minecraft.server.v1_16_R2.Entity)entityArmorStand, 78));
            try {
                craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(entityArmorStand.getId(), entityArmorStand.getDataWatcher(), false));
                if (itemStack != null) {
                    ArrayList arrayList = Lists.newArrayList();
                    arrayList.add(Pair.of((Object)EnumItemSlot.MAINHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
                    PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(entityArmorStand.getId(), (List)arrayList);
                    craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment);
                }
                return new CMIDataWatcher(entityArmorStand.getId(), entityArmorStand, itemStack != null ? CMIHoloLineType.staticIcon : CMIHoloLineType.plainText);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public FakeInfo spawnClickable(Player player, Location location, Object object, boolean bl) {
        try {
            if (bl) {
                EntitySlime entitySlime = new EntitySlime(EntityTypes.MAGMA_CUBE, (net.minecraft.server.v1_16_R2.World)((CraftWorld)location.getWorld()).getHandle());
                entitySlime.setInvisible(true);
                entitySlime.setNoGravity(true);
                entitySlime.setNoAI(true);
                entitySlime.setSize(2, true);
                entitySlime.setLocation(location.getX(), location.getY() - 0.45, location.getZ() - 0.2, 0.0f, 0.0f);
                entitySlime.setCustomNameVisible(false);
                entitySlime.setSilent(true);
                PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entitySlime);
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutSpawnEntityLiving);
                ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(entitySlime.getId(), entitySlime.getDataWatcher(), false));
                FakeInfo fakeInfo = new FakeInfo().setObj(object).setPlayer(player).setId(entitySlime.getId());
                fakeInfo.setEntity(entitySlime);
                PacketHandler.fakeEntities.put(entitySlime.getId(), fakeInfo);
                return fakeInfo;
            }
            EntityArmorStand entityArmorStand = new EntityArmorStand((net.minecraft.server.v1_16_R2.World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY() - 0.35, location.getZ());
            entityArmorStand.setInvisible(true);
            entityArmorStand.setArms(false);
            entityArmorStand.setNoGravity(true);
            entityArmorStand.setBasePlate(false);
            if (object instanceof CMIHologram) {
                if (((CMIHologram)object).getHeight() > 1.7) {
                    entityArmorStand.setSmall(false);
                    entityArmorStand.setLocation(location.getX(), location.getY() - 0.75, location.getZ(), 0.0f, 0.0f);
                } else {
                    entityArmorStand.setSmall(true);
                }
            } else {
                entityArmorStand.setSmall(true);
            }
            entityArmorStand.setCustomNameVisible(false);
            PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutSpawnEntityLiving);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(entityArmorStand.getId(), entityArmorStand.getDataWatcher(), false));
            FakeInfo fakeInfo = new FakeInfo().setObj(object).setPlayer(player).setId(entityArmorStand.getId());
            fakeInfo.setEntity(entityArmorStand);
            PacketHandler.fakeEntities.put(entityArmorStand.getId(), fakeInfo);
            return fakeInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeHologram(Player player, Integer n) {
        if (n == null) {
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{n}));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateHologram(Player player, CMIDataWatcher cMIDataWatcher, String string, ItemStack itemStack) {
        if (cMIDataWatcher == null) {
            return;
        }
        EntityArmorStand entityArmorStand = (EntityArmorStand)cMIDataWatcher.getStand();
        if (string == null || string.isEmpty()) {
            entityArmorStand.setCustomNameVisible(false);
        } else if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
            entityArmorStand.setCustomNameVisible(false);
        } else {
            entityArmorStand.setCustomNameVisible(true);
        }
        IChatBaseComponent iChatBaseComponent = CraftChatMessage.fromString((String)string)[0];
        entityArmorStand.setCustomName(iChatBaseComponent);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(cMIDataWatcher.getId().intValue(), entityArmorStand.getDataWatcher(), true);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(Pair.of((Object)EnumItemSlot.MAINHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
            PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(cMIDataWatcher.getId().intValue(), (List)arrayList);
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, ItemStack itemStack) {
        return this.makeFloatingIcon(player, location, itemStack, false);
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, ItemStack itemStack, boolean bl) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        EntityItem entityItem = new EntityItem((net.minecraft.server.v1_16_R2.World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ());
        entityItem.setItemStack(CraftItemStack.asNMSCopy((ItemStack)itemStack));
        entityItem.setPosition(location.getX(), location.getY(), location.getZ());
        entityItem.setNoGravity(true);
        if (bl) {
            entityItem.i(true);
        }
        PacketPlayOutEntityVelocity packetPlayOutEntityVelocity = new PacketPlayOutEntityVelocity(entityItem.getId(), new Vec3D(0.0, 0.0, 0.0));
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = new PacketPlayOutSpawnEntity((net.minecraft.server.v1_16_R2.Entity)entityItem);
        entityPlayer.playerConnection.sendPacket((Packet)packetPlayOutSpawnEntity);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(entityItem.getId(), entityItem.getDataWatcher(), true);
        entityPlayer.playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
        entityPlayer.playerConnection.sendPacket((Packet)packetPlayOutEntityVelocity);
        CMIDataWatcher cMIDataWatcher = new CMIDataWatcher(entityItem.getId(), entityItem.getDataWatcher(), CMIHoloLineType.icon);
        return cMIDataWatcher;
    }

    @Override
    public boolean clearSkin(Player player) {
        if (player == null) {
            return false;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        GameProfile gameProfile = craftPlayer.getProfile();
        gameProfile.getProperties().removeAll((Object)"textures");
        this.updatePlayerViaPackets(player);
        return true;
    }

    @Override
    public void updatePlayerViaPackets(Player player) {
        PacketPlayOutPlayerInfo packetPlayOutPlayerInfo;
        PacketPlayOutPlayerInfo packetPlayOutPlayerInfo2;
        EntityPlayer entityPlayer;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        EntityPlayer entityPlayer2 = null;
        if (!cMIUser.getTagName().equals(player.getName())) {
            entityPlayer = ((CraftServer)Bukkit.getServer()).getServer();
            GameProfile gameProfile = new GameProfile(player.getUniqueId(), CMIChatColor.translate((String)cMIUser.getTagName()));
            gameProfile.getProperties().putAll((Multimap)craftPlayer.getHandle().getProfile().getProperties());
            packetPlayOutPlayerInfo2 = entityPlayer.getWorldServer(craftPlayer.getHandle().getSpawnDimension());
            entityPlayer2 = new EntityPlayer((MinecraftServer)entityPlayer, (WorldServer)packetPlayOutPlayerInfo2, gameProfile, new PlayerInteractManager((WorldServer)packetPlayOutPlayerInfo2));
            packetPlayOutPlayerInfo = entityPlayer2.getBukkitEntity().getHandle();
            packetPlayOutPlayerInfo.e(player.getEntityId());
        }
        entityPlayer = craftPlayer.getHandle();
        int n = player.getEntityId();
        packetPlayOutPlayerInfo2 = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{entityPlayer});
        packetPlayOutPlayerInfo = null;
        packetPlayOutPlayerInfo = entityPlayer2 != null ? new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer2}) : new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer});
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{n});
        PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(Pair.of((Object)EnumItemSlot.HEAD, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Helmet))));
        arrayList.add(Pair.of((Object)EnumItemSlot.CHEST, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.ChestPlate))));
        arrayList.add(Pair.of((Object)EnumItemSlot.LEGS, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Pants))));
        arrayList.add(Pair.of((Object)EnumItemSlot.FEET, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Boots))));
        arrayList.add(Pair.of((Object)EnumItemSlot.MAINHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getItemInHand())));
        arrayList.add(Pair.of((Object)EnumItemSlot.OFFHAND, (Object)CraftItemStack.asNMSCopy((ItemStack)cMIUser.getItemInOffHand())));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(n, (List)arrayList);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(n, craftPlayer.getHandle().getDataWatcher(), true);
        PacketPlayOutAbilities packetPlayOutAbilities = new PacketPlayOutAbilities(craftPlayer.getHandle().abilities);
        PacketPlayOutMount packetPlayOutMount = null;
        if (player.getVehicle() != null) {
            packetPlayOutMount = new PacketPlayOutMount(((CraftEntity)player.getVehicle()).getHandle());
        }
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        int n2 = player.getInventory().getHeldItemSlot();
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            PlayerConnection playerConnection = ((CraftPlayer)player2).getHandle().playerConnection;
            if (player2 == player) {
                MobEffect mobEffect2;
                boolean bl = player.isFlying();
                playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo2);
                playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo);
                Location location = player.getLocation();
                HashSet hashSet = new HashSet();
                PacketPlayOutPosition packetPlayOutPosition = new PacketPlayOutPosition(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), hashSet, 0);
                playerConnection.sendPacket((Packet)packetPlayOutPosition);
                for (MobEffect mobEffect2 : entityPlayer.getEffects()) {
                    playerConnection.sendPacket((Packet)new PacketPlayOutEntityEffect(n, mobEffect2));
                }
                mobEffect2 = new PacketPlayOutUpdateHealth((float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
                playerConnection.sendPacket((Packet)mobEffect2);
                if (packetPlayOutMount != null) {
                    playerConnection.sendPacket((Packet)packetPlayOutMount);
                }
                playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
                playerConnection.sendPacket((Packet)packetPlayOutAbilities);
                CMIScheduler.runTask(() -> {
                    if (bl) {
                        player.setAllowFlight(true);
                        player.setFlying(true);
                    }
                    this.updateExpBar(player);
                    if (player.isOp()) {
                        ((CraftServer)Bukkit.getServer()).getHandle().addOp(craftPlayer.getProfile());
                        craftPlayer.recalculatePermissions();
                    }
                    player.getInventory().setHeldItemSlot(n2);
                });
                continue;
            }
            if (!player2.canSee(player)) continue;
            playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo2);
            playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo);
            if (CMI.getInstance().getUtilManager().getDistance(player2.getLocation(), player.getLocation()) < (double)CMI.getInstance().getUtilManager().getPlayerTrackingRange(player.getWorld())) {
                playerConnection.sendPacket((Packet)packetPlayOutEntityDestroy);
                playerConnection.sendPacket((Packet)packetPlayOutNamedEntitySpawn);
            }
            if (packetPlayOutMount != null) {
                playerConnection.sendPacket((Packet)packetPlayOutMount);
            }
            playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
            CMIScheduler.runTaskLater(() -> playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment), (long)1L);
        }
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, Color color) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(0);
        cMIEffect.setSpeed(1.0f);
        cMIEffect.setColor(org.bukkit.Color.fromBGR((int)color.getBlue(), (int)color.getGreen(), (int)color.getRed()));
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, float f, float f2, float f3, float f4, int n) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffectManager.CMIParticle cMIParticle, float f, float f2, float f3, float f4, int n) {
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffect cMIEffect) {
        if (player == null || !player.isOnline() || location == null || cMIEffect == null || location.getWorld() == null) {
            return;
        }
        CMIEffectManager.CMIParticle cMIParticle = cMIEffect.getParticle();
        if (cMIParticle == null) {
            return;
        }
        if (!cMIParticle.isParticle()) {
            return;
        }
        Particle particle = cMIParticle.getParticle();
        if (particle == null) {
            return;
        }
        Particle.DustOptions dustOptions = null;
        if (particle.equals((Object)Particle.REDSTONE)) {
            dustOptions = new Particle.DustOptions(cMIEffect.getColor(), (float)cMIEffect.getSize());
        }
        PacketPlayOutWorldParticles packetPlayOutWorldParticles = new PacketPlayOutWorldParticles(CraftParticle.toNMS((Particle)particle, dustOptions), true, location.getX(), location.getY(), location.getZ(), (float)cMIEffect.getOffset().getX(), (float)cMIEffect.getOffset().getY(), (float)cMIEffect.getOffset().getZ(), cMIEffect.getSpeed(), cMIEffect.getAmount());
        CraftPlayer craftPlayer = (CraftPlayer)player;
        if (craftPlayer.getHandle().playerConnection == null) {
            return;
        }
        if (!location.getWorld().equals(craftPlayer.getWorld())) {
            return;
        }
        craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutWorldParticles);
    }

    @Override
    public boolean forceTeleport(Player player, Location location) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.getHealth() == 0.0f || entityPlayer.dead) {
            return false;
        }
        if (entityPlayer.playerConnection == null) {
            return false;
        }
        if (entityPlayer.isVehicle()) {
            return false;
        }
        entityPlayer.stopRiding();
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        World world2 = location.getWorld();
        worldServer = world2 == null ? ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle() : ((CraftWorld)world2).getHandle();
        if (((CraftPlayer)player).getHandle().activeContainer != ((CraftPlayer)player).getHandle().defaultContainer) {
            ((CraftPlayer)player).getHandle().closeInventory();
        }
        if (((CraftWorld)player.getLocation().getWorld()).getHandle() == worldServer) {
            entityPlayer.playerConnection.teleport(location);
        } else {
            ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(entityPlayer, worldServer, true, location, true);
        }
        return true;
    }

    @Override
    public CMIHitBox getBlockHitBox(CMIHitBox cMIHitBox) {
        block9: {
            try {
                Block block = cMIHitBox.getBlock();
                if (block == null) {
                    return cMIHitBox;
                }
                BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
                WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
                ChunkSnapshot chunkSnapshot = block.getWorld().getEmptyChunkSnapshot(block.getX() >> 4, block.getZ() >> 4, false, false);
                int n = block.getX() % 16;
                n = n < 0 ? 16 + n : n;
                int n2 = block.getZ() % 16;
                int n3 = n2 = n2 < 0 ? 16 + n2 : n2;
                if (CMIMaterial.isAir((Material)chunkSnapshot.getBlockType(n, block.getY(), n2))) {
                    cMIHitBox.setMin(new Vector(1, 1, 1));
                    cMIHitBox.setMax(new Vector(0, 0, 0));
                    break block9;
                }
                try {
                    IBlockData iBlockData = worldServer.getType(blockPosition);
                    VoxelShape voxelShape = iBlockData.getCollisionShape((IBlockAccess)worldServer, blockPosition);
                    if (!voxelShape.isEmpty()) {
                        AxisAlignedBB axisAlignedBB = voxelShape.getBoundingBox();
                        cMIHitBox.setMin(new Vector(axisAlignedBB.a(EnumDirection.EnumAxis.X), axisAlignedBB.a(EnumDirection.EnumAxis.Y), axisAlignedBB.a(EnumDirection.EnumAxis.Z)));
                        cMIHitBox.setMax(new Vector(axisAlignedBB.b(EnumDirection.EnumAxis.X), axisAlignedBB.b(EnumDirection.EnumAxis.Y), axisAlignedBB.b(EnumDirection.EnumAxis.Z)));
                        break block9;
                    }
                    cMIHitBox.setMin(new Vector(1, 1, 1));
                    cMIHitBox.setMax(new Vector(0, 0, 0));
                }
                catch (Exception exception) {
                    try {
                        IBlockData iBlockData = worldServer.getType(blockPosition);
                        Object object = iBlockData.getClass().getMethod("g", worldServer.getClass(), blockPosition.getClass()).invoke((Object)iBlockData, worldServer, blockPosition);
                        AxisAlignedBB axisAlignedBB = (AxisAlignedBB)object.getClass().getMethod("a", new Class[0]).invoke(object, new Object[0]);
                        cMIHitBox.setMin(new Vector(axisAlignedBB.a(EnumDirection.EnumAxis.X), axisAlignedBB.a(EnumDirection.EnumAxis.Y), axisAlignedBB.a(EnumDirection.EnumAxis.Z)));
                        cMIHitBox.setMax(new Vector(axisAlignedBB.b(EnumDirection.EnumAxis.X), axisAlignedBB.b(EnumDirection.EnumAxis.Y), axisAlignedBB.b(EnumDirection.EnumAxis.Z)));
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        exception.printStackTrace();
                    }
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return cMIHitBox;
    }

    @Override
    public CMIHitBox getEntityHitBox(CMIHitBox cMIHitBox) {
        try {
            Entity entity = cMIHitBox.getEntity();
            if (entity == null) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
                return cMIHitBox;
            }
            AxisAlignedBB axisAlignedBB = ((CraftEntity)entity).getHandle().getBoundingBox();
            cMIHitBox.setMin(new Vector(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ));
            cMIHitBox.setMax(new Vector(axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public Block getBlockLookingAt(Player player, int n, boolean bl) {
        if (player == null) {
            return null;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > 120) {
            n = 120;
        }
        Location location = player.getLocation().clone().add(0.0, player.getEyeHeight(), 0.0);
        Vector vector = location.getDirection().normalize().multiply(n);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        RayTraceResult rayTraceResult = craftWorld.rayTraceBlocks(location, vector, (double)n, bl ? FluidCollisionMode.ALWAYS : FluidCollisionMode.NEVER);
        Block block = null;
        block = rayTraceResult == null ? player.getTargetBlock(null, n) : rayTraceResult.getHitBlock();
        return block;
    }

    @Override
    public Block getBlockLookingAt(World world2, Vector vector, Vector vector2, boolean bl) {
        try {
            CraftWorld craftWorld = (CraftWorld)world2;
            RayTrace rayTrace = new RayTrace(new Vec3D(vector.getX(), vector.getY(), vector.getZ()), new Vec3D(vector2.getX(), vector2.getY(), vector2.getZ()), RayTrace.BlockCollisionOption.COLLIDER, bl ? RayTrace.FluidCollisionOption.ANY : RayTrace.FluidCollisionOption.NONE, null);
            MovingObjectPositionBlock movingObjectPositionBlock = craftWorld.getHandle().rayTrace(rayTrace);
            RayTraceResult rayTraceResult = CraftRayTraceResult.fromNMS((World)craftWorld, (MovingObjectPosition)movingObjectPositionBlock);
            return rayTraceResult == null ? null : rayTraceResult.getHitBlock();
        }
        catch (Throwable throwable) {
            if (!this.informed) {
                throwable.printStackTrace();
                this.informed = true;
            }
            return null;
        }
    }
}

