/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.CustomText;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.CustomText.CText;
import com.Zrips.CMI.Modules.CustomText.CTextPage;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.ctext;
import com.Zrips.CMI.commands.list.editctext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import net.Zrips.CMILib.Chat.ChatMessageEdit;
import net.Zrips.CMILib.Chat.ChatMessageListEdit;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.Images.CMIImage;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.RawMessages.RawMessageCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CTextManager {
    private LinkedHashMap<String, CText> map = new LinkedHashMap();
    private HashMap<UUID, String> chatMap = new HashMap();
    private CMI plugin;
    private ChatFilterRule pageLabelRegex = new ChatFilterRule().setPattern("^(?i)(<pageLabel)(:)?([^>]*)(>)$");

    public CTextManager(CMI cMI) {
        this.plugin = cMI;
    }

    public HashMap<String, CText> getAll() {
        return this.map;
    }

    public void deleteCText(String string) {
        this.map.remove(string.toLowerCase());
    }

    public CText getCText(String string) {
        if (string == null) {
            return null;
        }
        return this.map.get(string.toLowerCase());
    }

    public boolean isChatEditing(Player player) {
        return this.chatMap.containsKey(player.getUniqueId());
    }

    public void addChatEditor(Player player, String string) {
        if (player == null) {
            return;
        }
        if (!string.endsWith(" ")) {
            string = String.valueOf(string) + " ";
        }
        this.chatMap.put(player.getUniqueId(), string);
    }

    public void removeChatEditor(Player player) {
        this.chatMap.remove(player.getUniqueId());
    }

    public String getChatEditorCmd(Player player) {
        return this.chatMap.get(player.getUniqueId());
    }

    public CText addNewCText(String string) {
        CText cText = new CText(string);
        this.map.put(string.toLowerCase(), cText);
        return cText;
    }

    public void load() {
        File[] fileArray;
        Long l = System.currentTimeMillis();
        this.map.clear();
        File file = new File(this.plugin.getDataFolder(), "CustomText");
        if (!file.isDirectory()) {
            file.mkdir();
            return;
        }
        File[] fileArray2 = fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            CText cText = this.getCTextFromFile(file2);
            if (cText != null) {
                String string = file2.getName().replace(".txt", "");
                this.map.put(string.toLowerCase(), cText);
            }
            ++n2;
        }
        if (!this.map.isEmpty()) {
            this.plugin.loadMessage(this.map.size(), "custom text's", System.currentTimeMillis() - l);
        }
    }

    public CText getCTextFromFile(File file) {
        String string;
        ArrayList<String> arrayList;
        block27: {
            if (!file.getName().endsWith(".txt") && !file.getName().endsWith(".yml")) {
                return null;
            }
            arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    string = bufferedReader.readLine();
                    while (string != null) {
                        arrayList.add(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        string = file.getName().replace(".txt", "");
        CText cText = new CText(string);
        int n = 1;
        int n2 = 0;
        for (String string2 : arrayList) {
            if (++n2 == 1) {
                boolean bl = false;
                if (string2.contains("<AutoPage>")) {
                    cText.setAutoPage(true);
                    bl = true;
                }
                if (string2.contains("<Hidden>")) {
                    cText.setHidden(true);
                    bl = true;
                }
                if (string2.contains("<NoAutoPage>")) {
                    cText.setAutoPage(false);
                    bl = true;
                }
                if (string2.contains("<AutoAlias>")) {
                    cText.setAutoAlias(true, false);
                    bl = true;
                }
                if (string2.contains("<ReqPermission>")) {
                    cText.setRequirePermission(true);
                    bl = true;
                }
                if (string2.contains("<NoAutoAlias>")) {
                    cText.setAutoAlias(false, false);
                    bl = true;
                }
                if (bl) continue;
            }
            if (string2.equalsIgnoreCase("<NextPage>")) {
                ++n;
                continue;
            }
            Matcher matcher = this.pageLabelRegex.getMatcher(string2);
            if (matcher != null) {
                while (matcher.find()) {
                    String string3 = matcher.group(3);
                    if (string3 == null || string3.isEmpty()) continue;
                    cText.addPageLabel(n, string3);
                }
                continue;
            }
            cText.addLine(n, string2);
        }
        return cText;
    }

    public void save(CText cText) {
        File file = new File(this.plugin.getDataFolder(), "CustomText");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        File file2 = new File(file, String.valueOf(cText.getName()) + ".txt");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        string = cText.isAutoPage() ? String.valueOf(string) + "<AutoPage>" : String.valueOf(string) + "<NoAutoPage>";
        if (cText.isHidden()) {
            string = String.valueOf(string) + "<Hidden>";
        }
        string = cText.isAutoAlias() ? String.valueOf(string) + "<AutoAlias>" : String.valueOf(string) + "<NoAutoAlias>";
        string = cText.isRequirePermission() ? String.valueOf(string) + "<ReqPermission>" : String.valueOf(string) + "<NoReqPermission>";
        arrayList.add(string);
        for (Map.Entry<Integer, CTextPage> entry : cText.getPagesMap().entrySet()) {
            if (arrayList.size() > 1) {
                arrayList.add("<NextPage>");
            }
            if (entry.getValue().getLabel() != null) {
                arrayList.add("<pageLabel:" + entry.getValue().getLabel() + ">");
            }
            arrayList.addAll(entry.getValue().getLines());
        }
        try {
            Files.write(file2.toPath(), arrayList, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void delete(CText cText) {
        File file;
        if (cText.isAutoAlias()) {
            cText.setAutoAlias(false, true);
        }
        if (!(file = new File(this.plugin.getDataFolder(), "CustomText")).isDirectory()) {
            file.mkdir();
            return;
        }
        File file2 = new File(file, String.valueOf(cText.getName()) + ".txt");
        file2.delete();
    }

    public void removeCTextLine(CText cText, Integer n, Integer n2) {
        CTextPage cTextPage = cText.getPageInfo(n);
        if (cTextPage == null) {
            return;
        }
        if (n2 < 0 || n2 + 1 > cTextPage.getLines().size()) {
            return;
        }
        cTextPage.getLines().remove(n2);
        cText.addPage((int)n, cTextPage);
    }

    public List<String> move(List<String> list2, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        String string = "";
        String string2 = "";
        if (list2.size() >= n4 + 1 && n4 >= 0) {
            string = list2.get(n4);
        }
        if (list2.size() >= n3 + 1 && n3 >= 0) {
            string2 = list2.get(n3);
        }
        if (!string.isEmpty() && !string2.isEmpty()) {
            list2.set(n4, string2);
            list2.set(n3, string);
        }
        return list2;
    }

    public void showCTextEditor(CommandSender commandSender, final CText cText, Integer n) {
        CTextPage cTextPage;
        CTextPage cTextPage2;
        if (n < 1) {
            n = 1;
        }
        if ((cTextPage2 = cText.getPageInfo(n)) == null && n > 1) {
            n = cText.getTotalPages() - 1;
            cTextPage2 = cText.getPageInfo(n);
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.addText(cText.isAutoPage() ? LC.modify_enabledSymbol.getLocale(new Object[0]) : LC.modify_disabledSymbol.getLocale(new Object[0])).addHover(CMILC.getIM(editctext.class, "autoPage", "[state]", cText.isAutoPage())).addCommand("cmi editctext " + cText.getName() + " autopage " + !cText.isAutoPage());
        rawMessage.addText(" ");
        rawMessage.addText(cText.isAutoAlias() ? LC.modify_enabledSymbol.getLocale(new Object[0]) : LC.modify_disabledSymbol.getLocale(new Object[0])).addHover(CMILC.getIM(editctext.class, "autoAlias", "[state]", cText.isAutoAlias())).addCommand("cmi editctext " + cText.getName() + " autoalias " + !cText.isAutoAlias());
        rawMessage.addText(" ");
        rawMessage.addText(cText.isRequirePermission() ? LC.modify_enabledSymbol.getLocale(new Object[0]) : LC.modify_disabledSymbol.getLocale(new Object[0])).addHover(String.valueOf(CMILC.getIM(editctext.class, "permReq", "[state]", cText.isRequirePermission())) + "\n" + "&ecmi.command.ctext." + cText.getName()).addCommand("cmi editctext " + cText.getName() + " permreg " + !cText.isRequirePermission());
        rawMessage.addText(" ");
        rawMessage.addText(cText.isHidden() ? LC.modify_enabledSymbol.getLocale(new Object[0]) : LC.modify_disabledSymbol.getLocale(new Object[0])).addHover(CMILC.getIM(editctext.class, "hidden", "[state]", cText.isHidden())).addCommand("cmi editctext " + cText.getName() + " hidden " + !cText.isHidden());
        rawMessage.addText(" ");
        rawMessage.addText(LC.modify_newPage.getLocale(new Object[0])).addHover(LC.modify_newPageHover.getLocale(new Object[0])).addCommand("cmi editctext " + cText.getName() + " " + n + " newpage");
        if (cTextPage2 != null) {
            cTextPage = cTextPage2;
            final Integer n2 = n;
            RawMessageCommand rawMessageCommand = new RawMessageCommand(){

                public void run(final CommandSender commandSender) {
                    ChatMessageEdit chatMessageEdit = new ChatMessageEdit(commandSender, cTextPage.getLabel() == null ? "" : cTextPage.getLabel()){

                        public void run(String string) {
                            if (!CMIText.isValidString((String)string)) {
                                return;
                            }
                            if (string.isEmpty() || string.equals("_") || string.equalsIgnoreCase("delete")) {
                                cTextPage.setLabel(null);
                            } else {
                                cTextPage.setLabel(string);
                            }
                            CTextManager.this.showCTextEditor(commandSender, cText, n2);
                            CTextManager.this.save(cText);
                        }

                        public void onCancel() {
                            CTextManager.this.showCTextEditor(commandSender, cText, n2);
                        }
                    };
                    chatMessageEdit.setCheckForCancel(true);
                    chatMessageEdit.printMessage();
                }
            };
            rawMessage.addText(CMILC.getIM(editctext.class, "pageLabel", new Object[0])).addHover(CMILC.getIM(editctext.class, "pageLabelHover", "[value]", cTextPage2.getLabel() == null ? "N/A" : cTextPage2.getLabel())).addCommand(rawMessageCommand);
        }
        rawMessage.addText("  ");
        rawMessage.addText(LC.modify_removePage.getLocale(new Object[0])).addHover(LC.modify_removePageHover.getLocale(new Object[0])).addCommand("cmi editctext " + cText.getName() + " " + n + " removepage");
        rawMessage.show(commandSender);
        if (cTextPage2 != null) {
            cTextPage = new ChatMessageListEdit(commandSender, cTextPage2.getLines(), ChatMessageListEdit.ChatEditType.String){

                public void onUpdate() {
                    CTextManager.this.save(cText);
                }
            };
            cTextPage.print();
        }
        cTextPage = new PageInfo(cTextPage2 != null ? cTextPage2.getLines().size() : 10, (cTextPage2 != null ? cTextPage2.getLines().size() : 10) * cText.getTotalPages(), n.intValue());
        try {
            cTextPage.setCustomNext(cText.getPageInfo(n + 1 > cText.getTotalPages() ? 1 : n + 1).getLabel());
            cTextPage.setCustomPrev(cText.getPageInfo(n - 1 < 1 ? cText.getTotalPages() : n - 1).getLabel());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        cTextPage.autoPagination(commandSender, String.valueOf(CommandsHandler.getLabel()) + " " + editctext.class.getSimpleName() + " " + cText.getName(), "-p:");
    }

    public void showCText(CommandSender commandSender, CText cText, Integer n) {
        this.showCText(commandSender, null, cText, n);
    }

    public void showCText(CommandSender commandSender, CMIUser cMIUser, CText cText, Integer n) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        hashSet.add((Player)commandSender);
        this.showCText(hashSet, cMIUser, cText, n);
    }

    public void showCText(Set<Player> set, final CMIUser cMIUser, final CText cText, Integer n) {
        CTextPage cTextPage = cText.getPageInfo(n);
        if (cTextPage == null) {
            return;
        }
        boolean bl = true;
        Boolean bl2 = null;
        for (Player player : set) {
            Snd snd = new Snd().setSender(player).setSource(cMIUser).setTarget(cMIUser);
            if (cMIUser == null) {
                snd.setSource(player);
                snd.setTarget(player);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<String> iterator = cTextPage.getLines().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                string2 = this.plugin.getLM().updateSnd(snd, string2);
                if (bl2 == null) {
                    bl2 = !string.isEmpty() && string.equals(string2) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                string2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(cMIUser == null ? player.getUniqueId() : cMIUser.getUniqueId(), string2);
                if (bl && !CMIChatColor.stripColor((String)string).isEmpty() && !string.equals(string2)) {
                    bl = false;
                }
                arrayList.add(string2);
            }
            CompletableFuture object2 = CMIImage.convertIntoRawMessage((CommandSender)player, (String)Config.imageFolder, arrayList, (boolean)false);
            object2.thenApply(rawMessage -> {
                rawMessage.show(player);
                if (!cText.isAutoPage()) {
                    return rawMessage;
                }
                PageInfo pageInfo = new PageInfo(1, cText.getTotalPages(), n){

                    public Boolean pageChange(int n) {
                        CTextManager.this.showCText((CommandSender)player, cMIUser, cText, (Integer)n);
                        return true;
                    }
                };
                try {
                    pageInfo.setCustomNext(cText.getPageInfo(n + 1 > cText.getTotalPages() ? 1 : n + 1).getLabel());
                    pageInfo.setCustomPrev(cText.getPageInfo(n - 1 < 1 ? cText.getTotalPages() : n - 1).getLabel());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                pageInfo.autoPagination((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + ctext.class.getSimpleName() + " " + cText.getName(), null);
                return rawMessage;
            });
        }
    }

    public static String clean(String string) {
        if (string == null || !string.contains("<")) {
            return string;
        }
        string = string.replaceAll(".*\\<T>|\\</T>.*", "");
        string = string.replaceAll(".*\\<H>|\\</H>.*", "");
        string = string.replaceAll(".*\\<C>|\\</C>.*", "");
        string = string.replaceAll(".*\\<CC>|\\</CC>.*", "");
        string = string.replaceAll(".*\\<CCI>|\\</CCI>.*", "");
        return string;
    }
}

