/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ArmorEffects;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorEffectManager {
    private CMI plugin;
    public static final String NBTName = "CMIArmorEffects";
    private Set<UUID> players = new HashSet<UUID>();
    private CMITask saveId = null;

    public ArmorEffectManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void removePlayer(UUID uUID) {
        this.players.remove(uUID);
        if (this.players.isEmpty()) {
            this.onDisable();
        }
    }

    public void addPlayer(UUID uUID) {
        this.players.add(uUID);
    }

    public void onDisable() {
        if (this.saveId != null) {
            this.saveId.cancel();
            this.saveId = null;
        }
    }

    public void tasker() {
        if (this.saveId != null) {
            return;
        }
        this.saveId = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.players.isEmpty()) {
                this.onDisable();
                return;
            }
            Iterator<UUID> iterator = this.players.iterator();
            while (iterator.hasNext()) {
                UUID uUID = iterator.next();
                Player player = CMIUser.getOnlinePlayer(uUID);
                if (player == null || !player.isOnline()) {
                    iterator.remove();
                    continue;
                }
                if (this.checkPlayerArmor(player)) continue;
                iterator.remove();
            }
        }, (long)280L, (long)280L);
    }

    public boolean checkPlayerArmor(Player player) {
        boolean bl = false;
        ItemStack[] itemStackArray = player.getInventory().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> list2;
            CMINBT cMINBT;
            ItemStack itemStack = itemStackArray[n2];
            if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR) && (cMINBT = new CMINBT(itemStack)).hasNBT(NBTName) && (list2 = cMINBT.getList(NBTName)) != null) {
                bl = true;
                this.tasker();
                list2 = CMIEncoder.decodeList(list2);
                for (String string : list2) {
                    PotionEffect potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string);
                    if (potionEffect == null) continue;
                    PotionEffect potionEffect2 = ArmorEffectManager.getPotionEffect(player, potionEffect.getType());
                    if (potionEffect2 != null) {
                        if ((!potionEffect2.getType().equals(PotionEffectType.NIGHT_VISION) || potionEffect2.getDuration() - 20 > potionEffect.getDuration()) && potionEffect2.getDuration() - 12 > potionEffect.getDuration()) continue;
                        if (potionEffect2.getType().equals(PotionEffectType.NIGHT_VISION)) {
                            potionEffect = this.plugin.getUtilManager().deserializePotionEffect(string, 30);
                        }
                        if (Version.isCurrentLower((Version)Version.v1_20_R1)) {
                            player.removePotionEffect(potionEffect.getType());
                        }
                        player.addPotionEffect(potionEffect);
                        if (!player.isFlying() || !potionEffect.getType().getName().equals("LEVITATION")) continue;
                        player.setFlying(false);
                        continue;
                    }
                    player.addPotionEffect(potionEffect);
                    if (!player.isFlying() || !potionEffect.getType().getName().equals("LEVITATION")) continue;
                    player.setFlying(false);
                }
            }
            ++n2;
        }
        return bl;
    }

    public static PotionEffect getPotionEffect(Player player, PotionEffectType potionEffectType) {
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            return player.getPotionEffect(potionEffectType);
        }
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            if (potionEffect.getType() != potionEffectType) continue;
            return potionEffect;
        }
        return null;
    }
}

