/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Elytra;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Speed;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.events.CMIArmorChangeEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Items.ArmorTypes;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ElytraBoostListener
implements Listener {
    private CMI plugin;
    private Effect eff = null;
    HashMap<UUID, Speed> speedMap = new HashMap();

    public ElytraBoostListener(CMI cMI) {
        this.plugin = cMI;
        Effect[] effectArray = Effect.values();
        int n = effectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Effect effect2 = effectArray[n2];
            if (effect2.name().equalsIgnoreCase("ENDERDRAGON_SHOOT")) {
                this.eff = effect2;
            }
            ++n2;
        }
    }

    @EventHandler
    public void onPlayerSpeed(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        Speed speed2 = this.speedMap.get(player.getUniqueId());
        if (!player.isGliding()) {
            if (speed2 != null) {
                this.speedMap.remove(player.getUniqueId());
            }
            return;
        }
        if (speed2 != null) {
            short s;
            short s2;
            double d;
            Object object;
            if (speed2.isBoosting() && this.plugin.getElytraManager().isBoostShowParticles()) {
                if (!speed2.isSuperBoosting()) {
                    ElytraBoostListener.showParticle(player, Particle.CLOUD);
                } else {
                    ElytraBoostListener.showParticle(player, Particle.FLAME);
                }
            }
            if (!speed2.isSpeedometer()) {
                return;
            }
            if (!speed2.isGoodTime()) {
                return;
            }
            String string = "";
            if (speed2.isBoosting()) {
                string = CMILC.Elytra_SpeedBoost.getLocale(new Object[0]);
            }
            double d2 = speed2.getSpeed();
            String string2 = String.valueOf(d2);
            try {
                DecimalFormat decimalFormat = new DecimalFormat("#000.00");
                if (!this.plugin.getElytraManager().isBoostSpeedDecimals()) {
                    decimalFormat = new DecimalFormat("#000");
                }
                string2 = decimalFormat.format(speed2.getSpeed());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            if (speed2.isShowDurability() && this.plugin.getConfigManager().isArmorDurabilityLossUse() && (object = CMILib.getInstance().getItemManager().getItem(player.getInventory().getChestplate())) != null && object.getCMIType().equals((Object)CMIMaterial.ELYTRA) && (d = 100.0 - (double)(s2 = object.getDurability()) * 100.0 / (double)(s = object.getMaxDurability())) <= (double)this.plugin.getConfigManager().getArmorDurabilityLossPercentage()) {
                bl = true;
            }
            if (bl) {
                object = CMILC.Elytra_Speed.getLocale("[speed]", string2);
                object = "&c" + CMIChatColor.stripColor((String)object);
                CMIActionBar.send((Player)player, (String)(String.valueOf(string) + (String)object + string));
            } else {
                CMIActionBar.send((Player)player, (String)(String.valueOf(string) + CMILC.Elytra_Speed.getLocale("[speed]", string2) + string));
            }
            speed2.setTime(System.currentTimeMillis());
            speed2.setLoc(player.getLocation());
        } else {
            this.speedMap.put(player.getUniqueId(), new Speed(player));
        }
    }

    @EventHandler
    public void onInventoryClick(CMIArmorChangeEvent cMIArmorChangeEvent) {
        if (cMIArmorChangeEvent.getType() == ArmorTypes.ELYTRA && !PermissionsManager.CMIPerm.elytra.hasPermission((CommandSender)cMIArmorChangeEvent.getPlayer())) {
            cMIArmorChangeEvent.setCancelled(true);
            CMILC.Elytra_CanUse.sendMessage(cMIArmorChangeEvent.getPlayer(), new Object[0]);
        }
    }

    public static double xPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.cos(Math.PI / 180 * d3);
    }

    public static double yPosYaw(double d, double d2) {
        return Math.cos(d) * d2;
    }

    public static double zPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.sin(Math.PI / 180 * d3);
    }

    public double zPosPitch2(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.sin(Math.PI / 180 * d3);
    }

    public void spawnCircle(Player player) {
        ElytraBoostListener.spawnCircle(player.getLocation());
    }

    public static void spawnCircle(Location location) {
        Location location2 = location.clone();
        double d = (double)location2.getYaw() / 180.0 * Math.PI;
        double d2 = (double)location2.getPitch() / 180.0 * Math.PI;
        double d3 = 1.0;
        location2 = location2.add(location2.getDirection());
        ElytraBoostListener.draw(location2, d3, d, d2, true);
        d3 = 0.5;
        location2 = location2.subtract(location2.getDirection());
        ElytraBoostListener.draw(location2, d3, d, d2, true);
    }

    private static void draw(Location location, double d, double d2, double d3, boolean bl) {
        Random random = new Random(System.currentTimeMillis());
        double d4 = 0.0;
        while (d4 < 360.0) {
            double d5 = d;
            if (bl) {
                d5 = (double)random.nextInt((int)(d * 10.0)) / 10.0;
            }
            double d6 = ElytraBoostListener.xPosYaw(Math.toRadians(d4), d5, d2);
            double d7 = ElytraBoostListener.yPosYaw(Math.toRadians(d4), d5);
            double d8 = ElytraBoostListener.zPosYaw(Math.toRadians(d4), d5, d2);
            Vector vector = new Vector(d6, d7, d8);
            vector = ElytraBoostListener.rotateX(vector, d3);
            vector = ElytraBoostListener.rotateY(vector, -d2);
            Location location2 = new Location(location.getWorld(), vector.getX() + location.getX(), vector.getY() + location.getY(), vector.getZ() + location.getZ());
            location.getWorld().spawnParticle(Particle.FLAME, location2, 1, 0.0, 0.0, 0.0, 0.0);
            d4 += 15.0;
        }
    }

    private static Vector rotateX(Vector vector, double d) {
        double d2 = Math.cos(d) * vector.getY() - Math.sin(d) * vector.getZ();
        double d3 = Math.sin(d) * vector.getY() + Math.cos(d) * vector.getZ();
        return vector.setY(d2).setZ(d3);
    }

    private static Vector rotateY(Vector vector, double d) {
        double d2 = Math.cos(d) * vector.getX() + Math.sin(d) * vector.getZ();
        double d3 = -Math.sin(d) * vector.getX() + Math.cos(d) * vector.getZ();
        return vector.setX(d2).setZ(d3);
    }

    @EventHandler
    public void EntityToggleGlideEvent(EntityToggleGlideEvent entityToggleGlideEvent) {
        if (!(entityToggleGlideEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityToggleGlideEvent.getEntity();
        if (entityToggleGlideEvent.isGliding()) {
            this.speedMap.put(player.getUniqueId(), new Speed(player));
        } else {
            this.speedMap.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onElytraFlight(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!player.isGliding()) {
            return;
        }
        Action action = playerInteractEvent.getAction();
        if (action == Action.PHYSICAL) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (this.plugin.getElytraManager().isPreventRocketUsage() && (CMIMaterial.get((ItemStack)cMIUser.getItemInHand()) == CMIMaterial.FIREWORK_ROCKET || CMIMaterial.get((ItemStack)cMIUser.getItemInOffHand()) == CMIMaterial.FIREWORK_ROCKET)) {
            playerInteractEvent.setCancelled(true);
        }
        if (!this.plugin.getElytraManager().getBoostItem().isAir() && action != Action.RIGHT_CLICK_AIR && action != Action.LEFT_CLICK_AIR) {
            return;
        }
        int n = this.plugin.getElytraManager().getBoostAmount();
        double d = this.plugin.getElytraManager().getBoostMultyplier();
        Speed speed2 = this.speedMap.get(player.getUniqueId());
        if (speed2 != null && !speed2.isAllowBoost()) {
            return;
        }
        if (speed2 == null || speed2.getSpeed() < (double)this.plugin.getElytraManager().getBoostSpeedLimit()) {
            ItemStack itemStack;
            if (player.isSneaking()) {
                if (speed2 == null || !speed2.isSuperBoosting() && speed2.isAllowSuperBoost()) {
                    this.spawnCircle(player);
                    if (this.eff != null) {
                        player.getWorld().playEffect(player.getLocation(), this.eff, 0);
                    }
                    d = this.plugin.getElytraManager().getBoostSuperMultyplier();
                    n = this.plugin.getElytraManager().getBoostSuperAmount();
                }
                if (speed2 != null && speed2.isAllowSuperBoost()) {
                    speed2.setSuperBoost(System.currentTimeMillis());
                }
            }
            if (speed2 != null) {
                speed2.setBoost(System.currentTimeMillis());
            }
            if (this.plugin.getElytraManager().isBoostRequiresItem()) {
                itemStack = player.getInventory().getItemInMainHand();
                if (!this.plugin.getElytraManager().getBoostItem().isAir() && this.plugin.getElytraManager().getBoostItem() != CMIMaterial.get((ItemStack)itemStack)) {
                    return;
                }
            }
            if (speed2 != null && !speed2.isFree()) {
                if (this.plugin.getElytraManager().isBoostUseItems()) {
                    itemStack = player.getInventory().getItemInMainHand();
                    if (itemStack == null) {
                        return;
                    }
                    if (!this.plugin.getElytraManager().getBoostItemConsume().isAir() && !cMIUser.getInventory().contains(this.plugin.getElytraManager().getBoostItemConsume().newItemStack())) {
                        return;
                    }
                    cMIUser.getInventory().removeItemByCriteria(this.plugin.getElytraManager().getBoostItemConsume().newItemStack(), CMIPlayerInventory.itemCheckType.material);
                    player.updateInventory();
                } else {
                    long l = cMIUser.getTotalExp();
                    if (l < (long)n) {
                        d = (double)l / (double)n;
                    }
                    if (l > (long)n) {
                        cMIUser.takeExp(n);
                    }
                }
            }
            ElytraBoostListener.setVel(player, d);
        }
    }

    private static void setVel(Player player, double d) {
        player.setVelocity(player.getVelocity().add(player.getLocation().getDirection().multiply(d)));
    }

    private static void showParticle(Player player, Particle particle) {
        player.getWorld().spawnParticle(particle, player.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
    }
}

