/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.utils;

import com.Zrips.CMI.CMI;
import java.security.Security;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.plugin.Plugin;

public class CMIEncoder {
    static Cipher encryptor;
    static Cipher decryptor;
    private static final String fineName = "security.key";

    public static void initialize() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), fineName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        configReader.addComment("KEY", new String[]{"DO NOT EDIT THIS!"});
        String string = configReader.get("KEY", UUID.randomUUID().toString().replace("-", ""));
        String string2 = configReader.get("KEY128", UUID.randomUUID().toString().replace("-", "").substring(16));
        configReader.save();
        SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), "AES");
        SecretKeySpec secretKeySpec2 = new SecretKeySpec(string2.getBytes(), "AES");
        try {
            Security.setProperty("crypto.policy", "unlimited");
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            encryptor = Cipher.getInstance("AES");
            decryptor = Cipher.getInstance("AES");
            encryptor.init(1, secretKeySpec);
            decryptor.init(2, secretKeySpec);
            CMI.getInstance().consoleMessage("Initialized Cipher256 " + encryptor.getAlgorithm());
        }
        catch (Error | Exception throwable) {
            try {
                encryptor = Cipher.getInstance("AES");
                decryptor = Cipher.getInstance("AES");
                encryptor.init(1, secretKeySpec2);
                decryptor.init(2, secretKeySpec2);
                CMI.getInstance().consoleMessage("Initialized Cipher128 " + encryptor.getAlgorithm());
            }
            catch (Error | Exception throwable2) {
                CMI.getInstance().consoleMessage("&eFailed to setup encoder by using key in security.key file.");
                CMI.getInstance().consoleMessage("&eEncryption will be disabled. This will not effect plugins work");
                CMI.getInstance().consoleMessage("&eThis is usually caused by outdated Java version in your server. Get atleast Java 8 u162");
                encryptor = null;
                decryptor = null;
            }
        }
    }

    public static String encode(String string) {
        if (encryptor == null) {
            return string;
        }
        try {
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(encryptor.doFinal(string.getBytes("UTF8")));
        }
        catch (Error | Exception throwable) {
            return string;
        }
    }

    public static boolean isEncoded(String string) {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            decoder.decode(string);
            return true;
        }
        catch (Error | Exception throwable) {
            return false;
        }
    }

    public static String decode(String string) {
        if (decryptor == null) {
            return string;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            return new String(decryptor.doFinal(decoder.decode(string)), "UTF8");
        }
        catch (Error | Exception throwable) {
            return null;
        }
    }

    public static List<String> encode(List<String> list2) {
        if (encryptor == null) {
            return list2;
        }
        try {
            Base64.Encoder encoder = Base64.getEncoder();
            int n = 0;
            while (n < list2.size()) {
                list2.set(n, encoder.encodeToString(encryptor.doFinal(list2.get(n).getBytes("UTF8"))));
                ++n;
            }
            return list2;
        }
        catch (Error | Exception throwable) {
            return list2;
        }
    }

    @Deprecated
    public static List<String> decode2(List<String> list2) {
        return CMIEncoder.decodeList(list2);
    }

    public static List<String> decodeList(List<String> list2) {
        if (decryptor == null) {
            return list2;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            int n = 0;
            while (n < list2.size()) {
                list2.set(n, new String(decryptor.doFinal(decoder.decode(list2.get(n))), "UTF8"));
                ++n;
            }
            return list2;
        }
        catch (Error | Exception throwable) {
            return null;
        }
    }
}

