/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFormat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFormat.ChatFormatManager;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.chat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.RawMessages.RawMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CMIChatRoom {
    private Set<CMIUser> users = new HashSet<CMIUser>();
    private Set<CMIUser> watchers = new HashSet<CMIUser>();
    private String chatName;
    private UUID owner;
    private boolean priv = false;
    private boolean locked = false;
    private boolean persistent = false;
    private Set<UUID> invitations;
    private long keepAliveUntil = 0L;

    public CMIChatRoom(String string) {
        this.chatName = string;
    }

    public String getChatName() {
        return this.chatName;
    }

    public void setChatName(String string) {
        this.chatName = string;
    }

    public Set<CMIUser> getUsers() {
        return this.users;
    }

    public Set<CMIUser> getWatchers() {
        return this.watchers;
    }

    public Set<UUID> getWatchersUUID() {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (CMIUser cMIUser : this.getWatchers()) {
            hashSet.add(cMIUser.getUniqueId());
        }
        return hashSet;
    }

    public void addUser(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        this.users.add(cMIUser);
        cMIUser.setChatRoom(this);
        this.keepAliveUntil = 0L;
    }

    public boolean removeUser(CMIUser cMIUser) {
        if (cMIUser == null) {
            return false;
        }
        cMIUser.setChatRoom(null);
        boolean bl = this.users.remove(cMIUser);
        this.keepAliveUntil = this.users.isEmpty() && !this.persistent ? System.currentTimeMillis() + (long)ChatFormatManager.ChatRoomLife * 1000L : System.currentTimeMillis() + 604800000L;
        return bl;
    }

    public void addWatcher(CMIUser cMIUser) {
        this.watchers.add(cMIUser);
    }

    public boolean removeWatcher(CMIUser cMIUser) {
        return this.watchers.remove(cMIUser);
    }

    public void broadcastMessage(CMIUser cMIUser, String string) {
        Object object2;
        this.cleanOldUsers();
        if (cMIUser == null) {
            return;
        }
        Snd snd = new Snd();
        snd.setSender(cMIUser);
        snd.setTarget(cMIUser);
        if (!PermissionsManager.CMIPerm.command_socialspy_hide.hasPermission((CommandSender)cMIUser.getPlayer())) {
            CMI.getInstance().getPlayerManager().sendChatRoomMessageToSpies((CommandSender)cMIUser.getPlayer(), this.getChatName(), string);
        }
        if (this.users.size() == 1) {
            CMILC.info(chat.class, (CommandSender)cMIUser.getPlayer(), "nobody", new Object[0]);
            return;
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.setDontBreakLine(true);
        String string2 = CMILC.Chat_privateHover.getLocale(new Object[0]);
        string2 = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), string2);
        if (CMI.getInstance().getChatFormatManager().containsUrl(string)) {
            object2 = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), CMILC.getIM(chat.class, "format", snd, "[chatRoomName]", this.getChatName(), "[message]", ""));
            rawMessage.addText((String)object2).addHover(string2);
            ChatFormatManager.chatClickAction.helpop.updateClickAction(rawMessage, cMIUser);
            CMI.getInstance().getChatFormatManager().convertHoverOver(rawMessage, string, cMIUser.getPlayer());
        } else {
            rawMessage.addText(CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(cMIUser.getPlayer(), CMILC.getIM(chat.class, "format", snd, "[chatRoomName]", this.getChatName(), "[message]", string))).addHover(string2);
            ChatFormatManager.chatClickAction.helpop.updateClickAction(rawMessage, cMIUser);
        }
        object2 = new HashSet();
        for (CMIUser cMIUser2 : new HashSet<CMIUser>(this.users)) {
            if (!cMIUser2.isOnline()) continue;
            object2.add(cMIUser2.getPlayer());
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (CMIUser cMIUser3 : new HashSet<CMIUser>(this.watchers)) {
            if (!cMIUser3.isOnline()) continue;
            hashSet.add(cMIUser3.getPlayer());
        }
        if (!hashSet.isEmpty()) {
            RawMessage rawMessage2 = new RawMessage();
            rawMessage2.setDontBreakLine(true);
            rawMessage2.addText(CMILC.getIM(chat.class, "watcherSymbolActive", new Object[0]) + CMILC.getIM(chat.class, "watcherSymbol", new Object[0]));
            rawMessage2.addRM(rawMessage);
            rawMessage2.show(hashSet);
        }
        rawMessage.show((Set)object2);
        rawMessage.show((CommandSender)Bukkit.getConsoleSender());
    }

    public void cleanOldUsers() {
        for (CMIUser cMIUser : new HashSet<CMIUser>(this.users)) {
            if (cMIUser.isOnline() || cMIUser.getLastLogoff() + 60000L > System.currentTimeMillis()) continue;
            this.removeUser(cMIUser);
        }
    }

    public void informLeave(CMIUser cMIUser) {
        Snd snd = new Snd();
        snd.setSender(cMIUser);
        snd.setTarget(cMIUser);
        String string = CMILC.getIM(chat.class, "leftInfo", snd);
        for (CMIUser cMIUser2 : new HashSet<CMIUser>(this.users)) {
            if (!cMIUser2.isOnline() || cMIUser2.equals(cMIUser)) continue;
            cMIUser2.sendMessage(string);
        }
        for (CMIUser cMIUser2 : new HashSet<CMIUser>(this.watchers)) {
            if (!cMIUser2.isOnline() || cMIUser2.equals(cMIUser)) continue;
            cMIUser2.sendMessage(string);
        }
    }

    public void informJoin(CMIUser cMIUser) {
        Snd snd = new Snd();
        snd.setSender(cMIUser);
        snd.setTarget(cMIUser);
        String string = CMILC.getIM(chat.class, "joinedInfo", snd);
        for (CMIUser cMIUser2 : new HashSet<CMIUser>(this.users)) {
            if (!cMIUser2.isOnline() || cMIUser2.equals(cMIUser)) continue;
            cMIUser2.sendMessage(string);
        }
        for (CMIUser cMIUser2 : new HashSet<CMIUser>(this.watchers)) {
            if (!cMIUser2.isOnline() || cMIUser2.equals(cMIUser)) continue;
            cMIUser2.sendMessage(string);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID uUID) {
        this.owner = uUID;
    }

    public boolean isOwner(UUID uUID) {
        return this.owner.equals(uUID);
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public void setPrivate(boolean bl) {
        this.priv = bl;
    }

    public boolean kick(CMIUser cMIUser) {
        boolean bl = this.users.remove(cMIUser);
        if (!bl) {
            return false;
        }
        if (cMIUser.getChatRoom() != null && cMIUser.getChatRoom().getChatName().equals(this.getChatName())) {
            cMIUser.setChatRoom(null);
        }
        this.removeInvitation(cMIUser.getUniqueId());
        this.keepAliveUntil = this.users.isEmpty() ? System.currentTimeMillis() + (long)ChatFormatManager.ChatRoomLife * 1000L : System.currentTimeMillis() + 604800000L;
        return true;
    }

    public Set<UUID> getInvitations() {
        return this.invitations;
    }

    public boolean isInvited(UUID uUID) {
        if (this.invitations == null) {
            return false;
        }
        return this.invitations.contains(uUID);
    }

    public void addInvitation(UUID uUID) {
        if (this.invitations == null) {
            this.invitations = new HashSet<UUID>();
        }
        this.invitations.add(uUID);
    }

    public void removeInvitation(UUID uUID) {
        if (this.invitations == null) {
            return;
        }
        this.invitations.remove(uUID);
    }

    public long getKeepAliveUntil() {
        return this.keepAliveUntil;
    }

    public void setKeepAliveUntil(long l) {
        this.keepAliveUntil = l;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }
}

