/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Economy;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Economy.Economy;
import com.Zrips.CMI.Modules.Economy.VaultManager;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.baltop;
import com.Zrips.CMI.utils.DateFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class EconomyManager {
    private CMI plugin;
    private boolean Enabled = false;
    private boolean CustomWorldsEnabled = false;
    private boolean Confirmation = false;
    private boolean LogEnabled = false;
    private Double MaxChequeValue;
    private boolean ChequePaper;
    private boolean ChequePermission;
    private boolean ChequeInCreative;
    private boolean ChequeAcceptNotEncoded;
    private boolean BalTopIncludeFakes;
    private long ExcludeInactive;
    private boolean BalTopDisplayWithShorts;
    private List<String> BalTopExclude;
    private List<String> BalTopExcludeStartingWith;
    private HashMap<String, Double> shortAmountValues = new HashMap();
    private String townyTownPrefix = "town-";
    private String townyNationPrefix = "nation-";
    private String townyDebtPrefix = "[DEBT]-";
    private String townyClosed_economy = "towny-server";
    private Boolean recalculatingTop = false;
    public static final String CMIDefaultWorld = "CMIGlobal";
    HashMap<String, WorldGroup> groups = new HashMap();
    private WorldGroup defaultGroup = null;
    private VaultManager vmanager = null;
    SortedMap<Double, UUID> balTop = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    Map<UUID, Double> balTopUsers = Collections.synchronizedMap(new HashMap());
    private Double totalServerMoney = 0.0;
    Long lastRecalculated = null;
    boolean locked = false;
    Map<UUID, baltopUpdateCache> balanceUpdateCache = Collections.synchronizedMap(new HashMap());
    int updateDelay = 15;
    CompletableFuture<Void> recTask = null;
    DecimalFormat defaultFormat;
    DecimalFormat shortDefaultFormat;
    File file = null;
    Writer writer = null;
    boolean checkedOldFile = false;
    private boolean recording = false;

    public EconomyManager(CMI cMI) {
        File file;
        this.plugin = cMI;
        if (!this.plugin.isEnabled()) {
            return;
        }
        VaultManager.EconomySetupResponse economySetupResponse = VaultManager.EconomySetupResponse.NoVault;
        if (CMIHookType.Vault.isPresent()) {
            this.vmanager = new VaultManager(cMI);
            economySetupResponse = this.vmanager.setupVault();
        }
        CMIHookType.Towny.init();
        if (CMIHookType.Towny.isPresent() && (file = new File("plugins" + File.separator + "Towny" + File.separator + "settings")).isDirectory()) {
            File file2 = new File("plugins" + File.separator + "Towny" + File.separator + "settings" + File.separator + "config.yml");
            try {
                ConfigReader configReader = new ConfigReader(file2);
                this.townyTownPrefix = configReader.getC().getString("economy.town_prefix");
                this.townyNationPrefix = configReader.getC().getString("economy.nation_prefix");
                if (configReader.getC().isString("economy.closed_economy.server_account")) {
                    this.townyClosed_economy = configReader.getC().getString("economy.closed_economy.server_account");
                }
                if (configReader.getC().isString("economy.debt_prefix")) {
                    this.townyDebtPrefix = configReader.getC().getString("economy.debt_prefix");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        switch (economySetupResponse) {
            case NoVault: {
                cMI.consoleMessage("&6Vault was not found, you will have limited economy support");
                break;
            }
            case NoVaultEconomy: {
                cMI.consoleMessage("&cVault was found but not economy plugin, you will have limited economy support");
                break;
            }
            case Vault: 
            case CMI: {
                cMI.consoleMessage("&7Vault &3was found - Enabling capabilities. Economy: &5" + this.vmanager.getVaultEconomy().getName());
                break;
            }
        }
        try {
            new Economy(cMI);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.Enabled = false;
            CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(cMI.prefix + "Cant find Vault plugin for economy compatability"));
        }
    }

    public void setForBalTopRecalculation() {
        this.lastRecalculated = null;
    }

    public String format(Double d) {
        if (d == null) {
            return "0";
        }
        if (this.vmanager == null) {
            return String.valueOf(d);
        }
        return this.vmanager.format(d);
    }

    public boolean isVaultEnabled() {
        return this.vmanager != null && this.vmanager.getVaultEconomy() != null;
    }

    public void removeFromUpdateCache(UUID uUID) {
        this.balanceUpdateCache.remove(uUID);
    }

    public synchronized void updateBalTop(CMIUser cMIUser) {
        baltopUpdateCache baltopUpdateCache2 = this.balanceUpdateCache.getOrDefault(cMIUser.getUniqueId(), new baltopUpdateCache());
        if (baltopUpdateCache2.getTime() == 0L || baltopUpdateCache2.getTime() < System.currentTimeMillis()) {
            this.forceUpdateBalTop(cMIUser);
            this.balanceUpdateCache.put(cMIUser.getUniqueId(), baltopUpdateCache2.setTime(System.currentTimeMillis() + (long)this.updateDelay * 1000L));
            return;
        }
        if (baltopUpdateCache2.getTask() == null) {
            this.balanceUpdateCache.put(cMIUser.getUniqueId(), baltopUpdateCache2.setTime(System.currentTimeMillis() + (long)this.updateDelay * 1000L));
            baltopUpdateCache2.setTask(CMIScheduler.runTaskLater(() -> {
                baltopUpdateCache2.setTask(null);
                this.forceUpdateBalTop(cMIUser);
            }, (long)300L));
        }
    }

    private void forceUpdateBalTop(CMIUser cMIUser) {
        UUID uUID;
        Double d = this.balTopUsers.remove(cMIUser.getUniqueId());
        if (d != null && (uUID = (UUID)this.balTop.remove(d)) != null) {
            this.totalServerMoney = this.totalServerMoney - d;
            Double d2 = cMIUser.getBalance();
            int n = this.plugin.getPlayerManager().getAllUsers().size();
            Random random = new Random(System.nanoTime());
            int n2 = 0;
            while (n2 < n) {
                if (!this.balTop.containsKey(d2)) break;
                d2 = d2 + (double)random.nextInt(1000000) / 1.0E8;
                ++n2;
            }
            this.totalServerMoney = this.totalServerMoney + d2;
            this.balTopUsers.put(cMIUser.getUniqueId(), d2);
            this.balTop.put(d2, cMIUser.getUniqueId());
        }
    }

    public void recalculateBalTop() {
        this.recTask = CMIScheduler.runTaskAsynchronously(() -> {
            TreeMap treeMap = new TreeMap(Collections.reverseOrder());
            HashMap<UUID, Double> hashMap = new HashMap<UUID, Double>();
            try {
                this.totalServerMoney = 0.0;
                int n = this.plugin.getPlayerManager().getAllUsers().size();
                Random random = new Random(System.nanoTime());
                for (Map.Entry<UUID, CMIUser> entry : new HashMap<UUID, CMIUser>(this.plugin.getPlayerManager().getAllUsers()).entrySet()) {
                    long l;
                    String string = entry.getValue().getName(false);
                    if (string == null || entry.getValue().isFakeAccount().booleanValue() && !this.isBalTopIncludeFakes() || this.startsWithExcluded(string) || this.getBalTopExclude().contains(string.toLowerCase())) continue;
                    Double d = entry.getValue().getBalance();
                    if (hashMap.containsKey(entry.getValue().getUniqueId()) || this.ExcludeInactive > 0L && !entry.getValue().isOnline() && this.ExcludeInactive < (l = System.currentTimeMillis() - entry.getValue().getLastLogoff(false))) continue;
                    int n2 = 0;
                    while (n2 < n - treeMap.size()) {
                        if (!treeMap.containsKey(d)) break;
                        d = d + (double)random.nextInt(10000) / 1.0E8;
                        ++n2;
                    }
                    this.totalServerMoney = this.totalServerMoney + d;
                    treeMap.put(d, entry.getValue().getUniqueId());
                    hashMap.put(entry.getValue().getUniqueId(), d);
                    entry.getValue().getEconomyAccount().setBalTopPosition(0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.recalculatingTop = false;
            try {
                CMIScheduler.runTask(() -> {
                    this.balTopUsers.clear();
                    this.balTopUsers.putAll(hashMap);
                    this.balTop.clear();
                    this.balTop.putAll(treeMap);
                });
                if (!baltop.cc.isEmpty()) {
                    CMIScheduler.runTask(() -> {
                        for (CommandSender commandSender : baltop.cc) {
                            this.plugin.performCommand(commandSender, "cmi baltop");
                        }
                        baltop.cc.clear();
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private boolean startsWithExcluded(String string) {
        string = string.toLowerCase();
        for (String string2 : this.BalTopExcludeStartingWith) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public SortedMap<Double, UUID> getBalTopMap() {
        if (this.lastRecalculated == null || this.lastRecalculated + 60000L < System.currentTimeMillis()) {
            this.lastRecalculated = System.currentTimeMillis();
            this.recalculatingTop = true;
            if (this.recTask != null) {
                this.recTask.cancel(false);
                this.recTask = null;
            }
            this.recalculateBalTop();
        }
        return this.balTop;
    }

    public int getBalTopPlace(UUID uUID) {
        SortedMap<Double, UUID> sortedMap = this.getBalTopMap();
        Double d = this.balTopUsers.get(uUID);
        if (d == null) {
            return this.plugin.getPlayerManager().getTotalUserCount();
        }
        return sortedMap.headMap(d).size() + 1;
    }

    public Set<WorldGroup> getWorldGroups() {
        HashSet<WorldGroup> hashSet = new HashSet<WorldGroup>();
        for (Map.Entry<String, WorldGroup> entry : this.groups.entrySet()) {
            if (this.CustomWorldsEnabled && entry.getKey().equals(CMIDefaultWorld)) continue;
            hashSet.add(entry.getValue());
        }
        return hashSet;
    }

    public Set<String> getWorlds(WorldGroup worldGroup) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, WorldGroup> entry : this.groups.entrySet()) {
            if (!entry.getValue().getName().equals(worldGroup.getName())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public WorldGroup getWorldGroup(String string) {
        if (string == null) {
            return this.groups.get(CMIDefaultWorld);
        }
        if (!this.groups.containsKey(string)) {
            for (Map.Entry<String, WorldGroup> entry : this.groups.entrySet()) {
                if (!entry.getValue().getName().equals(string)) continue;
                return entry.getValue();
            }
            return this.groups.get(CMIDefaultWorld);
        }
        return this.groups.get(string);
    }

    public DecimalFormat getMoneyFormat() {
        return this.getMoneyFormat(null);
    }

    public Double translateMoney(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        Double d = null;
        if ((string = string.replace(this.getDefaultGroup().getCurrencySymbol(), "")) == null || string.isEmpty()) {
            return d;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d == null) {
            String string2 = string.substring(string.length() - 1);
            Double d2 = this.shortAmountValues.get(string2.toLowerCase());
            try {
                if (d2 == null) {
                    Double.parseDouble(string2);
                }
            }
            catch (Throwable throwable) {
                return d;
            }
            try {
                String string3 = string.replace(",", ".");
                d = Double.parseDouble(string3.substring(0, string3.length() - 1));
            }
            catch (Exception exception) {
                try {
                    String string4 = string.replace(".", ",");
                    d = Double.parseDouble(string4.substring(0, string4.length() - 1));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (d2 == null) {
                d2 = 1.0;
            }
            if (d != null) {
                d = d * d2;
            }
        }
        return d;
    }

    public DecimalFormat getShortMoneyFormat() {
        return this.shortDefaultFormat;
    }

    public DecimalFormat getMoneyFormat(String string) {
        if (this.defaultFormat != null) {
            return this.defaultFormat;
        }
        WorldGroup worldGroup = this.getDefaultGroup();
        try {
            this.defaultFormat = worldGroup.isSwitchPlaces() ? new DecimalFormat(worldGroup.getCurrencyFormat(), new DecimalFormatSymbols(Locale.GERMANY)) : new DecimalFormat(worldGroup.getCurrencyFormat(), new DecimalFormatSymbols(Locale.ENGLISH));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.defaultFormat != null) {
            this.defaultFormat.setRoundingMode(RoundingMode.FLOOR);
            return this.defaultFormat;
        }
        try {
            this.defaultFormat = new DecimalFormat(worldGroup.getCurrencyFormat());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.plugin.consoleMessage("&cIncorrect economy money format!");
            this.defaultFormat = new DecimalFormat("###,##0.00");
        }
        this.defaultFormat.setRoundingMode(RoundingMode.FLOOR);
        return this.defaultFormat;
    }

    public void loadConfig() {
        Object object4;
        Object object2;
        this.defaultFormat = null;
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Economy.Enabled", new String[]{"Enable or disable CMI economy in general", "In case CMIInjector is present, then this will be set to true automatically.", "Attention! For economy to work properly with other plugins you will need ether an injector or recompiled Vault version. ", "You can find both option at top of plugins page", "ATTENTION! If you disabled CMI economy while server was running, you will need to perform full server restart for this to take correct effect and avoid any issues while getting players balances"});
        this.Enabled = configReader.get("Economy.Enabled", Boolean.valueOf(false));
        configReader.addComment("Economy.Confirmation", new String[]{"Determines if player needs to confirm money payment by clicking on chat message"});
        this.Confirmation = configReader.get("Economy.Confirmation", Boolean.valueOf(false));
        configReader.addComment("Economy.LogEnabled", new String[]{"Set to true if you want to log money transfers between players"});
        this.LogEnabled = configReader.get("Economy.LogEnabled", Boolean.valueOf(false));
        configReader.addComment("Economy.Log." + CMIMoneyLogType.Transfer.toString(), new String[]{"Pick what type you want to record.", "Keep in mind that Unknown type will be recorded every time there is money tranfer when CMI Economy is in use", "While type as Transfer will only record /cmi pay command actions", "Some duplicates can accure while having Unknown enabled with other types, as unknown record every balance change for the player without knowing who made that change"});
        Object object3 = CMIMoneyLogType.values();
        int n = ((CMIMoneyLogType[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            CMIMoneyLogType cMIMoneyLogType = object3[n2];
            cMIMoneyLogType.setEnabled(configReader.get("Economy.log." + cMIMoneyLogType.toString(), Boolean.valueOf(true)));
            ++n2;
        }
        configReader.addComment("Economy.Cheque.MaxValue", new String[]{"Determines max amount of cheque player can create", "Set it to 0 to remove limit"});
        this.MaxChequeValue = configReader.get("Economy.Cheque.MaxValue", Double.valueOf(configReader.getC().getDouble("Economy.MaxChequeValue", 1.0E8)));
        configReader.addComment("Economy.Cheque.Paper", new String[]{"If set to true player will be required to hold peace of paper to create cheque"});
        this.ChequePaper = configReader.get("Economy.Cheque.Paper", Boolean.valueOf(true));
        configReader.addComment("Economy.Cheque.Permission", new String[]{"When set to true player will be required to have " + PermissionsManager.CMIPerm.command_cheque_withdraw.getPermission() + " permission node to withdraw cheque"});
        this.ChequePermission = configReader.get("Economy.Cheque.Permission", Boolean.valueOf(false));
        configReader.addComment("Economy.Cheque.InCreative", new String[]{"Should we allow checque usage in creative mode", "If you have creative server, keep this at false or players could start duplicating items"});
        this.ChequeInCreative = configReader.get("Economy.Cheque.InCreative", Boolean.valueOf(false));
        configReader.addComment("Economy.Cheque.AcceptNotEncoded", new String[]{"Should we accept old cheque item stacks with non encoded data in them", "Keep it at false for most security"});
        this.ChequeAcceptNotEncoded = configReader.get("Economy.Cheque.AcceptNotEncoded", Boolean.valueOf(false));
        configReader.addComment("Economy.PaymentWithShorts.Allow", new String[]{"When set to true players will be able to make payments by using short amount formats like 10k which results into 10000 and similar", "In addition 10.2k will result into 10200"});
        boolean bl = configReader.get("Economy.PaymentWithShorts.Allow", Boolean.valueOf(true));
        configReader.addComment("Economy.PaymentWithShorts.values", new String[]{"List of suffixes we should accept and into what amount it results into", "Only one letter is acceptable when defining suffix"});
        List list2 = configReader.get("Economy.PaymentWithShorts.values", Arrays.asList("k-1000", "m-1000000", "b-1000000000", "t-1000000000000", "q-1000000000000000"));
        this.shortAmountValues.clear();
        if (bl) {
            for (String string : list2) {
                if (!string.contains("-") || (object2 = string.split("-"))[0].length() > 1) continue;
                try {
                    this.shortAmountValues.put(object2[0].toLowerCase(), Double.parseDouble(object2[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        configReader.addComment("Economy.BalTop.Exclude", new String[]{"List of players to exclude from baltop list"});
        this.BalTopExclude = configReader.get("Economy.BalTop.Exclude", Arrays.asList("Notch"));
        n = 0;
        while (n < this.BalTopExclude.size()) {
            this.BalTopExclude.set(n, this.BalTopExclude.get(n).toLowerCase());
            ++n;
        }
        configReader.addComment("Economy.BalTop.DisplayWithShorts", new String[]{"When enabled baltop list will show short money values, like 12.5M instead of 12501234"});
        this.BalTopDisplayWithShorts = configReader.get("Economy.BalTop.DisplayWithShorts", Boolean.valueOf(false));
        configReader.addComment("Economy.BalTop.ExcludeStartingWith", new String[]{"List of names to exclude from baltop", "Can be used to filter out towny towns"});
        this.BalTopExcludeStartingWith = configReader.get("Economy.BalTop.ExcludeStartingWith", Arrays.asList("town_", "town-", "towny_", "towny-", "debt-", "debt_"));
        n = 0;
        while (n < this.BalTopExcludeStartingWith.size()) {
            this.BalTopExcludeStartingWith.set(n, this.BalTopExcludeStartingWith.get(n).toLowerCase());
            ++n;
        }
        configReader.addComment("Economy.BalTop.IncludeFakes", new String[]{"When set to true some fake accounts will be included into baltop list", "This should include some previously marked accounts as fake which have been created for town usage or similar things"});
        this.BalTopIncludeFakes = configReader.get("Economy.BalTop.IncludeFakes", Boolean.valueOf(false));
        configReader.addComment("Economy.BalTop.ExcludeInactive", new String[]{"Set to 0 or lower to disable this feature", "Time in days of player being offline to exclude from being included in balance top list"});
        this.ExcludeInactive = configReader.get("Economy.BalTop.ExcludeInactive", 0);
        this.ExcludeInactive = this.ExcludeInactive > 0L ? this.ExcludeInactive * 24L * 60L * 60L * 1000L : 0L;
        configReader.addComment("Economy.Global.StartingAmount", new String[]{"Starting amount of money players will have"});
        Double d = configReader.get("Economy.Global.StartingAmount", Double.valueOf(100.0));
        configReader.addComment("Economy.Global.MinimalAmount", new String[]{"Minimal amount, can go into negative if needed"});
        object3 = configReader.get("Economy.Global.MinimalAmount", Double.valueOf(0.0));
        configReader.addComment("Economy.Global.MaximumAmount", new String[]{"Maximal amount of money player can have. Set to -1 to disable this limit"});
        object2 = configReader.get("Economy.Global.MaximumAmount", Double.valueOf(1.0E8));
        configReader.addComment("Economy.Global.MinimalPay", new String[]{"Defines amount until player can send to another player", "This can prevent annoying spam some players would want to create by sending tiny amounts of money"});
        Double d2 = configReader.get("Economy.Global.MinimalPay", Double.valueOf(0.5));
        configReader.addComment("Economy.Global.Fractions", new String[]{"Defines if you want to allow payments with fractions", "if this is disabled then payments will be limited to whole numbers and in case player provides number with fraction we will round number down"});
        boolean bl2 = configReader.get("Economy.Global.Fractions", Boolean.valueOf(true));
        configReader.addComment("Economy.Global.CurrencySymbol", new String[]{"Currency symbol to be used when showing balance or similar"});
        String string = configReader.get("Economy.Global.CurrencySymbol", "\u20ac");
        configReader.addComment("Economy.Global.MoneyFormat", new String[]{"Format used for displaying money"});
        String string2 = configReader.get("Economy.Global.MoneyFormat", configReader.getC().getString("Optimizations.MoneyFormat", "###,##0.00"));
        configReader.addComment("Economy.Global.UseShortNumbers", new String[]{"Converts long numbers to short ones, like 12305122 to 12.3m"});
        boolean bl3 = configReader.get("Economy.Global.UseShortNumbers", Boolean.valueOf(configReader.getC().getBoolean("Economy.Global.UseShortNumners", false)));
        configReader.addComment("Economy.Global.shortNumbersFormat", new String[]{"This format is only for amounts which gets defines suffix like '1.23k' while numbers lover than 1k will use MoneyFormat"});
        String string3 = configReader.get("Economy.Global.shortNumbersFormat", "###,##0.0");
        try {
            this.shortDefaultFormat = new DecimalFormat(string3, new DecimalFormatSymbols(Locale.ENGLISH));
            this.shortDefaultFormat.setRoundingMode(RoundingMode.FLOOR);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        configReader.addComment("Economy.Global.ShortNumbersSuffixes", new String[]{"Suffixes for short numbers"});
        List list3 = configReader.get("Economy.Global.ShortNumbersSuffixes", Arrays.asList("", "k-1000", "m-1000000", "b-1000000000", "t-1000000000000", "q-1000000000000000"));
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        Double d3 = 1.0;
        for (Object object4 : list3) {
            if (((String)object4).contains("-")) {
                try {
                    hashMap.put(Double.parseDouble(((String)object4).split("-", 2)[1]), ((String)object4).split("-", 2)[0]);
                }
                catch (Exception exception) {}
                continue;
            }
            hashMap.put(d3, (String)object4);
            d3 = d3 * 1000.0;
        }
        configReader.addComment("Economy.Global.SwitchPlaces", new String[]{"Replaces to western format where decimals are separated by , and thousands by . In example 1,000,000.00 changes to 1.000.000,00"});
        object4 = configReader.get("Economy.Global.SwitchPlaces", Boolean.valueOf(configReader.getC().getBoolean("Optimizations.SwitchPlaces", false)));
        configReader.addComment("Economy.Global.Placing", new String[]{"Placing of currency symbol"});
        String string4 = configReader.get("Economy.Global.Placing", !this.plugin.getLM().containsKey("econ.currencyPlacing") ? "[money][symbol]" : this.plugin.getLM().getDefaultMessage("econ.currencyPlacing"));
        this.defaultGroup = this.groups.get(CMIDefaultWorld);
        if (this.defaultGroup == null) {
            this.defaultGroup = new WorldGroup(CMIDefaultWorld);
        }
        this.defaultGroup.setStartingAmount(d).setMinimalAmount((Double)object3).setMaximumAmount((Double)object2).setCurrencyName(string).setCurrencySymbol(string).setCurrencyFormat(string2).setSwitchPlaces((Boolean)object4).setFractions(bl2).setPlacing(string4).setMinimalPay(d2).setUseShortNumbers(bl3).setShortNumbersSuffixes(hashMap);
        this.groups.put(CMIDefaultWorld, this.defaultGroup);
    }

    public boolean isCustomWorldsEnabled() {
        return this.CustomWorldsEnabled;
    }

    public boolean isEnabled() {
        return this.Enabled;
    }

    public void setEnabled(boolean bl) {
        this.Enabled = bl;
    }

    public VaultManager getVaultManager() {
        return this.vmanager;
    }

    public boolean isConfirmation() {
        return this.Confirmation;
    }

    public List<String> getBalTopExclude() {
        return this.BalTopExclude;
    }

    public void setBalTopExclude(List<String> list2) {
        this.BalTopExclude = list2;
    }

    public Boolean isRecalculatingTop() {
        return this.recalculatingTop;
    }

    public void setRecalculatingTop(boolean bl) {
        this.recalculatingTop = bl;
    }

    public Double getMaxChequeValue() {
        return this.MaxChequeValue;
    }

    public Double getTotalServerMoney() {
        return this.totalServerMoney;
    }

    public WorldGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    public void closeStream() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void moneyLog(CMIUser cMIUser, CMIUser cMIUser2, double d, CMIMoneyLogType cMIMoneyLogType, String string) {
        Object object;
        Comparable<Date> comparable;
        if (!this.LogEnabled) {
            return;
        }
        if (!this.checkedOldFile && !((File)(comparable = new File(CMI.getInstance().getDataFolder(), "moneyLog"))).isDirectory()) {
            ((File)comparable).mkdir();
        }
        comparable = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        String string2 = simpleDateFormat.format((Date)comparable);
        boolean bl = false;
        if (this.file != null) {
            if (!this.file.getName().equalsIgnoreCase(string2 + ".yml")) {
                bl = true;
                if (this.writer != null) {
                    try {
                        this.writer.flush();
                        this.writer.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.writer = null;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.file = new File(this.plugin.getDataFolder(), "moneyLog" + File.separator + string2 + ".yml");
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        }
        if (!this.checkedOldFile) {
            object = new File(this.plugin.getDataFolder(), "moneyLog.yml");
            if (((File)object).exists()) {
                Object object2 = new File(this.plugin.getDataFolder(), "moneyLog" + File.separator + "Old_moneyLog.yml");
                ((File)object).renameTo((File)object2);
            }
            this.checkedOldFile = true;
        }
        try {
            if (cMIMoneyLogType == null) {
                return;
            }
            if (!cMIMoneyLogType.isEnabled()) {
                return;
            }
            if (this.file == null) {
                this.file = new File(this.plugin.getDataFolder(), "moneyLog" + File.separator + string2 + ".yml");
            }
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                    if (this.writer != null) {
                        this.writer.flush();
                        this.writer.close();
                    }
                    this.writer = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
            if (this.writer == null) {
                try {
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8"));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            try {
                if (!this.plugin.isFullyLoaded()) {
                    return;
                }
                if (this.writer == null) {
                    return;
                }
                object = DateFormat.MiliToDate(System.currentTimeMillis(), "dd/MM/yy HH:mm:ss");
                switch (cMIMoneyLogType) {
                    case Transfer: {
                        if (cMIUser == null || cMIUser2 == null) {
                            return;
                        }
                        this.writer.append((String)object + " " + cMIUser.getName() + "(" + cMIUser.getFormatedBalance() + ") got " + this.format(d) + " from " + cMIUser2.getName() + "(" + cMIUser2.getFormatedBalance() + ")" + System.lineSeparator());
                        break;
                    }
                    case Unknown: {
                        if (cMIUser == null) {
                            return;
                        }
                        if (string == null) break;
                        switch (string) {
                            case "Withdraw": {
                                this.writer.append((String)object + " " + cMIUser.getName() + " lost " + this.format(d) + " (" + cMIUser.getFormatedBalance() + ")" + (String)(cMIUser2 != null ? " -> " + cMIUser2.getName() : "") + System.lineSeparator());
                                break;
                            }
                            case "Deposit": {
                                this.writer.append((String)object + " " + cMIUser.getName() + " got " + this.format(d) + " (" + cMIUser.getFormatedBalance() + ")" + (String)(cMIUser2 != null ? " -> " + cMIUser2.getName() : "") + System.lineSeparator());
                                break;
                            }
                            case "setBalance": {
                                this.writer.append((String)object + " " + cMIUser.getName() + " money set to " + this.format(d) + System.lineSeparator());
                            }
                        }
                        break;
                    }
                }
                if (this.writer != null) {
                    this.writer.flush();
                }
            }
            catch (Throwable throwable) {
                if (this.writer != null) {
                    try {
                        this.writer.flush();
                        this.writer.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                this.writer = null;
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    public String getTownyTownPrefix() {
        return this.townyTownPrefix;
    }

    public void setTownyTownPrefix(String string) {
        this.townyTownPrefix = string;
    }

    public String getTownyNationPrefix() {
        return this.townyNationPrefix;
    }

    public void setTownyNationPrefix(String string) {
        this.townyNationPrefix = string;
    }

    public boolean isBalTopIncludeFakes() {
        return this.BalTopIncludeFakes;
    }

    public boolean isTownyAccount(String string) {
        if (string == null) {
            return false;
        }
        return CMIHookType.Towny.isPresent() && (string.startsWith(this.plugin.getEconomyManager().getTownyTownPrefix()) || string.startsWith(this.plugin.getEconomyManager().getTownyNationPrefix()) || string.startsWith(this.plugin.getEconomyManager().getTownyDebtPrefix()) || string.equalsIgnoreCase(this.plugin.getEconomyManager().getTownyClosedEconomyName()));
    }

    public String getTownyClosedEconomyName() {
        return this.townyClosed_economy;
    }

    public boolean isBalTopDisplayWithShorts() {
        return this.BalTopDisplayWithShorts;
    }

    public String getTownyDebtPrefix() {
        return this.townyDebtPrefix;
    }

    public void setTownyDebtPrefix(String string) {
        this.townyDebtPrefix = string;
    }

    public boolean isChequePaperRequired() {
        return this.ChequePaper;
    }

    public boolean isChequeRequiresPermission() {
        return this.ChequePermission;
    }

    public boolean isChequeInCreative() {
        return this.ChequeInCreative;
    }

    public boolean isChequeAcceptNotEncoded() {
        return this.ChequeAcceptNotEncoded;
    }

    public class CMIEconomyResponse {
        private double amount;
        private double balance;
        private EconResponseType type;

        public CMIEconomyResponse(double d, double d2, EconResponseType econResponseType) {
            this.amount = d;
            this.balance = d2;
            this.type = econResponseType;
        }

        public double getAmount() {
            return this.amount;
        }

        public double getBalance() {
            return this.balance;
        }

        public EconResponseType getType() {
            return this.type;
        }
    }

    public static enum CMIMoneyLogType {
        Unknown,
        Transfer;

        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    public static enum EconResponseType {
        SUCCESS,
        FAILURE,
        NOT_IMPLEMENTED;

    }

    public class WorldGroup {
        private Double StartingAmount = 0.0;
        private Double MinimalAmount = 0.0;
        private Double MaximumAmount = 100.0;
        private Double MinimalPay = 0.5;
        private String CurrencyName = "Euro";
        private String CurrencySymbol = "\u20ac";
        private String CurrencyFormat = "###,##0.00";
        private String Placing = "[money][symbol]";
        private boolean switchPlaces = false;
        private boolean UseShortNumbers = false;
        private boolean fractions = true;
        private HashMap<Double, String> ShortNumbersSuffixes = new HashMap();
        private String name;

        public WorldGroup(String string) {
            this.name = string;
        }

        public Double getStartingAmount() {
            return this.StartingAmount;
        }

        public WorldGroup setStartingAmount(Double d) {
            this.StartingAmount = d;
            return this;
        }

        public Double getMinimalAmount() {
            return this.MinimalAmount;
        }

        public WorldGroup setMinimalAmount(Double d) {
            this.MinimalAmount = d;
            return this;
        }

        public Double getMaximumAmount() {
            return this.MaximumAmount;
        }

        public WorldGroup setMaximumAmount(Double d) {
            this.MaximumAmount = d == -1.0 ? Double.valueOf(Double.MAX_VALUE) : d;
            return this;
        }

        public String getCurrencyName() {
            return this.CurrencyName;
        }

        public WorldGroup setCurrencyName(String string) {
            this.CurrencyName = string;
            return this;
        }

        public String getCurrencySymbol() {
            return this.CurrencySymbol;
        }

        public WorldGroup setCurrencySymbol(String string) {
            this.CurrencySymbol = string;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getCurrencyFormat() {
            return this.CurrencyFormat;
        }

        public WorldGroup setCurrencyFormat(String string) {
            this.CurrencyFormat = string;
            return this;
        }

        public boolean isSwitchPlaces() {
            return this.switchPlaces;
        }

        public WorldGroup setSwitchPlaces(boolean bl) {
            this.switchPlaces = bl;
            return this;
        }

        public String getPlacing() {
            return this.Placing;
        }

        public WorldGroup setPlacing(String string) {
            this.Placing = string;
            return this;
        }

        public boolean isUseShortNumbers() {
            return this.UseShortNumbers;
        }

        public WorldGroup setUseShortNumbers(boolean bl) {
            this.UseShortNumbers = bl;
            return this;
        }

        public HashMap<Double, String> getShortNumbersSuffixes() {
            return this.ShortNumbersSuffixes;
        }

        public WorldGroup setShortNumbersSuffixes(HashMap<Double, String> hashMap) {
            this.ShortNumbersSuffixes = hashMap;
            return this;
        }

        public Double getMinimalPay() {
            return this.MinimalPay;
        }

        public WorldGroup setMinimalPay(Double d) {
            this.MinimalPay = d;
            return this;
        }

        public boolean isFractions() {
            return this.fractions;
        }

        public WorldGroup setFractions(boolean bl) {
            this.fractions = bl;
            return this;
        }
    }

    class baltopUpdateCache {
        private long time = 0L;
        private CMITask task = null;

        baltopUpdateCache() {
        }

        public long getTime() {
            return this.time;
        }

        public baltopUpdateCache setTime(long l) {
            this.time = l;
            return this;
        }

        public CMITask getTask() {
            return this.task;
        }

        public baltopUpdateCache setTask(CMITask cMITask) {
            this.task = cMITask;
            return this;
        }
    }
}

