/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Enchants.CMIEnchantEnum;
import net.Zrips.CMILib.Images.CMIImage;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CMIHologramLine {
    private CMIHoloLineType type = CMIHoloLineType.plainText;
    private String text;
    private String hoverText;
    private String command;
    private CMIItemStack item;
    private boolean itemInHand = false;
    private boolean staticText = true;
    boolean enchanted = false;
    private boolean glowing = false;
    Integer modelData = null;
    private Boolean randomU = null;
    private Float hue = null;
    private double globalY = -999.0;
    private List<String> image = null;
    private static final String regex = "(%)(?i)(CustomModelData:)(\\d+)(%)";
    private static final Pattern pattern = Pattern.compile("(%)(?i)(CustomModelData:)(\\d+)(%)", 8);

    public CMIHologramLine clone() {
        CMIHologramLine cMIHologramLine = new CMIHologramLine();
        cMIHologramLine.type = this.type;
        if (this.item != null) {
            cMIHologramLine.item = this.item.clone();
        }
        cMIHologramLine.itemInHand = this.itemInHand;
        cMIHologramLine.staticText = this.staticText;
        cMIHologramLine.enchanted = this.enchanted;
        cMIHologramLine.modelData = this.modelData;
        cMIHologramLine.randomU = this.randomU;
        cMIHologramLine.hoverText = this.hoverText;
        cMIHologramLine.command = this.command;
        return cMIHologramLine;
    }

    public CMIHologramLine(String string) {
        this.text = string;
        this.recheck();
    }

    public CMIHologramLine() {
    }

    private void recheck() {
        Object object;
        Object object2;
        this.enchanted = false;
        this.type = CMIHoloLineType.plainText;
        if (this.text.startsWith("<T>")) {
            try {
                object2 = null;
                if (this.text.contains("<H>") && this.text.contains("</H>")) {
                    object2 = this.text.replaceAll(".*\\<H>|\\</H>.*", "");
                }
                object = null;
                if (this.text.contains("<C>") && this.text.contains("</C>")) {
                    object = this.text.replaceAll(".*\\<C>|\\</C>.*", "");
                }
                String string = this.text.replaceAll(".*\\<T>|\\</T>.*", "");
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.hoverText = object2;
                }
                if (object != null && !((String)object).isEmpty()) {
                    this.command = object;
                }
                if (string != null && !string.isEmpty()) {
                    this.text = string;
                }
                if (this.text != null && this.hoverText == null) {
                    this.hoverText = this.text;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (this.text.equals("_")) {
            this.text = "";
        }
        if (this.text.startsWith("SICON:")) {
            this.text = this.text.substring("SICON:".length());
            this.type = CMIHoloLineType.staticIcon;
        } else if (this.text.startsWith("ICON:")) {
            this.text = this.text.substring("ICON:".length());
            this.type = CMIHoloLineType.icon;
        }
        if (this.text.contains("%glowing%")) {
            this.glowing = true;
            this.text = this.text.replace("%glowing%", "");
        }
        if (this.text.contains("%enchanted%")) {
            this.enchanted = true;
            this.text = this.text.replace("%enchanted%", "");
        }
        if (this.text.equalsIgnoreCase("%itemInHand%")) {
            this.itemInHand = true;
            this.staticText = false;
        }
        object2 = pattern.matcher(this.text);
        while (((Matcher)object2).find()) {
            try {
                this.modelData = Integer.parseInt(((Matcher)object2).group(3));
            }
            catch (Throwable throwable) {
                continue;
            }
            this.text = this.text.replace("%" + ((Matcher)object2).group(2) + String.valueOf(this.modelData) + "%", "");
        }
        if (this.text.contains("&u") || this.text.contains("\u00a7u")) {
            this.randomU = true;
            this.staticText = false;
        }
        if (CMI.getInstance().getPlaceholderAPIManager().containsPlaceHolder(this.text)) {
            this.staticText = false;
        }
        if (this.text.startsWith(CMIImage.imageIndicator) && Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1)) {
            this.type = CMIHoloLineType.image;
            object = CMIImage.convertLines(null, (String)Config.imageFolder, new ArrayList<String>(Arrays.asList(this.text)), (boolean)false);
            ((CompletableFuture)object).thenApply(list2 -> {
                this.image = list2;
                return null;
            });
            return;
        }
    }

    public CMIItemStack getItem(Player player) {
        return this.getItem(player, null);
    }

    public CMIItemStack getItem(Player player, CMIAsyncHead cMIAsyncHead) {
        if (this.type != CMIHoloLineType.icon && this.type != CMIHoloLineType.staticIcon) {
            return null;
        }
        if (this.itemInHand) {
            if (player == null || !player.isOnline()) {
                return null;
            }
            ItemStack itemStack = CMIItemStack.getItemInMainHand((Player)player);
            return itemStack == null || CMIMaterial.isAir((Material)itemStack.getType()) ? null : new CMIItemStack(itemStack);
        }
        if (this.isStaticText() && this.item != null) {
            return this.item;
        }
        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, this.text), (CMIAsyncHead)cMIAsyncHead);
        if (cMIItemStack == null || !cMIItemStack.getCMIType().isAir()) {
            if (cMIItemStack != null && this.enchanted) {
                cMIItemStack.addEnchant(CMIEnchantEnum.POWER.getEnchantment(), Integer.valueOf(1));
            }
            if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIItemStack.getCMIType().isAir()) {
                ItemStack itemStack = cMIItemStack.getItemStack();
                if (this.modelData != null && this.modelData > -1) {
                    itemStack = (ItemStack)new CMINBT(itemStack).setInt("CustomModelData", this.modelData);
                }
                cMIItemStack.setItemStack(itemStack);
            }
        }
        this.item = cMIItemStack;
        return cMIItemStack;
    }

    public boolean isStaticText() {
        return this.staticText;
    }

    public void setStaticText(boolean bl) {
        this.staticText = bl;
    }

    public boolean isItemInHand() {
        return this.itemInHand;
    }

    public void setItemInHand(boolean bl) {
        this.itemInHand = bl;
    }

    public String getText() {
        return this.text;
    }

    public String getText(Player player) {
        return this.checkText(player, this.text);
    }

    public String getHoverText(Player player) {
        return this.checkText(player, this.getHoverText());
    }

    private String checkText(Player player, String string) {
        if (this.isRandomU().booleanValue()) {
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1)) {
                if (this.hue == null) {
                    this.hue = Float.valueOf(new Random().nextFloat());
                }
                this.hue = Float.valueOf(this.hue.floatValue() + 0.05f);
                this.hue = Float.valueOf(this.hue.floatValue() > 1.0f ? 0.0f : this.hue.floatValue());
                Color color = Color.getHSBColor(this.hue.floatValue(), 0.9f, 0.9f);
                Object object = Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue() & 0xFFFFFF);
                while (((String)object).length() < 6) {
                    object = "0" + (String)object;
                }
                string = string.replace("&u", "{#" + (String)object + "}");
            } else {
                string = string.replace("&u", CMIChatColor.getRandomColor().getColorCode());
            }
        }
        if (!this.isStaticText()) {
            string = CMI.getInstance().getPlaceholderAPIManager().updatePlaceHolders(player, string);
        }
        string = string == null || string.equalsIgnoreCase("null") ? "" : CMIChatColor.colorize((String)string);
        return string;
    }

    public CMIItemStack getItem() {
        return this.item;
    }

    public void setItem(CMIItemStack cMIItemStack) {
        this.item = cMIItemStack;
    }

    public CMIHoloLineType getType() {
        return this.type;
    }

    public boolean isIcon() {
        return this.type == CMIHoloLineType.icon || this.type == CMIHoloLineType.staticIcon;
    }

    public void setType(CMIHoloLineType cMIHoloLineType) {
        this.type = cMIHoloLineType;
    }

    public Boolean isRandomU() {
        return this.randomU == null ? false : this.randomU;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean bl) {
        this.glowing = bl;
    }

    public List<String> getPlainImage() {
        return this.image;
    }

    public CompletableFuture<List<String>> getImage(Player player) {
        if (!this.staticText) {
            return CMIImage.convertLines((CommandSender)player, (String)CMI.getInstance().getDataFolder().getPath(), new ArrayList<String>(Arrays.asList(this.text)), (boolean)true);
        }
        return CompletableFuture.supplyAsync(() -> this.image);
    }

    public void setImage(List<String> list2) {
        this.image = list2;
    }

    public String getHoverText() {
        return this.hoverText;
    }

    public void setHoverText(String string) {
        this.hoverText = string;
    }

    public String getCommand() {
        return this.command;
    }

    public double getGlobalY() {
        return this.globalY;
    }

    public void setGlobalY(double d) {
        this.globalY = d;
    }
}

