/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Jail;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.CMIUserJailData;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Jail.CMIJail;
import com.Zrips.CMI.Modules.Jail.CMIJailCell;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.commands.list.jail;
import com.Zrips.CMI.commands.list.unjail;
import com.Zrips.CMI.events.CMIPlayerJailEvent;
import com.Zrips.CMI.events.CMIPlayerUnjailEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Time.CMITimeManager;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Schedulers.CMITask;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class JailManager {
    private SortedMap<String, CMIJail> jails;
    protected Map<String, Map<CuboidArea.ChunkRef, Set<CMIJail>>> chunkJails;
    private Set<CMIUser> onlineInjail = new HashSet<CMIUser>();
    protected Map<UUID, CMIUserJailData> jailed = new HashMap<UUID, CMIUserJailData>();
    private int JailCheckInterval = 500;
    private Integer DefaultTime = 500;
    private Integer JailChatRange = 20;
    private boolean CountWhileOffline = false;
    private boolean NoAfk = false;
    private boolean PreventDamage = true;
    private boolean noHunger = true;
    private List<String> cmdsOnUnJail;
    private List<String> cmdsOnJail;
    private List<String> whiteList;
    private CMI plugin;
    private CMITask sched = null;
    private String fileName = "Jails.yml";

    public JailManager(CMI cMI) {
        this.plugin = cMI;
        this.jails = new TreeMap<String, CMIJail>();
        this.chunkJails = new HashMap<String, Map<CuboidArea.ChunkRef, Set<CMIJail>>>();
    }

    public CMIUserJailData getJailData(UUID uUID2) {
        return this.jailed.computeIfAbsent(uUID2, uUID -> new CMIUserJailData());
    }

    public void recheckAllOnline() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (!cMIUser.isJailed()) continue;
            this.plugin.getJailManager().placePlayerIntoJail(cMIUser);
        }
    }

    public void stop() {
        if (this.sched == null) {
            return;
        }
        this.sched.cancel();
        this.sched = null;
    }

    private void tasker() {
        if (this.sched != null) {
            return;
        }
        this.sched = CMIScheduler.scheduleSyncRepeatingTask(() -> {
            if (this.onlineInjail.isEmpty()) {
                this.stop();
                return;
            }
            ArrayList<CMIUser> arrayList = null;
            for (CMIUser cMIUser : this.onlineInjail) {
                if (this.NoAfk && cMIUser.isAfk()) continue;
                if (!cMIUser.isOnline()) {
                    this.onlineInjail.remove(cMIUser);
                    continue;
                }
                cMIUser.setJailedForTime(cMIUser.getJailedForTime() - 1000L);
                if (cMIUser.isJailed()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<CMIUser>();
                }
                arrayList.add(cMIUser);
            }
            if (arrayList != null) {
                for (CMIUser cMIUser : arrayList) {
                    cMIUser.unjail();
                }
            }
        }, (long)0L, (long)20L);
    }

    public boolean anyJailedOnline() {
        return !this.onlineInjail.isEmpty();
    }

    public void removeOnline(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        this.onlineInjail.remove(cMIUser);
    }

    public void addOnline(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        this.onlineInjail.add(cMIUser);
        this.tasker();
    }

    public void addJail(CMIJail cMIJail) {
        this.jails.put(cMIJail.getName().toLowerCase(), cMIJail);
        this.recalculateChunks(cMIJail);
    }

    public void recalculateChunks() {
        this.chunkJails.clear();
        for (Map.Entry<String, CMIJail> entry : this.jails.entrySet()) {
            this.recalculateChunks(entry.getValue());
        }
    }

    public void recalculateChunks(CMIJail cMIJail) {
        if (cMIJail.getArea().getWorld() == null) {
            return;
        }
        Map<CuboidArea.ChunkRef, Set<CMIJail>> map = this.chunkJails.get(cMIJail.getArea().getWorld().getName());
        if (map == null) {
            map = new HashMap<CuboidArea.ChunkRef, Set<CMIJail>>();
        }
        for (CuboidArea.ChunkRef chunkRef : JailManager.getChunks(cMIJail)) {
            HashSet<CMIJail> hashSet = new HashSet<CMIJail>();
            if (map.containsKey(chunkRef)) {
                hashSet.addAll((Collection)map.get(chunkRef));
            }
            hashSet.add(cMIJail);
            map.put(chunkRef, hashSet);
        }
        this.chunkJails.put(cMIJail.getArea().getWorld().getName(), map);
    }

    public CMIJail getByName(String string) {
        if (string == null) {
            return null;
        }
        return (CMIJail)this.jails.get(string.toLowerCase());
    }

    public CMIJail getByLoc(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        CMIJail cMIJail = null;
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkJails.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMIJail>> map = this.chunkJails.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMIJail cMIJail2 : map.get(chunkRef)) {
                if (cMIJail2 == null || !cMIJail2.containsLoc(location)) continue;
                cMIJail = cMIJail2;
                break;
            }
        }
        return cMIJail;
    }

    public CMIJail collidesWithJail(CuboidArea cuboidArea) {
        return this.collidesWithJail(cuboidArea, null);
    }

    public CMIJail collidesWithJail(CuboidArea cuboidArea, CMIJail cMIJail) {
        Set<Map.Entry<String, CMIJail>> set = this.jails.entrySet();
        for (Map.Entry<String, CMIJail> entry : set) {
            CMIJail cMIJail2 = entry.getValue();
            if (!cMIJail2.checkCollision(cuboidArea) || cMIJail != null && cMIJail.equals(cMIJail2)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static List<CuboidArea.ChunkRef> getChunks(CMIJail cMIJail) {
        return cMIJail.getArea().getChunks();
    }

    private static List<CuboidArea.ChunkRef> getChunks(CMIJail cMIJail, int n) {
        ArrayList<CuboidArea.ChunkRef> arrayList = new ArrayList<CuboidArea.ChunkRef>();
        arrayList.addAll(cMIJail.getArea().getChunks(n));
        return arrayList;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Jail.CheckInterval", new String[]{"Defines in milliseconds how often to check if player leaves jail area", "Bigger numbers can help slightly lower server load"});
        this.JailCheckInterval = configReader.get("Jail.CheckInterval", 500);
        configReader.addComment("Jail.DefaultTime", new String[]{"Defines default jail time when time is not povided with command"});
        this.DefaultTime = configReader.get("Jail.DefaultTime", 300);
        configReader.addComment("Jail.ChatRange", new String[]{"Chat range in blocks while player is in jail", "Set to 0 to allow talking", "set to -1 to prevent talking in general while jailed"});
        this.JailChatRange = configReader.get("Jail.ChatRange", 20);
        configReader.addComment("Jail.CountWhileOffline", new String[]{"When set to true jail time will decreese while player is offline", "When set to false jail time will only be counted while player is online"});
        this.CountWhileOffline = configReader.get("Jail.CountWhileOffline", Boolean.valueOf(false));
        configReader.addComment("Jail.NoAfk", new String[]{"When set to true jail time will not decreese if player gets into afk mode while being jailed", "When set to false, time will pass normally"});
        this.NoAfk = configReader.get("Jail.NoAfk", Boolean.valueOf(false));
        configReader.addComment("Jail.PreventDamage", new String[]{"Do you want to prevent players damage while he is in jail"});
        this.PreventDamage = configReader.get("Jail.PreventDamage", Boolean.valueOf(true));
        configReader.addComment("Jail.PreventHunger", new String[]{"Do you want to prevent players hunger while he is in jail"});
        this.noHunger = configReader.get("Jail.PreventHunger", Boolean.valueOf(true));
        configReader.addComment("Jail.Commands.OnJail", new String[]{"Commands to be performed when player gets jailed"});
        this.cmdsOnJail = configReader.get("Jail.Commands.OnJail", Arrays.asList(""));
        configReader.addComment("Jail.Commands.OnUnJail", new String[]{"Commands to be performed when player gets unjailed"});
        this.cmdsOnUnJail = configReader.get("Jail.Commands.OnUnJail", Arrays.asList(""));
        this.whiteList = configReader.get("Jail.WhiteListedCmds", Arrays.asList("cmi msg", "cmi reply"));
        int n = 0;
        while (n < this.whiteList.size()) {
            this.whiteList.set(n, this.whiteList.get(n).toLowerCase());
            ++n;
        }
    }

    public void load() {
        Long l = System.currentTimeMillis();
        this.jails.clear();
        this.chunkJails.clear();
        this.plugin.safeRenameFile(this.fileName.toLowerCase(), "Saves" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        YamlConfiguration yamlConfiguration = null;
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Exception exception) {
            return;
        }
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        Map map = yamlConfiguration.getValues(false);
        for (Map.Entry entry : map.entrySet()) {
            Map map2 = yamlConfiguration.getValues(false);
            if (map2 == null) continue;
            try {
                this.loadMap(map2);
            }
            catch (Exception exception) {
                CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(String.valueOf(ChatColor.RED) + "Error in loading jails file for world: " + (String)entry.getKey()));
            }
        }
        this.plugin.loadMessage(this.jails.size(), "jails", System.currentTimeMillis() - l);
    }

    public void loadMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                CMIJail cMIJail = new CMIJail();
                cMIJail.setName(entry.getKey());
                MemorySection memorySection = (MemorySection)entry.getValue();
                cMIJail.loadBounds(memorySection.getString("Loc"));
                if (memorySection.contains("safeLoc")) {
                    cMIJail.setOutsideLocation(this.plugin.getPlayerManager().convertStringToLocation(memorySection.getString("safeLoc")));
                }
                if (memorySection.contains("cells")) {
                    Set set = memorySection.getConfigurationSection("cells").getKeys(false);
                    for (String string : set) {
                        MemorySection memorySection2 = (MemorySection)memorySection.get("cells." + string);
                        Integer n = null;
                        try {
                            n = Integer.parseInt(string);
                            CMIJailCell cMIJailCell = new CMIJailCell(cMIJail);
                            cMIJailCell.setId(n);
                            cMIJailCell.setWorld(cMIJail.getArea().getWorld());
                            if (memorySection2.contains("location")) {
                                cMIJailCell.setTeleportInLocation(this.plugin.getPlayerManager().convertStringToLocation(memorySection2.getString("location")));
                            }
                            cMIJail.addCell(cMIJailCell);
                        }
                        catch (Exception exception) {
                            this.plugin.consoleMessage("&cFailed to load " + string);
                        }
                    }
                }
                this.addJail(cMIJail);
            }
            catch (Exception exception) {
                CMIMessages.sendMessage((CommandSender)Bukkit.getConsoleSender(), (String)(String.valueOf(ChatColor.RED) + " Failed to load jail (" + entry.getKey() + ")! Reason:" + exception.getMessage() + " Error Log:"));
                Logger.getLogger(JailManager.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }

    public void save() {
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            return;
        }
        for (Map.Entry entry : configReader.getC().getValues(false).entrySet()) {
            configReader.getC().set((String)entry.getKey(), null);
        }
        configReader.header(Arrays.asList("Command section can utilize same custom variables as scheduler. Check Schedules.yml file for all possible variables."));
        for (Map.Entry<Object, Object> entry : this.jails.entrySet()) {
            CMIJail cMIJail = (CMIJail)entry.getValue();
            World world2 = cMIJail.getArea().getWorld();
            configReader.get(cMIJail.getName() + ".Loc", world2.getName() + ":" + cMIJail.getArea().toString());
            if (cMIJail.getOutsideLocation() != null) {
                configReader.get(cMIJail.getName() + ".safeLoc", this.plugin.getPlayerManager().convertLocToString(cMIJail.getOutsideLocation()));
            }
            for (Map.Entry<Integer, CMIJailCell> entry2 : cMIJail.getCells().entrySet()) {
                if (entry2.getValue().getTeleportInLocation() == null) continue;
                configReader.get(cMIJail.getName() + ".cells." + String.valueOf(entry2.getKey()) + ".location", this.plugin.getPlayerManager().convertLocToString(entry2.getValue().getTeleportInLocation()));
            }
        }
        configReader.save();
    }

    public SortedMap<String, CMIJail> getJails() {
        return this.jails;
    }

    public List<CMIJail> getJailsByDistance(Location location) {
        HashMap hashMap = new HashMap();
        ArrayList<CMIJail> arrayList = new ArrayList<CMIJail>();
        for (Map.Entry<String, CMIJail> entry : this.jails.entrySet()) {
            if (location != null && location.getWorld() != null && !location.getWorld().equals(entry.getValue().getArea().getWorld())) {
                arrayList.add(entry.getValue());
                continue;
            }
            if (entry.getValue().getCells().isEmpty() || location == null || location.getWorld() == null) continue;
            hashMap.put(entry.getValue(), (int)new CMILocation(entry.getValue().getArea().getMiddleLocation()).distance(location));
        }
        hashMap = this.plugin.getSortingManager().sortByValueObject(hashMap);
        ArrayList<CMIJail> arrayList2 = new ArrayList<CMIJail>();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList2.add((CMIJail)entry.getKey());
        }
        if (!arrayList.isEmpty()) {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    public void removeJail(CMIJail cMIJail) {
        this.jails.remove(cMIJail.getName().toLowerCase());
        this.recalculateChunks();
        this.save();
    }

    public int getJailsCheckInterval() {
        return this.JailCheckInterval;
    }

    private boolean isCellOk(CMIJailCell cMIJailCell) {
        if (cMIJailCell == null) {
            return false;
        }
        CMIJail cMIJail = this.getByName(cMIJailCell.getJail().getName());
        if (cMIJail == null) {
            return false;
        }
        if (!cMIJail.equals(cMIJailCell.getJail())) {
            return false;
        }
        CMIJailCell cMIJailCell2 = cMIJail.getCells().get(cMIJailCell.getId());
        if (cMIJailCell2 == null) {
            return false;
        }
        return cMIJailCell2.equals(cMIJailCell);
    }

    private boolean isJailOk(CMIJail cMIJail) {
        if (cMIJail == null) {
            return false;
        }
        return this.getByName(cMIJail.getName()) != null;
    }

    public CMIJailCell getValidCell(CMIUser cMIUser) {
        return this.getValidCell(cMIUser, null, null);
    }

    public CMIJailCell getValidCell(CMIUser cMIUser, CMIJail cMIJail, Integer n) {
        if (cMIUser.getCell() != null && this.isCellOk(cMIUser.getCell())) {
            return cMIUser.getCell();
        }
        CMIJail cMIJail2 = cMIUser.getCell() != null ? (this.isJailOk(cMIUser.getCell().getJail()) ? cMIUser.getCell().getJail() : null) : null;
        Object object = null;
        if (cMIJail2 == null) {
            if (cMIJail != null) {
                cMIJail2 = cMIJail;
            } else {
                for (CMIJail cMIJail3 : this.getJailsByDistance(cMIUser.getLocation())) {
                    if (cMIJail3.getCells().isEmpty()) continue;
                    cMIJail2 = cMIJail3;
                    break;
                }
            }
        }
        if (cMIJail2 == null) {
            return null;
        }
        if (n != null) {
            object = cMIJail2.getCells().get(n);
        }
        if (object == null) {
            int n2 = Integer.MAX_VALUE;
            Object object2 = null;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(cMIJail2.getCells().keySet());
            Collections.shuffle(arrayList);
            for (Integer n3 : arrayList) {
                CMIJailCell cMIJailCell = cMIJail2.getCells().get(n3);
                if (cMIJailCell == null || cMIJailCell.getTeleportInLocation() == null) continue;
                if (cMIJailCell.getJailed().isEmpty()) {
                    object2 = cMIJailCell;
                    break;
                }
                if (object2 == null) {
                    object2 = cMIJailCell;
                    n2 = cMIJailCell.getJailed().size();
                    continue;
                }
                if (n2 <= cMIJailCell.getJailed().size()) continue;
                object2 = cMIJailCell;
                n2 = cMIJailCell.getJailed().size();
            }
            object = object2;
        }
        return object;
    }

    public void removePlayerFromJail(CMIUser cMIUser) {
        cMIUser.setJailedForTime(0L);
        this.onlineInjail.remove(cMIUser);
        CMIJailCell cMIJailCell = cMIUser.getCell();
        cMIUser.setCell(null);
        CMIPlayerUnjailEvent cMIPlayerUnjailEvent = new CMIPlayerUnjailEvent(cMIUser, cMIJailCell);
        Bukkit.getPluginManager().callEvent((Event)cMIPlayerUnjailEvent);
        cMIUser.removeBossBar(cMIUser.getBossBar("CMIJailBar"));
        if (cMIJailCell == null) {
            return;
        }
        cMIJailCell.removeJailed(cMIUser.getUniqueId());
        if (cMIJailCell.getJail() == null) {
            return;
        }
        if (cMIJailCell.getJail().getOutsideLocation() == null) {
            this.processOnUnjailCommands(cMIUser);
            return;
        }
        if (cMIUser.isOnline()) {
            if (cMIUser.getPlayer().getVehicle() != null) {
                this.plugin.getAnimationManager().removePlayerFromChair(cMIUser.getPlayer());
                CMIScheduler.runTaskLater(() -> {
                    if (cMIUser.isOnline()) {
                        cMIUser.getPlayer().teleport(cMIJailCell.getJail().getOutsideLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }
                }, (long)1L);
            }
            cMIUser.getPlayer().teleport(cMIJailCell.getJail().getOutsideLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            CMILC.info(unjail.class, cMIUser, "unjailedTarget", new Snd().setSender(cMIUser).setTarget(cMIUser));
        } else {
            this.plugin.getNMS().setMiscLocation(cMIUser.getPlayer(), cMIJailCell.getJail().getOutsideLocation());
        }
        this.processOnUnjailCommands(cMIUser);
    }

    private void processOnUnjailCommands(CMIUser cMIUser) {
        Snd snd = new Snd();
        snd.setSender(cMIUser).setTarget(cMIUser);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.cmdsOnUnJail) {
            String string2 = this.plugin.getLM().updateSnd(snd, string);
            arrayList.add(string2);
        }
        if (!arrayList.isEmpty()) {
            this.plugin.getSpecializedCommandManager().processCmds(arrayList, cMIUser.isOnline() ? cMIUser.getPlayer() : null);
        }
    }

    public void placePlayerIntoJail(CMIUser cMIUser) {
        this.placePlayerIntoJail(cMIUser, null, null, cMIUser.getJailedForTime());
    }

    public boolean placePlayerIntoJail(CMIUser cMIUser, CMIJail cMIJail, Integer n, Long l) {
        Serializable serializable;
        Object object;
        CMIJailCell cMIJailCell;
        if (cMIJail != null || n != null) {
            cMIUser.setCell(null);
        }
        if (!this.isCellOk(cMIJailCell = cMIUser.getCell())) {
            cMIJailCell = this.getValidCell(cMIUser, cMIJail, n);
        }
        if (cMIJailCell == null || cMIJailCell.getTeleportInLocation() == null || cMIJailCell.getTeleportInLocation().getWorld() == null) {
            return false;
        }
        CMIPlayerJailEvent cMIPlayerJailEvent = new CMIPlayerJailEvent(cMIUser, cMIJailCell);
        Bukkit.getPluginManager().callEvent((Event)cMIPlayerJailEvent);
        if (cMIPlayerJailEvent.isCancelled()) {
            return false;
        }
        cMIJailCell = cMIPlayerJailEvent.getCell();
        if (cMIJailCell == null || cMIJailCell.getTeleportInLocation() == null || cMIJailCell.getTeleportInLocation().getWorld() == null) {
            return false;
        }
        if (cMIUser.isOnline()) {
            if (cMIUser.getPlayer().getVehicle() != null) {
                this.plugin.getAnimationManager().removePlayerFromChair(cMIUser.getPlayer());
                object = cMIJailCell.getTeleportInLocation();
                CMIScheduler.runTaskLater(() -> JailManager.lambda$3(cMIUser, (Location)object), (long)1L);
            } else {
                cMIUser.getPlayer().teleport((Location)cMIJailCell.getTeleportInLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            cMIUser.getPlayer().setFlying(false);
            cMIUser.getPlayer().setAllowFlight(false);
            this.onlineInjail.add(cMIUser);
        }
        cMIJailCell.addJailed(cMIUser.getUniqueId());
        cMIUser.setCell(cMIJailCell);
        if (Version.isCurrentHigher((Version)Version.v1_8_R3)) {
            cMIUser.removeBossBar(cMIUser.getBossBar("CMIJailBar"));
            object = new BossBarInfo(cMIUser.getPlayer(), "CMIJailBar");
            serializable = Double.valueOf((double)l.longValue() / 1000.0 - 1.0);
            object.setKeepForTicks(Integer.valueOf(22));
            object.setColor(BarColor.GREEN);
            object.setTitleOfBar(CMILC.getIM(jail.class, "bossbar", new Object[0]));
            object.setAdjustPerc(Double.valueOf(-(1.0 / (Double)serializable)));
            object.setPercentage(((Double)serializable).doubleValue(), ((Double)serializable).doubleValue());
            object.setStyle(BarStyle.SEGMENTED_20);
            object.setAuto(Integer.valueOf(20));
            cMIUser.addBossBar((BossBarInfo)object);
        }
        object = new Snd();
        ((Snd)object).setSender(cMIUser).setTarget(cMIUser);
        serializable = new ArrayList();
        for (String string : this.cmdsOnJail) {
            String string2 = this.plugin.getLM().updateSnd((Snd)object, string);
            serializable.add(string2);
        }
        if (!serializable.isEmpty()) {
            this.plugin.getSpecializedCommandManager().processCmds((List<String>)((Object)serializable), cMIUser.isOnline() ? cMIUser.getPlayer() : null);
        }
        this.tasker();
        return true;
    }

    public void informAboutLeftTime(Player player) {
        this.informAboutLeftTime(this.plugin.getPlayerManager().getUser(player));
    }

    public void informAboutLeftTime(CMIUser cMIUser) {
        if (!cMIUser.isJailed()) {
            return;
        }
        long l = cMIUser.getJailedForTime();
        CMILC.sendMessage(cMIUser, CMILC.getIM(jail.class, "leftTime", "[time]", CMITimeManager.to24hourShort((Long)l)));
    }

    public boolean canUseCommand(String string) {
        if ((string = string.toLowerCase()).contains("/")) {
            string = string.substring(1);
        }
        for (String string2 : this.whiteList) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public Integer getDefaultTime() {
        return this.DefaultTime;
    }

    public void setDefaultTime(int n) {
        this.DefaultTime = n;
    }

    public Integer getJailChatRange() {
        return this.JailChatRange;
    }

    public void setJailChatRange(Integer n) {
        this.JailChatRange = n;
    }

    public boolean isNoAfk() {
        return this.NoAfk;
    }

    public boolean isCountWhileOffline() {
        return this.CountWhileOffline;
    }

    public void setCountWhileOffline(boolean bl) {
        this.CountWhileOffline = bl;
    }

    public boolean isPreventDamage() {
        return this.PreventDamage;
    }

    public boolean isNoHunger() {
        return this.noHunger;
    }

    private static /* synthetic */ void lambda$3(CMIUser cMIUser, Location location) {
        if (cMIUser.isOnline()) {
            cMIUser.getPlayer().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }
}

