/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Painting;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIEvent;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.ArrayList;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PaintingListener
implements Listener {
    private CMI plugin;

    public PaintingListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPaintingBreak(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.plugin.getPaintingManager().removeEditor((Entity)player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPaintingBreak(HangingBreakEvent hangingBreakEvent) {
        if (hangingBreakEvent.isCancelled()) {
            return;
        }
        Hanging hanging = hangingBreakEvent.getEntity();
        if (hanging.getType() != EntityType.PAINTING) {
            return;
        }
        this.plugin.getPaintingManager().removeEditor((Entity)hanging);
    }

    @EventHandler
    public void onSignInteractShift(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        try {
            if (playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        Player player = playerInteractEvent.getPlayer();
        if (this.plugin.getPaintingManager().isEditing(player.getUniqueId())) {
            this.plugin.getPaintingManager().removeEditor(player.getUniqueId());
            CMILC.info_canceledEditingPainting.sendMessage(player, new Object[0]);
            playerInteractEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractPaiting(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (playerInteractEntityEvent.isCancelled()) {
            return;
        }
        try {
            if (playerInteractEntityEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError throwable) {
            // empty catch block
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.getPaintingManager().isEditing(player.getUniqueId())) {
            this.plugin.getPaintingManager().removeEditor(player.getUniqueId());
            CMILC.info_canceledEditingPainting.sendMessage(player, new Object[0]);
            playerInteractEntityEvent.setCancelled(true);
            return;
        }
        if (entity.getType() != EntityType.PAINTING) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        if (!PermissionsManager.CMIPerm.scrollpainting.hasPermission((CommandSender)player)) {
            return;
        }
        Painting painting = (Painting)entity;
        Block block = painting.getLocation().getBlock();
        BlockPlaceEvent blockPlaceEvent = CMIEvent.placeBlockEvent(block, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)blockPlaceEvent);
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        playerInteractEntityEvent.setCancelled(true);
        this.plugin.getPaintingManager().addEditor(player.getUniqueId(), entity);
        CMILC.info_startedEditingPainting.sendMessage(player, new Object[0]);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemHeldChange(PlayerItemHeldEvent playerItemHeldEvent) {
        int n;
        boolean bl;
        Player player = playerItemHeldEvent.getPlayer();
        int n2 = playerItemHeldEvent.getPreviousSlot();
        boolean bl2 = bl = n2 - (n = playerItemHeldEvent.getNewSlot()) > 0;
        if (n2 == 0 && n == 8 || n2 == 8 && n == 0) {
            boolean bl3 = bl = !bl;
        }
        if (!this.plugin.getPaintingManager().isEditing(player.getUniqueId())) {
            return;
        }
        Painting painting = this.plugin.getPaintingManager().getPainting(player.getUniqueId());
        if (painting == null) {
            return;
        }
        int n3 = painting.getArt().ordinal();
        int n4 = Art.values().length;
        ArrayList<Art> arrayList = new ArrayList<Art>();
        if (!bl) {
            var10_10 = n3 + 1;
            while (var10_10 < n4) {
                arrayList.add(Art.values()[var10_10]);
                ++var10_10;
            }
            var10_10 = 0;
            while (var10_10 < n3) {
                arrayList.add(Art.values()[var10_10]);
                ++var10_10;
            }
        } else {
            var10_10 = n3 - 1;
            while (var10_10 >= 0) {
                arrayList.add(Art.values()[var10_10]);
                --var10_10;
            }
            var10_10 = n4 - 1;
            while (var10_10 > n3) {
                arrayList.add(Art.values()[var10_10]);
                --var10_10;
            }
        }
        for (Art art : arrayList) {
            if (painting.setArt(art)) break;
        }
        CMILC.info_changedPainting.sendMessage(player, "[name]", painting.getArt().name().toLowerCase(), "[id]", painting.getArt().ordinal());
    }
}

