/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SpawnerCharge;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.SpawnerCharge.SCharges;
import java.util.UUID;
import net.Zrips.CMILib.Time.CMITimeManager;

public class PlayerCharge {
    private int charges = 0;
    private long lastGive = 0L;
    private SCharges SCharge;
    private UUID uuid;
    private long lastChecked = 0L;

    public PlayerCharge(CMIUser cMIUser, boolean bl) {
        if (cMIUser != null) {
            this.uuid = cMIUser.getUniqueId();
        }
        if (bl) {
            this.updateSpawnerCharge();
        }
    }

    private void updateSpawnerCharge() {
        if (CMIUser.getOnlinePlayer(this.uuid) == null) {
            return;
        }
        if (this.lastChecked + 1000L > System.currentTimeMillis()) {
            return;
        }
        this.lastChecked = System.currentTimeMillis();
        this.SCharge = CMI.getInstance().getSpawnerChargesManager().getCharge(CMIUser.getOnlinePlayer(this.uuid));
        if (this.lastGive == 0L && this.SCharge != null) {
            this.charges = this.SCharge.getStartingCharges();
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        this.charges = 0;
        this.lastGive = 0L;
        this.SCharge = null;
        if (bl) {
            this.updateSpawnerCharge();
        }
    }

    public int getCharges() {
        this.updateSpawnerCharge();
        this.updateChargeTimer();
        return this.charges;
    }

    public int getChargesClean() {
        return this.charges;
    }

    public boolean haveLeftCharge() {
        if (!CMI.getInstance().getSpawnerChargesManager().isChargesUse()) {
            return true;
        }
        this.updateSpawnerCharge();
        return this.charges > 0;
    }

    public boolean have() {
        this.updateSpawnerCharge();
        return this.SCharge != null;
    }

    public int getBonus() {
        if (this.SCharge == null) {
            return 0;
        }
        if (this.SCharge.getBonus() <= 0) {
            return 0;
        }
        return this.SCharge.getBonus();
    }

    public boolean lowerCd() {
        if (this.SCharge == null) {
            return false;
        }
        if (this.SCharge.getBonus() <= 0) {
            return false;
        }
        if (this.getCharges() >= this.getMaxCharges()) {
            return false;
        }
        if (this.lastGive > 0L) {
            this.lastGive -= (long)(this.SCharge.getBonus() * 1000);
        }
        return true;
    }

    public void setCharges(int n) {
        this.charges = n;
    }

    private void updateChargeTimer() {
        if (this.SCharge == null) {
            return;
        }
        if (this.lastGive == 0L) {
            this.lastGive = System.currentTimeMillis();
        }
        long l = this.SCharge.getCooldown() * 1000;
        long l2 = System.currentTimeMillis() - this.lastGive;
        int n = (int)(l2 / l);
        if (n > 0) {
            this.addCharge(n);
            long l3 = l * (long)n;
            this.lastGive += l3;
        }
    }

    public String getLeftTime() {
        if (this.lastGive == 0L || this.charges == this.getMaxCharges()) {
            this.lastGive = System.currentTimeMillis();
        }
        if (this.getCharges() >= this.getMaxCharges()) {
            return "-";
        }
        long l = this.getLastGive() + (long)(this.getCooldown() * 1000) + 1000L - System.currentTimeMillis();
        return CMITimeManager.to24hourShort((Long)l);
    }

    public boolean addCharge() {
        return this.addCharge(1);
    }

    public boolean addCharge(int n) {
        return this.addCharge(n, false);
    }

    public boolean addCharge(int n, boolean bl) {
        this.updateSpawnerCharge();
        if (bl) {
            this.charges += n;
        } else if (this.SCharge != null) {
            if (this.charges + n >= this.SCharge.getMaxCharges()) {
                this.charges = this.SCharge.getMaxCharges();
                return false;
            }
            this.charges += n;
        }
        return true;
    }

    public boolean takeCharge() {
        return this.takeCharge(1);
    }

    public boolean takeCharge(int n) {
        return this.takeCharge(n, false);
    }

    public boolean takeCharge(int n, boolean bl) {
        this.updateSpawnerCharge();
        if (this.lastGive == 0L || this.charges >= this.getMaxCharges()) {
            this.lastGive = System.currentTimeMillis();
        }
        if (this.charges < 0 && !bl) {
            return false;
        }
        this.charges -= n;
        this.updateChargeTimer();
        if (!bl && this.SCharge != null && this.charges < 0) {
            this.charges = 0;
            return false;
        }
        return true;
    }

    public int getMaxCharges() {
        this.updateSpawnerCharge();
        if (this.SCharge == null) {
            return 0;
        }
        return this.SCharge.getMaxCharges();
    }

    public long getLastGive() {
        return this.lastGive;
    }

    public void setLastGive(long l) {
        this.lastGive = l;
    }

    public int getCooldown() {
        this.updateSpawnerCharge();
        if (this.SCharge == null) {
            return -1;
        }
        return this.SCharge.getCooldown();
    }
}

