/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.NBT;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Advancements.CMIAdvancement;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.NBT.NMS;
import com.Zrips.CMI.utils.Util;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Advancements;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Vector3f;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMapChunk;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_19_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_19_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_19_R2.util.CraftRayTraceResult;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class v1_19_R2
implements NMS {
    private boolean informed = false;

    @Override
    public Player getPlayer(CMIUser cMIUser) {
        block6: {
            block5: {
                if (!cMIUser.isFakeAccount().booleanValue()) break block5;
                return null;
            }
            File file = Util.getFile(cMIUser.getUniqueId());
            if (file.canRead() && file.exists()) break block6;
            return null;
        }
        try {
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            GameProfile gameProfile = new GameProfile(cMIUser.getUniqueId(), cMIUser.getName(false));
            WorldServer worldServer = (WorldServer)dedicatedServer.E().iterator().next();
            EntityPlayer entityPlayer = new EntityPlayer((MinecraftServer)dedicatedServer, worldServer, gameProfile);
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            if (craftPlayer != null) {
                craftPlayer.loadData();
                return craftPlayer;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public Player createFakeOperator() {
        try {
            GameProfile gameProfile = new GameProfile(CMI.getInstance().getPlayerManager().getFakeUserUUID(), CMI.getInstance().getPlayerManager().getFakeUserName());
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            WorldServer worldServer = (WorldServer)dedicatedServer.E().iterator().next();
            EntityPlayer entityPlayer = new EntityPlayer((MinecraftServer)dedicatedServer, worldServer, gameProfile);
            entityPlayer.b = new PlayerConnection((MinecraftServer)dedicatedServer, new NetworkManager(EnumProtocolDirection.a), entityPlayer);
            entityPlayer.b.b.n = new InetSocketAddress("127.0.0.1", 25566);
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            craftPlayer.setOp(true);
            return craftPlayer;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void unloadData(Player player) {
        try {
            if (player == null || player.isOnline()) {
                return;
            }
            EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
            if (entityPlayer == null) {
                return;
            }
            WorldServer worldServer = entityPlayer.y();
            if (worldServer == null) {
                return;
            }
            worldServer.a(entityPlayer, Entity.RemovalReason.c);
            AdvancementDataPlayer advancementDataPlayer = entityPlayer.N();
            advancementDataPlayer.a();
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            PlayerList playerList = dedicatedServer.ab();
            if (Version.isCurrentSubEqual((int)0)) {
                List list2 = (List)playerList.getClass().getField("j").get(playerList);
                list2.remove(entityPlayer);
            } else {
                playerList.k.remove(entityPlayer);
            }
            ((CraftServer)Bukkit.getServer()).getScoreboardManager().removePlayer((Player)entityPlayer.getBukkitEntity());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public NBTTagCompound getNBTTagC(File file) {
        NBTTagCompound nBTTagCompound;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            return null;
        }
        return nBTTagCompound;
    }

    public NBTTagCompound getNBTTagC(UUID uUID) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(uUID);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public String getWorldName(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return null;
        }
        UUID uUID = new UUID(v1_19_R2.getUUIDWorldMost(nBTTagCompound), v1_19_R2.getUUIDWorldLeast(nBTTagCompound));
        return CMI.getInstance().getUtilManager().getWorldName(uUID);
    }

    @Override
    public void setMiscLocation(File file, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        v1_19_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setMiscLocation(Player player, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(player.getUniqueId());
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        this.saveData(nBTTagCompound, player);
    }

    private static NBTTagCompound setDimension(NBTTagCompound nBTTagCompound, int n) {
        nBTTagCompound.a("Dimension", n);
        return nBTTagCompound;
    }

    private static NBTTagCompound setLocationWorld(NBTTagCompound nBTTagCompound, long l, long l2) {
        nBTTagCompound.a("WorldUUIDLeast", l);
        nBTTagCompound.a("WorldUUIDMost", l2);
        return nBTTagCompound;
    }

    public static String getName(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.p("bukkit");
        return nBTTagCompound2.l("lastKnownName");
    }

    public static World getLocationWorld(NBTTagCompound nBTTagCompound) {
        return Bukkit.getWorld((UUID)new UUID(v1_19_R2.getUUIDWorldMost(nBTTagCompound), v1_19_R2.getUUIDWorldLeast(nBTTagCompound)));
    }

    private static long getUUIDWorldMost(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.i("WorldUUIDMost");
    }

    private static long getUUIDWorldLeast(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.i("WorldUUIDLeast");
    }

    public NBTTagCompound setMiscLocation(Location location, NBTTagCompound nBTTagCompound) {
        nBTTagCompound = v1_19_R2.setLocationWorld(nBTTagCompound, location.getWorld().getUID().getLeastSignificantBits(), location.getWorld().getUID().getMostSignificantBits());
        nBTTagCompound = v1_19_R2.setDimension(nBTTagCompound, location.getWorld().getEnvironment().getId());
        nBTTagCompound = v1_19_R2.setLocationPosition(nBTTagCompound, location.getX(), location.getY(), location.getZ());
        nBTTagCompound = v1_19_R2.setLocationView(nBTTagCompound, location.getYaw(), location.getPitch());
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationPosition(NBTTagCompound nBTTagCompound, double d, double d2, double d3) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((Object)NBTTagDouble.a((double)d));
        nBTTagList.add((Object)NBTTagDouble.a((double)d2));
        nBTTagList.add((Object)NBTTagDouble.a((double)d3));
        nBTTagCompound.a("Pos", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationView(NBTTagCompound nBTTagCompound, float f, float f2) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((Object)NBTTagFloat.a((float)f));
        nBTTagList.add((Object)NBTTagFloat.a((float)f2));
        nBTTagCompound.a("Rotation", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static void saveData(NBTTagCompound nBTTagCompound, File file) {
        if (nBTTagCompound == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveData(NBTTagCompound nBTTagCompound, Player player) {
        if (nBTTagCompound == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(Util.getFile(player));){
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clearPotionEffects(Player player) {
        File file = Util.getFile(player);
        this.clearPotionEffects(file);
    }

    public void clearPotionEffects(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound.r("ActiveEffects");
        v1_19_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setPotionEffects(Player player, PotionEffect potionEffect) {
        File file = Util.getFile(player);
        this.setPotionEffects(potionEffect, file);
    }

    public void setPotionEffects(PotionEffect potionEffect, File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagList nBTTagList = nBTTagCompound.c("ActiveEffects", 10);
        boolean bl = false;
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.a(n);
            if (nBTTagCompound2.f("Id") == potionEffect.getType().getId()) {
                bl = true;
                nBTTagCompound2.a("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
                nBTTagCompound2.a("Amplifier", (byte)potionEffect.getAmplifier());
                nBTTagCompound2.a("Duration", potionEffect.getDuration());
                nBTTagCompound2.a("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
                nBTTagList.a(n, (NBTBase)nBTTagCompound2);
                break;
            }
            ++n;
        }
        if (!bl) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.a("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
            nBTTagCompound3.a("Amplifier", (byte)potionEffect.getAmplifier());
            nBTTagCompound3.a("Duration", potionEffect.getDuration());
            nBTTagCompound3.a("Id", (byte)potionEffect.getType().getId());
            nBTTagCompound3.a("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
            nBTTagList.add((Object)nBTTagCompound3);
        }
        nBTTagCompound.a("ActiveEffects", (NBTBase)nBTTagList);
        v1_19_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void relightChunk(Chunk chunk) {
    }

    @Override
    public void resendChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().b.a((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle()));
    }

    @Override
    public void unloadChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().b.a((Packet)new PacketPlayOutUnloadChunk(chunk.getX(), chunk.getZ()));
    }

    @Override
    public void updateCollisions(Player player, boolean bl, boolean bl2) {
    }

    public static void sendPacket(Player player, PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeam) {
        ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutScoreboardTeam);
    }

    @Override
    public Inventory getShulkerInv(ItemStack itemStack) {
        if (!CMIMaterial.get((ItemStack)itemStack).isShulkerBox()) {
            return null;
        }
        try {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
            }
            if (!(itemMeta instanceof BlockStateMeta)) {
            }
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            if (!blockStateMeta.hasBlockState()) {
            }
            if (blockStateMeta.getBlockState() == null) {
            }
            if (!(blockStateMeta.getBlockState() instanceof ShulkerBox)) {
            }
            ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
            if (shulkerBox.getInventory() == null) {
            }
            return shulkerBox.getInventory();
        }
        finally {
            return null;
        }
    }

    @Override
    public Inventory getShulkerInv(Block block) {
        if (!CMIMaterial.get((Block)block).isShulkerBox()) {
            return null;
        }
        if (!(block.getState() instanceof ShulkerBox)) {
            return null;
        }
        ShulkerBox shulkerBox = (ShulkerBox)block.getState();
        if (shulkerBox.getInventory() == null) {
            return null;
        }
        return shulkerBox.getInventory();
    }

    @Override
    public int getTickLived(UUID uUID) {
        if (uUID == null) {
            return 0;
        }
        NBTTagCompound nBTTagCompound = this.getNBTTagC(uUID);
        if (nBTTagCompound == null) {
            return 0;
        }
        if (!nBTTagCompound.e("Spigot.ticksLived")) {
            return 0;
        }
        return nBTTagCompound.h("Spigot.ticksLived");
    }

    @Override
    public void showResurection(Player player) {
        this.showResurection(player, new ItemStack(Material.TOTEM_OF_UNDYING));
    }

    public void showResurection(Player player, ItemStack itemStack) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer instanceof EntityPlayer) {
            EntityPlayer entityPlayer2 = entityPlayer;
            entityPlayer2.b(StatisticList.c.b((Object)Items.sw));
            CriterionTriggers.B.a(entityPlayer2, CraftItemStack.asNMSCopy((ItemStack)itemStack));
        }
        entityPlayer.c(1.0f);
        entityPlayer.dW();
        if (CMI.getInstance().getTotemManager().getRegenerationDuration() > 0) {
            entityPlayer.b(new MobEffect(MobEffects.j, CMI.getInstance().getTotemManager().getRegenerationDuration() * 20, 1));
        }
        if (CMI.getInstance().getTotemManager().getFireResistanceDuration() > 0) {
            entityPlayer.b(new MobEffect(MobEffects.l, CMI.getInstance().getTotemManager().getFireResistanceDuration() * 20, 1));
        }
        if (CMI.getInstance().getTotemManager().getAbsorbtionDuration() > 0) {
            entityPlayer.b(new MobEffect(MobEffects.v, CMI.getInstance().getTotemManager().getAbsorbtionDuration() * 20, 1));
        }
        entityPlayer.s.a((net.minecraft.world.entity.Entity)entityPlayer, (byte)35);
    }

    @Override
    public void setEntityTag(Entity entity, String string, Object object) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        NBTTagCompound nBTTagCompound2 = entity2.f(nBTTagCompound);
        if (object instanceof String) {
            nBTTagCompound2.a(string, (String)object);
        } else if (object instanceof Short) {
            nBTTagCompound2.a(string, ((Short)object).shortValue());
        } else if (object instanceof Byte) {
            nBTTagCompound2.a(string, ((Byte)object).byteValue());
        }
        entity2.g(nBTTagCompound);
    }

    @Override
    public ItemStack removeEnchantNbt(ItemStack itemStack, Enchantment enchantment) {
        net.minecraft.world.item.ItemStack itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (itemStack2 == null) {
            return null;
        }
        try {
            String string = enchantment.getKey().getKey();
            NBTTagCompound nBTTagCompound = itemStack2.u();
            boolean bl = false;
            if (nBTTagCompound != null && nBTTagCompound.e("ench")) {
                NBTTagList nBTTagList = nBTTagCompound.c("ench", 10);
                int n = 0;
                while (n < nBTTagList.size()) {
                    if (nBTTagList.a(n).l("id").equalsIgnoreCase(string)) {
                        nBTTagList.remove(n);
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    nBTTagCompound.a("ench", (NBTBase)nBTTagList);
                }
                itemStack2.c(nBTTagCompound);
            }
            if (bl) {
                return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public ItemStack setNBTList(ItemStack itemStack, String string, List<String> list2) {
        net.minecraft.world.item.ItemStack itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (itemStack2 == null) {
            return null;
        }
        try {
            NBTTagCompound nBTTagCompound = itemStack2.u();
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            NBTTagList nBTTagList = new NBTTagList();
            if (list2 != null) {
                for (String string2 : list2) {
                    nBTTagList.add((Object)NBTTagString.a((String)string2));
                }
            }
            if (list2 == null) {
                nBTTagCompound.r(string);
            } else {
                nBTTagCompound.a(string, (NBTBase)nBTTagList);
            }
            itemStack2.c(nBTTagCompound);
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean changeGodMode(Player player, boolean bl) {
        if (player == null) {
            return false;
        }
        player.setInvulnerable(bl);
        return true;
    }

    @Override
    public boolean getGodMode(Player player) {
        return player.isInvulnerable();
    }

    @Override
    public void updateExpBar(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.getHandle().cB = -1;
    }

    @Override
    public Command getCommand(String string) {
        return ((CraftServer)Bukkit.getServer()).getCommandMap().getCommand(string);
    }

    private static EntityArmorStand createStand(Location location, String string, boolean bl) {
        double d = location.getX();
        double d2 = location.getZ();
        double d3 = location.getY();
        if (bl) {
            d += 0.05;
            d2 -= 0.2;
            d3 -= 0.3;
        } else {
            d3 -= 0.45;
        }
        EntityArmorStand entityArmorStand = new EntityArmorStand((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), d, d3, d2);
        entityArmorStand.j(true);
        entityArmorStand.r(false);
        entityArmorStand.t(true);
        entityArmorStand.e(true);
        entityArmorStand.s(true);
        entityArmorStand.a(bl);
        if (bl) {
            entityArmorStand.d(new Vector3f(-15.0f, -45.0f, 0.0f));
        }
        if (string != null && !string.isEmpty()) {
            IChatBaseComponent iChatBaseComponent = CraftChatMessage.fromString((String)CMIChatColor.translate((String)string))[0];
            entityArmorStand.b(iChatBaseComponent);
            if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
                entityArmorStand.n(false);
            } else {
                entityArmorStand.n(true);
            }
        } else {
            entityArmorStand.n(false);
        }
        return entityArmorStand;
    }

    @Override
    public CMIDataWatcher spawnHologram(Player player, Location location, String string, ItemStack itemStack) {
        EntityArmorStand entityArmorStand = v1_19_R2.createStand(location, string, itemStack != null);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().b.a((Packet)new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entityArmorStand, 78));
            try {
                int n = entityArmorStand.ah();
                craftPlayer.getHandle().b.a((Packet)new PacketPlayOutEntityMetadata(n, entityArmorStand.al().c()));
                if (itemStack != null) {
                    ArrayList arrayList = Lists.newArrayList();
                    arrayList.add(Pair.of((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
                    PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(n, (List)arrayList);
                    craftPlayer.getHandle().b.a((Packet)packetPlayOutEntityEquipment);
                }
                return new CMIDataWatcher(n, entityArmorStand, itemStack != null ? CMIHoloLineType.staticIcon : CMIHoloLineType.plainText);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public FakeInfo spawnClickable(Player player, Location location, Object object, boolean bl) {
        try {
            if (bl) {
                EntitySlime entitySlime = new EntitySlime(EntityTypes.aH, (net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle());
                entitySlime.j(true);
                entitySlime.e(true);
                entitySlime.a(true);
                entitySlime.b(2, true);
                entitySlime.a(location.getX(), location.getY() - 0.45, location.getZ() - 0.2, 0.0f, 0.0f);
                entitySlime.n(false);
                entitySlime.d(true);
                PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entitySlime);
                ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutSpawnEntity);
                ((CraftPlayer)player).getHandle().b.a((Packet)new PacketPlayOutEntityMetadata(entitySlime.ah(), entitySlime.al().c()));
                FakeInfo fakeInfo = new FakeInfo().setObj(object).setPlayer(player).setId(entitySlime.ah());
                fakeInfo.setEntity(entitySlime);
                PacketHandler.fakeEntities.put(entitySlime.ah(), fakeInfo);
                return fakeInfo;
            }
            EntityArmorStand entityArmorStand = new EntityArmorStand((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY() - 0.35, location.getZ());
            entityArmorStand.j(true);
            entityArmorStand.r(false);
            entityArmorStand.e(true);
            entityArmorStand.s(false);
            if (object instanceof CMIHologram) {
                if (((CMIHologram)object).getHeight() > 1.7) {
                    entityArmorStand.a(false);
                    entityArmorStand.a(location.getX(), location.getY() - 0.75, location.getZ(), 0.0f, 0.0f);
                } else {
                    entityArmorStand.a(true);
                }
            } else {
                entityArmorStand.a(true);
            }
            entityArmorStand.n(false);
            PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entityArmorStand);
            ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutSpawnEntity);
            ((CraftPlayer)player).getHandle().b.a((Packet)new PacketPlayOutEntityMetadata(entityArmorStand.ah(), entityArmorStand.al().c()));
            FakeInfo fakeInfo = new FakeInfo().setObj(object).setPlayer(player).setId(entityArmorStand.ah());
            fakeInfo.setEntity(entityArmorStand);
            PacketHandler.fakeEntities.put(entityArmorStand.ah(), fakeInfo);
            return fakeInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeHologram(Player player, Integer n) {
        if (n == null) {
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = null;
            if (Version.isCurrentSubEqual((int)0)) {
                try {
                    packetPlayOutEntityDestroy = (PacketPlayOutEntityDestroy)PacketPlayOutEntityDestroy.class.getConstructor(Integer.TYPE).newInstance(n);
                }
                catch (Throwable throwable) {
                    packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{n});
                }
            } else {
                packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{n});
            }
            if (packetPlayOutEntityDestroy != null) {
                craftPlayer.getHandle().b.a((Packet)packetPlayOutEntityDestroy);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateHologram(Player player, CMIDataWatcher cMIDataWatcher, String string, ItemStack itemStack) {
        if (cMIDataWatcher == null || !(cMIDataWatcher.getStand() instanceof EntityArmorStand)) {
            return;
        }
        EntityArmorStand entityArmorStand = (EntityArmorStand)cMIDataWatcher.getStand();
        if (string == null || string.isEmpty()) {
            entityArmorStand.n(false);
        } else if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
            entityArmorStand.n(false);
        } else {
            entityArmorStand.n(true);
        }
        IChatBaseComponent iChatBaseComponent = CraftChatMessage.fromString((String)string)[0];
        entityArmorStand.b(iChatBaseComponent);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(cMIDataWatcher.getId().intValue(), entityArmorStand.al().c());
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().b.a((Packet)packetPlayOutEntityMetadata);
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(Pair.of((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
            PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(cMIDataWatcher.getId().intValue(), (List)arrayList);
            craftPlayer.getHandle().b.a((Packet)packetPlayOutEntityEquipment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, ItemStack itemStack) {
        return this.makeFloatingIcon(player, location, itemStack, false);
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, ItemStack itemStack, boolean bl) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        EntityItem entityItem = new EntityItem((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack), 0.0, 0.0, 0.0);
        entityItem.e(location.getX(), location.getY(), location.getZ());
        entityItem.e(true);
        if (bl) {
            entityItem.i(true);
        }
        PacketPlayOutEntityVelocity packetPlayOutEntityVelocity = new PacketPlayOutEntityVelocity(entityItem.ah(), new Vec3D(0.0, 0.0, 0.0));
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entityItem);
        entityPlayer.b.a((Packet)packetPlayOutSpawnEntity);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(entityItem.ah(), entityItem.al().c());
        entityPlayer.b.a((Packet)packetPlayOutEntityMetadata);
        entityPlayer.b.a((Packet)packetPlayOutEntityVelocity);
        return new CMIDataWatcher(entityItem.ah(), entityItem.ai(), CMIHoloLineType.icon);
    }

    public void playSound(Player player, Location location, Sound sound2, float f, float f2) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.playSound(location, sound2, f, f2);
    }

    @Override
    public boolean clearSkin(Player player) {
        if (player == null) {
            return false;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        GameProfile gameProfile = craftPlayer.getProfile();
        if (gameProfile != null) {
            gameProfile.getProperties().removeAll((Object)"textures");
        }
        this.updatePlayerViaPackets(player);
        return true;
    }

    @Override
    public void updatePlayerViaPackets(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)CMI.getInstance(), () -> {
            EntityPlayer entityPlayer2;
            for (EntityPlayer entityPlayer2 : Bukkit.getOnlinePlayers()) {
                if (entityPlayer2.getUniqueId().equals(player.getUniqueId()) || !entityPlayer2.canSee(player)) continue;
                entityPlayer2.hidePlayer((Plugin)CMI.getInstance(), player);
                entityPlayer2.showPlayer((Plugin)CMI.getInstance(), player);
            }
            entityPlayer2 = craftPlayer.getHandle();
            ClientboundPlayerInfoRemovePacket clientboundPlayerInfoRemovePacket = new ClientboundPlayerInfoRemovePacket(List.of(craftPlayer.getUniqueId()));
            EntityPlayer entityPlayer3 = craftPlayer.getHandle();
            PlayerConnection playerConnection = entityPlayer3.b;
            playerConnection.a((Packet)clientboundPlayerInfoRemovePacket);
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(entityPlayer3, ((CraftWorld)player.getWorld()).getHandle(), true, craftPlayer.getLocation(), true);
            PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(player.getEntityId(), entityPlayer3.al().c());
            playerConnection.a((Packet)packetPlayOutEntityMetadata);
            ClientboundPlayerInfoUpdatePacket clientboundPlayerInfoUpdatePacket = ClientboundPlayerInfoUpdatePacket.a(List.of(entityPlayer2));
            playerConnection.a((Packet)clientboundPlayerInfoUpdatePacket);
        });
    }

    public void loadAdvancement(NamespacedKey namespacedKey, String string) {
        if (Bukkit.getAdvancement((NamespacedKey)namespacedKey) != null) {
            return;
        }
        MinecraftKey minecraftKey = CraftNamespacedKey.toMinecraft((NamespacedKey)namespacedKey);
        JsonElement jsonElement = (JsonElement)AdvancementDataWorld.b.fromJson(string, JsonElement.class);
        JsonObject jsonObject = ChatDeserializer.m((JsonElement)jsonElement, (String)"advancement");
        Advancement.SerializedAdvancement serializedAdvancement = Advancement.SerializedAdvancement.a((JsonObject)jsonObject, (LootDeserializationContext)new LootDeserializationContext(minecraftKey, MinecraftServer.getServer().aH()));
        if (serializedAdvancement != null) {
            MinecraftServer.getServer().ay().c.a((Map)Maps.newHashMap(Collections.singletonMap(minecraftKey, serializedAdvancement)));
        }
    }

    public void removeAdvancement(CMIAdvancement cMIAdvancement) {
        Bukkit.getUnsafe().removeAdvancement(cMIAdvancement.getId());
        try {
            DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
            Advancements advancements = dedicatedServer.ay().c;
            for (Map.Entry entry : advancements.b.entrySet()) {
                if (!((Advancement)entry.getValue()).h().a().equals(cMIAdvancement.getId().getKey().toLowerCase())) continue;
                advancements.b.remove(entry.getKey());
                break;
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, Color color) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(0);
        cMIEffect.setSpeed(1.0f);
        cMIEffect.setColor(org.bukkit.Color.fromBGR((int)color.getBlue(), (int)color.getGreen(), (int)color.getRed()));
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, float f, float f2, float f3, float f4, int n) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffectManager.CMIParticle cMIParticle, float f, float f2, float f3, float f4, int n) {
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffect cMIEffect) {
        if (player == null || !player.isOnline() || location == null || cMIEffect == null || location.getWorld() == null) {
            return;
        }
        CMIEffectManager.CMIParticle cMIParticle = cMIEffect.getParticle();
        if (cMIParticle == null) {
            return;
        }
        if (!cMIParticle.isParticle()) {
            return;
        }
        Particle particle = cMIParticle.getParticle();
        if (particle == null) {
            return;
        }
        Particle.DustOptions dustOptions = null;
        if (particle.equals((Object)Particle.REDSTONE)) {
            dustOptions = new Particle.DustOptions(cMIEffect.getColor(), (float)cMIEffect.getSize());
        } else if (cMIEffect.getParticle().getDataType().equals((Object)CMIEffectManager.CMIParticleDataType.BlockData)) {
            dustOptions = Bukkit.createBlockData((Material)(cMIEffect.getMaterial() == null ? CMIMaterial.STONE.getMaterial() : cMIEffect.getMaterial().getMaterial()));
        }
        PacketPlayOutWorldParticles packetPlayOutWorldParticles = new PacketPlayOutWorldParticles(CraftParticle.toNMS((Particle)particle, (Object)dustOptions), true, location.getX(), location.getY(), location.getZ(), (float)cMIEffect.getOffset().getX(), (float)cMIEffect.getOffset().getY(), (float)cMIEffect.getOffset().getZ(), cMIEffect.getSpeed(), cMIEffect.getAmount());
        CraftPlayer craftPlayer = (CraftPlayer)player;
        if (craftPlayer.getHandle().b == null) {
            return;
        }
        if (!location.getWorld().equals(craftPlayer.getWorld())) {
            return;
        }
        craftPlayer.getHandle().b.a((Packet)packetPlayOutWorldParticles);
    }

    @Override
    public boolean forceTeleport(Player player, Location location) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.ek() == 0.0f || !entityPlayer.br()) {
            return false;
        }
        if (entityPlayer.b == null) {
            return false;
        }
        if (entityPlayer.bK()) {
            return false;
        }
        entityPlayer.p();
        WorldServer worldServer = ((CraftWorld)location.getWorld()).getHandle();
        World world2 = location.getWorld();
        worldServer = world2 == null ? ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle() : ((CraftWorld)world2).getHandle();
        ((CraftPlayer)player).getHandle().q();
        if (((CraftWorld)player.getLocation().getWorld()).getHandle() == worldServer) {
            entityPlayer.b.teleport(location);
        } else {
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(entityPlayer, worldServer, true, location, true);
        }
        return true;
    }

    @Override
    public CMIHitBox getBlockHitBox(CMIHitBox cMIHitBox) {
        try {
            Block block = cMIHitBox.getBlock();
            if (block == null) {
                return cMIHitBox;
            }
            if (CMIMaterial.isAir((Material)block.getWorld().getBlockData(block.getLocation()).getMaterial())) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
            } else {
                BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
                WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
                IBlockData iBlockData = worldServer.a_(blockPosition);
                VoxelShape voxelShape = iBlockData.c((IBlockAccess)worldServer, blockPosition);
                if (!voxelShape.b()) {
                    AxisAlignedBB axisAlignedBB = voxelShape.a();
                    cMIHitBox.setMin(new Vector(axisAlignedBB.a(EnumDirection.EnumAxis.a), axisAlignedBB.a(EnumDirection.EnumAxis.b), axisAlignedBB.a(EnumDirection.EnumAxis.c)));
                    cMIHitBox.setMax(new Vector(axisAlignedBB.b(EnumDirection.EnumAxis.a), axisAlignedBB.b(EnumDirection.EnumAxis.b), axisAlignedBB.b(EnumDirection.EnumAxis.c)));
                } else {
                    cMIHitBox.setMin(new Vector(1, 1, 1));
                    cMIHitBox.setMax(new Vector(0, 0, 0));
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public CMIHitBox getEntityHitBox(CMIHitBox cMIHitBox) {
        try {
            Entity entity = cMIHitBox.getEntity();
            if (entity == null) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
                return cMIHitBox;
            }
            AxisAlignedBB axisAlignedBB = ((CraftEntity)entity).getHandle().cD();
            cMIHitBox.setMin(new Vector(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c));
            cMIHitBox.setMax(new Vector(axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public Block getBlockLookingAt(Player player, int n, boolean bl) {
        if (player == null) {
            return null;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > 120) {
            n = 120;
        }
        Location location = player.getLocation().clone().add(0.0, player.getEyeHeight(), 0.0);
        Vector vector = location.getDirection().normalize().multiply(n);
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        RayTraceResult rayTraceResult = craftWorld.rayTraceBlocks(location, vector, (double)n, bl ? FluidCollisionMode.ALWAYS : FluidCollisionMode.NEVER);
        Block block = null;
        block = rayTraceResult == null ? player.getTargetBlock(null, n) : rayTraceResult.getHitBlock();
        return block;
    }

    @Override
    public Block getBlockLookingAt(World world2, Vector vector, Vector vector2, boolean bl) {
        try {
            CraftWorld craftWorld = (CraftWorld)world2;
            RayTrace rayTrace = new RayTrace(new Vec3D(vector.getX(), vector.getY(), vector.getZ()), new Vec3D(vector2.getX(), vector2.getY(), vector2.getZ()), RayTrace.BlockCollisionOption.a, bl ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, null);
            MovingObjectPositionBlock movingObjectPositionBlock = craftWorld.getHandle().a(rayTrace);
            RayTraceResult rayTraceResult = CraftRayTraceResult.fromNMS((World)craftWorld, (MovingObjectPosition)movingObjectPositionBlock);
            return rayTraceResult == null ? null : rayTraceResult.getHitBlock();
        }
        catch (Throwable throwable) {
            if (!this.informed) {
                throwable.printStackTrace();
                this.informed = true;
            }
            return null;
        }
    }

    public Object createFakeEntityForTablist(Player player, String string) {
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer worldServer = (WorldServer)dedicatedServer.E().iterator().next();
        GameProfile gameProfile = new GameProfile(UUID.nameUUIDFromBytes(string.getBytes()), string);
        EntityPlayer entityPlayer = new EntityPlayer((MinecraftServer)dedicatedServer, worldServer, gameProfile);
        EntityPlayer entityPlayer2 = entityPlayer.getBukkitEntity().getHandle();
        entityPlayer2.e(player.getEntityId());
        try {
            entityPlayer.listName = new ChatComponentText(CMIChatColor.translate((String)cMIUser.getDisplayName()));
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            runtimeException.printStackTrace();
        }
        return entityPlayer;
    }

    public void sendPacketsForTablistSort(Player player, Player player2, Object object) {
        PacketPlayOutPlayerInfo packetPlayOutPlayerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{(EntityPlayer)object});
        ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutPlayerInfo);
        if (player.canSee(player2)) {
            packetPlayOutPlayerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{(EntityPlayer)object});
            ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutPlayerInfo);
        }
    }
}

