/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.BungeeCord;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.BungeeCord.BungeeCordListener;
import com.Zrips.CMI.Modules.BungeeCord.BungeeCordServer;
import com.Zrips.CMI.Modules.BungeeCord.BungeePlayer;
import com.Zrips.CMI.Modules.BungeeCord.CMIBungeeCord;
import com.Zrips.CMI.Modules.BungeeCord.CMIBungeeType;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Messages.CMIMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BungeeCordManager {
    public static final String ServerIP = "ServerIP";
    public static final String GetServer = "GetServer";
    public static final String GetServers = "GetServers";
    public static final String MessageChannel = "CMIMessageSubChannel";
    public static final String ServersPlayerCountsChannel = "CMIServersPlayerCounts";
    public static final String ServerPlayerCountsChannel = "CMIServerPlayerCounts";
    public static final String BroadcastChannel = "CMIBroadcastSubChannel";
    public static final String PublicChatChannel = "CMIChatSubChannel";
    public static final String StaffChatChannel = "CMIStaffSubChannel";
    public static final String PortalSetChannel = "CMIPortalSetSubChannel";
    public static final String PortalConfirmedSetChannel = "CMIPortalCSetSubChannel";
    public static final String TeleportChannel = "CMITeleportChannel";
    public static final String TalksWithChannel = "CMITalksWith";
    public static final String TalksWithRecordChannel = "CMITalksWithRecord";
    public static final String PlayerListRequest = "CMIPlayerListRequest";
    public static final String PlayerListFeedback = "CMIPlayerListFeedback";
    public static final String NetworkInformation = "CMINetworkInfo";
    public static final String ServerInformation = "CMIServerInfo";
    public static final String PlayerFeedback = "CMIPlayerFeedback";
    public static final String ServerListRequest = "CMIServerListRequest";
    public static UUID localRangedMessage;
    public static long localRangedMessageTime;
    HashMap<String, BungeeCordServer> servers = new HashMap();
    private CMI plugin;
    private boolean isBungee = false;
    private boolean CMIBPresent = false;
    private boolean gotServerList = false;
    private BungeeCordServer thisServer;
    private String thisServerName;
    private boolean enabledSupport = true;
    private boolean backToPreviousServer = true;
    private boolean namesInTabComplete = true;
    private CMIBungeeCord bcord = null;
    private CMIBungeeType type = CMIBungeeType.Unknown;
    Long time = 0L;
    private static final String spacer = "_20_";

    public BungeeCordManager(CMI cMI) {
        this.plugin = cMI;
        this.bcord = CMIBungeeCord.of((Plugin)cMI);
    }

    public void loadConfig() {
        try {
            ConfigReader configReader = this.plugin.getConfigManager().getConfig();
            configReader.addComment("BungeeCord.Enabled", new String[]{"You can disable bungeecord support entirely if you are exrperiencing issues with it", "When setting this to false some features like public messages over bungee cord, private messages over bungeecord, portals over bungecoord and other features will stop working", "Keep in mind that regular behavior of those features will remain intacted"});
            this.enabledSupport = configReader.get("BungeeCord.Enabled", Boolean.valueOf(false));
            configReader.addComment("BungeeCord.NamesInTabComplete", new String[]{"When set to true player names from entire bungee network will be included into tab complete"});
            this.namesInTabComplete = configReader.get("BungeeCord.NamesInTabComplete", Boolean.valueOf(false));
            configReader.addComment("BungeeCord.BackToPreviousServer", new String[]{"When enabled player can return to previous server when using /back comand instead of being teleported to previous location on that server", "This only applies if player came to this server without teleporting around"});
            this.backToPreviousServer = configReader.get("BungeeCord.BackToPreviousServer", Boolean.valueOf(false));
        }
        catch (Exception exception) {
            this.plugin.consoleMessage("&cFailed to load BungeeCord Configuration!");
        }
    }

    public void initialize() {
        try {
            if (this.plugin.getServer().spigot().getConfig().getBoolean("settings.bungeecord")) {
                this.plugin.consoleMessage("Enabling BungeeCord Support");
                this.isBungee = true;
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        if (this.enabledSupport) {
            new BungeeCordListener(this.plugin);
            CMI.getInstance().consoleMessage("Initializing BungeeCord");
        }
    }

    public boolean isCMIBPresent() {
        return this.CMIBPresent;
    }

    public void setCMIBPresent(boolean bl) {
        if (bl) {
            this.plugin.consoleMessage("CMI proxy plugin detected");
            this.sendNetworkInfoUpdate();
        }
        this.CMIBPresent = bl;
    }

    @Deprecated
    public boolean isBungee() {
        return this.isBungeeCord();
    }

    public void setBungeeCord(boolean bl) {
        this.isBungee = bl;
    }

    public boolean isBungeeCord() {
        return this.isBungee && this.enabledSupport;
    }

    public void addServer(BungeeCordServer bungeeCordServer) {
        this.gotServerList = true;
        this.servers.put(bungeeCordServer.getName().toLowerCase(), bungeeCordServer);
        bungeeCordServer.update();
    }

    public BungeeCordServer getServer(String string) {
        if (System.currentTimeMillis() > this.time + 600L) {
            this.updateServers();
        }
        return this.servers.get(string.toLowerCase());
    }

    public HashMap<String, BungeeCordServer> getServers() {
        if (System.currentTimeMillis() > this.time + 600L) {
            this.sendNetworkInfoUpdate();
            this.updateServers();
            this.time = System.currentTimeMillis();
        }
        return this.servers;
    }

    public void sendNetworkInfoUpdate() {
        if (!this.type.equals((Object)CMIBungeeType.Unknown)) {
            return;
        }
        if (!this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(NetworkInformation);
        this.plugin.getServer().sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void sendServerInformationToBungee() {
        if (this.type.equals((Object)CMIBungeeType.Unknown)) {
            return;
        }
        if (!this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(ServerInformation);
        byteArrayDataOutput.writeInt(CMI.getInstance().getUtilManager().getOnlinePlayerCount());
        byteArrayDataOutput.writeInt(Bukkit.getMaxPlayers());
        byteArrayDataOutput.writeUTF(Bukkit.getMotd());
        this.plugin.getServer().sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void sendServerListRequest() {
        if (this.gotServerList || !this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(ServerListRequest);
        player.sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void sendPlayerListRequest() {
        if (!this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(PlayerListRequest);
        player.sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void sendPlayerInfoRequest(String string) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        BungeeCordServer bungeeCordServer = this.getServer(string);
        if (bungeeCordServer == null) {
            return;
        }
        if (bungeeCordServer.getCurrentPlayers() <= 0) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.getThisServerName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteArrayDataOutput.writeShort(byteArrayOutputStream.toByteArray().length);
        byteArrayDataOutput.write(byteArrayOutputStream.toByteArray());
        this.forward(bungeeCordServer.getName(), PlayerListRequest, byteArrayDataOutput.toByteArray());
    }

    private static Player getFirstPlayer() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        return player;
    }

    public BungeeCordServer getThisServer() {
        if (this.thisServer == null && this.getThisServerName() != null) {
            this.thisServer = this.getServer(this.getThisServerName());
        }
        return this.thisServer;
    }

    public void setThisServer(BungeeCordServer bungeeCordServer) {
        this.thisServer = bungeeCordServer;
    }

    public String getThisServerName() {
        if (this.thisServerName == null && this.thisServer != null) {
            this.thisServerName = this.thisServer.getName();
        }
        if (this.thisServerName == null) {
            this.updateServersInfo();
        }
        return this.thisServerName == null ? CMILib.getInstance().getReflectionManager().getServerName() : this.thisServerName;
    }

    public String getThisServerNameOneWord() {
        if (this.thisServerName == null && this.thisServer != null) {
            this.thisServerName = this.thisServer.getName();
        }
        return this.thisServerName == null ? CMILib.getInstance().getReflectionManager().getServerName().replace(" ", spacer) : this.thisServerName.replace(" ", spacer);
    }

    public void setThisServerName(String string) {
        this.thisServerName = string;
        if (this.getThisServerName() != null) {
            this.thisServer = this.getServer(this.getThisServerName());
        }
    }

    public BungeePlayer getBungeePlayer(String string) {
        if (!this.enabledSupport) {
            return null;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.servers.entrySet()) {
            BungeePlayer bungeePlayer = entry.getValue().getPlayer(string);
            if (bungeePlayer == null) continue;
            return bungeePlayer;
        }
        return null;
    }

    public BungeePlayer getBungeePlayer(UUID uUID) {
        if (!this.enabledSupport) {
            return null;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.servers.entrySet()) {
            BungeePlayer bungeePlayer = entry.getValue().getPlayer(uUID);
            if (bungeePlayer == null) continue;
            return bungeePlayer;
        }
        return null;
    }

    public BungeeCordServer getPlayerServer(UUID uUID) {
        if (!this.enabledSupport) {
            return null;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.servers.entrySet()) {
            BungeePlayer bungeePlayer = entry.getValue().getPlayer(uUID);
            if (bungeePlayer == null) continue;
            return entry.getValue();
        }
        if (CMIUser.getOnlinePlayer(uUID) != null) {
            return this.thisServer;
        }
        return null;
    }

    public BungeeCordServer getPlayerServer(String string) {
        if (!this.enabledSupport) {
            return null;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.servers.entrySet()) {
            BungeePlayer bungeePlayer = entry.getValue().getPlayer(string);
            if (bungeePlayer == null) continue;
            return entry.getValue();
        }
        if (Bukkit.getPlayerExact((String)string) != null) {
            return this.thisServer;
        }
        return null;
    }

    public boolean anyPlayersOnServer(String string) {
        if (!this.enabledSupport) {
            return false;
        }
        BungeeCordServer bungeeCordServer = this.getServer(string);
        if (bungeeCordServer == null) {
            return false;
        }
        return bungeeCordServer.getCurrentPlayers() > 0;
    }

    public void updateServersInfo() {
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(GetServer);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void updateServersIp() {
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.getServers().entrySet()) {
            if (entry.getValue().getIp() != null) continue;
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(ServerIP);
            byteArrayDataOutput.writeUTF(entry.getKey());
            player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        }
    }

    public void updateServers() {
        if (!this.isBungee) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(GetServers);
        try {
            player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public void connectToServer(Player player, String string) {
        if (player == null || !player.isOnline()) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("Connect");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void connectOther(String string, String string2) {
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("ConnectOther");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void connectToServer(String string, String string2) {
        this.connectToServer(CMIUser.getOnlinePlayer(string), string2);
    }

    public int getPlayersInServer(String string) {
        if (!this.enabledSupport) {
            return 0;
        }
        BungeeCordServer bungeeCordServer = this.getServer(string);
        if (bungeeCordServer == null) {
            return 0;
        }
        bungeeCordServer.update();
        return bungeeCordServer.getCurrentPlayers();
    }

    public void sendPublicMessage(String string, String string2, String string3) {
        if (!this.enabledSupport) {
            return;
        }
        if (this.getPlayersInServer(string) < 1) {
            return;
        }
        if (string3.length() > 32766) {
            string3 = CMIChatColor.stripColor((String)string3);
        }
        if (string3.length() > 32766) {
            this.plugin.consoleMessage("&cFailed to send public bungee message (" + string3.length() + ")");
            return;
        }
        try {
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(string2);
            byteArrayDataOutput.writeUTF(string3);
            byteArrayDataOutput.writeLong(System.currentTimeMillis());
            this.forward(string, PublicChatChannel, byteArrayDataOutput.toByteArray());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void sendStaffMessage(String string, String string2) {
        for (Map.Entry<String, BungeeCordServer> entry : this.getServers().entrySet()) {
            if (entry.getValue().getCurrentPlayers() <= 0) continue;
            this.sendStaffMessage(entry.getKey(), string, string2);
        }
    }

    public void sendStaffMessage(String string, String string2, String string3) {
        if (!this.enabledSupport) {
            return;
        }
        if (this.getPlayersInServer(string) < 1) {
            return;
        }
        if (this.getThisServerName().equalsIgnoreCase(string)) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeUTF(string3);
        byteArrayDataOutput.writeLong(System.currentTimeMillis());
        this.forward(string, StaffChatChannel, byteArrayDataOutput.toByteArray());
    }

    @Deprecated
    public void sendMessage(String string, String string2, String string3) {
        this.sendPrivateMessage(string, string2, string3);
    }

    public void sendPrivateMessage(String string, String string2, String string3) {
        if (!this.enabledSupport) {
            return;
        }
        BungeeCordServer bungeeCordServer = this.getPlayerServer(string2);
        if (bungeeCordServer == null) {
            return;
        }
        if (bungeeCordServer.getCurrentPlayers() <= 0) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeUTF(string3);
        byteArrayDataOutput.writeLong(System.currentTimeMillis());
        this.forward(bungeeCordServer.getName(), MessageChannel, byteArrayDataOutput.toByteArray());
    }

    public void sendBroadcastMessage(String string, BungeeCordServer bungeeCordServer, String string2) {
        if (!this.enabledSupport) {
            return;
        }
        if (bungeeCordServer == null) {
            return;
        }
        if (bungeeCordServer.getCurrentPlayers() <= 0) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeLong(System.currentTimeMillis());
        this.forward(bungeeCordServer.getName(), BroadcastChannel, byteArrayDataOutput.toByteArray());
    }

    public void sendPortalSetLocationToBungee(String string, String string2, String string3, Location location) {
        if (!this.enabledSupport) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(PortalSetChannel);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeUTF(this.getThisServerName());
        byteArrayDataOutput.writeUTF(string3);
        byteArrayDataOutput.writeUTF(this.plugin.getPlayerManager().convertLocToString(location));
        byteArrayDataOutput.writeUTF(string);
        this.plugin.getServer().sendPluginMessage((Plugin)CMI.getInstance(), "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void sendPortalSetSuccessResponse(String string, String string2, String string3, String string4) {
        if (!this.enabledSupport) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("Forward");
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeUTF(PortalConfirmedSetChannel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.getThisServerName());
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeUTF(string3);
            dataOutputStream.writeUTF(string4);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byteArrayDataOutput.writeShort(byteArrayOutputStream.toByteArray().length);
        byteArrayDataOutput.write(byteArrayOutputStream.toByteArray());
        this.plugin.getServer().sendPluginMessage((Plugin)CMI.getInstance(), "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void recordBackLocation(String string, UUID uUID, Location location) {
        this.teleporToLocation(string, uUID, "", location, "");
    }

    public void teleporToLocation(String string, UUID uUID, String string2, Location location) {
        this.teleporToLocation(string, uUID, string2, location, "");
    }

    public void teleporToLocation(String string, UUID uUID, String string2, Location location, String string3) {
        if (!this.enabledSupport) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(TeleportChannel);
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(uUID.toString());
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeUTF(CMILocation.toString((Location)location, (boolean)false));
        byteArrayDataOutput.writeUTF(string3);
        this.plugin.getServer().sendPluginMessage((Plugin)CMI.getInstance(), "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void withWhomHeTalks(String string) {
        if (!this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(TalksWithChannel);
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void talksWith(String string, String string2) {
        if (!this.isCMIBPresent()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF(TalksWithRecordChannel);
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        CMIMessages.consoleMessage((String)("Record talks with " + string + " and " + string2));
        player.sendPluginMessage((Plugin)this.plugin, "cmib:fromserver", byteArrayDataOutput.toByteArray());
    }

    public void forward(String string, String string2, byte[] byArray) {
        Player player = BungeeCordManager.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("Forward");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeShort(byArray.length);
        byteArrayDataOutput.write(byArray);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public boolean isPlayerOnAnotherServer(String string) {
        if (!this.enabledSupport) {
            return false;
        }
        if (this.getThisServerName() == null) {
            return false;
        }
        if (CMIUser.getOnlinePlayer(string) != null) {
            return false;
        }
        BungeePlayer bungeePlayer = this.getBungeePlayer(string);
        return bungeePlayer != null && !bungeePlayer.getServerName().equalsIgnoreCase(this.getThisServerName());
    }

    public void sendNewPlayerInfoToNetwork(Player player) {
        if (!this.enabledSupport) {
            return;
        }
        if (!this.isBungeeCord()) {
            return;
        }
        for (Map.Entry<String, BungeeCordServer> entry : this.getServers().entrySet()) {
            if (entry.getValue().getCurrentPlayers() <= 0) continue;
            this.sendNewPlayerInfoToNetwork(player, entry.getKey());
        }
    }

    public void sendNewPlayerInfoToNetwork(Player player, String string) {
        if (!this.enabledSupport) {
            return;
        }
        if (!this.isBungeeCord()) {
            return;
        }
        if (this.getThisServerName() == null) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (this.getPlayersInServer(string) < 1) {
            return;
        }
        if (string.equalsIgnoreCase(this.getThisServerName())) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        String string2 = String.valueOf(cMIUser.getName()) + "::" + cMIUser.getDisplayName(false) + "::" + (cMIUser.getNickName() == null ? "" : cMIUser.getNickName()) + "::" + cMIUser.getUniqueId() + "::" + (cMIUser.isVanished() ? 1 : 0);
        byteArrayDataOutput.writeUTF(this.getThisServerName());
        byteArrayDataOutput.writeUTF(string2);
        this.forward(string, PlayerFeedback, byteArrayDataOutput.toByteArray());
    }

    public boolean isEnabledSupport() {
        return this.enabledSupport;
    }

    public CMIBungeeCord getBungeeCord() {
        return this.bcord;
    }

    public CMIBungeeType getNetworkType() {
        return this.type;
    }

    public void setNetworkType(CMIBungeeType cMIBungeeType) {
        this.type = cMIBungeeType;
    }

    public boolean isNamesInTabComplete() {
        return this.namesInTabComplete;
    }

    public boolean isBackToPreviousServer() {
        return this.backToPreviousServer;
    }
}

