/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Display;

import com.Zrips.CMI.Modules.Display.CMIDisplayTransform;
import com.Zrips.CMI.Modules.Display.CMIDisplayType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class CMIDisplay {
    CMIDisplayTransform transform;
    private static Constructor<?> TextDisplay;
    private static Constructor<?> ItemDisplay;
    private static Constructor<?> BlockDisplay;
    private static Constructor<?> InteractDisplay;
    private static Object textDisplayEntityType;
    private static Object itemDisplayEntityType;
    private static Object blockDisplayEntityType;
    private static Object interactionEntityType;
    private static Class<?> worldClass;
    private static Constructor<?> PacketPlayOutSpawnEntity;
    private static Constructor<?> PacketPlayOutEntityMetadata;
    private static Constructor<?> PacketPlayOutEntityDestroy;
    private static Method sendPacket;
    private static Method method1;
    private static Method method2;
    private static Field playerConnection;
    private static Method setLocationMethod;
    protected Location loc;
    protected Display display;
    protected Object d;
    private int id;
    private CMIDisplayType type;

    static {
        setLocationMethod = null;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3)) {
            try {
                String string = "aX";
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                    string = "bb";
                } else if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R3)) {
                    string = "aY";
                }
                String string2 = "ae";
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                    string2 = "ah";
                } else if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R3)) {
                    string2 = "af";
                }
                String string3 = "ab";
                if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4)) {
                    string3 = "ae";
                } else if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R3)) {
                    string3 = "ac";
                }
                textDisplayEntityType = EntityTypes.class.getField(string).get(EntityTypes.class);
                itemDisplayEntityType = EntityTypes.class.getField(string2).get(EntityTypes.class);
                interactionEntityType = EntityTypes.class.getField(string3).get(EntityTypes.class);
                blockDisplayEntityType = EntityTypes.class.getField("j").get(EntityTypes.class);
                worldClass = World.class;
                BlockDisplay = Display.BlockDisplay.class.getConstructor(EntityTypes.class, worldClass);
                ItemDisplay = Display.ItemDisplay.class.getConstructor(EntityTypes.class, worldClass);
                TextDisplay = Display.TextDisplay.class.getConstructor(EntityTypes.class, worldClass);
                InteractDisplay = Interaction.class.getConstructor(EntityTypes.class, worldClass);
                PacketPlayOutSpawnEntity = PacketPlayOutSpawnEntity.class.getConstructor(net.minecraft.world.entity.Entity.class);
                PacketPlayOutEntityMetadata = PacketPlayOutEntityMetadata.class.getConstructor(Integer.TYPE, List.class);
                PacketPlayOutEntityDestroy = PacketPlayOutEntityDestroy.class.getConstructor(int[].class);
                playerConnection = Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1) ? EntityPlayer.class.getField("c") : EntityPlayer.class.getField("b");
                sendPacket = Version.isCurrentEqualOrHigher((Version)Version.v1_20_R2) ? PlayerConnection.class.getMethod("b", Packet.class) : PlayerConnection.class.getMethod("a", Packet.class);
                method1 = Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4) ? net.minecraft.world.entity.Entity.class.getMethod("ap", new Class[0]) : (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R3) ? net.minecraft.world.entity.Entity.class.getMethod("an", new Class[0]) : (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R2) ? net.minecraft.world.entity.Entity.class.getMethod("al", new Class[0]) : net.minecraft.world.entity.Entity.class.getMethod("aj", new Class[0])));
                setLocationMethod = Version.isCurrentEqualOrHigher((Version)Version.v1_20_R4) ? net.minecraft.world.entity.Entity.class.getMethod("p", Double.TYPE, Double.TYPE, Double.TYPE) : net.minecraft.world.entity.Entity.class.getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE);
                method2 = DataWatcher.class.getMethod("c", new Class[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public CMIDisplay(CMIDisplayType cMIDisplayType, Location location) {
        block16: {
            this.d = null;
            this.id = 0;
            if (cMIDisplayType == null || location == null) {
                return;
            }
            this.type = cMIDisplayType;
            this.loc = location;
            try {
                Object object = CMILib.getInstance().getReflectionManager().getCraftWorld(location.getWorld());
                switch (cMIDisplayType) {
                    case Block: {
                        this.d = BlockDisplay.newInstance(blockDisplayEntityType, object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]));
                        break;
                    }
                    case Item: {
                        this.d = ItemDisplay.newInstance(itemDisplayEntityType, object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]));
                        break;
                    }
                    case Text: {
                        this.d = TextDisplay.newInstance(textDisplayEntityType, object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]));
                        break;
                    }
                    case Interaction: {
                        this.d = InteractDisplay.newInstance(interactionEntityType, object.getClass().getMethod("getHandle", new Class[0]).invoke(object, new Object[0]));
                        break;
                    }
                }
                setLocationMethod.invoke(this.d, location.getX(), location.getY(), location.getZ());
                if (this.d != null) {
                    switch (cMIDisplayType) {
                        case Text: 
                        case Block: 
                        case Item: {
                            this.display = (Display)this.d.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(this.d, new Object[0]);
                            if (this.display != null) {
                                this.id = this.display.getEntityId();
                                break;
                            }
                            break block16;
                        }
                        case Interaction: {
                            org.bukkit.entity.Interaction interaction = (org.bukkit.entity.Interaction)this.d.getClass().getMethod("getBukkitEntity", new Class[0]).invoke(this.d, new Object[0]);
                            if (interaction != null) {
                                this.id = interaction.getEntityId();
                                break;
                            }
                            break block16;
                        }
                    }
                    break block16;
                }
                CMIMessages.consoleMessage((String)("Failed to determine display entity " + (Object)((Object)cMIDisplayType)));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public Entity getDisplayEntity() {
        return this.display;
    }

    public Transformation getTransformation() {
        return this.display.getTransformation();
    }

    public void getTransformation(Transformation transformation) {
        this.display.setTransformation(transformation);
    }

    public void setWidth(double d) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> {
                Transformation transformation = this.display.getTransformation();
                Vector3f vector3f = transformation.getScale();
                vector3f.x = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                this.display.setTransformation(transformation);
            });
        } else {
            Transformation transformation = this.display.getTransformation();
            Vector3f vector3f = transformation.getScale();
            vector3f.x = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            this.display.setTransformation(transformation);
        }
    }

    public void setHeight(double d) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> {
                Transformation transformation = this.display.getTransformation();
                Vector3f vector3f = transformation.getScale();
                vector3f.y = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
                this.display.setTransformation(transformation);
            });
        } else {
            Transformation transformation = this.display.getTransformation();
            Vector3f vector3f = transformation.getScale();
            vector3f.y = (float)CMINumber.clamp((double)d, (double)0.01, (int)1000);
            this.display.setTransformation(transformation);
        }
    }

    public void setInterpolationDuration(int n) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.setInterpolationDuration(n));
        } else {
            this.display.setInterpolationDuration(n);
        }
    }

    public int getInterpolationDuration() {
        return this.display.getInterpolationDuration();
    }

    public void setInterpolationDelay(int n) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.display.setInterpolationDelay(n));
        } else {
            this.display.setInterpolationDelay(n);
        }
    }

    public int getInterpolationDelay() {
        return this.display.getInterpolationDelay();
    }

    public void setLocation(Location location) {
        this.loc = location;
    }

    public float getRange() {
        return this.display.getViewRange();
    }

    public void setRange(int n) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.display.setViewRange((float)n));
        } else {
            this.display.setViewRange((float)n);
        }
    }

    public void setBrightness(int n, int n2) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.display.setBrightness(new Display.Brightness(CMINumber.clamp((int)n, (int)0, (int)15), CMINumber.clamp((int)n2, (int)0, (int)15))));
        } else {
            this.display.setBrightness(new Display.Brightness(CMINumber.clamp((int)n, (int)0, (int)15), CMINumber.clamp((int)n2, (int)0, (int)15)));
        }
    }

    public void setBillboard(Display.Billboard billboard) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.display.setBillboard(billboard));
        } else {
            this.display.setBillboard(billboard);
        }
    }

    public Display.Billboard getBillboard() {
        return this.display.getBillboard();
    }

    public Location getLocation() {
        return this.loc;
    }

    public Object getDisplay() {
        return this.d;
    }

    private static void sendPacket(Object object, Object object2) {
        try {
            sendPacket.invoke(object, object2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void show(Player player) {
        this.show(player, (net.minecraft.world.entity.Entity)this.d);
    }

    private void show(Player player, net.minecraft.world.entity.Entity entity) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!player.getWorld().equals(this.loc.getWorld())) {
            return;
        }
        try {
            Object object = playerConnection.get(CMILib.getInstance().getReflectionManager().getPlayerHandle(player));
            CMIDisplay.sendPacket(object, PacketPlayOutSpawnEntity.newInstance(entity));
            if (!this.type.equals((Object)CMIDisplayType.Interaction)) {
                CMIDisplay.sendPacket(object, PacketPlayOutEntityMetadata.newInstance(this.id, method2.invoke(method1.invoke((Object)entity, new Object[0]), new Object[0])));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, (Object)entity, this.getLocation());
    }

    public void update(Player player) {
        this.update(player, (net.minecraft.world.entity.Entity)this.d);
    }

    public void update(Player player, boolean bl) {
        this.update(player, (net.minecraft.world.entity.Entity)this.d, bl);
    }

    private void update(Player player, net.minecraft.world.entity.Entity entity) {
        this.update(player, entity, true);
    }

    private void update(Player player, net.minecraft.world.entity.Entity entity, boolean bl) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!player.getWorld().equals(this.loc.getWorld())) {
            return;
        }
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> {
                try {
                    Object object = playerConnection.get(CMILib.getInstance().getReflectionManager().getPlayerHandle(player));
                    if (!this.type.equals((Object)CMIDisplayType.Interaction)) {
                        CMIDisplay.sendPacket(object, PacketPlayOutEntityMetadata.newInstance(this.id, method2.invoke(method1.invoke((Object)entity, new Object[0]), new Object[0])));
                    }
                    if (bl) {
                        CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, (Object)entity, this.getLocation());
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            });
        } else {
            try {
                Object object = playerConnection.get(CMILib.getInstance().getReflectionManager().getPlayerHandle(player));
                if (!this.type.equals((Object)CMIDisplayType.Interaction)) {
                    CMIDisplay.sendPacket(object, PacketPlayOutEntityMetadata.newInstance(this.id, method2.invoke(method1.invoke((Object)entity, new Object[0]), new Object[0])));
                }
                if (bl) {
                    CMILib.getInstance().getReflectionManager().superficialEntityTeleport(player, (Object)entity, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void destroy(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        try {
            Object object = playerConnection.get(CMILib.getInstance().getReflectionManager().getPlayerHandle(player));
            CMIDisplay.sendPacket(object, PacketPlayOutEntityDestroy.newInstance(new Object[]{new int[]{this.id}}));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getId() {
        return this.id;
    }
}

