/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Display;

import com.Zrips.CMI.Modules.Display.CMIDisplay;
import com.Zrips.CMI.Modules.Display.CMIDisplayType;
import java.util.List;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;

public class CMITextDisplay
extends CMIDisplay {
    private TextDisplay td;

    public CMITextDisplay(Location location) {
        super(CMIDisplayType.Text, location);
        try {
            this.td = (TextDisplay)this.display;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.setBillboard(Display.Billboard.VERTICAL);
        this.setRange(32);
        this.setWidth(1.0);
        this.setHeight(1.0);
        this.loc = location;
        this.setLocation(location);
    }

    public String getText() {
        return this.td.getText();
    }

    public void setText(String string) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setText(CMIChatColor.translate((String)string)));
        } else {
            this.td.setText(CMIChatColor.translate((String)string));
        }
    }

    public void setText(List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        list2.forEach(string -> {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append("\n&r");
            }
            stringBuilder.append((String)string);
        });
        String string2 = CMIChatColor.translate((String)stringBuilder.toString());
        if (string2.length() >= 15000) {
            CMIMessages.consoleMessage((String)("&4Hologram text too long. Max 15000 characters, got " + string2.length()));
            return;
        }
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setText(string2));
        } else {
            this.td.setText(string2);
        }
    }

    public int getLineWidth() {
        return this.td.getLineWidth();
    }

    public void setLineWidth(int n) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setLineWidth(n));
        } else {
            this.td.setLineWidth(n);
        }
    }

    public byte getTextOpacity() {
        return this.td.getTextOpacity();
    }

    public void setTextOpacity(byte by) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setTextOpacity(by));
        } else {
            this.td.setTextOpacity(by);
        }
    }

    public TextDisplay.TextAlignment getAligment() {
        return this.td.getAlignment();
    }

    public void setAligment(TextDisplay.TextAlignment textAlignment) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setAlignment(textAlignment));
        } else {
            this.td.setAlignment(textAlignment);
        }
    }

    public void setDefaultBackground(boolean bl) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setDefaultBackground(bl));
        } else {
            this.td.setDefaultBackground(bl);
        }
    }

    public boolean isDefaultBackground() {
        return this.td.isDefaultBackground();
    }

    public void setBackgroundColor(Color color) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setBackgroundColor(color));
        } else {
            this.td.setBackgroundColor(color);
        }
    }

    public void setBackgroundColor(CMIChatColor cMIChatColor) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setBackgroundColor(cMIChatColor.getRGBColor()));
        } else {
            this.td.setBackgroundColor(cMIChatColor.getRGBColor());
        }
    }

    public Color getBackgroundColor() {
        return this.td.getBackgroundColor();
    }

    public void setFacing(double d, double d2) {
        this.getLocation().setPitch((float)d);
        this.getLocation().setYaw((float)d2);
    }

    public float getDisplayHeight() {
        return this.td.getDisplayHeight();
    }

    public void setShadowed(boolean bl) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setShadowed(bl));
        } else {
            this.td.setShadowed(bl);
        }
    }

    public boolean isShadowed() {
        return this.td.isShadowed();
    }

    public void setSeeThrough(boolean bl) {
        if (Version.isFolia()) {
            CMIScheduler.runAtLocation((Location)this.getLocation(), () -> this.td.setSeeThrough(bl));
        } else {
            this.td.setSeeThrough(bl);
        }
    }

    public boolean isSeeThrough() {
        return this.td.isSeeThrough();
    }
}

