/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Holograms;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIInteractType;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Holograms.CMIHologramClickEvent;
import com.Zrips.CMI.Modules.Holograms.CMIHologramLine;
import com.Zrips.CMI.Modules.Holograms.CMIHologramPage;
import com.Zrips.CMI.Modules.Holograms.HologramManager;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.CMIVisualEffect;
import com.Zrips.CMI.Modules.Particl.ParticleManager;
import com.Zrips.CMI.events.CMIPlayerFakeEntityInteractEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;

public class HologramListener
implements Listener {
    private CMI plugin;
    protected Map<UUID, Long> lastUpdateRange;
    protected Map<UUID, Long> stickyLastUpdate;

    public HologramListener(CMI cMI) {
        this.plugin = cMI;
        this.lastUpdateRange = new HashMap<UUID, Long>();
        this.stickyLastUpdate = new HashMap<UUID, Long>();
    }

    private List<Location> getLocations(Location location, double d, int n) {
        double d2 = (double)location.getYaw() / 180.0 * Math.PI;
        double d3 = (double)location.getPitch() / 180.0 * Math.PI;
        double d4 = Math.PI * 2 * d / 0.3;
        double d5 = (double)((int)((location.getPitch() + 540.0f) % 360.0f * 100.0f)) / 100.0;
        d3 = 0.0;
        ArrayList<Location> arrayList = new ArrayList<Location>();
        int n2 = 0;
        double d6 = d5 += 90.0;
        while (d6 < 360.0) {
            if (++n2 > 1) break;
            double d7 = HologramListener.xPosYaw(Math.toRadians(d6), d, d2);
            double d8 = HologramListener.yPosYaw(Math.toRadians(d6), d);
            double d9 = HologramListener.zPosYaw(Math.toRadians(d6), d, d2);
            Vector vector = new Vector(d7, d8, d9);
            vector = HologramListener.rotateX(vector, d3);
            vector = HologramListener.rotateY(vector, -d2);
            Location location2 = new Location(location.getWorld(), vector.getX() + location.getX(), vector.getY() + location.getY(), vector.getZ() + location.getZ());
            arrayList.add(location2);
            d6 += 360.0 / d4;
        }
        return arrayList;
    }

    private static Vector rotateX(Vector vector, double d) {
        double d2 = Math.cos(d) * vector.getY() - Math.sin(d) * vector.getZ();
        double d3 = Math.sin(d) * vector.getY() + Math.cos(d) * vector.getZ();
        return vector.setY(d2).setZ(d3);
    }

    private static Vector rotateY(Vector vector, double d) {
        double d2 = Math.cos(d) * vector.getX() + Math.sin(d) * vector.getZ();
        double d3 = -Math.sin(d) * vector.getX() + Math.cos(d) * vector.getZ();
        return vector.setX(d2).setZ(d3);
    }

    private static double xPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.cos(Math.PI / 180 * d3);
    }

    private static double yPosYaw(double d, double d2) {
        return Math.cos(d) * d2;
    }

    public static double zPosYaw(double d, double d2, double d3) {
        return Math.sin(d) * d2 * Math.sin(Math.PI / 180 * d3);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < (long)this.plugin.getHologramManager().getHoloCheckInterval()) {
            return;
        }
        this.lastUpdateRange.put(player.getUniqueId(), l2);
        this.stickyLastUpdate.put(player.getUniqueId(), l2);
        this.plugin.getHologramManager().handleHoloUpdates(player, location2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.plugin.getHologramManager().removeAimAt(player.getUniqueId());
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        if (!playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            this.plugin.getHologramManager().removeLastHologramInRange(player.getUniqueId());
        }
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < 20L) {
            return;
        }
        this.lastUpdateRange.put(player.getUniqueId(), l2);
        CMIScheduler.runTaskLater(() -> this.plugin.getHologramManager().handleHoloUpdates(player, location2), (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.lastUpdateRange.remove(player.getUniqueId());
        this.plugin.getHologramManager().clearCachedData(player.getUniqueId());
        this.plugin.getHologramManager().clearCache(player.getUniqueId());
        this.plugin.getHologramManager().removeAimAt(player.getUniqueId());
        this.plugin.getHologramManager().removeLastHologramInRange(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player == null) {
            return;
        }
        CMIScheduler.runTaskLater(() -> {
            if (player.isOnline()) {
                this.plugin.getHologramManager().handleHoloUpdates(player, player.getLocation());
            }
        }, (long)20L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        Block block;
        Player player = playerInteractEvent.getPlayer();
        if (player == null) {
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HologramManager.CMIAiming cMIAiming = this.plugin.getHologramManager().getAimAt(player.getUniqueId());
        if (cMIAiming == null) {
            return;
        }
        CMIHologram cMIHologram = this.plugin.getHologramManager().getByName(cMIAiming.getName());
        if (cMIHologram == null) {
            return;
        }
        int n = cMIHologram.getHoveringLine(player.getUniqueId());
        if (n < 1) {
            return;
        }
        if (cMIHologram.isCheckLineOfSight() && (block = CMI.getInstance().getNMS().getBlockLookingAt(cMIHologram.getLocation().getWorld(), player.getEyeLocation().toVector(), cMIHologram.getCenterLocation().toVector(), false)) != null) {
            return;
        }
        playerInteractEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(CMIHologramClickEvent cMIHologramClickEvent) {
        if (cMIHologramClickEvent.isCancelled()) {
            return;
        }
        CMIHologram cMIHologram = cMIHologramClickEvent.getHologram();
        Player player = cMIHologramClickEvent.getPlayer();
        Integer n = cMIHologram.getPlayerPage(player.getUniqueId());
        CMIHologramPage cMIHologramPage = cMIHologram.getPage(n);
        int n2 = cMIHologramClickEvent.getLineNumber() - 1;
        if (!cMIHologram.isNewDisplayMethod() && !cMIHologram.isDownOrder().booleanValue()) {
            n2 = cMIHologramPage.getLines().size() - n2 - 1;
        }
        if (cMIHologram.isAutoPagination() && n2 == cMIHologramPage.getLines().size()) {
            cMIHologram.processPrevNextPageClick(player);
            return;
        }
        CMIHologramLine cMIHologramLine = cMIHologramPage.getLines().get(n2);
        String string = cMIHologramLine.getCommand();
        if (string != null) {
            cMIHologram.onInteraction(player, cMIHologramClickEvent.getActionType());
            Snd snd = new Snd();
            snd.setSender(player).setTarget(player);
            string = this.plugin.getLM().updateSnd(snd, string);
            this.plugin.getSpecializedCommandManager().processCmds("CMIHologram", Arrays.asList(string.split(";;")), player, cMIHologramClickEvent.getActionType());
            if (cMIHologram.isShowParticle() && ParticleManager.CMIPresetAnimations.HologramNewInteraction.isEnabled()) {
                CMIPEAnimationInterface cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.HologramNewInteraction.getInter(cMIHologramClickEvent.getPlayer());
                cMIPEAnimationInterface.setCenter(cMIHologramClickEvent.getPos().toLocation(cMIHologram.getWorld()));
                CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(player, cMIPEAnimationInterface);
                cMIVisualEffect.setUntil(System.currentTimeMillis() + 2000L);
                cMIVisualEffect.show(player);
            }
            cMIHologram.update(player);
        } else {
            HologramListener.hologramInteraction(cMIHologram, cMIHologramClickEvent.getActionType(), player);
            if (!cMIHologram.getCommands().isEmpty() && cMIHologram.isShowParticle() && ParticleManager.CMIPresetAnimations.HologramInteraction.isEnabled()) {
                CMIPEAnimationInterface cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.HologramInteraction.getInter(cMIHologramClickEvent.getPlayer());
                cMIPEAnimationInterface.setCenter(cMIHologramClickEvent.getPos().toLocation(cMIHologram.getWorld()));
                CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(cMIHologramClickEvent.getPlayer(), cMIPEAnimationInterface);
                cMIVisualEffect.setTargetPlayer(cMIHologramClickEvent.getPlayer());
                cMIVisualEffect.setUntil(System.currentTimeMillis() + 2000L);
                cMIVisualEffect.show(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void CMIPlayerFakeEntityInteractEvent(CMIPlayerFakeEntityInteractEvent cMIPlayerFakeEntityInteractEvent) {
        if (!(cMIPlayerFakeEntityInteractEvent.getObject() instanceof CMIHologram)) {
            return;
        }
        CMIHologram cMIHologram = (CMIHologram)cMIPlayerFakeEntityInteractEvent.getObject();
        if (cMIHologram.isNewIneractionMethod()) {
            HologramManager.CMIAiming cMIAiming = this.plugin.getHologramManager().getAimAt(cMIPlayerFakeEntityInteractEvent.getPlayer().getUniqueId());
            if (cMIAiming == null) {
                return;
            }
            int n = cMIHologram.getHoveringLine(cMIPlayerFakeEntityInteractEvent.getPlayer().getUniqueId());
            if (n < 1) {
                return;
            }
            CMIInteractType cMIInteractType = cMIPlayerFakeEntityInteractEvent.getType();
            if (cMIPlayerFakeEntityInteractEvent.getPlayer().isSneaking()) {
                if (cMIInteractType == CMIInteractType.LeftClick) {
                    cMIInteractType = CMIInteractType.LeftShiftClick;
                } else if (cMIInteractType == CMIInteractType.RightClick) {
                    cMIInteractType = CMIInteractType.RightShiftClick;
                }
            }
            CMIHologramClickEvent cMIHologramClickEvent = new CMIHologramClickEvent(cMIPlayerFakeEntityInteractEvent.getPlayer(), cMIHologram, n, cMIAiming.getPos(), cMIInteractType);
            Bukkit.getPluginManager().callEvent((Event)cMIHologramClickEvent);
            return;
        }
        CMIInteractType cMIInteractType = cMIPlayerFakeEntityInteractEvent.getType();
        HologramListener.hologramInteraction(cMIHologram, cMIInteractType, cMIPlayerFakeEntityInteractEvent.getPlayer());
        if (cMIHologram.isShowParticle() && ParticleManager.CMIPresetAnimations.HologramInteraction.isEnabled()) {
            CMIPEAnimationInterface cMIPEAnimationInterface = ParticleManager.CMIPresetAnimations.HologramInteraction.getInter(cMIPlayerFakeEntityInteractEvent.getPlayer());
            cMIPEAnimationInterface.setCenter(cMIHologram.getCenterLocation());
            CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(cMIPlayerFakeEntityInteractEvent.getPlayer(), cMIPEAnimationInterface);
            cMIVisualEffect.setTargetPlayer(cMIPlayerFakeEntityInteractEvent.getPlayer());
            cMIVisualEffect.setUntil(System.currentTimeMillis() + 2000L);
            cMIVisualEffect.show(cMIPlayerFakeEntityInteractEvent.getPlayer());
        }
    }

    private static void hologramInteraction(CMIHologram cMIHologram, CMIInteractType cMIInteractType, Player player) {
        cMIHologram.onInteraction(player, cMIInteractType);
        List<String> list2 = cMIHologram.getCommands(player, cMIInteractType);
        CMIScheduler.runTask(() -> CMI.getInstance().getSpecializedCommandManager().processCmds("CMIHolo" + cMIHologram.getName(), list2, player, cMIInteractType));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawnEvent(PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.lastUpdateRange.remove(player.getUniqueId());
        this.plugin.getHologramManager().removeLastHologramInRange(player.getUniqueId());
        CMIScheduler.runTaskLater(() -> {
            if (player.isOnline()) {
                this.plugin.getHologramManager().handleHoloUpdates(player, player.getLocation());
            }
        }, (long)20L);
    }
}

