/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Signs;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIColorTypes;
import com.Zrips.CMI.Containers.CMIEvent;
import com.Zrips.CMI.Containers.CMITextCleaner;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.dsign;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerSignEditListeners
implements Listener {
    private CMI plugin;
    Set<UUID> signEditCache = new HashSet<UUID>();

    public PlayerSignEditListeners(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignChangeEvent(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        String[] stringArray = signChangeEvent.getLines();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            string = CMITextCleaner.cleanFromColorCodes(player, string, CMIColorTypes.signs, true);
            string = string.replace("\uff06", "&");
            signChangeEvent.setLine(n, string);
            ++n;
        }
        if (!(signChangeEvent.getBlock().getState() instanceof Sign)) {
            return;
        }
        try {
            Sign sign = (Sign)signChangeEvent.getBlock().getState();
            int n2 = 0;
            while (n2 < 4) {
                if (!sign.getLine(n2).equals(signChangeEvent.getLines()[n2])) {
                    if (this.signEditCache.remove(player.getUniqueId())) {
                        PlayerSignEditListeners.disableNCP(player, false);
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignInteractShift(PlayerInteractEvent playerInteractEvent) {
        Object object;
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_20_R1)) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (!playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (!cMIUser.getOptionState(PlayerOption.shiftSignEdit).booleanValue()) {
            return;
        }
        if (!PermissionsManager.CMIPerm.signs_shiftedit.hasPermission((CommandSender)player)) {
            return;
        }
        if (cMIUser.getItemInHand() != null && CMIMaterial.isSign((Material)cMIUser.getItemInHand().getType())) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (sign.getLine(0).equalsIgnoreCase(this.plugin.getConfigManager().getElevatorIndicator())) {
            return;
        }
        if (this.plugin.getSignManager().getSignEditBlackList().contains(CMIChatColor.stripColor((String)sign.getLine(0).toLowerCase()))) {
            LC.info_cantEdit.sendMessage((Object)player, new Object[0]);
            return;
        }
        if (Version.isCurrentEqual((Version)Version.v1_16_R1)) {
            LC.info_versionNotSupported.sendMessage((Object)player, new Object[0]);
            return;
        }
        boolean bl = false;
        if (CMIHookType.NoCheatPlus.isEnabled()) {
            if (NCPExemptionManager.isExempted((Player)player, (CheckType)CheckType.BLOCKPLACE_AUTOSIGN)) {
                bl = true;
            }
            if (!bl) {
                this.signEditCache.add(player.getUniqueId());
                NCPExemptionManager.exemptPermanently((Player)player, (CheckType)CheckType.BLOCKPLACE_AUTOSIGN);
            }
        }
        if (!PermissionsManager.CMIPerm.signs_shifteditbypass.hasPermission((CommandSender)player)) {
            object = CMIEvent.placeSignEvent(block, sign, player);
            Bukkit.getServer().getPluginManager().callEvent((Event)object);
            if (object.isCancelled()) {
                PlayerSignEditListeners.disableNCP(player, bl);
                return;
            }
            String[] stringArray = sign.getLines();
            SignChangeEvent signChangeEvent = new SignChangeEvent(block, player, stringArray);
            Bukkit.getServer().getPluginManager().callEvent((Event)signChangeEvent);
            if (object.isCancelled()) {
                PlayerSignEditListeners.disableNCP(player, bl);
                return;
            }
        }
        if ((object = this.plugin.getSignManager().getByLoc(block.getLocation())) != null && PermissionsManager.CMIPerm.command_$1.hasPermission((CommandSender)player, "dsign")) {
            PlayerSignEditListeners.disableNCP(player, bl);
            this.plugin.performCommand((CommandSender)player, String.valueOf(CommandsHandler.getLabel()) + " " + dsign.class.getSimpleName() + " " + this.plugin.getPlayerManager().convertLocToString(block.getLocation()));
            playerInteractEvent.setCancelled(true);
            return;
        }
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                PlayerSignEditListeners.disableNCP(player, bl);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.plugin.getReflectionManager().openSignUI(player, sign)) {
            playerInteractEvent.setCancelled(true);
        }
    }

    private static void disableNCP(Player player, boolean bl) {
        if (CMIHookType.NoCheatPlus.isEnabled() && !bl) {
            NCPExemptionManager.unexempt((Player)player, (CheckType)CheckType.BLOCKPLACE_AUTOSIGN);
        }
    }
}

