/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Container;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.Zrips.CMILib.Container.RandomLoc;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CuboidArea {
    private Vector p1;
    private Vector p2;
    private Vector highPoints;
    private Vector lowPoints;
    private World world;
    private static final int MIN_HEIGHT = 0;

    public CuboidArea(World world, Vector startLoc, Vector endLoc) {
        this.highPoints = startLoc.clone();
        this.p1 = startLoc.clone();
        this.lowPoints = endLoc.clone();
        this.p2 = endLoc.clone();
        this.world = world;
        this.recheck();
    }

    public CuboidArea(Location startLoc, Location endLoc) {
        this.highPoints = startLoc.toVector().clone();
        this.p1 = startLoc.toVector().clone();
        this.lowPoints = endLoc.toVector().clone();
        this.p2 = endLoc.toVector().clone();
        this.world = startLoc.getWorld();
        this.recheck();
    }

    public CuboidArea clone() {
        CuboidArea clone = new CuboidArea(this.world);
        clone.highPoints = this.highPoints == null ? null : this.highPoints.clone();
        clone.lowPoints = this.lowPoints == null ? null : this.lowPoints.clone();
        clone.p1 = this.p1 == null ? null : this.p1.clone();
        clone.p2 = this.p2 == null ? null : this.p2.clone();
        return clone;
    }

    private void recheck() {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        this.highPoints = new Vector(Math.max(this.p1.getBlockX(), this.p2.getBlockX()), Math.max(this.p1.getBlockY(), this.p2.getBlockY()), Math.max(this.p1.getBlockZ(), this.p2.getBlockZ()));
        this.lowPoints = new Vector(Math.min(this.p1.getBlockX(), this.p2.getBlockX()), Math.min(this.p1.getBlockY(), this.p2.getBlockY()), Math.min(this.p1.getBlockZ(), this.p2.getBlockZ()));
    }

    public boolean valid() {
        return this.p1 != null && this.p2 != null;
    }

    public CuboidArea(World world) {
        this.world = world;
    }

    public boolean isAreaWithinArea(CuboidArea area) {
        return this.containsLoc(area.highPoints) && this.containsLoc(area.lowPoints);
    }

    public Location getOutsideFreeLoc() {
        if (!this.valid()) {
            return null;
        }
        ArrayList<RandomLoc> randomLocList = new ArrayList<RandomLoc>();
        for (int z = -1; z < this.getZSize() + 1; ++z) {
            randomLocList.add(new RandomLoc(this.getLowPoint().getX(), 0.0, this.getLowPoint().getZ() + (double)z));
            randomLocList.add(new RandomLoc(this.getLowPoint().getX() + (double)this.getXSize(), 0.0, this.getLowPoint().getZ() + (double)z));
        }
        for (int x = -1; x < this.getXSize() + 1; ++x) {
            randomLocList.add(new RandomLoc(this.getLowPoint().getX() + (double)x, 0.0, this.getLowPoint().getZ()));
            randomLocList.add(new RandomLoc(this.getLowPoint().getX() + (double)x, 0.0, this.getLowPoint().getZ() + (double)this.getZSize()));
        }
        Location loc = this.getMiddlePoint().toLocation(this.getWorld()).clone();
        boolean found = false;
        int it = 0;
        int maxIt = 30;
        while (!found && it < maxIt) {
            ++it;
            Random ran = new Random(System.currentTimeMillis());
            if (randomLocList.isEmpty()) break;
            int check = ran.nextInt(randomLocList.size());
            RandomLoc place = (RandomLoc)randomLocList.get(check);
            randomLocList.remove(check);
            double x = place.getX();
            double z = place.getZ();
            loc.setX(x);
            loc.setZ(z);
            loc.setY((double)this.getHighPoint().getBlockY());
            int max = this.getHighPoint().getBlockY();
            int i = max = this.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : max;
            while ((double)i > this.getLowPoint().getY()) {
                loc.setY((double)i);
                Block block = loc.getBlock();
                Block block2 = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = loc.clone().add(0.0, -1.0, 0.0).getBlock();
                if (block3.getType() != Material.AIR && block.getType() == Material.AIR && block2.getType() == Material.AIR) break;
                --i;
            }
            if (loc.getBlock().getType() != Material.AIR || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.LAVA || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType().equals((Object)CMIMaterial.LAVA.getMaterial()) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.WATER || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType().equals((Object)CMIMaterial.WATER.getMaterial())) continue;
            found = true;
            loc.setY(loc.getY() + 2.0);
            loc.add(0.5, 0.0, 0.5);
            break;
        }
        return loc;
    }

    public boolean containsLoc(Location loc) {
        if (loc == null) {
            return false;
        }
        if (loc.getWorld() == null) {
            return false;
        }
        if (!loc.getWorld().equals(this.world)) {
            return false;
        }
        return this.containsLoc(loc.toVector(), 0);
    }

    public boolean containsLoc(Vector vector) {
        return this.containsLoc(vector, 0);
    }

    public boolean containsLoc(Location loc, int extraRange) {
        if (loc == null) {
            return false;
        }
        if (!loc.getWorld().equals(this.world)) {
            return false;
        }
        return this.containsLoc(loc.toVector(), extraRange);
    }

    public boolean containsLoc(Vector vector, int extraRange) {
        if (vector == null) {
            return false;
        }
        if (this.lowPoints.getBlockX() - extraRange > vector.getBlockX()) {
            return false;
        }
        if (this.highPoints.getBlockX() + extraRange < vector.getBlockX()) {
            return false;
        }
        if (this.lowPoints.getBlockZ() - extraRange > vector.getBlockZ()) {
            return false;
        }
        if (this.highPoints.getBlockZ() + extraRange < vector.getBlockZ()) {
            return false;
        }
        if (this.lowPoints.getBlockY() - extraRange > vector.getBlockY()) {
            return false;
        }
        return this.highPoints.getBlockY() + extraRange >= vector.getBlockY();
    }

    public boolean checkCollision(CuboidArea area) {
        if (area.getWorld() == null || this.getWorld() == null) {
            return false;
        }
        if (!area.getWorld().equals(this.getWorld())) {
            return false;
        }
        if (!this.valid()) {
            return false;
        }
        if (area.containsLoc(this.lowPoints) || area.containsLoc(this.highPoints) || this.containsLoc(area.highPoints) || this.containsLoc(area.lowPoints)) {
            return true;
        }
        return CuboidArea.advCuboidCheckCollision(this.highPoints, this.lowPoints, area.highPoints, area.lowPoints);
    }

    private static boolean advCuboidCheckCollision(Vector A1High, Vector A1Low, Vector A2High, Vector A2Low) {
        int A1HX = A1High.getBlockX();
        int A1LX = A1Low.getBlockX();
        int A1HY = A1High.getBlockY();
        int A1LY = A1Low.getBlockY();
        int A1HZ = A1High.getBlockZ();
        int A1LZ = A1Low.getBlockZ();
        int A2HX = A2High.getBlockX();
        int A2LX = A2Low.getBlockX();
        int A2HY = A2High.getBlockY();
        int A2LY = A2Low.getBlockY();
        int A2HZ = A2High.getBlockZ();
        int A2LZ = A2Low.getBlockZ();
        return (A1HX >= A2LX && A1HX <= A2HX || A1LX >= A2LX && A1LX <= A2HX || A2HX >= A1LX && A2HX <= A1HX || A2LX >= A1LX && A2LX <= A1HX) && (A1HY >= A2LY && A1HY <= A2HY || A1LY >= A2LY && A1LY <= A2HY || A2HY >= A1LY && A2HY <= A1HY || A2LY >= A1LY && A2LY <= A1HY) && (A1HZ >= A2LZ && A1HZ <= A2HZ || A1LZ >= A2LZ && A1LZ <= A2HZ || A2HZ >= A1LZ && A2HZ <= A1HZ || A2LZ >= A1LZ && A2LZ <= A1HZ);
    }

    public long getSize() {
        if (!this.valid()) {
            return 0L;
        }
        int xsize = this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
        int zsize = this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
        int ysize = this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
        return xsize * ysize * zsize;
    }

    public int getXSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        if (!this.valid()) {
            return 0;
        }
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    @Deprecated
    public Location getHighLoc() {
        if (!this.valid()) {
            return null;
        }
        return new Location(this.getWorld(), (double)this.highPoints.getBlockX(), (double)this.highPoints.getBlockY(), (double)this.highPoints.getBlockZ());
    }

    public Vector getHighPoint() {
        return this.highPoints;
    }

    @Deprecated
    public Location getLowLoc() {
        if (!this.valid()) {
            return null;
        }
        return new Location(this.getWorld(), (double)this.lowPoints.getBlockX(), (double)this.lowPoints.getBlockY(), (double)this.lowPoints.getBlockZ());
    }

    public Vector getLowPoint() {
        return this.lowPoints;
    }

    public World getWorld() {
        return this.world;
    }

    public List<ChunkRef> getChunks() {
        return this.getChunks(0);
    }

    public List<ChunkRef> getChunks(int range) {
        ArrayList<ChunkRef> chunks = new ArrayList<ChunkRef>();
        Vector high = this.highPoints;
        Vector low = this.lowPoints;
        int lowX = ChunkRef.getChunkCoord(low.getBlockX() - range);
        int lowZ = ChunkRef.getChunkCoord(low.getBlockZ() - range);
        int highX = ChunkRef.getChunkCoord(high.getBlockX() + range);
        int highZ = ChunkRef.getChunkCoord(high.getBlockZ() + range);
        for (int x = lowX; x <= highX; ++x) {
            for (int z = lowZ; z <= highZ; ++z) {
                chunks.add(new ChunkRef(x, z));
            }
        }
        return chunks;
    }

    public void setArea(CuboidArea area) {
        this.highPoints = area.getHighPoint().clone();
        this.lowPoints = area.getLowPoint().clone();
        this.p1 = area.p1.clone();
        this.p2 = area.p2.clone();
        this.world = area.getWorld();
        this.recheck();
    }

    public void setHighLocation(Location highLocation) {
        if (highLocation == null) {
            return;
        }
        this.world = highLocation.getWorld();
        this.setHighPoint(highLocation.toVector());
    }

    public void setHighPoint(Vector highLocation) {
        this.p1 = highLocation;
        this.recheck();
    }

    public void setLowLocation(Location lowLocation) {
        if (lowLocation == null) {
            return;
        }
        this.world = lowLocation.getWorld();
        this.setLowPoint(lowLocation.toVector());
    }

    public void setLowPoint(Vector lowPoint) {
        this.p2 = lowPoint;
        this.recheck();
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void setLocation(Location location) {
        if (location == null) {
            return;
        }
        this.world = location.getWorld();
        this.setPoint(location.toVector());
    }

    public void setPoint(Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.p1 == null) {
            this.p1 = vector;
        } else {
            this.p2 = vector;
        }
        this.recheck();
    }

    @Deprecated
    public Location getMiddleLocation() {
        if (!this.valid()) {
            return null;
        }
        return new Location(this.world, (this.getLowPoint().getX() + this.getHighPoint().getX()) / 2.0, (this.getLowPoint().getY() + this.getHighPoint().getY()) / 2.0, (this.getLowPoint().getZ() + this.getHighPoint().getZ()) / 2.0);
    }

    public Vector getMiddlePoint() {
        if (!this.valid()) {
            return null;
        }
        return new Vector((this.getLowPoint().getX() + this.getHighPoint().getX()) / 2.0, (this.getLowPoint().getY() + this.getHighPoint().getY()) / 2.0, (this.getLowPoint().getZ() + this.getHighPoint().getZ()) / 2.0);
    }

    public String toString() {
        if (!this.valid()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.lowPoints.getX()).append(":").append(this.lowPoints.getY()).append(":").append(this.lowPoints.getZ()).append(":").append(this.highPoints.getX()).append(":").append(this.highPoints.getY()).append(":").append(this.highPoints.getZ());
        return sb.toString();
    }

    public boolean shift(Player player, double amount) {
        return this.shift(CuboidArea.getDirection(player), amount);
    }

    public boolean shift(Direction d, double amount) {
        if (!this.valid()) {
            return false;
        }
        if (d == null) {
            return false;
        }
        switch (d) {
            case DOWN: {
                double oldy = (double)this.getLowPoint().getBlockY() - amount;
                if (oldy < 0.0) {
                    oldy = 0.0;
                }
                this.getLowPoint().setY(oldy);
                this.getHighPoint().setY((double)this.getHighPoint().getBlockY() - amount);
                break;
            }
            case MINUSX: {
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() - amount);
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() - amount);
                break;
            }
            case MINUSZ: {
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() - amount);
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() - amount);
                break;
            }
            case PLUSX: {
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() + amount);
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() + amount);
                break;
            }
            case PLUSZ: {
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() + amount);
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() + amount);
                break;
            }
            case UP: {
                double oldy = (double)this.getHighPoint().getBlockY() + amount;
                if (oldy > (double)this.getMaxWorldHeight()) {
                    oldy = this.getMaxWorldHeight();
                }
                this.getHighPoint().setY(oldy);
                this.getLowPoint().setY((double)this.getLowPoint().getBlockY() + amount);
                break;
            }
        }
        return true;
    }

    public boolean expand(Player player, double amount) {
        return this.expand(CuboidArea.getDirection(player), amount);
    }

    public boolean expand(Direction d, double amount) {
        if (!this.valid()) {
            return false;
        }
        if (d == null) {
            return false;
        }
        switch (d) {
            case DOWN: {
                double oldy = (double)this.getLowPoint().getBlockY() - amount;
                if (oldy < 0.0) {
                    oldy = 0.0;
                }
                this.getLowPoint().setY(oldy);
                break;
            }
            case MINUSX: {
                this.getLowPoint().setX((double)this.getLowPoint().getBlockX() - amount);
                break;
            }
            case MINUSZ: {
                this.getLowPoint().setZ((double)this.getLowPoint().getBlockZ() - amount);
                break;
            }
            case PLUSX: {
                this.getHighPoint().setX((double)this.getHighPoint().getBlockX() + amount);
                break;
            }
            case PLUSZ: {
                this.getHighPoint().setZ((double)this.getHighPoint().getBlockZ() + amount);
                break;
            }
            case UP: {
                double oldy = (double)this.getHighPoint().getBlockY() + amount;
                if (oldy > (double)this.getMaxWorldHeight()) {
                    oldy = this.getMaxWorldHeight();
                }
                this.getHighPoint().setY(oldy);
                break;
            }
        }
        return true;
    }

    public boolean contract(Player player, double amount) {
        if (!this.valid()) {
            return false;
        }
        return this.contract(CuboidArea.getDirection(player), amount);
    }

    public boolean contract(Direction d, double amount) {
        if (!this.valid()) {
            return false;
        }
        if (d == null) {
            return false;
        }
        switch (d) {
            case DOWN: {
                double oldy = (double)this.getHighPoint().getBlockY() - amount;
                if (oldy > (double)this.getMaxWorldHeight()) {
                    oldy = this.getMaxWorldHeight();
                }
                oldy = (double)this.getHighPoint().getBlockY() - amount;
                oldy = this.getLowPoint().getY() > oldy ? this.getLowPoint().getY() : oldy;
                this.getHighPoint().setY(oldy);
                break;
            }
            case MINUSX: {
                double res = (double)this.getHighPoint().getBlockX() - amount;
                res = this.getLowPoint().getX() > res ? this.getLowPoint().getX() : res;
                this.getHighPoint().setX(res);
                break;
            }
            case MINUSZ: {
                double res = (double)this.getHighPoint().getBlockZ() - amount;
                res = this.getLowPoint().getZ() > res ? this.getLowPoint().getZ() : res;
                this.getHighPoint().setZ(res);
                break;
            }
            case PLUSX: {
                double res = (double)this.getLowPoint().getBlockX() + amount;
                res = this.getHighPoint().getX() < res ? this.getHighPoint().getX() : res;
                this.getLowPoint().setX(res);
                break;
            }
            case PLUSZ: {
                double res = (double)this.getLowPoint().getBlockZ() + amount;
                res = this.getHighPoint().getZ() < res ? this.getHighPoint().getZ() : res;
                this.getLowPoint().setZ(res);
                break;
            }
            case UP: {
                double oldy = (double)this.getLowPoint().getBlockY() + amount;
                if (oldy < 0.0) {
                    oldy = 0.0;
                }
                oldy = (double)this.getLowPoint().getBlockY() + amount;
                oldy = this.getHighPoint().getY() < oldy ? this.getHighPoint().getY() : oldy;
                this.getLowPoint().setY(oldy);
                break;
            }
        }
        return true;
    }

    private int getMaxWorldHeight() {
        if (this.getWorld() == null) {
            return 256;
        }
        switch (this.getWorld().getEnvironment()) {
            case NETHER: {
                return 128;
            }
            case NORMAL: 
            case THE_END: {
                return 256;
            }
        }
        return 256;
    }

    private static Direction getDirection(Player player) {
        int yaw = (int)player.getLocation().getYaw();
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 45;
        int facing = (yaw %= 360) / 90;
        float pitch = player.getLocation().getPitch();
        if (pitch < -50.0f) {
            return Direction.UP;
        }
        if (pitch > 50.0f) {
            return Direction.DOWN;
        }
        if (facing == 1) {
            return Direction.MINUSX;
        }
        if (facing == 3) {
            return Direction.PLUSX;
        }
        if (facing == 2) {
            return Direction.MINUSZ;
        }
        if (facing == 0) {
            return Direction.PLUSZ;
        }
        return null;
    }

    public static final class ChunkRef {
        private final int z;
        private final int x;

        public static int getChunkCoord(int val) {
            return val >> 4;
        }

        public ChunkRef(Location loc) {
            this.x = ChunkRef.getChunkCoord(loc.getBlockX());
            this.z = ChunkRef.getChunkCoord(loc.getBlockZ());
        }

        public ChunkRef(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkRef other = (ChunkRef)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            return this.x ^ this.z;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ x: ").append(this.x).append(", z: ").append(this.z).append(" }");
            return sb.toString();
        }
    }

    public static enum Direction {
        UP,
        DOWN,
        PLUSX,
        PLUSZ,
        MINUSX,
        MINUSZ;

    }
}

