/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Equations;

import java.util.HashSet;
import net.Zrips.CMILib.Equations.ConstantNode;
import net.Zrips.CMILib.Equations.EvaluationException;
import net.Zrips.CMILib.Equations.ExpressionNode;
import net.Zrips.CMILib.Equations.FunctionNode;
import net.Zrips.CMILib.Equations.OperatorNode;
import net.Zrips.CMILib.Equations.ParseError;
import net.Zrips.CMILib.Equations.VariableNode;

public class Parser {
    private static final char TERM = '@';
    private static final char NUM = 'n';
    private static final char FUNC = 'f';
    private static final char VAR = 'x';
    private static final char OP_BRACKET = '(';
    private static final char CL_BRACKET = ')';
    private char[] input;
    private boolean error;
    private int inp_cur;
    private Element cc;
    private ExpressionNode root;
    private HashSet<String> functions;
    private HashSet<String> variables;

    public Parser(String str) {
        this(str, false);
    }

    public Parser(String str, boolean error) {
        this.input = this.convertInput(str);
        this.root = null;
        this.inp_cur = 0;
        this.error = error;
        this.functions = new HashSet();
        this.variables = new HashSet();
    }

    protected char[] convertInput(String str) {
        char[] input = str.toCharArray();
        char[] output = new char[input.length + 1];
        int pos = 0;
        for (int i = 0; i < input.length; ++i) {
            char c = input[i];
            if (!Parser.isNumber(c) && !Parser.isOperator(c) && !Parser.isText(c) && !Parser.isBracket(c)) continue;
            output[pos++] = c;
        }
        output[pos++] = 64;
        return output;
    }

    public ExpressionNode getTree() throws ParseError {
        if (this.root == null) {
            this.cc = this.parse();
            this.root = this.S();
            if (!Parser.isEndOfExpression(this.cc.getToken())) {
                throw new ParseError("Expecting operator or end of input", this.inp_cur);
            }
        }
        return this.root;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private static boolean isOperator(char c) {
        for (int i = 0; i < OperatorNode.OPERATIONS.length; ++i) {
            if (c != OperatorNode.OPERATIONS[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isText(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == ')';
    }

    private static boolean isEndOfExpression(char c) {
        return c == '@';
    }

    private Element parse() {
        if (this.detectImplicitMult()) {
            return new Element('*');
        }
        if (Parser.isOperator(this.input[this.inp_cur]) || Parser.isBracket(this.input[this.inp_cur]) || Parser.isEndOfExpression(this.input[this.inp_cur])) {
            return new Element(this.input[this.inp_cur++]);
        }
        if (Parser.isNumber(this.input[this.inp_cur])) {
            double d;
            int tmp = this.inp_cur++;
            while (Parser.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            if (Character.toLowerCase(this.input[this.inp_cur]) == 'e') {
                if (this.input[this.inp_cur + 1] == '-' || Parser.isNumber(this.input[this.inp_cur + 1])) {
                    this.inp_cur += 2;
                }
                while (Parser.isNumber(this.input[this.inp_cur])) {
                    ++this.inp_cur;
                }
            }
            String s = new String(this.input, tmp, this.inp_cur - tmp);
            try {
                d = Double.valueOf(s);
            }
            catch (NumberFormatException ex) {
                throw new ParseError("Invalid number: " + s, this.inp_cur);
            }
            return new Element('n', d);
        }
        if (Parser.isText(this.input[this.inp_cur])) {
            int i;
            int tmp = this.inp_cur++;
            while (Parser.isText(this.input[this.inp_cur]) || Parser.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            String s = new String(this.input, tmp, this.inp_cur - tmp);
            String lower = s.toLowerCase();
            for (i = 0; i < FunctionNode.FUNCTIONS.length; ++i) {
                if (!lower.equals(FunctionNode.FUNCTIONS[i])) continue;
                this.functions.add(FunctionNode.FUNCTIONS[i]);
                return new Element('f', i);
            }
            for (i = 0; i < ConstantNode.CONSTANTS.length; ++i) {
                if (!lower.equals(ConstantNode.CONSTANTS[i])) continue;
                return new Element('n', i);
            }
            this.variables.add(s);
            return new Element('x', s);
        }
        throw new ParseError("Unrecognized identifier", this.inp_cur);
    }

    private boolean detectImplicitMult() {
        if (this.cc != null && this.cc.getToken() == 'n') {
            this.cc = null;
            int old_input = this.inp_cur;
            Element next = this.parse();
            this.inp_cur = old_input;
            if (next.getToken() == 'x' || next.getToken() == 'f') {
                return true;
            }
        }
        return false;
    }

    private ExpressionNode S() {
        ExpressionNode current = this.E();
        while (this.cc.getToken() == '+' || this.cc.getToken() == '-') {
            char operator = this.cc.getToken();
            this.cc = this.parse();
            current = new OperatorNode(current, this.E(), operator);
        }
        return current;
    }

    private ExpressionNode E() {
        ExpressionNode current = this.G();
        while (this.cc.getToken() == '*') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.G(), '*');
        }
        return current;
    }

    private ExpressionNode G() {
        ExpressionNode current = this.H();
        while (this.cc.getToken() == '/') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.H(), '/');
        }
        return current;
    }

    private ExpressionNode H() {
        ExpressionNode current = this.T();
        while (this.cc.getToken() == '%') {
            this.cc = this.parse();
            current = new OperatorNode(current, this.T(), '%');
        }
        return current;
    }

    private ExpressionNode T() {
        if (this.cc.getToken() == '-') {
            this.cc = this.parse();
            return new FunctionNode(this.F(), "-");
        }
        return this.F();
    }

    private ExpressionNode F() {
        ExpressionNode left = this.U();
        if (this.cc.getToken() == '^') {
            this.cc = this.parse();
            return new OperatorNode(left, this.F(), '^');
        }
        return left;
    }

    private ExpressionNode U() {
        switch (this.cc.getToken()) {
            case 'n': {
                double n = this.cc.number;
                int constPosition = this.cc.position;
                this.cc = this.parse();
                if (constPosition >= 0) {
                    return new ConstantNode(constPosition);
                }
                return new ConstantNode(n);
            }
            case 'x': {
                String name = this.cc.name;
                this.cc = this.parse();
                return new VariableNode(name, this.error);
            }
            case '(': {
                this.cc = this.parse();
                ExpressionNode tmp = this.S();
                if (this.cc.getToken() == ')') {
                    this.cc = this.parse();
                    return tmp;
                }
                throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
            }
            case 'f': {
                int function = this.cc.position;
                this.cc = this.parse();
                if (this.cc.getToken() != '(') {
                    throw new ParseError("Semantic Error, expected '('", this.inp_cur);
                }
                this.cc = this.parse();
                ExpressionNode tmp2 = this.S();
                if (this.cc.getToken() != ')') {
                    throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
                }
                this.cc = this.parse();
                return new FunctionNode(tmp2, function);
            }
        }
        throw new ParseError("Semantic Error, expected function or variable or constant or '('", this.inp_cur);
    }

    public void setVariable(String name, double value) throws ParseError {
        this.getTree();
        this.root.setVariable(name, value);
    }

    public double getValue() throws ParseError, EvaluationException {
        this.getTree();
        return this.root.getValue();
    }

    private class Element {
        private char token;
        public double number = Double.NaN;
        public int position = -1;
        public String name = null;

        public Element(char token) {
            this.token = token;
        }

        public Element(char token, double number) {
            this.token = token;
            this.number = number;
        }

        public Element(char token, String name) {
            this.token = token;
            this.name = name;
        }

        public Element(char token, int position) {
            this.token = token;
            this.position = position;
        }

        public char getToken() {
            return this.token;
        }
    }
}

