/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Messages;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.CustomText.CText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Advancements.AdvancementManager;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMICommandSender;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.Snd;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Messages.CMIMultiMessageType;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.TitleMessages.CMITitleMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CMIMultiMessage {
    private boolean updateSnd = false;
    private boolean translateColors = true;
    private boolean translatePlaceholders = true;
    private CMIMultiMessageType type = null;
    private String message;
    private List<Object> extra;

    public CMIMultiMessage(String msg) {
        block8: for (CMIMultiMessageType one : CMIMultiMessageType.values()) {
            Pattern pattern = one.getRegex();
            Matcher match = pattern.matcher(msg);
            if (!match.find()) continue;
            this.type = one;
            switch (one) {
                case actionBar: 
                case broadcast: {
                    this.message = msg = msg.substring(match.group().length());
                    continue block8;
                }
                case toast: {
                    CMIMaterial material;
                    AdvancementManager.FrameType frame;
                    msg = msg.substring(match.group().length());
                    this.extra = new ArrayList<Object>();
                    if (match.group(2) != null && (frame = AdvancementManager.FrameType.getFromString(match.group(3))) != null) {
                        this.extra.add((Object)frame);
                    }
                    if (match.group(4) != null && (material = CMIMaterial.get(match.group(5))).isValidItem()) {
                        this.extra.add((Object)material);
                    }
                    if (msg.startsWith(" ")) {
                        msg = msg.substring(1);
                    }
                    this.message = msg;
                    continue block8;
                }
                case bossBar: {
                    msg = msg.substring(match.group().length());
                    this.extra = new ArrayList<Object>();
                    this.extra.add(match.group(2));
                    if (match.group(4) != null && !match.group(4).isEmpty()) {
                        this.extra.add(match.group(4));
                    }
                    this.message = msg;
                    continue block8;
                }
                case customText: 
                case timedActionBar: {
                    msg = msg.substring(match.group().length());
                    this.extra = new ArrayList<Object>();
                    this.extra.add(match.group(2));
                    this.message = msg;
                    continue block8;
                }
                case json: 
                case plain: {
                    this.message = msg;
                    continue block8;
                }
                case title: {
                    String title = match.group(3);
                    if (title != null && !title.isEmpty()) {
                        this.message = title;
                        this.extra = new ArrayList<Object>();
                        this.extra.add(match.group(5));
                        continue block8;
                    }
                    this.message = match.group(5);
                    continue block8;
                }
            }
        }
        if (this.type == null) {
            this.message = msg;
            this.type = CMIMultiMessageType.plain;
        }
    }

    public boolean show(CMICommandSender sender) {
        return this.show(sender.getSender());
    }

    public boolean show(CommandSender sender) {
        this.message = CMILib.getInstance().getLM().filterNewLine(this.message);
        if (this.isTranslateColors()) {
            this.message = CMIChatColor.translate(this.message);
        }
        if (this.isUpdateSnd()) {
            this.message = CMILib.getInstance().getLM().updateSnd(new Snd().setSender(sender).setTarget(sender), this.message);
        }
        if (sender instanceof Player && this.isTranslatePlaceholders()) {
            this.message = CMILib.getInstance().getPlaceholderAPIManager().updatePlaceHolders((Player)sender, this.message);
        }
        block2 : switch (this.type) {
            case actionBar: {
                CMIActionBar.send(sender, this.message);
                break;
            }
            case bossBar: {
                if (!(sender instanceof Player)) {
                    return false;
                }
                String bName = (String)this.getExtra().get(0);
                int keepfor = 30;
                if (this.getExtra().size() > 1) {
                    try {
                        keepfor = (int)(Double.parseDouble((String)this.getExtra().get(1)) * 20.0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                BossBarInfo barInfo = new BossBarInfo((Player)sender, bName);
                barInfo.setKeepForTicks(keepfor);
                barInfo.setTitleOfBar(this.message);
                CMILib.getInstance().getBossBarManager().addBossBar((Player)sender, barInfo);
                break;
            }
            case broadcast: {
                CMIMultiMessage sub = new CMIMultiMessage(this.message);
                switch (sub.getType()) {
                    case customText: {
                        for (Player one : Bukkit.getOnlinePlayers()) {
                            sub.show((CommandSender)one);
                        }
                        break block2;
                    }
                    default: {
                        if (!(sender instanceof Player)) {
                            sender.sendMessage(this.message);
                        }
                        CMIMessages.broadcastMessage(sender, this.message);
                        break;
                    }
                }
                break;
            }
            case customText: {
                if (!CMILib.getInstance().isCmiPresent()) break;
                CText cText = CMI.getInstance().getCTextManager().getCText((String)this.getExtra().get(0));
                if (cText == null) {
                    sender.sendMessage(this.message);
                    break;
                }
                CMI.getInstance().getCTextManager().showCText(sender, cText, Integer.valueOf(1));
                break;
            }
            case json: {
                RawMessage rm = RawMessage.translateRawMessage(sender, this.message);
                Bukkit.getScheduler().runTask((Plugin)CMILib.getInstance(), () -> rm.show(sender));
                break;
            }
            case timedActionBar: {
                if (!(sender instanceof Player)) {
                    return false;
                }
                int ime = 0;
                try {
                    ime = Integer.parseInt((String)this.getExtra().get(0));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CMIActionBar.send((Player)sender, this.message, ime);
                break;
            }
            case title: {
                String subtitle;
                String title = this.message;
                String string = subtitle = this.getExtra().isEmpty() ? null : (String)this.getExtra().get(0);
                if (!(sender instanceof Player)) break;
                CMITitleMessage.send((Player)sender, (Object)title, (Object)subtitle);
                break;
            }
            case toast: {
                if (!(sender instanceof Player)) {
                    return false;
                }
                if (Version.isCurrentLower(Version.v1_12_R1)) {
                    sender.sendMessage(this.message);
                    break;
                }
                CMIMaterial material = CMIMaterial.BLACK_STAINED_GLASS_PANE;
                AdvancementManager.FrameType type = AdvancementManager.FrameType.CHALLENGE;
                if (this.extra != null) {
                    for (Object oneS : this.extra) {
                        if (oneS instanceof CMIMaterial) {
                            material = (CMIMaterial)((Object)oneS);
                            continue;
                        }
                        if (!(oneS instanceof AdvancementManager.FrameType)) continue;
                        type = (AdvancementManager.FrameType)((Object)oneS);
                    }
                }
                AdvancementManager.sendToast((Player)sender, this.message, material.newCMIItemStack(), type);
                break;
            }
            default: {
                if (sender == null) break;
                if (Version.isCurrentEqualOrHigher(Version.v1_16_R1) && sender instanceof Player) {
                    RawMessage rm = new RawMessage();
                    rm.addText(this.message);
                    rm.show(sender);
                    break;
                }
                if (Version.isCurrentLower(Version.v1_16_R1)) {
                    this.message = CMIChatColor.stripHexColor(this.message);
                }
                sender.sendMessage(this.message);
            }
        }
        return true;
    }

    public boolean isTranslateColors() {
        return this.translateColors;
    }

    public void setTranslateColors(boolean translateColors) {
        this.translateColors = translateColors;
    }

    public boolean isUpdateSnd() {
        return this.updateSnd;
    }

    public void setUpdateSnd(boolean updateSnd) {
        this.updateSnd = updateSnd;
    }

    public CMIMultiMessageType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Object> getExtra() {
        if (this.extra == null) {
            this.extra = new ArrayList<Object>();
        }
        return this.extra;
    }

    public boolean isMultiType() {
        return this.type != null && !this.type.equals((Object)CMIMultiMessageType.plain);
    }

    public boolean isTranslatePlaceholders() {
        return this.translatePlaceholders;
    }

    public void setTranslatePlaceholders(boolean translatePlaceholders) {
        this.translatePlaceholders = translatePlaceholders;
    }
}

