/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Sounds;

import java.util.HashMap;
import java.util.Map;
import net.Zrips.CMILib.CMILib;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class CMISound {
    private static HashMap<String, Sound> soundsByname = new HashMap();
    private String rawName = null;
    private Sound sound = null;
    private float pitch = 1.0f;
    private float volume = 1.0f;
    private boolean enabled = true;

    public CMISound(String name) {
        this(name, 1.0f, 1.0f);
    }

    public CMISound(String name, float volume, float pitch) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.contains(":")) {
            String[] split = name.split(":");
            name = split[0];
            if (split.length > 1) {
                try {
                    volume = Float.parseFloat(split[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (split.length > 2) {
                try {
                    pitch = Float.parseFloat(split[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.volume = volume;
        this.pitch = pitch;
        this.rawName = name = name.toLowerCase().replace("_", "");
        if (soundsByname.isEmpty()) {
            for (Sound one : Sound.values()) {
                soundsByname.put(one.name().toLowerCase().replace("_", ""), one);
            }
        }
        this.sound = soundsByname.get(name);
        if (this.sound == null) {
            for (Map.Entry entry : soundsByname.entrySet()) {
                if (!((String)entry.getKey()).contains(name)) continue;
                this.sound = (Sound)entry.getValue();
            }
        }
        if (this.sound != null) {
            this.rawName = this.sound.toString();
        }
    }

    public Sound getSound() {
        return this.sound;
    }

    public CMISound setSound(Sound sound) {
        this.sound = sound;
        return this;
    }

    public CMISound play(Location loc) {
        if (!this.enabled) {
            return this;
        }
        if (this.sound == null) {
            return this;
        }
        loc.getWorld().playSound(loc, this.sound, this.volume, this.pitch);
        return this;
    }

    public CMISound play(Player player) {
        if (!this.enabled) {
            return this;
        }
        if (this.sound == null) {
            return this;
        }
        if (player == null) {
            return this;
        }
        CMILib.getInstance().getReflectionManager().playSound(player, player.getLocation(), this.sound, this.volume, this.pitch);
        return this;
    }

    public float getPitch() {
        return this.pitch;
    }

    public CMISound setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public float getVolume() {
        return this.volume;
    }

    public CMISound setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public String getRawName() {
        return this.rawName;
    }

    public String toString() {
        return this.sound == null ? "Unknown" : this.sound.toString() + ":" + CMISound.fmt(this.volume) + ":" + CMISound.fmt(this.pitch);
    }

    private static String fmt(float d) {
        return String.format("%s", Float.valueOf(d));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

