/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.mylogo.chestlock.LockConfig;
import me.mylogo.chestlock.Metrics;
import me.mylogo.chestlock.Module;
import me.mylogo.chestlock.cmd.ClgCommand;
import me.mylogo.chestlock.command.Commands;
import me.mylogo.chestlock.gui.GuiManager;
import me.mylogo.chestlock.items.ItemManager;
import me.mylogo.chestlock.listeners.OtherListener;
import me.mylogo.chestlock.listeners.PlayerListener;
import me.mylogo.chestlock.lock.LockManager;
import me.mylogo.chestlock.user.LockUserManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Lock
extends JavaPlugin {
    private static Lock instance;
    private List<Module> modules;
    private LockUserManager userManager;
    private LockManager lockManager;
    private GuiManager guiManager;
    private ItemManager itemManager;
    private LockConfig lockConfig;
    private Commands commands;

    public void onEnable() {
        Lock.loadConfig0();
        instance = this;
        this.modules = new ArrayList<Module>();
        this.getDataFolder().mkdir();
        new File(this.getDataFolder(), "data").mkdir();
        this.itemManager = new ItemManager(this);
        this.lockConfig = new LockConfig(this);
        this.guiManager = new GuiManager(this);
        this.userManager = this.registerModule(LockUserManager::new);
        this.lockManager = this.registerModule(LockManager::new);
        this.commands = new Commands(this, this.lockConfig.getPrefix());
        this.commands.setErrorMessages(this.lockConfig.getPlayerNotFound(), this.lockConfig.getNotANumber(), this.lockConfig.getNoPermissions()).registerCommand(new ClgCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OtherListener(this), (Plugin)this);
        new Metrics((Plugin)this);
    }

    public void onDisable() {
        for (Module module : this.modules) {
            try {
                module.onDisable();
            }
            catch (Exception exception) {
                if (module != null) {
                    module.printError("Could not disable " + module.getClass().getSimpleName());
                }
                exception.printStackTrace();
            }
        }
    }

    private <T extends Module> T registerModule(Function<Lock, T> function) {
        try {
            Module module = (Module)function.apply(this);
            this.modules.add(module);
            return (T)module;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public LockUserManager getUserManager() {
        return this.userManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public LockConfig getLockConfig() {
        return this.lockConfig;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public void reload() {
        LockConfig lockConfig;
        this.lockConfig = lockConfig = new LockConfig(this);
    }

    public static Lock getInstance() {
        return instance;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=827444&resource_id=63650&nonce=-991569717").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

