/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.Module;
import me.mylogo.chestlock.XMaterial;
import me.mylogo.chestlock.guis.LockGui;
import me.mylogo.chestlock.items.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class LockConfig
extends Module {
    private FileConfiguration config;
    private Set<Material> rightClickBlacklist;
    private final Set<Material> LOCKABLE = new HashSet<Material>();

    public LockConfig(Lock lock) {
        super(lock);
        Material material;
        this.plugin = lock;
        try {
            this.config = this.loadEnsuredConfig("config.yml", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (String string : this.config.getStringList("lockable_blocks")) {
            material = XMaterial.matchXMaterial(string).map(XMaterial::parseMaterial).orElse(null);
            if (material == null) {
                Bukkit.getConsoleSender().sendMessage("\u00a7c-----");
                Bukkit.getConsoleSender().sendMessage(" \u00a7c[CLG] Could not find material in lockable_blocks: " + string);
                Bukkit.getConsoleSender().sendMessage("\u00a7c-----");
                continue;
            }
            this.LOCKABLE.add(material);
        }
        this.rightClickBlacklist = new HashSet<Material>();
        for (String string : this.config.getStringList("right_click_blacklist")) {
            material = XMaterial.matchXMaterial(string).map(XMaterial::parseMaterial).orElse(null);
            if (material != null) {
                this.rightClickBlacklist.add(material);
                continue;
            }
            this.printError("Item not found in config.yml:", string);
        }
        ItemStack itemStack = this.getItem("gui_blank");
        System.out.println("GUI Blank item:" + itemStack);
        if (itemStack != null) {
            LockGui.BLANK = itemStack;
        }
    }

    public String getString(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(string, "NOT_FOUND").replace("%prfx%", this.getPrefix()));
    }

    public String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("prfx", "[CLGUI]"));
    }

    public ItemStack getItem(String string2) {
        ConfigurationSection configurationSection = this.config.getConfigurationSection("items").getConfigurationSection(string2);
        if (configurationSection != null) {
            if (!configurationSection.isSet("type")) {
                return new ItemBuilder(XMaterial.DIRT.parseMaterial()).setName("Could not find type for items." + string2).build();
            }
            ItemStack itemStack = XMaterial.matchXMaterial(configurationSection.getString("type")).map(XMaterial::parseItem).orElse(null);
            if (itemStack == null) {
                return new ItemBuilder(XMaterial.DIRT.parseMaterial()).setName("Invalid type/data for items." + string2).build();
            }
            ItemBuilder itemBuilder = new ItemBuilder(itemStack);
            if (configurationSection.isSet("name")) {
                itemBuilder.setName(ChatColor.translateAlternateColorCodes((char)'&', (String)configurationSection.getString("name")));
            }
            if (configurationSection.isSet("lore")) {
                itemBuilder.setLore(configurationSection.getStringList("lore").stream().map(string -> ChatColor.translateAlternateColorCodes((char)'&', (String)string)).collect(Collectors.toList()));
            }
            itemStack = itemBuilder.build();
            return itemStack;
        }
        return new ItemBuilder(XMaterial.DIRT.parseMaterial()).setName("Could not find items." + string2).build();
    }

    public ItemStack getYesItem() {
        return this.getItem("gui_agree");
    }

    public ItemStack getNoItem() {
        return this.getItem("gui_deny");
    }

    public String getLockRequestTitle() {
        return this.getString("gui.request_lock.title");
    }

    public boolean isLockable(Material material) {
        return this.LOCKABLE.contains(material);
    }

    public String getMessage(String string) {
        return this.getString("msg." + string);
    }

    public String getYouLockedContainer() {
        return this.getMessage("you_locked_container");
    }

    public String getYouAddedContainer() {
        return this.getMessage("added_container");
    }

    public String getBrokeContainer() {
        return this.getMessage("broke_container");
    }

    public String getContainerIsLocked(String string) {
        return this.getMessage("locked_container").replace("%player%", string);
    }

    public String getContainerNotLockable() {
        return this.getMessage("cannot_lock_container");
    }

    public String getLockTitle() {
        return this.getString("gui.lock_gui.title");
    }

    public String getLockGuiFriendsTitle() {
        return this.getString("gui.lock_gui.friends_title");
    }

    public String getFriendsGuiTitle() {
        return this.getString("gui.friends_gui.title");
    }

    public ItemStack getNextPageItem() {
        return this.getItem("next_page");
    }

    public ItemStack getPreviousPageItem() {
        return this.getItem("previous_page");
    }

    public ItemStack getAddFriendItem() {
        return this.getItem("add_friend");
    }

    public String getFriendSkullName() {
        return this.getString("gui.friends_gui.friend_skull_name");
    }

    public List<String> getFriendsSkullLore() {
        return this.config.getStringList("gui.friends_gui.friend_skull_lore").stream().map(string -> ChatColor.translateAlternateColorCodes((char)'&', (String)string)).collect(Collectors.toList());
    }

    public String getChoosePlayerGuiTitle() {
        return this.getString("gui.choose_player_gui.title");
    }

    public ItemStack getUnlockItem() {
        return this.getItem("unlock");
    }

    public String getReallyUnlockTitle() {
        return this.getString("gui.really_unlock.title");
    }

    public ItemStack getCopyFriendsItem() {
        return this.getItem("copy_friends");
    }

    public ItemStack getPasteFriendsItem() {
        return this.getItem("paste_friends");
    }

    public String getFriendsCopied() {
        return this.getMessage("copied_friends");
    }

    public String getFriendsPasted() {
        return this.getMessage("paste_friends");
    }

    public String getNoFriendsCopied() {
        return this.getMessage("no_friends_copied");
    }

    public String getFriendAlreadyAdded() {
        return this.getMessage("already_added");
    }

    public String getCannotAddYourself() {
        return this.getMessage("cannot_add_yourself");
    }

    public ItemStack getChestSettingsItem() {
        return this.getItem("lock_settings");
    }

    public String getChestSettingsTitle() {
        return this.getString("gui.lock_settings.title");
    }

    public ItemStack getPublicEnabledItem() {
        return this.getItem("public_enabled");
    }

    public ItemStack getPublicDisabledItem() {
        return this.getItem("public_disabled");
    }

    public ItemStack getItemExtractEnabled() {
        return this.getItem("item_extract_activated");
    }

    public ItemStack getItemExtractDisabled() {
        return this.getItem("item_extract_disabled");
    }

    public ItemStack getItemInsertionEnabled() {
        return this.getItem("item_insert_activated");
    }

    public ItemStack getItemInsertionDisabled() {
        return this.getItem("item_insert_disabled");
    }

    public ItemStack getBackItem() {
        return this.getItem("back");
    }

    public String getYouCannotClaimMore() {
        return this.getMessage("you_cannot_claim_more");
    }

    public int getMaxClaims() {
        return this.config.getInt("max_chest_claims");
    }

    public int getMaxClaims(Player player) {
        List list = player.getEffectivePermissions().stream().map(PermissionAttachmentInfo::getPermission).filter(string -> string.startsWith("clg.maxclaims.")).collect(Collectors.toList());
        if (list.isEmpty()) {
            return this.getMaxClaims();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : list) {
            String string3 = string2.substring("clg.maxclaims.".length());
            try {
                arrayList.add(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Could not read number value of " + list + " Reading:" + string3);
            }
        }
        if (arrayList.isEmpty()) {
            return this.getMaxClaims();
        }
        return arrayList.stream().mapToInt(n -> n).max().getAsInt();
    }

    public boolean isRightClickBlacklist(Material material) {
        return this.rightClickBlacklist.contains(material);
    }

    public String getNoPermissions() {
        return this.getMessage("no_permissions");
    }

    public String getPlayerNotFound() {
        return this.getMessage("player_not_found");
    }

    public String getNotANumber() {
        return this.getMessage("not_a_number");
    }

    public boolean willLocksBreakOnExplosion() {
        return this.config.getBoolean("break_on_explosion");
    }

    public boolean lockOnlyWithEmptyHand() {
        return this.config.getBoolean("lock_only_empty_hand");
    }
}

